/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.BBRomBuffer;
import org.jetbrains.bio.CompressionType;
import org.jetbrains.bio.MMBRomBuffer;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBufferFactory;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.BPlusLeaf;
import org.jetbrains.bio.big.BPlusTree;
import org.jetbrains.bio.big.BigBedFile;
import org.jetbrains.bio.big.BigFile;
import org.jetbrains.bio.big.BigFile$Companion$WhenMappings;
import org.jetbrains.bio.big.BigSummary;
import org.jetbrains.bio.big.BigSummaryKt;
import org.jetbrains.bio.big.BigWigFile;
import org.jetbrains.bio.big.ChromosomeInterval;
import org.jetbrains.bio.big.Interval;
import org.jetbrains.bio.big.RTreeIndex;
import org.jetbrains.bio.big.RTreeIndexLeaf;
import org.jetbrains.bio.big.ZoomData;
import org.jetbrains.bio.big.ZoomLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 f*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0005fghijB7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010I\u001a\u00020\fH\u0016J-\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020OH\u0000\u00a2\u0006\u0002\bQJF\u0010R\u001a\b\u0012\u0004\u0012\u00028\u00000D2\u0006\u0010S\u001a\u00020\u00042\b\b\u0002\u0010T\u001a\u00020\b2\b\b\u0002\u0010U\u001a\u00020\b2\b\b\u0002\u0010V\u001a\u00020W2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J;\u0010R\u001a\b\u0012\u0004\u0012\u00028\u00000X2\u0006\u0010L\u001a\u00020K2\u0006\u0010R\u001a\u00020Y2\u0006\u0010V\u001a\u00020W2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\bZJ+\u0010[\u001a\b\u0012\u0004\u0012\u00028\u00000X2\u0006\u0010\\\u001a\u00020K2\u0006\u0010R\u001a\u00020Y2\u0006\u0010V\u001a\u00020WH \u00a2\u0006\u0002\b]JN\u0010^\u001a\b\u0012\u0004\u0012\u0002070D2\u0006\u0010S\u001a\u00020\u00042\b\b\u0002\u0010T\u001a\u00020\b2\b\b\u0002\u0010U\u001a\u00020\b2\b\b\u0002\u0010_\u001a\u00020\b2\b\b\u0002\u0010`\u001a\u00020W2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bJD\u0010a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002070b0X2\u0006\u0010L\u001a\u00020K2\u0006\u0010R\u001a\u00020Y2\u0006\u0010c\u001a\u0002022\u0006\u0010_\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002JA\u0010d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002070b0X2\u0006\u0010L\u001a\u00020K2\u0006\u0010R\u001a\u00020Y2\u0006\u0010_\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH \u00a2\u0006\u0002\beR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R*\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010+\u0018\u00010*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0016\u00100\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00101\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203\u0018\u00010*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010-\"\u0004\b5\u0010/R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000203X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001b\u0010?\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u001e\u001a\u0004\b@\u0010AR \u0010C\u001a\b\u0012\u0004\u0012\u0002020DX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006k"}, d2={"Lorg/jetbrains/bio/big/BigFile;", "T", "Ljava/io/Closeable;", "source", "", "buffFactory", "Lorg/jetbrains/bio/RomBufferFactory;", "magic", "", "prefetch", "cancelledChecker", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lorg/jetbrains/bio/RomBufferFactory;IILkotlin/jvm/functions/Function0;)V", "bPlusTree", "Lorg/jetbrains/bio/big/BPlusTree;", "getBPlusTree$big", "()Lorg/jetbrains/bio/big/BPlusTree;", "setBPlusTree$big", "(Lorg/jetbrains/bio/big/BPlusTree;)V", "blockCacheIns", "Ljava/util/concurrent/atomic/AtomicLong;", "blockCacheMisses", "getBuffFactory$big", "()Lorg/jetbrains/bio/RomBufferFactory;", "chromosomes", "Lgnu/trove/map/TIntObjectMap;", "getChromosomes", "()Lgnu/trove/map/TIntObjectMap;", "chromosomes$delegate", "Lkotlin/Lazy;", "compression", "Lorg/jetbrains/bio/CompressionType;", "getCompression", "()Lorg/jetbrains/bio/CompressionType;", "header", "Lorg/jetbrains/bio/big/BigFile$Header;", "getHeader$big", "()Lorg/jetbrains/bio/big/BigFile$Header;", "setHeader$big", "(Lorg/jetbrains/bio/big/BigFile$Header;)V", "prefetchedChr2Leaf", "", "Lorg/jetbrains/bio/big/BPlusLeaf;", "getPrefetchedChr2Leaf$big", "()Ljava/util/Map;", "setPrefetchedChr2Leaf$big", "(Ljava/util/Map;)V", "prefetchedChromosomes", "prefetchedLevel2RTreeIndex", "Lorg/jetbrains/bio/big/ZoomLevel;", "Lorg/jetbrains/bio/big/RTreeIndex;", "getPrefetchedLevel2RTreeIndex$big", "setPrefetchedLevel2RTreeIndex$big", "prefetechedTotalSummary", "Lorg/jetbrains/bio/big/BigSummary;", "rTree", "getRTree$big", "()Lorg/jetbrains/bio/big/RTreeIndex;", "setRTree$big", "(Lorg/jetbrains/bio/big/RTreeIndex;)V", "getSource", "()Ljava/lang/String;", "totalSummary", "getTotalSummary", "()Lorg/jetbrains/bio/big/BigSummary;", "totalSummary$delegate", "zoomLevels", "", "getZoomLevels$big", "()Ljava/util/List;", "setZoomLevels$big", "(Ljava/util/List;)V", "close", "decompressAndCacheBlock", "Lorg/jetbrains/bio/RomBuffer;", "input", "chrom", "dataOffset", "", "dataSize", "decompressAndCacheBlock$big", "query", "name", "startOffset", "endOffset", "overlaps", "", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bio/big/ChromosomeInterval;", "query$big", "queryInternal", "decompressedBlock", "queryInternal$big", "summarize", "numBins", "index", "summarizeFromZoom", "Lkotlin/collections/IndexedValue;", "zoomLevel", "summarizeInternal", "summarizeInternal$big", "Companion", "Header", "Post", "RomBufferState", "Type", "big"})
public abstract class BigFile<T>
implements Closeable {
    public Header header;
    public List<ZoomLevel> zoomLevels;
    public BPlusTree bPlusTree;
    public RTreeIndex rTree;
    private BigSummary prefetechedTotalSummary;
    @NotNull
    private final Lazy totalSummary$delegate;
    private TIntObjectMap<String> prefetchedChromosomes;
    @NotNull
    private final Lazy chromosomes$delegate;
    @Nullable
    private Map<ZoomLevel, RTreeIndex> prefetchedLevel2RTreeIndex;
    @Nullable
    private Map<String, BPlusLeaf> prefetchedChr2Leaf;
    private final AtomicLong blockCacheMisses;
    private final AtomicLong blockCacheIns;
    @NotNull
    private final String source;
    @NotNull
    private final RomBufferFactory buffFactory;
    private static final Logger LOG;
    public static final int PREFETCH_LEVEL_OFF = 0;
    public static final int PREFETCH_LEVEL_FAST = 1;
    public static final int PREFETCH_LEVEL_DETAILED = 2;
    private static final ThreadLocal<Pair<RomBufferState, RomBuffer>> lastCachedBlockInfo;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Header getHeader$big() {
        Header header2 = this.header;
        if (header2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        }
        return header2;
    }

    public final void setHeader$big(@NotNull Header header2) {
        Intrinsics.checkNotNullParameter((Object)header2, (String)"<set-?>");
        this.header = header2;
    }

    @NotNull
    public final List<ZoomLevel> getZoomLevels$big() {
        List<ZoomLevel> list = this.zoomLevels;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zoomLevels");
        }
        return list;
    }

    public final void setZoomLevels$big(@NotNull List<ZoomLevel> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.zoomLevels = list;
    }

    @NotNull
    public final BPlusTree getBPlusTree$big() {
        BPlusTree bPlusTree = this.bPlusTree;
        if (bPlusTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bPlusTree");
        }
        return bPlusTree;
    }

    public final void setBPlusTree$big(@NotNull BPlusTree bPlusTree) {
        Intrinsics.checkNotNullParameter((Object)bPlusTree, (String)"<set-?>");
        this.bPlusTree = bPlusTree;
    }

    @NotNull
    public final RTreeIndex getRTree$big() {
        RTreeIndex rTreeIndex = this.rTree;
        if (rTreeIndex == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rTree");
        }
        return rTreeIndex;
    }

    public final void setRTree$big(@NotNull RTreeIndex rTreeIndex) {
        Intrinsics.checkNotNullParameter((Object)rTreeIndex, (String)"<set-?>");
        this.rTree = rTreeIndex;
    }

    @NotNull
    public final BigSummary getTotalSummary() {
        Lazy lazy = this.totalSummary$delegate;
        BigFile bigFile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BigSummary)lazy.getValue();
    }

    @NotNull
    public final TIntObjectMap<String> getChromosomes() {
        Lazy lazy = this.chromosomes$delegate;
        BigFile bigFile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TIntObjectMap)lazy.getValue();
    }

    @Nullable
    public final Map<ZoomLevel, RTreeIndex> getPrefetchedLevel2RTreeIndex$big() {
        return this.prefetchedLevel2RTreeIndex;
    }

    public final void setPrefetchedLevel2RTreeIndex$big(@Nullable Map<ZoomLevel, RTreeIndex> map) {
        this.prefetchedLevel2RTreeIndex = map;
    }

    @Nullable
    public final Map<String, BPlusLeaf> getPrefetchedChr2Leaf$big() {
        return this.prefetchedChr2Leaf;
    }

    public final void setPrefetchedChr2Leaf$big(@Nullable Map<String, BPlusLeaf> map) {
        this.prefetchedChr2Leaf = map;
    }

    @NotNull
    public final CompressionType getCompression() {
        CompressionType compressionType;
        Header header2 = this.header;
        if (header2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        }
        Header header3 = header2;
        boolean bl = false;
        boolean bl2 = false;
        Header $this$with = header3;
        boolean bl3 = false;
        if ($this$with.getVersion() < 3 || $this$with.getUncompressBufSize() == 0) {
            compressionType = CompressionType.NO_COMPRESSION;
        } else if ($this$with.getVersion() <= 4) {
            compressionType = CompressionType.DEFLATE;
        } else if ($this$with.getVersion() == 5) {
            compressionType = CompressionType.SNAPPY;
        } else {
            String string = "unsupported version: " + $this$with.getVersion();
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return compressionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<BigSummary> summarize(@NotNull String name, int startOffset, int endOffset, int numBins, boolean index2, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List list = CollectionsKt.emptyList();
        Closeable closeable = this.buffFactory.create();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Sequence<IndexedValue<BigSummary>> sequence;
            ZoomLevel zoomLevel;
            BPlusLeaf bPlusLeaf;
            RomBuffer input = (RomBuffer)closeable;
            boolean bl3 = false;
            if (this.prefetchedChr2Leaf != null) {
                Map<String, BPlusLeaf> map = this.prefetchedChr2Leaf;
                Intrinsics.checkNotNull(map);
                bPlusLeaf = map.get(name);
            } else {
                BPlusTree bPlusTree = this.bPlusTree;
                if (bPlusTree == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bPlusTree");
                }
                bPlusLeaf = bPlusTree.find(input, name);
            }
            if (bPlusLeaf == null) {
                throw (Throwable)new NoSuchElementException(name);
            }
            BPlusLeaf chromosome = bPlusLeaf;
            int properEndOffset = endOffset == 0 ? chromosome.getSize() : endOffset;
            ChromosomeInterval query2 = Interval.Companion.invoke$big(chromosome.getId(), startOffset, properEndOffset);
            boolean bl4 = numBins <= query2.length();
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "number of bins must not exceed interval length, got " + numBins + " > " + query2.length() + ", source " + this.source;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            List<ZoomLevel> list2 = this.zoomLevels;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"zoomLevels");
            }
            if ((zoomLevel = BigSummaryKt.pick(list2, query2.length() / (2 * numBins))) == null || !index2) {
                LOG.trace("Summarizing " + query2 + " from raw data");
                sequence = this.summarizeInternal$big(input, query2, numBins, cancelledChecker);
            } else {
                LOG.trace("Summarizing " + query2 + " from " + zoomLevel.getReduction() + "x zoom");
                sequence = this.summarizeFromZoom(input, query2, zoomLevel, numBins, cancelledChecker);
            }
            Sequence<IndexedValue<BigSummary>> sparseSummaries = sequence;
            BigSummary emptySummary = new BigSummary(0L, 0.0, 0.0, 0.0, 0.0, 31, null);
            int n = numBins;
            BigSummary[] bigSummaryArray = new BigSummary[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                Object[] objectArray = bigSummaryArray;
                boolean bl8 = false;
                BigSummary bigSummary = emptySummary;
                objectArray[n4] = bigSummary;
            }
            Object[] summaries = bigSummaryArray;
            for (IndexedValue indexedValue : sparseSummaries) {
                n2 = indexedValue.component1();
                BigSummary summary = (BigSummary)indexedValue.component2();
                summaries[i] = summary;
            }
            list = ArraysKt.asList((Object[])summaries);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    public static /* synthetic */ List summarize$default(BigFile bigFile, String string, int n, int n2, int n3, boolean bl, Function0 function0, int n4, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: summarize");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            function0 = null;
        }
        return bigFile.summarize(string, n, n2, n3, bl, (Function0<Unit>)function0);
    }

    @NotNull
    public abstract Sequence<IndexedValue<BigSummary>> summarizeInternal$big(@NotNull RomBuffer var1, @NotNull ChromosomeInterval var2, int var3, @Nullable Function0<Unit> var4) throws IOException;

    /*
     * WARNING - void declaration
     */
    private final Sequence<IndexedValue<BigSummary>> summarizeFromZoom(RomBuffer input, ChromosomeInterval query2, ZoomLevel zoomLevel, int numBins, Function0<Unit> cancelledChecker) {
        void edge;
        RTreeIndex rTreeIndex;
        if (this.prefetchedLevel2RTreeIndex != null) {
            Map<ZoomLevel, RTreeIndex> map = this.prefetchedLevel2RTreeIndex;
            Intrinsics.checkNotNull(map);
            RTreeIndex rTreeIndex2 = map.get(zoomLevel);
            Intrinsics.checkNotNull((Object)rTreeIndex2);
            rTreeIndex = rTreeIndex2;
        } else {
            rTreeIndex = RTreeIndex.Companion.read$big(input, zoomLevel.getIndexOffset());
        }
        RTreeIndex zRTree = rTreeIndex;
        Interval interval = query2;
        Header header2 = this.header;
        if (header2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        }
        List zoomData2 = SequencesKt.toList((Sequence)SequencesKt.flatMap(zRTree.findOverlappingBlocks(input, interval, header2.getUncompressBufSize(), cancelledChecker), (Function1)((Function1)new Function1<RTreeIndexLeaf, Sequence<? extends ZoomData>>(this, query2, input){
            final /* synthetic */ BigFile this$0;
            final /* synthetic */ ChromosomeInterval $query;
            final /* synthetic */ RomBuffer $input;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Sequence<ZoomData> invoke(@NotNull RTreeIndexLeaf $dstr$_u24__u24$offset$size) {
                void offset;
                String chrom;
                Intrinsics.checkNotNullParameter((Object)$dstr$_u24__u24$offset$size, (String)"<name for destructuring parameter 0>");
                long l = $dstr$_u24__u24$offset$size.component2();
                long size = $dstr$_u24__u24$offset$size.component3();
                boolean bl = !this.this$0.getCompression().getAbsent() || size % (long)ZoomData.Companion.getSIZE$big() == 0L;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String string = chrom = (String)this.this$0.getChromosomes().get(this.$query.getChromIx());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chrom");
                RomBuffer romBuffer = this.this$0.decompressAndCacheBlock$big(this.$input, string, (long)offset, size);
                bl3 = false;
                boolean bl5 = false;
                RomBuffer $this$with = romBuffer;
                boolean bl6 = false;
                ArrayList<ZoomData> res = new ArrayList<ZoomData>();
                do {
                    ZoomData zoomData2;
                    if (!(zoomData2 = ZoomData.Companion.read$big($this$with)).getInterval$big().intersects(this.$query)) continue;
                    res.add(zoomData2);
                } while ($this$with.hasRemaining());
                return CollectionsKt.asSequence((Iterable)res);
            }
            {
                this.this$0 = bigFile;
                this.$query = chromosomeInterval;
                this.$input = romBuffer;
                super(1);
            }
        })));
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        return SequencesKt.filterNotNull((Sequence)SequencesKt.mapIndexed(query2.slice$big(numBins), (Function2)((Function2)new Function2<Integer, ChromosomeInterval, IndexedValue<? extends BigSummary>>((Ref.IntRef)edge, zoomData2){
            final /* synthetic */ Ref.IntRef $edge;
            final /* synthetic */ List $zoomData;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final IndexedValue<BigSummary> invoke(int i, @NotNull ChromosomeInterval bin) {
                Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
                BigSummary summary = new BigSummary(0L, 0.0, 0.0, 0.0, 0.0, 31, null);
                int n = this.$edge.element;
                int n2 = this.$zoomData.size();
                while (n < n2) {
                    void j;
                    ChromosomeInterval interval = ((ZoomData)this.$zoomData.get((int)j)).getInterval$big();
                    if (interval.getEndOffset() <= bin.getStartOffset()) {
                        this.$edge.element = j + true;
                    } else {
                        if (interval.getStartOffset() > bin.getEndOffset()) break;
                        if (interval.intersects(bin)) {
                            summary.update$big((ZoomData)this.$zoomData.get((int)j), interval.intersectionLength(bin), interval.length());
                        }
                    }
                    ++j;
                }
                return summary.isEmpty$big() ? null : new IndexedValue(i, (Object)summary);
            }
            {
                this.$edge = intRef;
                this.$zoomData = list;
                super(2);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<T> query(@NotNull String name, int startOffset, int endOffset, boolean overlaps, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Closeable closeable = this.buffFactory.create();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            List list;
            BPlusLeaf res;
            BPlusLeaf bPlusLeaf;
            RomBuffer input = (RomBuffer)closeable;
            boolean bl3 = false;
            if (this.prefetchedChr2Leaf != null) {
                Map<String, BPlusLeaf> map = this.prefetchedChr2Leaf;
                Intrinsics.checkNotNull(map);
                bPlusLeaf = map.get(name);
            } else {
                BPlusTree bPlusTree = this.bPlusTree;
                if (bPlusTree == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bPlusTree");
                }
                bPlusLeaf = res = bPlusTree.find(input, name);
            }
            if (res == null) {
                list = CollectionsKt.emptyList();
            } else {
                void chromIx;
                BPlusLeaf bPlusLeaf2 = res;
                int n = bPlusLeaf2.component2();
                int size = bPlusLeaf2.component3();
                int properEndOffset = endOffset == 0 ? size : endOffset;
                list = SequencesKt.toList(this.query$big(input, Interval.Companion.invoke$big((int)chromIx, startOffset, properEndOffset), overlaps, cancelledChecker));
            }
            List list2 = list;
            return list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ List query$default(BigFile bigFile, String string, int n, int n2, boolean bl, Function0 function0, int n3, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: query");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            function0 = null;
        }
        return bigFile.query(string, n, n2, bl, (Function0<Unit>)function0);
    }

    @JvmOverloads
    @NotNull
    public final List<T> query(@NotNull String name, int startOffset, int endOffset, boolean overlaps) throws IOException {
        return BigFile.query$default(this, name, startOffset, endOffset, overlaps, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final List<T> query(@NotNull String name, int startOffset, int endOffset) throws IOException {
        return BigFile.query$default(this, name, startOffset, endOffset, false, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final List<T> query(@NotNull String name, int startOffset) throws IOException {
        return BigFile.query$default(this, name, startOffset, 0, false, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final List<T> query(@NotNull String name) throws IOException {
        return BigFile.query$default(this, name, 0, 0, false, null, 30, null);
    }

    @NotNull
    public final Sequence<T> query$big(@NotNull RomBuffer input, @NotNull ChromosomeInterval query2, boolean overlaps, @Nullable Function0<Unit> cancelledChecker) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        String chrom = (String)this.getChromosomes().get(query2.getChromIx());
        RTreeIndex rTreeIndex = this.rTree;
        if (rTreeIndex == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rTree");
        }
        Interval interval = query2;
        Header header2 = this.header;
        if (header2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        }
        return SequencesKt.flatMap(rTreeIndex.findOverlappingBlocks(input, interval, header2.getUncompressBufSize(), cancelledChecker), (Function1)new Function1<RTreeIndexLeaf, Sequence<? extends T>>(this, cancelledChecker, input, chrom, query2, overlaps){
            final /* synthetic */ BigFile this$0;
            final /* synthetic */ Function0 $cancelledChecker;
            final /* synthetic */ RomBuffer $input;
            final /* synthetic */ String $chrom;
            final /* synthetic */ ChromosomeInterval $query;
            final /* synthetic */ boolean $overlaps;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final Sequence<T> invoke(@NotNull RTreeIndexLeaf $dstr$_u24__u24$dataOffset$dataSize) {
                Sequence<T> sequence;
                void dataOffset;
                Intrinsics.checkNotNullParameter((Object)$dstr$_u24__u24$dataOffset$dataSize, (String)"<name for destructuring parameter 0>");
                long l = $dstr$_u24__u24$dataOffset$dataSize.component2();
                long dataSize = $dstr$_u24__u24$dataOffset$dataSize.component3();
                Function0 function0 = this.$cancelledChecker;
                if (function0 != null) {
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
                String string = this.$chrom;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chrom");
                Closeable closeable = this.this$0.decompressAndCacheBlock$big(this.$input, string, (long)dataOffset, dataSize);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    RomBuffer decompressedInput = (RomBuffer)closeable;
                    boolean bl3 = false;
                    sequence = this.this$0.queryInternal$big(decompressedInput, this.$query, this.$overlaps);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return sequence;
            }
            {
                this.this$0 = bigFile;
                this.$cancelledChecker = function0;
                this.$input = romBuffer;
                this.$chrom = string;
                this.$query = chromosomeInterval;
                this.$overlaps = bl;
                super(1);
            }
        });
    }

    @NotNull
    public final RomBuffer decompressAndCacheBlock$big(@NotNull RomBuffer input, @NotNull String chrom, long dataOffset, long dataSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Pair stateAndBlock = lastCachedBlockInfo.get();
        RomBufferState newState = new RomBufferState(this.buffFactory, dataOffset, dataSize, chrom);
        RomBuffer decompressedBlock = null;
        if (Intrinsics.areEqual((Object)((RomBufferState)stateAndBlock.getFirst()), (Object)newState) ^ true) {
            RomBuffer romBuffer;
            CompressionType compressionType = this.getCompression();
            Header header2 = this.header;
            if (header2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"header");
            }
            RomBuffer newDecompressedInput = input.decompress$big(dataOffset, dataSize, compressionType, header2.getUncompressBufSize());
            stateAndBlock = TuplesKt.to((Object)newState, (Object)newDecompressedInput);
            RomBuffer romBuffer2 = newDecompressedInput;
            if (romBuffer2 instanceof BBRomBuffer || romBuffer2 instanceof MMBRomBuffer) {
                lastCachedBlockInfo.set((Pair<RomBufferState, RomBuffer>)stateAndBlock);
                this.blockCacheMisses.incrementAndGet();
                romBuffer = newDecompressedInput.duplicate(newDecompressedInput.getPosition(), newDecompressedInput.getLimit());
            } else {
                romBuffer = newDecompressedInput;
            }
            decompressedBlock = romBuffer;
        } else {
            this.blockCacheIns.incrementAndGet();
            Object object = stateAndBlock.getSecond();
            Intrinsics.checkNotNull((Object)object);
            RomBuffer block = (RomBuffer)object;
            decompressedBlock = block.duplicate(block.getPosition(), block.getLimit());
        }
        return decompressedBlock;
    }

    @NotNull
    public abstract Sequence<T> queryInternal$big(@NotNull RomBuffer var1, @NotNull ChromosomeInterval var2, boolean var3) throws IOException;

    @Override
    public void close() {
        lastCachedBlockInfo.remove();
        long m = this.blockCacheMisses.get();
        long n = m + this.blockCacheIns.get();
        LOG.trace("BigFile closed: Cache misses " + Precision.round((double)(100.0 * (double)m / (double)n), (int)1) + "% (" + m + " of " + n + "), " + "source: : " + this.source + ' ');
        this.buffFactory.close();
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final RomBufferFactory getBuffFactory$big() {
        return this.buffFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BigFile(@NotNull String source, @NotNull RomBufferFactory buffFactory, int magic, int prefetch, @Nullable Function0<Unit> cancelledChecker) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)buffFactory, (String)"buffFactory");
        this.source = source;
        this.buffFactory = buffFactory;
        this.totalSummary$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BigSummary>(this){
            final /* synthetic */ BigFile this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final BigSummary invoke() {
                BigSummary bigSummary = BigFile.access$getPrefetechedTotalSummary$p(this.this$0);
                if (bigSummary == null) {
                    Closeable closeable = this.this$0.getBuffFactory$big().create();
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        RomBuffer it = (RomBuffer)closeable;
                        boolean bl3 = false;
                        BigSummary bigSummary2 = BigSummary.Companion.read$big(it, this.this$0.getHeader$big().getTotalSummaryOffset());
                        bigSummary = bigSummary2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return bigSummary;
            }
            {
                this.this$0 = bigFile;
                super(0);
            }
        }));
        this.chromosomes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TIntObjectMap<String>>(this){
            final /* synthetic */ BigFile this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final TIntObjectMap<String> invoke() {
                TIntObjectMap tIntObjectMap = BigFile.access$getPrefetchedChromosomes$p(this.this$0);
                if (tIntObjectMap == null) {
                    BPlusTree bPlusTree = this.this$0.getBPlusTree$big();
                    boolean bl = false;
                    boolean bl2 = false;
                    BPlusTree $this$with = bPlusTree;
                    boolean bl3 = false;
                    TIntObjectHashMap res = new TIntObjectHashMap($this$with.getHeader().getItemCount());
                    Closeable closeable = this.this$0.getBuffFactory$big().create();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable = null;
                    try {
                        RomBuffer it = (RomBuffer)closeable;
                        boolean bl6 = false;
                        for (BPlusLeaf bPlusLeaf : $this$with.traverse(it)) {
                            void key;
                            String string = bPlusLeaf.component1();
                            int id = bPlusLeaf.component2();
                            res.put(id, (Object)key);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    tIntObjectMap = TCollections.unmodifiableMap((TIntObjectMap)((TIntObjectMap)res));
                }
                return tIntObjectMap;
            }
            {
                this.this$0 = bigFile;
                super(0);
            }
        }));
        try {
            Closeable closeable = this.buffFactory.create();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ZoomLevel zoomLevel;
                Object object;
                void $this$mapTo$iv$iv222;
                Object $this$map$iv;
                RomBuffer input = (RomBuffer)closeable;
                boolean bl3 = false;
                Function0<Unit> function0 = cancelledChecker;
                if (function0 != null) {
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
                Header header2 = this.header = Header.Companion.read$big(input, magic);
                if (header2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"header");
                }
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)header2.getZoomLevelCount());
                BigFile bigFile = this;
                boolean $i$f$map = false;
                void var14_18 = $this$map$iv;
                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv222.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    object = destination$iv$iv;
                    boolean bl4 = false;
                    zoomLevel = ZoomLevel.Companion.read$big(input);
                    object.add(zoomLevel);
                }
                object = (List)destination$iv$iv;
                bigFile.zoomLevels = object;
                Header header3 = this.header;
                if (header3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"header");
                }
                this.bPlusTree = BPlusTree.Companion.read$big(input, header3.getChromTreeOffset());
                if (prefetch >= 1) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$with;
                    Function0<Unit> function02 = cancelledChecker;
                    if (function02 != null) {
                        Unit cfr_ignored_1 = (Unit)function02.invoke();
                    }
                    Header header4 = this.header;
                    if (header4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"header");
                    }
                    this.prefetechedTotalSummary = BigSummary.Companion.read$big(input, header4.getTotalSummaryOffset());
                    Function0<Unit> function03 = cancelledChecker;
                    if (function03 != null) {
                        Unit cfr_ignored_2 = (Unit)function03.invoke();
                    }
                    BPlusTree bPlusTree = this.bPlusTree;
                    if (bPlusTree == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"bPlusTree");
                    }
                    $this$map$iv = bPlusTree;
                    $i$f$map = false;
                    boolean $this$mapTo$iv$iv222 = false;
                    destination$iv$iv = $this$map$iv;
                    bigFile = this;
                    boolean bl5 = false;
                    Object res = new TIntObjectHashMap($this$with.getHeader().getItemCount());
                    for (BPlusLeaf it : $this$with.traverse(input)) {
                        void key;
                        String bl4 = it.component1();
                        int id = it.component2();
                        res.put(id, (Object)key);
                    }
                    object = TCollections.unmodifiableMap((TIntObjectMap)((TIntObjectMap)res));
                    bigFile.prefetchedChromosomes = object;
                    Function0<Unit> function04 = cancelledChecker;
                    if (function04 != null) {
                        Unit cfr_ignored_3 = (Unit)function04.invoke();
                    }
                    TIntObjectMap<String> tIntObjectMap = this.prefetchedChromosomes;
                    Intrinsics.checkNotNull(tIntObjectMap);
                    Collection collection = tIntObjectMap.valueCollection();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"prefetchedChromosomes!!.valueCollection()");
                    $this$map$iv = collection;
                    bigFile = this;
                    $i$f$map = false;
                    Object $this$mapTo$iv$iv222 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    res = $this$mapTo$iv$iv222.iterator();
                    while (res.hasNext()) {
                        Iterator item$iv$iv = res.next();
                        String it = (String)((Object)item$iv$iv);
                        object = destination$iv$iv;
                        boolean bl6 = false;
                        BPlusTree bPlusTree2 = this.bPlusTree;
                        if (bPlusTree2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"bPlusTree");
                        }
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        zoomLevel = TuplesKt.to((Object)it, (Object)bPlusTree2.find(input, string));
                        object.add(zoomLevel);
                    }
                    object = (List)destination$iv$iv;
                    bigFile.prefetchedChr2Leaf = MapsKt.toMap((Iterable)((Iterable)object));
                    List<ZoomLevel> list = this.zoomLevels;
                    if (list == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"zoomLevels");
                    }
                    $this$map$iv = list;
                    bigFile = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv222 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        Pair pair;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                        boolean bl7 = false;
                        ZoomLevel it = (ZoomLevel)element$iv$iv;
                        boolean bl8 = false;
                        if (it.getReduction() == 0) {
                            pair = null;
                        } else {
                            boolean bl9 = it.getIndexOffset() != 0L;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            if (!bl9) {
                                boolean bl12 = false;
                                String string = "Zoom index offset expected to be not zero.";
                                throw (Throwable)new IllegalArgumentException(string.toString());
                            }
                            bl9 = it.getDataOffset() != 0L;
                            bl10 = false;
                            bl11 = false;
                            if (!bl9) {
                                boolean bl13 = false;
                                String string = "Zoom data offset expected to be not zero.";
                                throw (Throwable)new IllegalArgumentException(string.toString());
                            }
                            RTreeIndex zRTree = RTreeIndex.Companion.read$big(input, it.getIndexOffset());
                            Header header5 = this.header;
                            if (header5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"header");
                            }
                            zRTree.prefetchBlocksIndex(input, true, false, header5.getUncompressBufSize(), cancelledChecker);
                            pair = TuplesKt.to((Object)it, (Object)zRTree);
                        }
                        if (pair == null) continue;
                        Pair pair2 = pair;
                        boolean bl14 = false;
                        boolean bl15 = false;
                        Pair it$iv$iv = pair2;
                        boolean bl16 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                    bigFile.prefetchedLevel2RTreeIndex = MapsKt.toMap((Iterable)((Iterable)object));
                }
                Function0<Unit> function05 = cancelledChecker;
                if (function05 != null) {
                    Unit cfr_ignored_4 = (Unit)function05.invoke();
                }
                Header header6 = this.header;
                if (header6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"header");
                }
                this.rTree = RTreeIndex.Companion.read$big(input, header6.getUnzoomedIndexOffset());
                if (prefetch >= 2) {
                    RTreeIndex rTreeIndex = this.rTree;
                    if (rTreeIndex == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"rTree");
                    }
                    Header header7 = this.header;
                    if (header7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"header");
                    }
                    rTreeIndex.prefetchBlocksIndex(input, false, true, header7.getUncompressBufSize(), cancelledChecker);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.buffFactory.close();
            throw (Throwable)e;
        }
        this.blockCacheMisses = new AtomicLong();
        this.blockCacheIns = new AtomicLong();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(BigFile.class);
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.lastCachedBlockInfo.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"ThreadLocal.withInitial \u20260L, \"\") to null\n        }");
        lastCachedBlockInfo = threadLocal;
    }

    public static final /* synthetic */ BigSummary access$getPrefetechedTotalSummary$p(BigFile $this) {
        return $this.prefetechedTotalSummary;
    }

    public static final /* synthetic */ void access$setPrefetechedTotalSummary$p(BigFile $this, BigSummary bigSummary) {
        $this.prefetechedTotalSummary = bigSummary;
    }

    public static final /* synthetic */ TIntObjectMap access$getPrefetchedChromosomes$p(BigFile $this) {
        return $this.prefetchedChromosomes;
    }

    public static final /* synthetic */ void access$setPrefetchedChromosomes$p(BigFile $this, TIntObjectMap tIntObjectMap) {
        $this.prefetchedChromosomes = tIntObjectMap;
    }

    @JvmStatic
    @NotNull
    public static final BigFile<Comparable<?>> read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        return Companion.read(path, cancelledChecker);
    }

    @JvmStatic
    @NotNull
    public static final BigFile<Comparable<?>> read(@NotNull String src, int prefetch, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
        return Companion.read(src, prefetch, cancelledChecker, factoryProvider);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b(\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 <2\u00020\u0001:\u0001<Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\t\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\tH\u00c6\u0003J\t\u0010,\u001a\u00020\tH\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\u008b\u0001\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\tH\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u00020\u0005H\u00d6\u0001J\t\u00105\u001a\u000206H\u00d6\u0001J\u0015\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\b;R\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0017\u00a8\u0006="}, d2={"Lorg/jetbrains/bio/big/BigFile$Header;", "", "order", "Ljava/nio/ByteOrder;", "magic", "", "version", "zoomLevelCount", "chromTreeOffset", "", "unzoomedDataOffset", "unzoomedIndexOffset", "fieldCount", "definedFieldCount", "asOffset", "totalSummaryOffset", "uncompressBufSize", "extendedHeaderOffset", "(Ljava/nio/ByteOrder;IIIJJJIIJJIJ)V", "getAsOffset", "()J", "getChromTreeOffset", "getDefinedFieldCount", "()I", "getExtendedHeaderOffset", "getFieldCount", "getMagic", "getOrder", "()Ljava/nio/ByteOrder;", "getTotalSummaryOffset", "getUncompressBufSize", "getUnzoomedDataOffset", "getUnzoomedIndexOffset", "getVersion", "getZoomLevelCount", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "write", "", "output", "Lorg/jetbrains/bio/OrderedDataOutput;", "write$big", "Companion", "big"})
    public static final class Header {
        @NotNull
        private final ByteOrder order;
        private final int magic;
        private final int version;
        private final int zoomLevelCount;
        private final long chromTreeOffset;
        private final long unzoomedDataOffset;
        private final long unzoomedIndexOffset;
        private final int fieldCount;
        private final int definedFieldCount;
        private final long asOffset;
        private final long totalSummaryOffset;
        private final int uncompressBufSize;
        private final long extendedHeaderOffset;
        public static final int BYTES = 64;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final void write$big(@NotNull OrderedDataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            boolean bl = false;
            boolean bl2 = false;
            OrderedDataOutput $this$with = output;
            boolean bl3 = false;
            boolean bl4 = output.tell() == 0L;
            boolean bl5 = false;
            boolean bl6 = false;
            bl6 = false;
            boolean bl7 = false;
            if (!bl4) {
                boolean bl8 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            $this$with.writeInt(this.magic);
            $this$with.writeShort(this.version);
            $this$with.writeShort(this.zoomLevelCount);
            $this$with.writeLong(this.chromTreeOffset);
            $this$with.writeLong(this.unzoomedDataOffset);
            $this$with.writeLong(this.unzoomedIndexOffset);
            $this$with.writeShort(this.fieldCount);
            $this$with.writeShort(this.definedFieldCount);
            $this$with.writeLong(this.asOffset);
            $this$with.writeLong(this.totalSummaryOffset);
            $this$with.writeInt(this.uncompressBufSize);
            $this$with.writeLong(this.extendedHeaderOffset);
        }

        @NotNull
        public final ByteOrder getOrder() {
            return this.order;
        }

        public final int getMagic() {
            return this.magic;
        }

        public final int getVersion() {
            return this.version;
        }

        public final int getZoomLevelCount() {
            return this.zoomLevelCount;
        }

        public final long getChromTreeOffset() {
            return this.chromTreeOffset;
        }

        public final long getUnzoomedDataOffset() {
            return this.unzoomedDataOffset;
        }

        public final long getUnzoomedIndexOffset() {
            return this.unzoomedIndexOffset;
        }

        public final int getFieldCount() {
            return this.fieldCount;
        }

        public final int getDefinedFieldCount() {
            return this.definedFieldCount;
        }

        public final long getAsOffset() {
            return this.asOffset;
        }

        public final long getTotalSummaryOffset() {
            return this.totalSummaryOffset;
        }

        public final int getUncompressBufSize() {
            return this.uncompressBufSize;
        }

        public final long getExtendedHeaderOffset() {
            return this.extendedHeaderOffset;
        }

        public Header(@NotNull ByteOrder order, int magic, int version, int zoomLevelCount, long chromTreeOffset, long unzoomedDataOffset, long unzoomedIndexOffset, int fieldCount, int definedFieldCount, long asOffset, long totalSummaryOffset, int uncompressBufSize, long extendedHeaderOffset) {
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            this.order = order;
            this.magic = magic;
            this.version = version;
            this.zoomLevelCount = zoomLevelCount;
            this.chromTreeOffset = chromTreeOffset;
            this.unzoomedDataOffset = unzoomedDataOffset;
            this.unzoomedIndexOffset = unzoomedIndexOffset;
            this.fieldCount = fieldCount;
            this.definedFieldCount = definedFieldCount;
            this.asOffset = asOffset;
            this.totalSummaryOffset = totalSummaryOffset;
            this.uncompressBufSize = uncompressBufSize;
            this.extendedHeaderOffset = extendedHeaderOffset;
        }

        public /* synthetic */ Header(ByteOrder byteOrder, int n, int n2, int n3, long l, long l2, long l3, int n4, int n5, long l4, long l5, int n6, long l6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 4) != 0) {
                n2 = 5;
            }
            if ((n7 & 8) != 0) {
                n3 = 0;
            }
            if ((n7 & 0x200) != 0) {
                l4 = 0L;
            }
            if ((n7 & 0x400) != 0) {
                l5 = 0L;
            }
            if ((n7 & 0x1000) != 0) {
                l6 = 0L;
            }
            this(byteOrder, n, n2, n3, l, l2, l3, n4, n5, l4, l5, n6, l6);
        }

        @NotNull
        public final ByteOrder component1() {
            return this.order;
        }

        public final int component2() {
            return this.magic;
        }

        public final int component3() {
            return this.version;
        }

        public final int component4() {
            return this.zoomLevelCount;
        }

        public final long component5() {
            return this.chromTreeOffset;
        }

        public final long component6() {
            return this.unzoomedDataOffset;
        }

        public final long component7() {
            return this.unzoomedIndexOffset;
        }

        public final int component8() {
            return this.fieldCount;
        }

        public final int component9() {
            return this.definedFieldCount;
        }

        public final long component10() {
            return this.asOffset;
        }

        public final long component11() {
            return this.totalSummaryOffset;
        }

        public final int component12() {
            return this.uncompressBufSize;
        }

        public final long component13() {
            return this.extendedHeaderOffset;
        }

        @NotNull
        public final Header copy(@NotNull ByteOrder order, int magic, int version, int zoomLevelCount, long chromTreeOffset, long unzoomedDataOffset, long unzoomedIndexOffset, int fieldCount, int definedFieldCount, long asOffset, long totalSummaryOffset, int uncompressBufSize, long extendedHeaderOffset) {
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            return new Header(order, magic, version, zoomLevelCount, chromTreeOffset, unzoomedDataOffset, unzoomedIndexOffset, fieldCount, definedFieldCount, asOffset, totalSummaryOffset, uncompressBufSize, extendedHeaderOffset);
        }

        public static /* synthetic */ Header copy$default(Header header2, ByteOrder byteOrder, int n, int n2, int n3, long l, long l2, long l3, int n4, int n5, long l4, long l5, int n6, long l6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                byteOrder = header2.order;
            }
            if ((n7 & 2) != 0) {
                n = header2.magic;
            }
            if ((n7 & 4) != 0) {
                n2 = header2.version;
            }
            if ((n7 & 8) != 0) {
                n3 = header2.zoomLevelCount;
            }
            if ((n7 & 0x10) != 0) {
                l = header2.chromTreeOffset;
            }
            if ((n7 & 0x20) != 0) {
                l2 = header2.unzoomedDataOffset;
            }
            if ((n7 & 0x40) != 0) {
                l3 = header2.unzoomedIndexOffset;
            }
            if ((n7 & 0x80) != 0) {
                n4 = header2.fieldCount;
            }
            if ((n7 & 0x100) != 0) {
                n5 = header2.definedFieldCount;
            }
            if ((n7 & 0x200) != 0) {
                l4 = header2.asOffset;
            }
            if ((n7 & 0x400) != 0) {
                l5 = header2.totalSummaryOffset;
            }
            if ((n7 & 0x800) != 0) {
                n6 = header2.uncompressBufSize;
            }
            if ((n7 & 0x1000) != 0) {
                l6 = header2.extendedHeaderOffset;
            }
            return header2.copy(byteOrder, n, n2, n3, l, l2, l3, n4, n5, l4, l5, n6, l6);
        }

        @NotNull
        public String toString() {
            return "Header(order=" + this.order + ", magic=" + this.magic + ", version=" + this.version + ", zoomLevelCount=" + this.zoomLevelCount + ", chromTreeOffset=" + this.chromTreeOffset + ", unzoomedDataOffset=" + this.unzoomedDataOffset + ", unzoomedIndexOffset=" + this.unzoomedIndexOffset + ", fieldCount=" + this.fieldCount + ", definedFieldCount=" + this.definedFieldCount + ", asOffset=" + this.asOffset + ", totalSummaryOffset=" + this.totalSummaryOffset + ", uncompressBufSize=" + this.uncompressBufSize + ", extendedHeaderOffset=" + this.extendedHeaderOffset + ")";
        }

        public int hashCode() {
            ByteOrder byteOrder = this.order;
            return ((((((((((((byteOrder != null ? byteOrder.hashCode() : 0) * 31 + Integer.hashCode(this.magic)) * 31 + Integer.hashCode(this.version)) * 31 + Integer.hashCode(this.zoomLevelCount)) * 31 + Long.hashCode(this.chromTreeOffset)) * 31 + Long.hashCode(this.unzoomedDataOffset)) * 31 + Long.hashCode(this.unzoomedIndexOffset)) * 31 + Integer.hashCode(this.fieldCount)) * 31 + Integer.hashCode(this.definedFieldCount)) * 31 + Long.hashCode(this.asOffset)) * 31 + Long.hashCode(this.totalSummaryOffset)) * 31 + Integer.hashCode(this.uncompressBufSize)) * 31 + Long.hashCode(this.extendedHeaderOffset);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Header)) break block3;
                    Header header2 = (Header)object;
                    if (!Intrinsics.areEqual((Object)this.order, (Object)header2.order) || this.magic != header2.magic || this.version != header2.version || this.zoomLevelCount != header2.zoomLevelCount || this.chromTreeOffset != header2.chromTreeOffset || this.unzoomedDataOffset != header2.unzoomedDataOffset || this.unzoomedIndexOffset != header2.unzoomedIndexOffset || this.fieldCount != header2.fieldCount || this.definedFieldCount != header2.definedFieldCount || this.asOffset != header2.asOffset || this.totalSummaryOffset != header2.totalSummaryOffset || this.uncompressBufSize != header2.uncompressBufSize || this.extendedHeaderOffset != header2.extendedHeaderOffset) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/bio/big/BigFile$Header$Companion;", "", "()V", "BYTES", "", "read", "Lorg/jetbrains/bio/big/BigFile$Header;", "input", "Lorg/jetbrains/bio/RomBuffer;", "magic", "read$big", "big"})
        public static final class Companion {
            @NotNull
            public final Header read$big(@NotNull RomBuffer input, int magic) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                boolean bl = false;
                boolean bl2 = false;
                RomBuffer $this$with = input;
                boolean bl3 = false;
                $this$with.checkHeader(magic);
                int version = $this$with.readUnsignedShort();
                int zoomLevelCount = $this$with.readUnsignedShort();
                long chromTreeOffset = $this$with.readLong();
                long unzoomedDataOffset = $this$with.readLong();
                long unzoomedIndexOffset = $this$with.readLong();
                int fieldCount = $this$with.readUnsignedShort();
                int definedFieldCount = $this$with.readUnsignedShort();
                long asOffset = $this$with.readLong();
                long totalSummaryOffset = $this$with.readLong();
                int uncompressBufSize = $this$with.readInt();
                long extendedHeaderOffset = $this$with.readLong();
                if (extendedHeaderOffset > 0L) {
                    LOG.debug("Header extensions are unsupported");
                }
                return new Header($this$with.getOrder(), magic, version, zoomLevelCount, chromTreeOffset, unzoomedDataOffset, unzoomedIndexOffset, fieldCount, definedFieldCount, asOffset, totalSummaryOffset, uncompressBufSize, extendedHeaderOffset);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/bio/big/BigFile$RomBufferState;", "", "buffFactory", "Lorg/jetbrains/bio/RomBufferFactory;", "offset", "", "size", "chrom", "", "(Lorg/jetbrains/bio/RomBufferFactory;JJLjava/lang/String;)V", "getChrom", "()Ljava/lang/String;", "getOffset", "()J", "getSize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "big"})
    public static final class RomBufferState {
        private final RomBufferFactory buffFactory;
        private final long offset;
        private final long size;
        @NotNull
        private final String chrom;

        public final long getOffset() {
            return this.offset;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final String getChrom() {
            return this.chrom;
        }

        public RomBufferState(@Nullable RomBufferFactory buffFactory, long offset, long size, @NotNull String chrom) {
            Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
            this.buffFactory = buffFactory;
            this.offset = offset;
            this.size = size;
            this.chrom = chrom;
        }

        private final RomBufferFactory component1() {
            return this.buffFactory;
        }

        public final long component2() {
            return this.offset;
        }

        public final long component3() {
            return this.size;
        }

        @NotNull
        public final String component4() {
            return this.chrom;
        }

        @NotNull
        public final RomBufferState copy(@Nullable RomBufferFactory buffFactory, long offset, long size, @NotNull String chrom) {
            Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
            return new RomBufferState(buffFactory, offset, size, chrom);
        }

        public static /* synthetic */ RomBufferState copy$default(RomBufferState romBufferState, RomBufferFactory romBufferFactory, long l, long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                romBufferFactory = romBufferState.buffFactory;
            }
            if ((n & 2) != 0) {
                l = romBufferState.offset;
            }
            if ((n & 4) != 0) {
                l2 = romBufferState.size;
            }
            if ((n & 8) != 0) {
                string = romBufferState.chrom;
            }
            return romBufferState.copy(romBufferFactory, l, l2, string);
        }

        @NotNull
        public String toString() {
            return "RomBufferState(buffFactory=" + this.buffFactory + ", offset=" + this.offset + ", size=" + this.size + ", chrom=" + this.chrom + ")";
        }

        public int hashCode() {
            RomBufferFactory romBufferFactory = this.buffFactory;
            String string = this.chrom;
            return (((romBufferFactory != null ? romBufferFactory.hashCode() : 0) * 31 + Long.hashCode(this.offset)) * 31 + Long.hashCode(this.size)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RomBufferState)) break block3;
                    RomBufferState romBufferState = (RomBufferState)object;
                    if (!Intrinsics.areEqual((Object)this.buffFactory, (Object)romBufferState.buffFactory) || this.offset != romBufferState.offset || this.size != romBufferState.size || !Intrinsics.areEqual((Object)this.chrom, (Object)romBufferState.chrom)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00070\rH\u0082\b\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0013JC\u0010\u0014\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00162\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\b\u001bJB\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00162\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001aH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/bio/big/BigFile$Post;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "modify", "T", "path", "Ljava/nio/file/Path;", "offset", "", "block", "Lkotlin/Function2;", "Lorg/jetbrains/bio/big/BigFile;", "Lorg/jetbrains/bio/OrderedDataOutput;", "(Ljava/nio/file/Path;JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "totalSummary", "", "totalSummary$big", "zoom", "itemsPerSlot", "", "initial", "step", "cancelledChecker", "Lkotlin/Function0;", "zoom$big", "zoomAt", "Lorg/jetbrains/bio/big/ZoomLevel;", "bf", "output", "prevLevelReduction", "big"})
    protected static final class Post {
        private static final Logger LOG;
        @NotNull
        public static final Post INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T modify(Path path, long offset, Function2<? super BigFile<?>, ? super OrderedDataOutput, ? extends T> block) {
            Object object;
            int $i$f$modify = 0;
            Closeable closeable = org.jetbrains.bio.big.BigFile$Companion.read$default(Companion, path, null, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object object2;
                BigFile bf = (BigFile)closeable;
                boolean bl3 = false;
                Closeable closeable2 = OrderedDataOutput.Companion.invoke(path, bf.getHeader$big().getOrder(), offset, false);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    OrderedDataOutput it = (OrderedDataOutput)closeable2;
                    boolean bl6 = false;
                    object2 = block.invoke((Object)bf, (Object)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                object = object2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static /* synthetic */ Object modify$default(Post this_, Path path, long offset, Function2 block, int n, Object object) {
            Object object2;
            if ((n & 2) != 0) {
                offset = 0L;
            }
            boolean $i$f$modify = false;
            object = org.jetbrains.bio.big.BigFile$Companion.read$default(Companion, path, null, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object object3;
                BigFile bf = (BigFile)object;
                boolean bl3 = false;
                Closeable closeable = OrderedDataOutput.Companion.invoke(path, bf.getHeader$big().getOrder(), offset, false);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    OrderedDataOutput it = (OrderedDataOutput)closeable;
                    boolean bl6 = false;
                    object3 = block.invoke((Object)bf, (Object)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                object2 = object3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void zoom$big(@NotNull Path path, int itemsPerSlot, int initial, int step, @Nullable Function0<Unit> cancelledChecker) {
            OrderedDataOutput output;
            boolean bl;
            OrderedDataOutput it$iv2;
            boolean bl2;
            Closeable closeable;
            boolean bl3;
            Closeable bf$iv2;
            Path path$iv;
            void $this$time$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger logger2 = logger;
            String message$iv = "Computing zoom levels with step " + step + " for " + path;
            boolean $i$f$time = false;
            $this$time$iv.debug(message$iv);
            Stopwatch stopwatch$iv = Stopwatch.createStarted();
            boolean bl4 = false;
            ArrayList<ZoomLevel> zoomLevels = new ArrayList<ZoomLevel>();
            Post post = INSTANCE;
            Path path2 = path;
            long offset$iv = Files.size(path);
            boolean $i$f$modify = false;
            Closeable closeable2 = org.jetbrains.bio.big.BigFile$Companion.read$default(Companion, path$iv, null, 2, null);
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = null;
            try {
                bf$iv2 = (BigFile)closeable2;
                bl3 = false;
                closeable = OrderedDataOutput.Companion.invoke(path$iv, ((BigFile)bf$iv2).getHeader$big().getOrder(), offset$iv, false);
                bl2 = false;
                boolean bl7 = false;
                Throwable throwable2 = null;
                try {
                    it$iv2 = (OrderedDataOutput)closeable;
                    bl = false;
                    OrderedDataOutput orderedDataOutput = it$iv2;
                    BigFile bf = bf$iv2;
                    boolean bl8 = false;
                    int reduction = initial;
                    int n = 0;
                    int n2 = ((Collection)bf.getZoomLevels$big()).size();
                    while (n < n2) {
                        void level;
                        ZoomLevel zoomLevel = INSTANCE.zoomAt(reduction, bf, output, itemsPerSlot, reduction / step, cancelledChecker);
                        if (zoomLevel == null) {
                            LOG.trace(reduction + "x reduction rejected");
                            break;
                        }
                        LOG.trace(reduction + "x reduction accepted");
                        zoomLevels.add(zoomLevel);
                        if ((reduction *= step) < 0) {
                            LOG.trace("Reduction overflow (" + reduction + ") at level " + (int)level + ", next levels ignored");
                            break;
                        }
                        ++level;
                    }
                    it$iv2 = Unit.INSTANCE;
                }
                catch (Throwable it$iv2) {
                    throwable2 = it$iv2;
                    throw it$iv2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                bf$iv2 = it$iv2;
            }
            catch (Throwable bf$iv2) {
                throwable = bf$iv2;
                throw bf$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            Post this_$iv = INSTANCE;
            path$iv = path;
            offset$iv = 64;
            $i$f$modify = false;
            closeable2 = org.jetbrains.bio.big.BigFile$Companion.read$default(Companion, path$iv, null, 2, null);
            bl5 = false;
            boolean bl9 = false;
            Throwable throwable3 = null;
            try {
                Unit unit;
                bf$iv2 = (BigFile)closeable2;
                bl3 = false;
                closeable = OrderedDataOutput.Companion.invoke(path$iv, ((BigFile)bf$iv2).getHeader$big().getOrder(), offset$iv, false);
                bl2 = false;
                boolean bl10 = false;
                Throwable throwable4 = null;
                try {
                    it$iv2 = (OrderedDataOutput)closeable;
                    bl = false;
                    output = it$iv2;
                    Closeable $noName_0 = bf$iv2;
                    boolean bl11 = false;
                    for (ZoomLevel zoomLevel : zoomLevels) {
                        long zoomHeaderOffset = output.tell();
                        zoomLevel.write$big(output);
                        boolean bl12 = (int)(output.tell() - zoomHeaderOffset) == ZoomLevel.Companion.getBYTES$big();
                        boolean bl13 = false;
                        boolean bl14 = false;
                        if (!_Assertions.ENABLED || bl12) continue;
                        boolean bl15 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable4 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable4);
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable6) {
                throwable3 = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
            }
            Unit res$iv = Unit.INSTANCE;
            stopwatch$iv.stop();
            $this$time$iv.debug("Done in " + stopwatch$iv);
        }

        public static /* synthetic */ void zoom$big$default(Post post, Path path, int n, int n2, int n3, Function0 function0, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n = 512;
            }
            if ((n4 & 4) != 0) {
                n2 = 8;
            }
            if ((n4 & 8) != 0) {
                n3 = 4;
            }
            post.zoom$big(path, n, n2, n3, (Function0<Unit>)function0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final ZoomLevel zoomAt(int $this$zoomAt, BigFile<?> bf, OrderedDataOutput output, int itemsPerSlot, int prevLevelReduction, Function0<Unit> cancelledChecker) {
            ZoomLevel zoomLevel;
            int reduction = $this$zoomAt;
            long zoomedDataOffset = output.tell();
            ArrayList<RTreeIndexLeaf> leaves2 = new ArrayList<RTreeIndexLeaf>();
            Closeable closeable = bf.getBuffFactory$big().create();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                RomBuffer input = (RomBuffer)closeable;
                boolean bl3 = false;
                for (BPlusLeaf bPlusLeaf : bf.getBPlusTree$big().traverse(input)) {
                    void chromIx;
                    int n = bPlusLeaf.component2();
                    int size = bPlusLeaf.component3();
                    ChromosomeInterval query2 = Interval.Companion.invoke$big((int)chromIx, 0, size);
                    if (prevLevelReduction > size) continue;
                    Sequence<IndexedValue<BigSummary>> summaries = bf.summarizeInternal$big(input, query2, SupportKt.divCeiling(size, reduction), cancelledChecker);
                    UnmodifiableIterator unmodifiableIterator = Iterators.partition((Iterator)summaries.iterator(), (int)itemsPerSlot);
                    Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"Iterators.partition(summ\u2026iterator(), itemsPerSlot)");
                    Iterator iterator2 = (Iterator)unmodifiableIterator;
                    boolean bl4 = false;
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        List slot = (List)iterator3.next();
                        long dataOffset = output.tell();
                        output.with(bf.getCompression(), (Function1<? super OrderedDataOutput, Unit>)((Function1)new Function1<OrderedDataOutput, Unit>(slot, (int)chromIx, bf, prevLevelReduction, reduction, cancelledChecker, itemsPerSlot, output, leaves2){
                            final /* synthetic */ List $slot;
                            final /* synthetic */ int $chromIx;
                            final /* synthetic */ BigFile $bf$inlined;
                            final /* synthetic */ int $prevLevelReduction$inlined;
                            final /* synthetic */ int $reduction$inlined;
                            final /* synthetic */ Function0 $cancelledChecker$inlined;
                            final /* synthetic */ int $itemsPerSlot$inlined;
                            final /* synthetic */ OrderedDataOutput $output$inlined;
                            final /* synthetic */ ArrayList $leaves$inlined;
                            {
                                this.$slot = list;
                                this.$chromIx = n;
                                this.$bf$inlined = bigFile;
                                this.$prevLevelReduction$inlined = n2;
                                this.$reduction$inlined = n3;
                                this.$cancelledChecker$inlined = function0;
                                this.$itemsPerSlot$inlined = n4;
                                this.$output$inlined = orderedDataOutput;
                                this.$leaves$inlined = arrayList;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull OrderedDataOutput $this$with) {
                                Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                                for (IndexedValue indexedValue : this.$slot) {
                                    void sum;
                                    void maxValue;
                                    void minValue;
                                    void count;
                                    void i;
                                    int n = indexedValue.component1();
                                    BigSummary summary = (BigSummary)indexedValue.component2();
                                    void startOffset = i * this.$reduction$inlined;
                                    void endOffset = (i + true) * this.$reduction$inlined;
                                    BigSummary bigSummary = summary;
                                    long l = bigSummary.component1();
                                    double d = bigSummary.component2();
                                    double d2 = bigSummary.component3();
                                    double d3 = bigSummary.component4();
                                    double sumSquares = bigSummary.component5();
                                    new ZoomData(this.$chromIx, (int)startOffset, (int)endOffset, (int)count, (float)minValue, (float)maxValue, (float)sum, (float)sumSquares).write$big($this$with);
                                }
                            }
                        }));
                        List list = slot;
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"slot");
                        ChromosomeInterval interval = Interval.Companion.invoke$big((int)chromIx, ((IndexedValue)CollectionsKt.first((List)list)).getIndex() * reduction, (((IndexedValue)CollectionsKt.last((List)slot)).getIndex() + 1) * reduction);
                        leaves2.add(new RTreeIndexLeaf(interval, dataOffset, output.tell() - dataOffset));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (leaves2.size() > 1) {
                long zoomedIndexOffset = output.tell();
                RTreeIndex.Companion.write$big$default(RTreeIndex.Companion, output, leaves2, 0, itemsPerSlot, 4, null);
                zoomLevel = new ZoomLevel(reduction, zoomedDataOffset, zoomedIndexOffset);
            } else {
                zoomLevel = null;
            }
            return zoomLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void totalSummary$big(@NotNull Path path) {
            void path$iv;
            void $this$time$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Closeable closeable = org.jetbrains.bio.big.BigFile$Companion.read$default(Companion, path, null, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BigFile it22 = (BigFile)closeable;
                boolean bl3 = false;
                long it22 = it22.getHeader$big().getTotalSummaryOffset();
            }
            catch (Throwable it22) {
                throwable = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            long totalSummaryOffset = it22;
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            closeable = logger;
            String message$iv = "Computing total summary block for " + path;
            boolean $i$f$time = false;
            $this$time$iv.debug(message$iv);
            Stopwatch stopwatch$iv = Stopwatch.createStarted();
            boolean bl4 = false;
            Post post = INSTANCE;
            Path path2 = path;
            long offset$iv = totalSummaryOffset;
            boolean $i$f$modify = false;
            Closeable closeable2 = org.jetbrains.bio.big.BigFile$Companion.read$default(Companion, (Path)path$iv, null, 2, null);
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable2 = null;
            try {
                Unit unit;
                BigFile bf$iv = (BigFile)closeable2;
                boolean bl7 = false;
                Closeable closeable3 = OrderedDataOutput.Companion.invoke((Path)path$iv, bf$iv.getHeader$big().getOrder(), offset$iv, false);
                boolean bl8 = false;
                boolean bl9 = false;
                Throwable throwable3 = null;
                try {
                    void output;
                    void $this$fold$iv;
                    void $this$flatMapTo$iv$iv;
                    OrderedDataOutput it$iv = (OrderedDataOutput)closeable3;
                    boolean bl10 = false;
                    OrderedDataOutput orderedDataOutput = it$iv;
                    BigFile bf = bf$iv;
                    boolean bl11 = false;
                    Collection collection = bf.getChromosomes().valueCollection();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"bf.chromosomes.valueCollection()");
                    Iterable $this$flatMap$iv = collection;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl12 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        Iterable list$iv$iv = BigFile.summarize$default(bf, string, 0, 0, 1, false, null, 48, null);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    BigSummary initial$iv = new BigSummary(0L, 0.0, 0.0, 0.0, 0.0, 31, null);
                    boolean $i$f$fold = false;
                    BigSummary accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void p2;
                        Object element$iv$iv;
                        element$iv$iv = (BigSummary)element$iv;
                        BigSummary p1 = accumulator$iv;
                        boolean bl13 = false;
                        accumulator$iv = p1.plus$big((BigSummary)p2);
                    }
                    accumulator$iv.write$big((OrderedDataOutput)output);
                    boolean bl14 = (int)(output.tell() - totalSummaryOffset) == BigSummary.Companion.getBYTES$big();
                    boolean bl15 = false;
                    boolean bl16 = false;
                    if (_Assertions.ENABLED && !bl14) {
                        boolean bl17 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit res$iv = Unit.INSTANCE;
            stopwatch$iv.stop();
            $this$time$iv.debug("Done in " + stopwatch$iv);
        }

        private Post() {
        }

        static {
            Post post;
            INSTANCE = post = new Post();
            LOG = LoggerFactory.getLogger(post.getClass());
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/bio/big/BigFile$Type;", "", "(Ljava/lang/String;I)V", "BIGWIG", "BIGBED", "big"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BIGWIG;
        public static final /* enum */ Type BIGBED;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[2];
            Type[] typeArray2 = typeArray;
            typeArray[0] = BIGWIG = new Type();
            typeArray[1] = BIGBED = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010j\u0002`\u0014J0\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u001e\b\u0002\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010j\u0002`\u0014J%\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001dJ$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J1\u0010#\u001a&\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e \u0005*\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\f0\fH\u0000\u00a2\u0006\u0002\b$J,\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\u0006\u0010\u001a\u001a\u00020(2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*H\u0007JV\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u00072\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\u001e\b\u0002\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010j\u0002`\u0014H\u0007J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0013H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/bio/big/BigFile$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PREFETCH_LEVEL_DETAILED", "", "PREFETCH_LEVEL_FAST", "PREFETCH_LEVEL_OFF", "lastCachedBlockInfo", "Ljava/lang/ThreadLocal;", "Lkotlin/Pair;", "Lorg/jetbrains/bio/big/BigFile$RomBufferState;", "Lorg/jetbrains/bio/RomBuffer;", "defaultFactory", "Lkotlin/Function2;", "", "Ljava/nio/ByteOrder;", "Lorg/jetbrains/bio/RomBufferFactory;", "Lorg/jetbrains/bio/big/RomBufferFactoryProvider;", "determineFileType", "Lorg/jetbrains/bio/big/BigFile$Type;", "src", "factoryProvider", "getByteOrder", "path", "magic", "bufferFactory", "getByteOrder$big", "guess", "", "expectedMagic", "littleEndianMagic", "guessFileType", "lastCachedBlockInfoValue", "lastCachedBlockInfoValue$big", "read", "Lorg/jetbrains/bio/big/BigFile;", "", "Ljava/nio/file/Path;", "cancelledChecker", "Lkotlin/Function0;", "", "prefetch", "readLEMagic", "buffFactory", "big"})
    public static final class Companion {
        public final Pair<RomBufferState, RomBuffer> lastCachedBlockInfoValue$big() {
            return (Pair)lastCachedBlockInfo.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int readLEMagic(RomBufferFactory buffFactory) {
            int n;
            Closeable closeable = buffFactory.create();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                RomBuffer it = (RomBuffer)closeable;
                boolean bl3 = false;
                n = it.readInt();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ByteOrder getByteOrder$big(@NotNull String path, int magic, @NotNull RomBufferFactory bufferFactory) {
            void valid;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)bufferFactory, (String)"bufferFactory");
            int leMagic = this.readLEMagic(bufferFactory);
            Pair<Boolean, ByteOrder> pair = this.guess(magic, leMagic);
            boolean bl = (Boolean)pair.component1();
            ByteOrder byteOrder = (ByteOrder)pair.component2();
            boolean bl2 = false;
            boolean bl3 = false;
            if (valid == false) {
                boolean bl4 = false;
                int bigMagic = Integer.reverseBytes(magic);
                String string = "Unexpected header leMagic: Actual " + leMagic + " doesn't match expected LE=" + magic + " and BE=" + bigMagic + "}," + " file: " + path;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return byteOrder;
        }

        private final Pair<Boolean, ByteOrder> guess(int expectedMagic, int littleEndianMagic) {
            if (littleEndianMagic != expectedMagic) {
                int bigEndianMagic = Integer.reverseBytes(littleEndianMagic);
                if (bigEndianMagic != expectedMagic) {
                    return TuplesKt.to((Object)false, (Object)ByteOrder.BIG_ENDIAN);
                }
                return TuplesKt.to((Object)true, (Object)ByteOrder.BIG_ENDIAN);
            }
            return TuplesKt.to((Object)true, (Object)ByteOrder.LITTLE_ENDIAN);
        }

        @NotNull
        public final Function2<String, ByteOrder, RomBufferFactory> defaultFactory() {
            return defaultFactory.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final BigFile<Comparable<?>> read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return org.jetbrains.bio.big.BigFile$Companion.read$default(this, ((Object)path).toString(), 0, cancelledChecker, null, 10, null);
        }

        public static /* synthetic */ BigFile read$default(Companion companion, Path path, Function0 function0, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                function0 = null;
            }
            return companion.read(path, (Function0<Unit>)function0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final BigFile<Comparable<?>> read(@NotNull String src, int prefetch, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter(factoryProvider, (String)"factoryProvider");
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"ByteOrder.LITTLE_ENDIAN");
            Closeable closeable = (Closeable)factoryProvider.invoke((Object)src, (Object)byteOrder);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BigFile bigFile;
                RomBufferFactory factory = (RomBufferFactory)closeable;
                boolean bl3 = false;
                int magic = Companion.readLEMagic(factory);
                Type type = Companion.guessFileType(magic);
                if (type == null) throw (Throwable)new IllegalStateException("Unsupported file header magic: " + magic);
                switch (BigFile$Companion$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        bigFile = BigBedFile.Companion.read(src, prefetch, cancelledChecker, factoryProvider);
                        break;
                    }
                    case 2: {
                        bigFile = BigWigFile.Companion.read(src, prefetch, cancelledChecker, factoryProvider);
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException("Unsupported file header magic: " + magic);
                    }
                }
                BigFile bigFile2 = bigFile;
                return bigFile2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ BigFile read$default(Companion companion, String string, int n, Function0 function0, Function2 function2, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 2;
            }
            if ((n2 & 4) != 0) {
                function0 = null;
            }
            if ((n2 & 8) != 0) {
                function2 = companion.defaultFactory();
            }
            return companion.read(string, n, (Function0<Unit>)function0, function2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Type determineFileType(@NotNull String src, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) {
            Type type;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter(factoryProvider, (String)"factoryProvider");
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"ByteOrder.LITTLE_ENDIAN");
            Closeable closeable = (Closeable)factoryProvider.invoke((Object)src, (Object)byteOrder);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                RomBufferFactory factory = (RomBufferFactory)closeable;
                boolean bl3 = false;
                type = Companion.guessFileType(Companion.readLEMagic(factory));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return type;
        }

        public static /* synthetic */ Type determineFileType$default(Companion companion, String string, Function2 function2, int n, Object object) {
            if ((n & 2) != 0) {
                function2 = companion.defaultFactory();
            }
            return companion.determineFileType(string, function2);
        }

        private final Type guessFileType(int magic) {
            return (Boolean)this.guess(-2021002517, magic).getFirst() != false ? Type.BIGBED : ((Boolean)this.guess(BigWigFile.Companion.getMAGIC$big(), magic).getFirst() != false ? Type.BIGWIG : null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

