/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.CompressionType;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBufferFactory;
import org.jetbrains.bio.ScoredInterval;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.BPlusLeaf;
import org.jetbrains.bio.big.BPlusTree;
import org.jetbrains.bio.big.BedGraphSection;
import org.jetbrains.bio.big.BigFile;
import org.jetbrains.bio.big.BigSummary;
import org.jetbrains.bio.big.BigWigFile;
import org.jetbrains.bio.big.BigWigFile$WhenMappings;
import org.jetbrains.bio.big.BigWigKt;
import org.jetbrains.bio.big.ChromosomeInterval;
import org.jetbrains.bio.big.FixedStepSection;
import org.jetbrains.bio.big.Interval;
import org.jetbrains.bio.big.RTreeIndex;
import org.jetbrains.bio.big.RTreeIndexLeaf;
import org.jetbrains.bio.big.VariableStepSection;
import org.jetbrains.bio.big.WigSection;
import org.jetbrains.bio.big.ZoomLevel;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B7\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016JA\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0010\u00a2\u0006\u0002\b\u001cJ$\u0010\u001d\u001a\u00020\u0015*\u00020\u00132\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/bio/big/BigWigFile;", "Lorg/jetbrains/bio/big/BigFile;", "Lorg/jetbrains/bio/big/WigSection;", "path", "", "buffFactory", "Lorg/jetbrains/bio/RomBufferFactory;", "magic", "", "prefetch", "cancelledChecker", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lorg/jetbrains/bio/RomBufferFactory;IILkotlin/jvm/functions/Function0;)V", "queryInternal", "Lkotlin/sequences/Sequence;", "decompressedBlock", "Lorg/jetbrains/bio/RomBuffer;", "query", "Lorg/jetbrains/bio/big/ChromosomeInterval;", "overlaps", "", "queryInternal$big", "summarizeInternal", "Lkotlin/collections/IndexedValue;", "Lorg/jetbrains/bio/big/BigSummary;", "input", "numBins", "summarizeInternal$big", "contains", "startOffset", "endOffset", "Companion", "big"})
public final class BigWigFile
extends BigFile<WigSection> {
    private static final int MAGIC;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<IndexedValue<BigSummary>> summarizeInternal$big(@NotNull RomBuffer input, @NotNull ChromosomeInterval query2, int numBins, @Nullable Function0<Unit> cancelledChecker) {
        void edge;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        List wigItems2 = SequencesKt.toList((Sequence)SequencesKt.flatMap(this.query$big(input, query2, true, cancelledChecker), (Function1)summarizeInternal.wigItems.1.INSTANCE));
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        return SequencesKt.filterNotNull((Sequence)SequencesKt.mapIndexed(query2.slice$big(numBins), (Function2)((Function2)new Function2<Integer, ChromosomeInterval, IndexedValue<? extends BigSummary>>((Ref.IntRef)edge, wigItems2, query2){
            final /* synthetic */ Ref.IntRef $edge;
            final /* synthetic */ List $wigItems;
            final /* synthetic */ ChromosomeInterval $query;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final IndexedValue<BigSummary> invoke(int i, @NotNull ChromosomeInterval bin) {
                Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
                BigSummary summary = new BigSummary(0L, 0.0, 0.0, 0.0, 0.0, 31, null);
                int n = this.$edge.element;
                int n2 = this.$wigItems.size();
                while (n < n2) {
                    void j;
                    ScoredInterval wigItem = (ScoredInterval)this.$wigItems.get((int)j);
                    if (wigItem.getEnd() <= bin.getStartOffset()) {
                        this.$edge.element = j + true;
                    } else {
                        if (wigItem.getStart() > bin.getEndOffset()) break;
                        ChromosomeInterval interval = Interval.Companion.invoke$big(this.$query.getChromIx(), wigItem.getStart(), wigItem.getEnd());
                        if (interval.intersects(bin)) {
                            summary.update$big(wigItem.getScore(), interval.intersectionLength(bin));
                        }
                    }
                    ++j;
                }
                return summary.isEmpty$big() ? null : new IndexedValue(i, (Object)summary);
            }
            {
                this.$edge = intRef;
                this.$wigItems = list;
                this.$query = chromosomeInterval;
                super(2);
            }
        })));
    }

    private final boolean contains(ChromosomeInterval $this$contains, int startOffset, int endOffset, boolean overlaps) {
        ChromosomeInterval interval = Interval.Companion.invoke$big($this$contains.getChromIx(), startOffset, endOffset);
        return overlaps && interval.intersects($this$contains) || $this$contains.contains(interval);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<WigSection> queryInternal$big(@NotNull RomBuffer decompressedBlock, @NotNull ChromosomeInterval query2, boolean overlaps) {
        WigSection wigSection;
        WigSection wigSection2;
        void $this$with;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)decompressedBlock, (String)"decompressedBlock");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        String chrom = (String)this.getChromosomes().get(query2.getChromIx());
        boolean bl = false;
        boolean bl2 = false;
        RomBuffer romBuffer = decompressedBlock;
        int n = 0;
        Object[] objectArray2 = objectArray = new WigSection[1];
        boolean bl3 = false;
        int chromIx = $this$with.readInt();
        boolean bl4 = chromIx == query2.getChromIx();
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "interval contains wrong chromosome " + chromIx + ", expected " + query2.getChromIx() + ", source: " + this.getSource();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int start = $this$with.readInt();
        $this$with.readInt();
        int step = $this$with.readInt();
        int span = $this$with.readInt();
        int type = $this$with.readUnsignedByte();
        $this$with.readByte();
        int count = $this$with.readUnsignedShort();
        WigSection.Type[] types = WigSection.Type.values();
        boolean bl8 = type >= 1 && type <= types.length;
        boolean bl9 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = 0;
        if (!bl8) {
            boolean bl10 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        switch (BigWigFile$WhenMappings.$EnumSwitchMapping$0[types[type - 1].ordinal()]) {
            case 1: {
                int i;
                String string = chrom;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chrom");
                BedGraphSection section = new BedGraphSection(string, null, null, null, 14, null);
                boolean match = false;
                n2 = 0;
                n3 = count;
                while (n2 < n3) {
                    int startOffset = $this$with.readInt();
                    int endOffset = $this$with.readInt();
                    float value = $this$with.readFloat();
                    if (this.contains(query2, startOffset, endOffset, overlaps)) {
                        section.set(startOffset, endOffset, value);
                        match = true;
                    } else if (match) break;
                    ++i;
                }
                wigSection2 = section;
                break;
            }
            case 2: {
                int i;
                String string = chrom;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chrom");
                VariableStepSection section = new VariableStepSection(string, span, null, null, 12, null);
                boolean match = false;
                n3 = count;
                for (i = 0; i < n3; ++i) {
                    int pos = $this$with.readInt();
                    float value = $this$with.readFloat();
                    if (this.contains(query2, pos, pos + span, overlaps)) {
                        section.set(pos, value);
                        match = true;
                        continue;
                    }
                    if (match) break;
                }
                wigSection2 = section;
                break;
            }
            case 3: {
                int margin = query2.getStartOffset() % step;
                int shift = margin == 0 ? 0 : (overlaps ? -margin : step - margin);
                int realignedStart = Math.max(start, query2.getStartOffset() + shift);
                String string = chrom;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chrom");
                FixedStepSection section = new FixedStepSection(string, realignedStart, step, span, null, 16, null);
                boolean match = false;
                int value = 0;
                int n4 = count;
                while (value < n4) {
                    void i;
                    int pos = start + i * step;
                    float value2 = $this$with.readFloat();
                    if (this.contains(query2, pos, pos + span, overlaps)) {
                        section.add(value2);
                        match = true;
                    } else if (match) break;
                    ++i;
                }
                wigSection2 = section;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        objectArray[n] = wigSection = wigSection2;
        return SequencesKt.sequenceOf((Object[])objectArray2);
    }

    private BigWigFile(String path, RomBufferFactory buffFactory, int magic, int prefetch, Function0<Unit> cancelledChecker) {
        super(path, buffFactory, magic, prefetch, cancelledChecker);
    }

    static {
        Companion = new Companion(null);
        MAGIC = (int)2291137574L;
    }

    public /* synthetic */ BigWigFile(String path, RomBufferFactory buffFactory, int magic, int prefetch, Function0 cancelledChecker, DefaultConstructorMarker $constructor_marker) {
        this(path, buffFactory, magic, prefetch, (Function0<Unit>)cancelledChecker);
    }

    @JvmStatic
    @NotNull
    public static final BigWigFile read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        return Companion.read(path, cancelledChecker);
    }

    @JvmStatic
    @NotNull
    public static final BigWigFile read(@NotNull String src, int prefetch, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
        return Companion.read(src, prefetch, cancelledChecker, factoryProvider);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        Companion.write(wigSections, chromSizes, outputPath, zoomLevelCount, compression, order, cancelledChecker);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order) throws IOException {
        org.jetbrains.bio.big.BigWigFile$Companion.write$default(Companion, wigSections, chromSizes, outputPath, zoomLevelCount, compression, order, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount, @NotNull CompressionType compression) throws IOException {
        org.jetbrains.bio.big.BigWigFile$Companion.write$default(Companion, wigSections, chromSizes, outputPath, zoomLevelCount, compression, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount) throws IOException {
        org.jetbrains.bio.big.BigWigFile$Companion.write$default(Companion, wigSections, chromSizes, outputPath, zoomLevelCount, null, null, null, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath) throws IOException {
        org.jetbrains.bio.big.BigWigFile$Companion.write$default(Companion, wigSections, chromSizes, outputPath, 0, null, null, null, 120, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00042\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u001e\b\u0002\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u0002`\u0015H\u0007Jh\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u001b0\u00182\u0006\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u00132\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/jetbrains/bio/big/BigWigFile$Companion;", "", "()V", "MAGIC", "", "getMAGIC$big", "()I", "read", "Lorg/jetbrains/bio/big/BigWigFile;", "path", "Ljava/nio/file/Path;", "cancelledChecker", "Lkotlin/Function0;", "", "src", "", "prefetch", "factoryProvider", "Lkotlin/Function2;", "Ljava/nio/ByteOrder;", "Lorg/jetbrains/bio/RomBufferFactory;", "Lorg/jetbrains/bio/big/RomBufferFactoryProvider;", "write", "wigSections", "", "Lorg/jetbrains/bio/big/WigSection;", "chromSizes", "Lkotlin/Pair;", "outputPath", "zoomLevelCount", "compression", "Lorg/jetbrains/bio/CompressionType;", "order", "WigSectionSummary", "big"})
    public static final class Companion {
        public final int getMAGIC$big() {
            return MAGIC;
        }

        @JvmStatic
        @NotNull
        public final BigWigFile read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return org.jetbrains.bio.big.BigWigFile$Companion.read$default(this, ((Object)path).toString(), 0, cancelledChecker, null, 10, null);
        }

        public static /* synthetic */ BigWigFile read$default(Companion companion, Path path, Function0 function0, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                function0 = null;
            }
            return companion.read(path, (Function0<Unit>)function0);
        }

        @JvmStatic
        @NotNull
        public final BigWigFile read(@NotNull String src, int prefetch, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter(factoryProvider, (String)"factoryProvider");
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"ByteOrder.LITTLE_ENDIAN");
            RomBufferFactory factory = (RomBufferFactory)factoryProvider.invoke((Object)src, (Object)byteOrder);
            try {
                ByteOrder byteOrder2 = BigFile.Companion.getByteOrder$big(src, this.getMAGIC$big(), factory);
                factory.setOrder(byteOrder2);
                return new BigWigFile(src, factory, this.getMAGIC$big(), prefetch, cancelledChecker, null);
            }
            catch (Exception e) {
                Closeables.close((Closeable)factory, (boolean)true);
                throw (Throwable)e;
            }
        }

        public static /* synthetic */ BigWigFile read$default(Companion companion, String string, int n, Function0 function0, Function2 function2, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 2;
            }
            if ((n2 & 4) != 0) {
                function0 = null;
            }
            if ((n2 & 8) != 0) {
                function2 = BigFile.Companion.defaultFactory();
            }
            return companion.read(string, n, (Function0<Unit>)function0, function2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order, @Nullable Function0<Unit> cancelledChecker) throws IOException {
            Intrinsics.checkNotNullParameter(wigSections, (String)"wigSections");
            Intrinsics.checkNotNullParameter(chromSizes, (String)"chromSizes");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            WigSectionSummary wigSectionSummary = new WigSectionSummary();
            boolean bl = false;
            boolean bl2 = false;
            WigSectionSummary $this$apply52222 = wigSectionSummary;
            boolean bl3 = false;
            Iterable<? extends WigSection> $this$forEach$iv = wigSections;
            boolean $i$f$forEach = false;
            Iterator<? extends WigSection> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                WigSection element$iv;
                WigSection it = element$iv = iterator2.next();
                boolean bl4 = false;
                $this$apply52222.invoke(it);
            }
            WigSectionSummary summary = wigSectionSummary;
            Closeable closeable = OrderedDataOutput.Companion.invoke$default(OrderedDataOutput.Companion, outputPath, order, 0L, false, 12, null);
            bl2 = false;
            boolean $this$apply52222 = false;
            Throwable $this$apply52222 = null;
            try {
                Collection<Integer> collection;
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                BPlusLeaf bPlusLeaf;
                Collection collection2;
                Object item$iv$iv2;
                void $this$mapIndexedTo$iv$iv;
                int n;
                Iterable $this$filterTo$iv$iv;
                Object output = (OrderedDataOutput)closeable;
                boolean bl5 = false;
                ((OrderedDataOutput)output).skipBytes(64);
                ((OrderedDataOutput)output).skipBytes(ZoomLevel.Companion.getBYTES$big() * zoomLevelCount);
                long totalSummaryOffset = ((OrderedDataOutput)output).tell();
                ((OrderedDataOutput)output).skipBytes(BigSummary.Companion.getBYTES$big());
                Iterable<Pair<String, Integer>> $this$filter$iv = chromSizes;
                boolean $i$f$filter = false;
                Iterable<Pair<String, Integer>> bl4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Pair it = (Pair)element$iv$iv;
                    n = 0;
                    if (!summary.getChromosomes().contains(it.getFirst())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
                boolean $i$f$mapIndexed = false;
                $this$filterTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                    void i;
                    void key;
                    Iterator $dstr$key$size;
                    n = index$iv$iv++;
                    boolean bl6 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Pair pair = (Pair)item$iv$iv2;
                    int n2 = n;
                    collection2 = destination$iv$iv;
                    boolean bl7 = false;
                    String string = (String)$dstr$key$size.component1();
                    int size = ((Number)$dstr$key$size.component2()).intValue();
                    bPlusLeaf = new BPlusLeaf((String)key, (int)i, size);
                    collection2.add(bPlusLeaf);
                }
                List unsortedChromosomes = (List)destination$iv$iv;
                long chromTreeOffset = ((OrderedDataOutput)output).tell();
                BPlusTree.Companion.write$big$default(BPlusTree.Companion, (OrderedDataOutput)output, unsortedChromosomes, 0, 4, null);
                long unzoomedDataOffset = ((OrderedDataOutput)output).tell();
                Iterable $this$map$iv = unsortedChromosomes;
                boolean $i$f$map = false;
                item$iv$iv2 = $this$map$iv;
                Iterable<Object> destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    void it;
                    BPlusLeaf bl7 = (BPlusLeaf)item$iv$iv3;
                    collection2 = destination$iv$iv2;
                    boolean bl8 = false;
                    bPlusLeaf = TuplesKt.to((Object)it.getKey(), (Object)it.getId());
                    collection2.add(bPlusLeaf);
                }
                Map resolver = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                Iterable<? extends WigSection> $this$map$iv2 = wigSections;
                boolean $i$f$map2 = false;
                destination$iv$iv2 = $this$map$iv2;
                Object destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
                    void it;
                    WigSection bl8 = (WigSection)item$iv$iv4;
                    collection = destination$iv$iv3;
                    boolean bl9 = false;
                    Integer n3 = it.getSize();
                    collection.add(n3);
                }
                collection = (List)destination$iv$iv3;
                int n4 = CollectionsKt.sumOfInt((Iterable)collection);
                ArrayList<RTreeIndexLeaf> leaves2 = new ArrayList<RTreeIndexLeaf>(n4);
                int uncompressBufSize = 0;
                Function0<Unit> function0 = cancelledChecker;
                Object object = function0 != null ? (Unit)function0.invoke() : null;
                for (Pair pair : SupportKt.groupingBy(CollectionsKt.asSequence(wigSections), write.header.1.1.INSTANCE)) {
                    void name;
                    destination$iv$iv3 = (String)pair.component1();
                    Sequence sections = (Sequence)pair.component2();
                    Function0<Unit> function02 = cancelledChecker;
                    Object object2 = function02 != null ? (Unit)function02.invoke() : null;
                    Integer chromIx = (Integer)resolver.get(name);
                    if (chromIx == null) {
                        Sequence $this$forEach$iv2 = sections;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            WigSection it = (WigSection)element$iv;
                            boolean bl10 = false;
                        }
                        continue;
                    }
                    for (WigSection section : SequencesKt.flatMap((Sequence)sections, (Function1)write.header.1.3.INSTANCE)) {
                        if (section.isEmpty()) continue;
                        long dataOffset = ((OrderedDataOutput)output).tell();
                        int current2 = ((OrderedDataOutput)output).with(compression, (Function1<? super OrderedDataOutput, Unit>)((Function1)new Function1<OrderedDataOutput, Unit>(section, resolver){
                            final /* synthetic */ WigSection $section;
                            final /* synthetic */ Map $resolver;

                            public final void invoke(@NotNull OrderedDataOutput $this$with) {
                                block1: {
                                    WigSection wigSection;
                                    block2: {
                                        block0: {
                                            Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                                            wigSection = this.$section;
                                            if (!(wigSection instanceof BedGraphSection)) break block0;
                                            BigWigKt.access$write((BedGraphSection)this.$section, $this$with, this.$resolver);
                                            break block1;
                                        }
                                        if (!(wigSection instanceof FixedStepSection)) break block2;
                                        BigWigKt.access$write((FixedStepSection)this.$section, $this$with, this.$resolver);
                                        break block1;
                                    }
                                    if (!(wigSection instanceof VariableStepSection)) break block1;
                                    BigWigKt.access$write((VariableStepSection)this.$section, $this$with, this.$resolver);
                                }
                            }
                            {
                                this.$section = wigSection;
                                this.$resolver = map;
                                super(1);
                            }
                        }));
                        leaves2.add(new RTreeIndexLeaf(Interval.Companion.invoke$big(chromIx, section.getStart(), section.getEnd()), dataOffset, ((OrderedDataOutput)output).tell() - dataOffset));
                        uncompressBufSize = Math.max(uncompressBufSize, current2);
                    }
                }
                Function0<Unit> function03 = cancelledChecker;
                Object object3 = function03 != null ? (Unit)function03.invoke() : null;
                long unzoomedIndexOffset = ((OrderedDataOutput)output).tell();
                RTreeIndex.Companion.write$big$default(RTreeIndex.Companion, (OrderedDataOutput)output, leaves2, 0, 1, 4, null);
                output = new BigFile.Header(((OrderedDataOutput)output).getOrder(), Companion.getMAGIC$big(), compression == CompressionType.SNAPPY ? 5 : 4, zoomLevelCount, chromTreeOffset, unzoomedDataOffset, unzoomedIndexOffset, 0, 0, 0L, totalSummaryOffset, compression.getAbsent() ? 0 : uncompressBufSize, 0L, 4608, null);
            }
            catch (Throwable output) {
                $this$apply52222 = output;
                throw output;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)$this$apply52222);
            }
            Object header2 = output;
            closeable = OrderedDataOutput.Companion.invoke$default(OrderedDataOutput.Companion, outputPath, order, 0L, false, 4, null);
            bl2 = false;
            boolean $this$apply52222 = false;
            Throwable $this$apply52222 = null;
            try {
                OrderedDataOutput it = (OrderedDataOutput)closeable;
                boolean bl11 = false;
                ((BigFile.Header)header2).write$big(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                $this$apply52222 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)$this$apply52222);
            }
            boolean bl12 = false;
            bl2 = false;
            WigSectionSummary $this$with = summary;
            boolean bl13 = false;
            if ($this$with.getCount() > 0) {
                int initial = (int)Math.max(SupportKt.divCeiling($this$with.getSum(), (long)$this$with.getCount()), 1L) * 10;
                BigFile.Post.zoom$big$default(BigFile.Post.INSTANCE, outputPath, 0, initial, 0, cancelledChecker, 10, null);
            }
            BigFile.Post.INSTANCE.totalSummary$big(outputPath);
        }

        public static /* synthetic */ void write$default(Companion companion, Iterable iterable, Iterable iterable2, Path path, int n, CompressionType compressionType, ByteOrder byteOrder, Function0 function0, int n2, Object object) throws IOException {
            if ((n2 & 8) != 0) {
                n = 8;
            }
            if ((n2 & 0x10) != 0) {
                compressionType = CompressionType.SNAPPY;
            }
            if ((n2 & 0x20) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            if ((n2 & 0x40) != 0) {
                function0 = null;
            }
            companion.write(iterable, iterable2, path, n, compressionType, byteOrder, (Function0<Unit>)function0);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order) throws IOException {
            org.jetbrains.bio.big.BigWigFile$Companion.write$default(this, wigSections, chromSizes, outputPath, zoomLevelCount, compression, order, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount, @NotNull CompressionType compression) throws IOException {
            org.jetbrains.bio.big.BigWigFile$Companion.write$default(this, wigSections, chromSizes, outputPath, zoomLevelCount, compression, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int zoomLevelCount) throws IOException {
            org.jetbrains.bio.big.BigWigFile$Companion.write$default(this, wigSections, chromSizes, outputPath, zoomLevelCount, null, null, null, 112, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<? extends WigSection> wigSections, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath) throws IOException {
            org.jetbrains.bio.big.BigWigFile$Companion.write$default(this, wigSections, chromSizes, outputPath, 0, null, null, null, 120, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/bio/big/BigWigFile$Companion$WigSectionSummary;", "", "()V", "chromosomes", "Ljava/util/HashSet;", "", "getChromosomes", "()Ljava/util/HashSet;", "count", "", "getCount", "()I", "setCount", "(I)V", "edge", "previous", "sum", "", "getSum", "()J", "setSum", "(J)V", "invoke", "", "section", "Lorg/jetbrains/bio/big/WigSection;", "big"})
        private static final class WigSectionSummary {
            @NotNull
            private final HashSet<String> chromosomes = new HashSet();
            private int count;
            private long sum;
            private int edge;
            private String previous = "";

            @NotNull
            public final HashSet<String> getChromosomes() {
                return this.chromosomes;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public final long getSum() {
                return this.sum;
            }

            public final void setSum(long l) {
                this.sum = l;
            }

            public final void invoke(@NotNull WigSection section) {
                Intrinsics.checkNotNullParameter((Object)section, (String)"section");
                boolean bl = !this.chromosomes.contains(section.getChrom());
                int n = Intrinsics.areEqual((Object)section.getChrom(), (Object)this.previous) || bl ? 1 : 0;
                boolean bl2 = false;
                boolean bl3 = false;
                if (n == 0) {
                    boolean bl4 = false;
                    String string = "must be sorted by chromosome";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.chromosomes.add(section.getChrom());
                if (section.isEmpty()) {
                    return;
                }
                n = section.getStart() >= this.edge || bl ? 1 : 0;
                bl2 = false;
                bl3 = false;
                if (n == 0) {
                    boolean bl5 = false;
                    String string = "must be sorted by offset";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.sum += (long)section.getSpan();
                n = this.count;
                this.count = n + 1;
                this.previous = section.getChrom();
                this.edge = section.getStart();
            }
        }
    }
}

