/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.big.Interval;
import org.jetbrains.bio.big.Offset;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0000J\u0011\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0096\u0004J\u0006\u0010\u001d\u001a\u00020\u0003J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006("}, d2={"Lorg/jetbrains/bio/big/ChromosomeInterval;", "Lorg/jetbrains/bio/big/Interval;", "chromIx", "", "startOffset", "endOffset", "(III)V", "getChromIx", "()I", "getEndOffset", "left", "Lorg/jetbrains/bio/big/Offset;", "getLeft", "()Lorg/jetbrains/bio/big/Offset;", "right", "getRight", "getStartOffset", "component1", "component2", "component3", "contains", "", "other", "copy", "equals", "", "hashCode", "intersectionLength", "intersects", "length", "slice", "Lkotlin/sequences/Sequence;", "n", "slice$big", "toString", "", "write", "", "output", "Lorg/jetbrains/bio/OrderedDataOutput;", "big"})
public final class ChromosomeInterval
implements Interval {
    private final int chromIx;
    private final int startOffset;
    private final int endOffset;

    @Override
    @NotNull
    public Offset getLeft() {
        return new Offset(this.chromIx, this.startOffset);
    }

    @Override
    @NotNull
    public Offset getRight() {
        return new Offset(this.chromIx, this.endOffset);
    }

    @Override
    public boolean intersects(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Interval interval = other;
        return interval instanceof ChromosomeInterval ? (this.chromIx == ((ChromosomeInterval)other).chromIx ? ((ChromosomeInterval)other).endOffset > this.startOffset && ((ChromosomeInterval)other).startOffset < this.endOffset : false) : other.intersects(this);
    }

    public final int intersectionLength(@NotNull ChromosomeInterval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.min(this.endOffset, other.endOffset) - Math.max(this.startOffset, other.startOffset);
    }

    public final boolean contains(@NotNull ChromosomeInterval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.chromIx == this.chromIx && other.startOffset >= this.startOffset && other.endOffset <= this.endOffset;
    }

    @NotNull
    public final Sequence<ChromosomeInterval> slice$big(int n) {
        Sequence sequence;
        boolean bl = n > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "n must be >0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = n <= this.length();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "n must be <= length, got " + n + " > " + this.length();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (n == 1) {
            sequence = SequencesKt.sequenceOf((Object[])new ChromosomeInterval[]{this});
        } else {
            double width = (double)this.length() / (double)n;
            IntProgression $this$mapUnboxed$iv = (IntProgression)RangesKt.until((int)0, (int)n);
            boolean $i$f$mapUnboxed = false;
            IntIterator it$iv = $this$mapUnboxed$iv.iterator();
            sequence = SequencesKt.asSequence((Iterator)new Iterator<ChromosomeInterval>(it$iv, this, width){
                final /* synthetic */ IntIterator $it;
                final /* synthetic */ ChromosomeInterval this$0;
                final /* synthetic */ double $width$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = chromosomeInterval;
                    this.$width$inlined = d;
                }

                public ChromosomeInterval next() {
                    int i = this.$it.nextInt();
                    boolean bl = false;
                    int start = (int)Math.round((double)this.this$0.getStartOffset() + (double)i * this.$width$inlined);
                    int end = (int)Math.round((double)this.this$0.getStartOffset() + (double)(i + 1) * this.$width$inlined);
                    return Interval.Companion.invoke$big(this.this$0.getChromIx(), start, Math.min(end, this.this$0.getEndOffset()));
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            });
        }
        return sequence;
    }

    public final int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public void write(@NotNull OrderedDataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        boolean bl = false;
        boolean bl2 = false;
        OrderedDataOutput $this$with = output;
        boolean bl3 = false;
        $this$with.writeInt(this.chromIx);
        $this$with.writeInt(this.startOffset);
        $this$with.writeInt(this.chromIx);
        $this$with.writeInt(this.endOffset);
    }

    @NotNull
    public String toString() {
        return this.chromIx + ":[" + this.startOffset + "; " + this.endOffset + ')';
    }

    public final int getChromIx() {
        return this.chromIx;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public ChromosomeInterval(int chromIx, int startOffset, int endOffset) {
        this.chromIx = chromIx;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    @NotNull
    public Interval union(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Interval.DefaultImpls.union(this, other);
    }

    public final int component1() {
        return this.chromIx;
    }

    public final int component2() {
        return this.startOffset;
    }

    public final int component3() {
        return this.endOffset;
    }

    @NotNull
    public final ChromosomeInterval copy(int chromIx, int startOffset, int endOffset) {
        return new ChromosomeInterval(chromIx, startOffset, endOffset);
    }

    public static /* synthetic */ ChromosomeInterval copy$default(ChromosomeInterval chromosomeInterval, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = chromosomeInterval.chromIx;
        }
        if ((n4 & 2) != 0) {
            n2 = chromosomeInterval.startOffset;
        }
        if ((n4 & 4) != 0) {
            n3 = chromosomeInterval.endOffset;
        }
        return chromosomeInterval.copy(n, n2, n3);
    }

    public int hashCode() {
        return (Integer.hashCode(this.chromIx) * 31 + Integer.hashCode(this.startOffset)) * 31 + Integer.hashCode(this.endOffset);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ChromosomeInterval)) break block3;
                ChromosomeInterval chromosomeInterval = (ChromosomeInterval)object;
                if (this.chromIx != chromosomeInterval.chromIx || this.startOffset != chromosomeInterval.startOffset || this.endOffset != chromosomeInterval.endOffset) break block3;
            }
            return true;
        }
        return false;
    }
}

