/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.base.MoreObjects;
import gnu.trove.list.TFloatList;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Iterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.ScoredInterval;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.WigSection;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u001f\u001a\u00020\tH\u00c0\u0003\u00a2\u0006\u0002\b J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\u0011\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0005H\u0086\u0002J\b\u0010(\u001a\u00020\u0005H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000*2\u0006\u0010/\u001a\u00020\u0005H\u0016J\b\u00100\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lorg/jetbrains/bio/big/FixedStepSection;", "Lorg/jetbrains/bio/big/WigSection;", "chrom", "", "start", "", "step", "span", "values", "Lgnu/trove/list/TFloatList;", "(Ljava/lang/String;IIILgnu/trove/list/TFloatList;)V", "getChrom", "()Ljava/lang/String;", "end", "getEnd", "()I", "size", "getSize", "getSpan", "getStart", "getStep", "getValues$big", "()Lgnu/trove/list/TFloatList;", "add", "", "value", "", "component1", "component2", "component3", "component4", "component5", "component5$big", "copy", "equals", "", "other", "", "get", "pos", "hashCode", "query", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bio/ScoredInterval;", "from", "to", "splice", "max", "toString", "big"})
public final class FixedStepSection
implements WigSection {
    @NotNull
    private final String chrom;
    private final int start;
    private final int step;
    private final int span;
    @NotNull
    private final TFloatList values;

    @Override
    public int getEnd() {
        return this.getStart() + this.step * (this.values.size() - 1) + this.getSpan();
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    public final void add(float value) {
        SupportKt.ignore(this.values.add(value));
    }

    public final float get(int pos) {
        return this.values.get((pos - this.getStart()) / this.step);
    }

    @Override
    @NotNull
    public Sequence<ScoredInterval> query(int from, int to) {
        int i = Math.max(this.getStart(), from - from % this.getSpan());
        int j = Math.min(this.getStart() + this.step * this.getSize(), to - to % this.getSpan());
        IntProgression $this$mapUnboxed$iv = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)i, (int)j)), (int)this.step);
        boolean $i$f$mapUnboxed = false;
        IntIterator it$iv = $this$mapUnboxed$iv.iterator();
        return SequencesKt.asSequence((Iterator)new Iterator<ScoredInterval>(it$iv, this){
            final /* synthetic */ IntIterator $it;
            final /* synthetic */ FixedStepSection this$0;
            {
                this.$it = $captured_local_variable$1;
                this.this$0 = fixedStepSection;
            }

            public ScoredInterval next() {
                int it = this.$it.nextInt();
                boolean bl = false;
                return new ScoredInterval(it, it + this.this$0.getSpan(), this.this$0.get(it));
            }

            public boolean hasNext() {
                return this.$it.hasNext();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        });
    }

    @NotNull
    public Sequence<FixedStepSection> splice(int max) {
        Sequence sequence;
        int chunks = SupportKt.divCeiling(this.getSize(), max);
        if (chunks == 1) {
            sequence = SequencesKt.sequenceOf((Object[])new FixedStepSection[]{this});
        } else {
            IntProgression $this$mapUnboxed$iv = (IntProgression)RangesKt.until((int)0, (int)chunks);
            boolean $i$f$mapUnboxed = false;
            IntIterator it$iv = $this$mapUnboxed$iv.iterator();
            sequence = SequencesKt.asSequence((Iterator)new Iterator<FixedStepSection>(it$iv, this, max){
                final /* synthetic */ IntIterator $it;
                final /* synthetic */ FixedStepSection this$0;
                final /* synthetic */ int $max$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = fixedStepSection;
                    this.$max$inlined = n;
                }

                public FixedStepSection next() {
                    int i = this.$it.nextInt();
                    boolean bl = false;
                    int from = i * this.$max$inlined;
                    int to = Math.min((i + 1) * this.$max$inlined, this.this$0.getValues$big().size());
                    int n = this.this$0.getStart() + this.this$0.getStep() * from;
                    TFloatList tFloatList = this.this$0.getValues$big().subList(from, to);
                    Intrinsics.checkNotNullExpressionValue((Object)tFloatList, (String)"values.subList(from, to)");
                    return FixedStepSection.copy$default(this.this$0, null, n, 0, 0, tFloatList, 13, null);
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            });
        }
        return sequence;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).addValue((Object)this.getChrom()).add("start", this.getStart()).add("end", this.getEnd()).add("step", this.step).add("span", this.getSpan()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoreObjects.toStringHelp\u2026)\n            .toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return other == this ? true : (!(other instanceof FixedStepSection) ? false : this.getStart() == this.getStart() && this.step == ((FixedStepSection)other).step && this.getSpan() == ((FixedStepSection)other).getSpan() && Intrinsics.areEqual((Object)this.values, (Object)((FixedStepSection)other).values));
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.step, this.getSpan(), this.values);
    }

    @Override
    @NotNull
    public String getChrom() {
        return this.chrom;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public final int getStep() {
        return this.step;
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @NotNull
    public final TFloatList getValues$big() {
        return this.values;
    }

    public FixedStepSection(@NotNull String chrom, int start, int step, int span, @NotNull TFloatList values) {
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.chrom = chrom;
        this.start = start;
        this.step = step;
        this.span = span;
        this.values = values;
    }

    public /* synthetic */ FixedStepSection(String string, int n, int n2, int n3, TFloatList tFloatList, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x10) != 0) {
            tFloatList = (TFloatList)new TFloatArrayList();
        }
        this(string, n, n2, n3, tFloatList);
    }

    @Override
    @NotNull
    public Sequence<ScoredInterval> query() {
        return WigSection.DefaultImpls.query(this);
    }

    @Override
    public boolean isEmpty() {
        return WigSection.DefaultImpls.isEmpty(this);
    }

    @Override
    public int compareTo(@NotNull WigSection other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return WigSection.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final String component1() {
        return this.getChrom();
    }

    public final int component2() {
        return this.getStart();
    }

    public final int component3() {
        return this.step;
    }

    public final int component4() {
        return this.getSpan();
    }

    @NotNull
    public final TFloatList component5$big() {
        return this.values;
    }

    @NotNull
    public final FixedStepSection copy(@NotNull String chrom, int start, int step, int span, @NotNull TFloatList values) {
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new FixedStepSection(chrom, start, step, span, values);
    }

    public static /* synthetic */ FixedStepSection copy$default(FixedStepSection fixedStepSection, String string, int n, int n2, int n3, TFloatList tFloatList, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = fixedStepSection.getChrom();
        }
        if ((n4 & 2) != 0) {
            n = fixedStepSection.getStart();
        }
        if ((n4 & 4) != 0) {
            n2 = fixedStepSection.step;
        }
        if ((n4 & 8) != 0) {
            n3 = fixedStepSection.getSpan();
        }
        if ((n4 & 0x10) != 0) {
            tFloatList = fixedStepSection.values;
        }
        return fixedStepSection.copy(string, n, n2, n3, tFloatList);
    }
}

