/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.base.MoreObjects;
import gnu.trove.list.TFloatList;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.ScoredInterval;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.WigKt;
import org.jetbrains.bio.big.WigSection;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u001b\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\tH\u00c0\u0003\u00a2\u0006\u0002\b\u001eJ1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\u0011\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005H\u0086\u0002J\b\u0010'\u001a\u00020\u0005H\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0016J\u0019\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010/\u001a\u00020%H\u0086\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00000)2\u0006\u00101\u001a\u00020\u0005H\u0016J\b\u00102\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00063"}, d2={"Lorg/jetbrains/bio/big/VariableStepSection;", "Lorg/jetbrains/bio/big/WigSection;", "chrom", "", "span", "", "positions", "Lgnu/trove/list/TIntList;", "values", "Lgnu/trove/list/TFloatList;", "(Ljava/lang/String;ILgnu/trove/list/TIntList;Lgnu/trove/list/TFloatList;)V", "getChrom", "()Ljava/lang/String;", "end", "getEnd", "()I", "getPositions$big", "()Lgnu/trove/list/TIntList;", "size", "getSize", "getSpan", "start", "getStart", "getValues$big", "()Lgnu/trove/list/TFloatList;", "component1", "component2", "component3", "component3$big", "component4", "component4$big", "copy", "equals", "", "other", "", "get", "", "pos", "hashCode", "query", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bio/ScoredInterval;", "from", "to", "set", "", "value", "splice", "max", "toString", "big"})
public final class VariableStepSection
implements WigSection {
    @NotNull
    private final String chrom;
    private final int span;
    @NotNull
    private final TIntList positions;
    @NotNull
    private final TFloatList values;

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public int getStart() {
        boolean bl = this.getSize() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "no data";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.positions.get(0);
    }

    @Override
    public int getEnd() {
        boolean bl = this.getSize() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "no data";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return WigKt.access$last(this.positions) + this.getSpan();
    }

    public final void set(int pos, float value) {
        if (this.positions.isEmpty() || pos > WigKt.access$last(this.positions)) {
            this.positions.add(pos);
            this.values.add(value);
        } else {
            int i = this.positions.binarySearch(pos);
            if (i < 0) {
                this.positions.insert(~i, pos);
                this.values.insert(~i, value);
            } else {
                TFloatList tFloatList = this.values;
                int n = i;
                tFloatList.set(n, tFloatList.get(n) + value);
            }
        }
    }

    public final float get(int pos) {
        int i = this.positions.binarySearch(pos);
        if (i < 0) {
            throw (Throwable)new NoSuchElementException();
        }
        return this.values.get(i);
    }

    @Override
    @NotNull
    public Sequence<ScoredInterval> query(int from, int to) {
        int j;
        int i = this.positions.binarySearch(from);
        if (i < 0) {
            i ^= 0xFFFFFFFF;
        }
        if ((j = this.positions.binarySearch(to - this.getSpan() + 1)) < 0) {
            j = ~j - 1;
        }
        int n = i;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(n, j))), (Function1)((Function1)new Function1<Integer, ScoredInterval>(this){
            final /* synthetic */ VariableStepSection this$0;

            @NotNull
            public final ScoredInterval invoke(int it) {
                return new ScoredInterval(this.this$0.getPositions$big().get(it), this.this$0.getPositions$big().get(it) + this.this$0.getSpan(), this.this$0.getValues$big().get(it));
            }
            {
                this.this$0 = variableStepSection;
                super(1);
            }
        }));
    }

    @NotNull
    public Sequence<VariableStepSection> splice(int max) {
        Sequence sequence;
        int chunks = SupportKt.divCeiling(this.getSize(), max);
        if (chunks == 1) {
            sequence = SequencesKt.sequenceOf((Object[])new VariableStepSection[]{this});
        } else {
            IntProgression $this$mapUnboxed$iv = (IntProgression)RangesKt.until((int)0, (int)chunks);
            boolean $i$f$mapUnboxed = false;
            IntIterator it$iv = $this$mapUnboxed$iv.iterator();
            sequence = SequencesKt.asSequence((Iterator)new Iterator<VariableStepSection>(it$iv, this, max){
                final /* synthetic */ IntIterator $it;
                final /* synthetic */ VariableStepSection this$0;
                final /* synthetic */ int $max$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = variableStepSection;
                    this.$max$inlined = n;
                }

                public VariableStepSection next() {
                    int i = this.$it.nextInt();
                    boolean bl = false;
                    int from = i * this.$max$inlined;
                    int to = Math.min((i + 1) * this.$max$inlined, this.this$0.getSize());
                    TIntList tIntList = this.this$0.getPositions$big().subList(from, to);
                    Intrinsics.checkNotNullExpressionValue((Object)tIntList, (String)"positions.subList(from, to)");
                    TFloatList tFloatList = this.this$0.getValues$big().subList(from, to);
                    Intrinsics.checkNotNullExpressionValue((Object)tFloatList, (String)"values.subList(from, to)");
                    return VariableStepSection.copy$default(this.this$0, null, 0, tIntList, tFloatList, 3, null);
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            });
        }
        return sequence;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).addValue((Object)this.getChrom()).addValue(this.getSpan()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoreObjects.toStringHelp\u2026)\n            .toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return other == this ? true : (!(other instanceof VariableStepSection) ? false : this.getSpan() == ((VariableStepSection)other).getSpan() && Intrinsics.areEqual((Object)this.positions, (Object)((VariableStepSection)other).positions) && Intrinsics.areEqual((Object)this.values, (Object)((VariableStepSection)other).values));
    }

    public int hashCode() {
        return Objects.hash(this.getSpan(), this.positions, this.values);
    }

    @Override
    @NotNull
    public String getChrom() {
        return this.chrom;
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @NotNull
    public final TIntList getPositions$big() {
        return this.positions;
    }

    @NotNull
    public final TFloatList getValues$big() {
        return this.values;
    }

    public VariableStepSection(@NotNull String chrom, int span, @NotNull TIntList positions, @NotNull TFloatList values) {
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.chrom = chrom;
        this.span = span;
        this.positions = positions;
        this.values = values;
        boolean bl = this.positions.size() == this.values.size();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ VariableStepSection(String string, int n, TIntList tIntList, TFloatList tFloatList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            tIntList = (TIntList)new TIntArrayList();
        }
        if ((n2 & 8) != 0) {
            tFloatList = (TFloatList)new TFloatArrayList();
        }
        this(string, n, tIntList, tFloatList);
    }

    @Override
    @NotNull
    public Sequence<ScoredInterval> query() {
        return WigSection.DefaultImpls.query(this);
    }

    @Override
    public boolean isEmpty() {
        return WigSection.DefaultImpls.isEmpty(this);
    }

    @Override
    public int compareTo(@NotNull WigSection other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return WigSection.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final String component1() {
        return this.getChrom();
    }

    public final int component2() {
        return this.getSpan();
    }

    @NotNull
    public final TIntList component3$big() {
        return this.positions;
    }

    @NotNull
    public final TFloatList component4$big() {
        return this.values;
    }

    @NotNull
    public final VariableStepSection copy(@NotNull String chrom, int span, @NotNull TIntList positions, @NotNull TFloatList values) {
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new VariableStepSection(chrom, span, positions, values);
    }

    public static /* synthetic */ VariableStepSection copy$default(VariableStepSection variableStepSection, String string, int n, TIntList tIntList, TFloatList tFloatList, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = variableStepSection.getChrom();
        }
        if ((n2 & 2) != 0) {
            n = variableStepSection.getSpan();
        }
        if ((n2 & 4) != 0) {
            tIntList = variableStepSection.positions;
        }
        if ((n2 & 8) != 0) {
            tFloatList = variableStepSection.values;
        }
        return variableStepSection.copy(string, n, tIntList, tFloatList);
    }
}

