/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.tdf;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.CompressionType;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBufferFactory;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.BigFile;
import org.jetbrains.bio.tdf.IndexEntry;
import org.jetbrains.bio.tdf.TdfDataset;
import org.jetbrains.bio.tdf.TdfFile;
import org.jetbrains.bio.tdf.TdfFileKt;
import org.jetbrains.bio.tdf.TdfGroup;
import org.jetbrains.bio.tdf.TdfMasterIndex;
import org.jetbrains.bio.tdf.TdfSummary;
import org.jetbrains.bio.tdf.TdfTile;
import org.jetbrains.bio.tdf.TrackType;
import org.jetbrains.bio.tdf.WindowFunction;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 R2\u00020\u0001:\u0002RSBc\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010*\u001a\u00020+H\u0016J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0013H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c2\u0003J\t\u0010/\u001a\u00020\u0007H\u00c2\u0003J\t\u00100\u001a\u00020\tH\u00c2\u0003J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u00102\u001a\u00020\u000eH\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003Jy\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u00107\u001a\u00020\u00132\b\u00108\u001a\u0004\u0018\u000109H\u00d6\u0003J$\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00032\b\b\u0002\u0010=\u001a\u00020&2\b\b\u0002\u0010>\u001a\u00020\fH\u0007J\u0015\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bAJ\u000e\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020\u0003J\u0018\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020;2\u0006\u0010G\u001a\u00020&J\t\u0010H\u001a\u00020&H\u00d6\u0001J6\u0010I\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\u0006\u0010J\u001a\u00020;2\u0006\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020&2\u0010\b\u0002\u0010M\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010NJ:\u0010O\u001a\u00020P2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020&2\b\b\u0002\u0010=\u001a\u00020&2\u0010\b\u0002\u0010M\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010NJ\t\u0010Q\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\"\u00a8\u0006T"}, d2={"Lorg/jetbrains/bio/tdf/TdfFile;", "Ljava/io/Closeable;", "source", "", "buffFactory", "Lorg/jetbrains/bio/RomBufferFactory;", "header", "Lorg/jetbrains/bio/tdf/TdfFile$Header;", "index", "Lorg/jetbrains/bio/tdf/TdfMasterIndex;", "windowFunctions", "", "Lorg/jetbrains/bio/tdf/WindowFunction;", "trackType", "Lorg/jetbrains/bio/tdf/TrackType;", "trackLine", "trackNames", "build", "compressed", "", "(Ljava/lang/String;Lorg/jetbrains/bio/RomBufferFactory;Lorg/jetbrains/bio/tdf/TdfFile$Header;Lorg/jetbrains/bio/tdf/TdfMasterIndex;Ljava/util/List;Lorg/jetbrains/bio/tdf/TrackType;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Z)V", "getBuild", "()Ljava/lang/String;", "getCompressed", "()Z", "dataSetNames", "", "getDataSetNames", "()Ljava/util/Set;", "groupNames", "getGroupNames", "getSource", "getTrackLine", "getTrackNames", "()Ljava/util/List;", "getTrackType", "()Lorg/jetbrains/bio/tdf/TrackType;", "version", "", "getVersion", "()I", "getWindowFunctions", "close", "", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "getDataset", "Lorg/jetbrains/bio/tdf/TdfDataset;", "chromosome", "zoom", "windowFunction", "getDatasetInternal", "name", "getDatasetInternal$big", "getGroup", "Lorg/jetbrains/bio/tdf/TdfGroup;", "getTile", "Lorg/jetbrains/bio/tdf/TdfTile;", "ds", "tileNumber", "hashCode", "query", "dataset", "startOffset", "endOffset", "cancelledChecker", "Lkotlin/Function0;", "summarize", "Lorg/jetbrains/bio/tdf/TdfSummary;", "toString", "Companion", "Header", "big"})
public final class TdfFile
implements Closeable {
    @NotNull
    private final String source;
    private final RomBufferFactory buffFactory;
    private final Header header;
    private final TdfMasterIndex index;
    @NotNull
    private final List<WindowFunction> windowFunctions;
    @NotNull
    private final TrackType trackType;
    @NotNull
    private final String trackLine;
    @NotNull
    private final List<String> trackNames;
    @NotNull
    private final String build;
    private final boolean compressed;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getVersion() {
        return this.header.getVersion();
    }

    @NotNull
    public final Set<String> getDataSetNames() {
        return this.index.getDatasets().keySet();
    }

    @NotNull
    public final Set<String> getGroupNames() {
        return this.index.getGroups().keySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TdfTile> query(@NotNull TdfDataset dataset, int startOffset, int endOffset, @Nullable Function0<Unit> cancelledChecker) {
        void $this$mapNotNullTo$iv$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        int startTile = startOffset / dataset.getTileWidth();
        int endTile = SupportKt.divCeiling(endOffset, dataset.getTileWidth());
        int n2 = n = startTile;
        n = dataset.getTileCount() - 1;
        boolean bl = false;
        Iterable $this$mapNotNull$iv = (Iterable)new IntRange(n2, Math.min(n, endTile));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TdfTile tdfTile;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            int it = element$iv$iv;
            boolean bl3 = false;
            Function0<Unit> function0 = cancelledChecker;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
            if (this.getTile(dataset, it) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            TdfTile it$iv$iv = tdfTile;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List query$default(TdfFile tdfFile, TdfDataset tdfDataset, int n, int n2, Function0 function0, int n3, Object object) {
        if ((n3 & 8) != 0) {
            function0 = null;
        }
        return tdfFile.query(tdfDataset, n, n2, (Function0<Unit>)function0);
    }

    @NotNull
    public final TdfSummary summarize(@NotNull String chromosome, int startOffset, int endOffset, int zoom, @Nullable Function0<Unit> cancelledChecker) {
        TdfDataset dataset;
        block2: {
            TdfDataset tdfDataset;
            Intrinsics.checkNotNullParameter((Object)chromosome, (String)"chromosome");
            try {
                tdfDataset = TdfFile.getDataset$default(this, chromosome, zoom, null, 4, null);
            }
            catch (NoSuchElementException e) {
                tdfDataset = this.getDatasetInternal$big('/' + chromosome + "/raw");
            }
            dataset = tdfDataset;
            Function0<Unit> function0 = cancelledChecker;
            if (function0 == null) break block2;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        return new TdfSummary(this.query(dataset, startOffset, endOffset, cancelledChecker), startOffset, endOffset);
    }

    public static /* synthetic */ TdfSummary summarize$default(TdfFile tdfFile, String string, int n, int n2, int n3, Function0 function0, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x10) != 0) {
            function0 = null;
        }
        return tdfFile.summarize(string, n, n2, n3, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TdfTile getTile(@NotNull TdfDataset ds, int tileNumber) {
        TdfTile tdfTile;
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        boolean bl = false;
        boolean bl2 = false;
        TdfDataset $this$with = ds;
        boolean bl3 = false;
        int n = tileNumber;
        n = 0 <= n && $this$with.getTileCount() > n ? 1 : 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n == 0) {
            boolean bl6 = false;
            String string = "invalid tile index";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long position = $this$with.getTilePositions()[tileNumber];
        if (position < 0L) {
            return null;
        }
        CompressionType compression = this.compressed ? CompressionType.DEFLATE : CompressionType.NO_COMPRESSION;
        Closeable closeable = this.buffFactory.create();
        boolean bl7 = false;
        boolean bl8 = false;
        Throwable throwable = null;
        try {
            RomBuffer input = (RomBuffer)closeable;
            boolean bl9 = false;
            tdfTile = (TdfTile)input.with$big(position, $this$with.getTileSizes()[tileNumber], compression, 0, (Function1)new Function1<RomBuffer, TdfTile>($this$with, position, compression, this, tileNumber){
                final /* synthetic */ TdfDataset $this_with$inlined;
                final /* synthetic */ long $position$inlined;
                final /* synthetic */ CompressionType $compression$inlined;
                final /* synthetic */ TdfFile this$0;
                final /* synthetic */ int $tileNumber$inlined;
                {
                    this.$this_with$inlined = tdfDataset;
                    this.$position$inlined = l;
                    this.$compression$inlined = compressionType;
                    this.this$0 = tdfFile;
                    this.$tileNumber$inlined = n;
                    super(1);
                }

                @NotNull
                public final TdfTile invoke(@NotNull RomBuffer $this$with) {
                    Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                    return TdfTile.Companion.read$big($this$with, this.this$0.getTrackNames().size());
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return tdfTile;
    }

    @JvmOverloads
    @NotNull
    public final TdfDataset getDataset(@NotNull String chromosome, int zoom, @NotNull WindowFunction windowFunction) {
        Intrinsics.checkNotNullParameter((Object)chromosome, (String)"chromosome");
        Intrinsics.checkNotNullParameter((Object)((Object)windowFunction), (String)"windowFunction");
        boolean bl = this.windowFunctions.contains((Object)windowFunction);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        StringBuilder stringBuilder = new StringBuilder().append('/').append(chromosome).append("/z").append(zoom).append('/');
        String string = windowFunction.name();
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return this.getDatasetInternal$big(stringBuilder.append(string3).toString());
    }

    public static /* synthetic */ TdfDataset getDataset$default(TdfFile tdfFile, String string, int n, WindowFunction windowFunction, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            windowFunction = WindowFunction.MEAN;
        }
        return tdfFile.getDataset(string, n, windowFunction);
    }

    @JvmOverloads
    @NotNull
    public final TdfDataset getDataset(@NotNull String chromosome, int zoom) {
        return TdfFile.getDataset$default(this, chromosome, zoom, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final TdfDataset getDataset(@NotNull String chromosome) {
        return TdfFile.getDataset$default(this, chromosome, 0, null, 6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final TdfDataset getDatasetInternal$big(@NotNull String name) {
        TdfDataset tdfDataset;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexEntry> map = this.index.getDatasets();
        boolean bl = false;
        Map<String, IndexEntry> map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(name)) {
            throw (Throwable)new NoSuchElementException(name);
        }
        IndexEntry indexEntry = this.index.getDatasets().get(name);
        Intrinsics.checkNotNull((Object)indexEntry);
        Object object = indexEntry;
        long l = ((IndexEntry)object).component1();
        int size = ((IndexEntry)object).component2();
        object = this.buffFactory.create();
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            void offset;
            RomBuffer input = (RomBuffer)object;
            boolean bl5 = false;
            tdfDataset = (TdfDataset)RomBuffer.with$big$default(input, (long)offset, size, null, 0, getDatasetInternal.1.1.INSTANCE, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return tdfDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final TdfGroup getGroup(@NotNull String name) {
        TdfGroup tdfGroup;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexEntry> map = this.index.getGroups();
        boolean bl = false;
        Map<String, IndexEntry> map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(name)) {
            throw (Throwable)new NoSuchElementException(name);
        }
        IndexEntry indexEntry = this.index.getGroups().get(name);
        Intrinsics.checkNotNull((Object)indexEntry);
        Object object = indexEntry;
        long l = ((IndexEntry)object).component1();
        int size = ((IndexEntry)object).component2();
        object = this.buffFactory.create();
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            void offset;
            RomBuffer input = (RomBuffer)object;
            boolean bl5 = false;
            tdfGroup = (TdfGroup)RomBuffer.with$big$default(input, (long)offset, size, null, 0, getGroup.1.1.INSTANCE, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return tdfGroup;
    }

    @Override
    public void close() {
        this.buffFactory.close();
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final List<WindowFunction> getWindowFunctions() {
        return this.windowFunctions;
    }

    @NotNull
    public final TrackType getTrackType() {
        return this.trackType;
    }

    @NotNull
    public final String getTrackLine() {
        return this.trackLine;
    }

    @NotNull
    public final List<String> getTrackNames() {
        return this.trackNames;
    }

    @NotNull
    public final String getBuild() {
        return this.build;
    }

    public final boolean getCompressed() {
        return this.compressed;
    }

    public TdfFile(@NotNull String source, @NotNull RomBufferFactory buffFactory, @NotNull Header header2, @NotNull TdfMasterIndex index2, @NotNull List<? extends WindowFunction> windowFunctions2, @NotNull TrackType trackType, @NotNull String trackLine, @NotNull List<String> trackNames2, @NotNull String build, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)buffFactory, (String)"buffFactory");
        Intrinsics.checkNotNullParameter((Object)header2, (String)"header");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter(windowFunctions2, (String)"windowFunctions");
        Intrinsics.checkNotNullParameter((Object)trackType, (String)"trackType");
        Intrinsics.checkNotNullParameter((Object)trackLine, (String)"trackLine");
        Intrinsics.checkNotNullParameter(trackNames2, (String)"trackNames");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        this.source = source;
        this.buffFactory = buffFactory;
        this.header = header2;
        this.index = index2;
        this.windowFunctions = windowFunctions2;
        this.trackType = trackType;
        this.trackLine = trackLine;
        this.trackNames = trackNames2;
        this.build = build;
        this.compressed = compressed;
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    private final RomBufferFactory component2() {
        return this.buffFactory;
    }

    private final Header component3() {
        return this.header;
    }

    private final TdfMasterIndex component4() {
        return this.index;
    }

    @NotNull
    public final List<WindowFunction> component5() {
        return this.windowFunctions;
    }

    @NotNull
    public final TrackType component6() {
        return this.trackType;
    }

    @NotNull
    public final String component7() {
        return this.trackLine;
    }

    @NotNull
    public final List<String> component8() {
        return this.trackNames;
    }

    @NotNull
    public final String component9() {
        return this.build;
    }

    public final boolean component10() {
        return this.compressed;
    }

    @NotNull
    public final TdfFile copy(@NotNull String source, @NotNull RomBufferFactory buffFactory, @NotNull Header header2, @NotNull TdfMasterIndex index2, @NotNull List<? extends WindowFunction> windowFunctions2, @NotNull TrackType trackType, @NotNull String trackLine, @NotNull List<String> trackNames2, @NotNull String build, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)buffFactory, (String)"buffFactory");
        Intrinsics.checkNotNullParameter((Object)header2, (String)"header");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter(windowFunctions2, (String)"windowFunctions");
        Intrinsics.checkNotNullParameter((Object)trackType, (String)"trackType");
        Intrinsics.checkNotNullParameter((Object)trackLine, (String)"trackLine");
        Intrinsics.checkNotNullParameter(trackNames2, (String)"trackNames");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        return new TdfFile(source, buffFactory, header2, index2, windowFunctions2, trackType, trackLine, trackNames2, build, compressed);
    }

    public static /* synthetic */ TdfFile copy$default(TdfFile tdfFile, String string, RomBufferFactory romBufferFactory, Header header2, TdfMasterIndex tdfMasterIndex, List list, TrackType trackType, String string2, List list2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = tdfFile.source;
        }
        if ((n & 2) != 0) {
            romBufferFactory = tdfFile.buffFactory;
        }
        if ((n & 4) != 0) {
            header2 = tdfFile.header;
        }
        if ((n & 8) != 0) {
            tdfMasterIndex = tdfFile.index;
        }
        if ((n & 0x10) != 0) {
            list = tdfFile.windowFunctions;
        }
        if ((n & 0x20) != 0) {
            trackType = tdfFile.trackType;
        }
        if ((n & 0x40) != 0) {
            string2 = tdfFile.trackLine;
        }
        if ((n & 0x80) != 0) {
            list2 = tdfFile.trackNames;
        }
        if ((n & 0x100) != 0) {
            string3 = tdfFile.build;
        }
        if ((n & 0x200) != 0) {
            bl = tdfFile.compressed;
        }
        return tdfFile.copy(string, romBufferFactory, header2, tdfMasterIndex, list, trackType, string2, list2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "TdfFile(source=" + this.source + ", buffFactory=" + this.buffFactory + ", header=" + this.header + ", index=" + this.index + ", windowFunctions=" + this.windowFunctions + ", trackType=" + this.trackType + ", trackLine=" + this.trackLine + ", trackNames=" + this.trackNames + ", build=" + this.build + ", compressed=" + this.compressed + ")";
    }

    public int hashCode() {
        String string = this.source;
        RomBufferFactory romBufferFactory = this.buffFactory;
        Header header2 = this.header;
        TdfMasterIndex tdfMasterIndex = this.index;
        List<WindowFunction> list = this.windowFunctions;
        TrackType trackType = this.trackType;
        String string2 = this.trackLine;
        List<String> list2 = this.trackNames;
        String string3 = this.build;
        int n = (((((((((string != null ? string.hashCode() : 0) * 31 + (romBufferFactory != null ? romBufferFactory.hashCode() : 0)) * 31 + (header2 != null ? ((Object)header2).hashCode() : 0)) * 31 + (tdfMasterIndex != null ? ((Object)tdfMasterIndex).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (trackType != null ? ((Object)trackType).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31;
        int n2 = this.compressed ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TdfFile)) break block3;
                TdfFile tdfFile = (TdfFile)object;
                if (!Intrinsics.areEqual((Object)this.source, (Object)tdfFile.source) || !Intrinsics.areEqual((Object)this.buffFactory, (Object)tdfFile.buffFactory) || !Intrinsics.areEqual((Object)this.header, (Object)tdfFile.header) || !Intrinsics.areEqual((Object)this.index, (Object)tdfFile.index) || !Intrinsics.areEqual(this.windowFunctions, tdfFile.windowFunctions) || !Intrinsics.areEqual((Object)this.trackType, (Object)tdfFile.trackType) || !Intrinsics.areEqual((Object)this.trackLine, (Object)tdfFile.trackLine) || !Intrinsics.areEqual(this.trackNames, tdfFile.trackNames) || !Intrinsics.areEqual((Object)this.build, (Object)tdfFile.build) || this.compressed != tdfFile.compressed) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final TdfFile read(@NotNull Path path) throws IOException {
        return Companion.read(path);
    }

    @JvmStatic
    @NotNull
    public static final TdfFile read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        return Companion.read(path, cancelledChecker);
    }

    @JvmStatic
    @NotNull
    public static final TdfFile read(@NotNull String src, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
        return Companion.read(src, cancelledChecker, factoryProvider);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/bio/tdf/TdfFile$Header;", "", "version", "", "indexOffset", "", "indexSize", "headerSize", "(IJII)V", "getHeaderSize", "()I", "getIndexOffset", "()J", "getIndexSize", "getVersion", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "big"})
    public static final class Header {
        private final int version;
        private final long indexOffset;
        private final int indexSize;
        private final int headerSize;
        public static final int BYTES = 24;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final int getVersion() {
            return this.version;
        }

        public final long getIndexOffset() {
            return this.indexOffset;
        }

        public final int getIndexSize() {
            return this.indexSize;
        }

        public final int getHeaderSize() {
            return this.headerSize;
        }

        public Header(int version, long indexOffset, int indexSize, int headerSize) {
            this.version = version;
            this.indexOffset = indexOffset;
            this.indexSize = indexSize;
            this.headerSize = headerSize;
        }

        public final int component1() {
            return this.version;
        }

        public final long component2() {
            return this.indexOffset;
        }

        public final int component3() {
            return this.indexSize;
        }

        public final int component4() {
            return this.headerSize;
        }

        @NotNull
        public final Header copy(int version, long indexOffset, int indexSize, int headerSize) {
            return new Header(version, indexOffset, indexSize, headerSize);
        }

        public static /* synthetic */ Header copy$default(Header header2, int n, long l, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = header2.version;
            }
            if ((n4 & 2) != 0) {
                l = header2.indexOffset;
            }
            if ((n4 & 4) != 0) {
                n2 = header2.indexSize;
            }
            if ((n4 & 8) != 0) {
                n3 = header2.headerSize;
            }
            return header2.copy(n, l, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Header(version=" + this.version + ", indexOffset=" + this.indexOffset + ", indexSize=" + this.indexSize + ", headerSize=" + this.headerSize + ")";
        }

        public int hashCode() {
            return ((Integer.hashCode(this.version) * 31 + Long.hashCode(this.indexOffset)) * 31 + Integer.hashCode(this.indexSize)) * 31 + Integer.hashCode(this.headerSize);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Header)) break block3;
                    Header header2 = (Header)object;
                    if (this.version != header2.version || this.indexOffset != header2.indexOffset || this.indexSize != header2.indexSize || this.headerSize != header2.headerSize) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/bio/tdf/TdfFile$Header$Companion;", "", "()V", "BYTES", "", "read", "Lorg/jetbrains/bio/tdf/TdfFile$Header;", "input", "Lorg/jetbrains/bio/RomBuffer;", "read$big", "big"})
        public static final class Companion {
            @NotNull
            public final Header read$big(@NotNull RomBuffer input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                boolean bl = false;
                boolean bl2 = false;
                RomBuffer $this$with = input;
                boolean bl3 = false;
                byte[] b = $this$with.readBytes(4);
                boolean bl4 = false;
                String magicString = new String(b, Charsets.UTF_8);
                bl4 = StringsKt.startsWith$default((String)magicString, (String)"TDF", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)magicString, (String)"IBF", (boolean)false, (int)2, null);
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = "bad signature in " + input;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int version = $this$with.readInt();
                long indexOffset = $this$with.readLong();
                int indexSize = $this$with.readInt();
                int headerSize = $this$with.readInt();
                return new Header(version, indexOffset, indexSize, headerSize);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0007JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u001e\b\u0002\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bio/tdf/TdfFile$Companion;", "", "()V", "read", "Lorg/jetbrains/bio/tdf/TdfFile;", "path", "Ljava/nio/file/Path;", "cancelledChecker", "Lkotlin/Function0;", "", "src", "", "factoryProvider", "Lkotlin/Function2;", "Ljava/nio/ByteOrder;", "Lorg/jetbrains/bio/RomBufferFactory;", "Lorg/jetbrains/bio/big/RomBufferFactoryProvider;", "big"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TdfFile read(@NotNull Path path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return org.jetbrains.bio.tdf.TdfFile$Companion.read$default(this, ((Object)path).toString(), null, read.1.INSTANCE, 2, null);
        }

        @JvmStatic
        @NotNull
        public final TdfFile read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return org.jetbrains.bio.tdf.TdfFile$Companion.read$default(this, ((Object)path).toString(), cancelledChecker, null, 4, null);
        }

        public static /* synthetic */ TdfFile read$default(Companion companion, Path path, Function0 function0, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                function0 = null;
            }
            return companion.read(path, (Function0<Unit>)function0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final TdfFile read(@NotNull String src, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter(factoryProvider, (String)"factoryProvider");
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"ByteOrder.LITTLE_ENDIAN");
            RomBufferFactory buffFactory = (RomBufferFactory)factoryProvider.invoke((Object)src, (Object)byteOrder);
            try {
                Closeable closeable = buffFactory.create();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    RomBuffer input = (RomBuffer)closeable;
                    boolean bl3 = false;
                    Function0<Unit> function0 = cancelledChecker;
                    if (function0 != null) {
                        Unit cfr_ignored_0 = (Unit)function0.invoke();
                    }
                    Header header2 = Header.Companion.read$big(input);
                    List windowFunctions2 = SequencesKt.toList((Sequence)TdfFileKt.access$getSequenceOf(input, read.2.windowFunctions.1.INSTANCE));
                    TrackType trackType = TrackType.Companion.read(input);
                    String string = input.readCString();
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String trackLine = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    Function0<Unit> function02 = cancelledChecker;
                    if (function02 != null) {
                        Unit cfr_ignored_1 = (Unit)function02.invoke();
                    }
                    List trackNames2 = SequencesKt.toList((Sequence)TdfFileKt.access$getSequenceOf(input, (Function1)new Function1<RomBuffer, String>(input){
                        final /* synthetic */ RomBuffer $input;

                        @NotNull
                        public final String invoke(@NotNull RomBuffer $this$getSequenceOf) {
                            Intrinsics.checkNotNullParameter((Object)$this$getSequenceOf, (String)"$receiver");
                            return this.$input.readCString();
                        }
                        {
                            this.$input = romBuffer;
                            super(1);
                        }
                    }));
                    String build = input.readCString();
                    boolean compressed = (input.readInt() & 1) != 0;
                    Function0<Unit> function03 = cancelledChecker;
                    if (function03 != null) {
                        Unit cfr_ignored_2 = (Unit)function03.invoke();
                    }
                    boolean bl5 = Ints.checkedCast((long)input.getPosition()) == header2.getHeaderSize() + 24;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    bl7 = false;
                    boolean bl8 = false;
                    if (!bl5) {
                        boolean bl9 = false;
                        String string3 = "Check failed.";
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    TdfMasterIndex index2 = (TdfMasterIndex)RomBuffer.with$big$default(input, header2.getIndexOffset(), header2.getIndexSize(), null, 0, read.2.index.1.INSTANCE, 4, null);
                    Function0<Unit> function04 = cancelledChecker;
                    if (function04 != null) {
                        Unit cfr_ignored_3 = (Unit)function04.invoke();
                    }
                    TdfFile tdfFile = new TdfFile(src, buffFactory, header2, index2, windowFunctions2, trackType, trackLine, trackNames2, build, compressed);
                    return tdfFile;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                buffFactory.close();
                throw (Throwable)e;
            }
        }

        public static /* synthetic */ TdfFile read$default(Companion companion, String string, Function0 function0, Function2 function2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                function0 = null;
            }
            if ((n & 4) != 0) {
                function2 = BigFile.Companion.defaultFactory();
            }
            return companion.read(string, (Function0<Unit>)function0, function2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

