/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.viktor.F64Array;
import org.jetbrains.bio.viktor.F64ArrayKt;
import org.jetbrains.bio.viktor.F64FlatArray;
import org.jetbrains.bio.viktor.InternalsKt;
import org.jetbrains.bio.viktor.KahanSum;
import org.jetbrains.bio.viktor.MoreMathKt;
import org.jetbrains.bio.viktor._I;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0017\n\u0002\b.\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 \u0080\u00012\u00020\u0001:\u0004\u0080\u0001\u0081\u0001B?\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$2\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00002\b\b\u0002\u0010%\u001a\u00020\u0005J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020+0$H\u0010\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0002J\r\u0010/\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b0J*\u00101\u001a\u00020.2\u0006\u0010'\u001a\u00020\u00002\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020.03H\u0002J\u0011\u00105\u001a\u00020\u00182\u0006\u0010'\u001a\u00020+H\u0096\u0002J\b\u00106\u001a\u00020\u0000H\u0016J\u0010\u00107\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0016J\b\u00108\u001a\u00020.H\u0016J\u0011\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020+H\u0086\u0002J\u0011\u00109\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010;\u001a\u00020.2\u0006\u0010:\u001a\u00020+H\u0096\u0002J\u0011\u0010;\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010<\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0003H\u0086\u0004J\u0011\u0010<\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0007H\u0096\u0004J\u0011\u0010<\u001a\u00020+2\u0006\u0010'\u001a\u00020=H\u0096\u0004J\u0011\u0010<\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0004J\u0013\u0010>\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010?\u001a\u00020\u0000H\u0016J\b\u0010@\u001a\u00020.H\u0016J\b\u0010A\u001a\u00020\u0000H\u0016J\b\u0010B\u001a\u00020.H\u0016J\u0010\u0010C\u001a\u00020.2\u0006\u0010D\u001a\u00020+H\u0016J\b\u0010E\u001a\u000204H\u0016J\u0011\u0010F\u001a\u00020+2\u0006\u0010G\u001a\u00020\u0005H\u0096\u0002J\u0019\u0010F\u001a\u00020+2\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0005H\u0086\u0002J!\u0010F\u001a\u00020+2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0005H\u0086\u0002J\u0015\u0010F\u001a\u00020+2\n\u0010K\u001a\u00020\u0007\"\u00020\u0005H\u0086\u0002J\b\u0010L\u001a\u00020\u0005H\u0016J\b\u0010M\u001a\u00020\u0000H\u0016J\b\u0010N\u001a\u00020\u0000H\u0016J\b\u0010O\u001a\u00020.H\u0016J\u0011\u0010P\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0004J\u0010\u0010Q\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0016J\b\u0010R\u001a\u00020.H\u0016J\u0006\u0010S\u001a\u00020.J\b\u0010T\u001a\u00020+H\u0016J\b\u0010U\u001a\u00020+H\u0016J\u0006\u0010V\u001a\u00020+J\b\u0010W\u001a\u00020+H\u0016J\u0011\u0010X\u001a\u00020\u00002\u0006\u0010:\u001a\u00020+H\u0086\u0002J\u0011\u0010X\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010Y\u001a\u00020.2\u0006\u0010:\u001a\u00020+H\u0096\u0002J\u0011\u0010Y\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010Z\u001a\u00020\u00002\u0006\u0010:\u001a\u00020+H\u0086\u0002J\u0011\u0010Z\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010[\u001a\u00020.2\u0006\u0010:\u001a\u00020+H\u0096\u0002J\u0011\u0010[\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u001a\u0010\\\u001a\u00020.2\u0006\u0010K\u001a\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\u0005H\u0016J\u0006\u0010]\u001a\u00020.J\u0014\u0010^\u001a\u00020\u00002\n\u0010\b\u001a\u00020\u0007\"\u00020\u0005H\u0016J\b\u0010_\u001a\u00020+H\u0016J\u0019\u0010`\u001a\u00020.2\u0006\u0010G\u001a\u00020\u00052\u0006\u0010a\u001a\u00020+H\u0096\u0002J!\u0010`\u001a\u00020.2\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u00052\u0006\u0010a\u001a\u00020+H\u0086\u0002J)\u0010`\u001a\u00020.2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u00052\u0006\u0010a\u001a\u00020+H\u0086\u0002J\u001d\u0010`\u001a\u00020.2\n\u0010K\u001a\u00020\u0007\"\u00020\u00052\u0006\u0010a\u001a\u00020+H\u0086\u0002J.\u0010b\u001a\u00020\u00002\b\b\u0002\u0010c\u001a\u00020\u00052\b\b\u0002\u0010d\u001a\u00020\u00052\b\b\u0002\u0010e\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0005J\b\u0010f\u001a\u00020+H\u0016J\u0011\u0010g\u001a\u00020\u00002\u0006\u0010:\u001a\u00020+H\u0086\u0002J\u0011\u0010g\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010h\u001a\u00020.2\u0006\u0010:\u001a\u00020+H\u0096\u0002J\u0011\u0010h\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\b\u0010i\u001a\u00020\u0001H\u0016J\b\u0010j\u001a\u00020\u0003H\u0016J\u0011\u0010k\u001a\u0006\u0012\u0002\b\u00030lH\u0016\u00a2\u0006\u0002\u0010mJ\b\u0010n\u001a\u00020oH\u0016J\u001a\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020\u00052\b\b\u0002\u0010q\u001a\u00020rH\u0016J\u001c\u0010s\u001a\u00020\u00002\u0012\u0010t\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0uH\u0016J\u001c\u0010v\u001a\u00020.2\u0012\u0010t\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0uH\u0016J\t\u0010w\u001a\u00020\u0000H\u0096\u0002J\t\u0010x\u001a\u00020\u0000H\u0086\u0002J\u0018\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00000$2\b\b\u0002\u0010z\u001a\u00020\u0005H\u0002J\u000e\u0010{\u001a\b\u0012\u0004\u0012\u0002040$H\u0002J\u0019\u0010|\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0005H\u0082\bJ!\u0010|\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0005H\u0082\bJ\u0011\u0010|\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0007H\u0082\bJ\u001a\u0010}\u001a\u00020\u00002\u0006\u0010~\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0005H\u0016J\u0011\u0010\u007f\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0007H\u0082\bR!\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001"}, d2={"Lorg/jetbrains/bio/viktor/F64Array;", "", "data", "", "offset", "", "strides", "", "shape", "unrollDim", "unrollStride", "unrollSize", "([DI[I[IIII)V", "V", "Lorg/jetbrains/bio/viktor/F64Array$Viewer;", "getV$annotations", "()V", "getV", "()Lorg/jetbrains/bio/viktor/F64Array$Viewer;", "V$delegate", "Lkotlin/Lazy;", "getData", "()[D", "isFlattenable", "", "()Z", "nDim", "getNDim", "()I", "getOffset", "getShape", "()[I", "size", "getSize", "getStrides", "along", "Lkotlin/sequences/Sequence;", "axis", "append", "other", "argMax", "argMin", "asSequence", "", "asSequence$viktor", "checkShape", "", "clone", "clone$viktor", "commonUnrollToFlat", "action", "Lkotlin/Function2;", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "contains", "copy", "copyTo", "cumSum", "div", "update", "divAssign", "dot", "", "equals", "exp", "expInPlace", "expm1", "expm1InPlace", "fill", "init", "flatten", "get", "pos", "r", "c", "d", "indices", "hashCode", "log", "log1p", "log1pInPlace", "logAddExp", "logAddExpAssign", "logInPlace", "logRescale", "logSumExp", "max", "mean", "min", "minus", "minusAssign", "plus", "plusAssign", "reorder", "rescale", "reshape", "sd", "set", "value", "slice", "from", "to", "step", "sum", "times", "timesAssign", "toArray", "toDoubleArray", "toGenericArray", "", "()[Ljava/lang/Object;", "toString", "", "maxDisplay", "format", "Ljava/text/DecimalFormat;", "transform", "op", "Lkotlin/Function1;", "transformInPlace", "unaryMinus", "unaryPlus", "unrollOnce", "n", "unrollToFlat", "unsafeIndex", "view", "index", "view0", "Companion", "Viewer", "viktor"})
public class F64Array {
    private final int nDim;
    private final int size;
    private final boolean isFlattenable;
    @NotNull
    private final transient Lazy V$delegate;
    @NotNull
    private final double[] data;
    private final int offset;
    @NotNull
    private final int[] strides;
    @NotNull
    private final int[] shape;
    private final int unrollDim;
    private final int unrollStride;
    private final int unrollSize;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getNDim() {
        return this.nDim;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isFlattenable() {
        return this.isFlattenable;
    }

    /*
     * WARNING - void declaration
     */
    public final double get(int ... indices) {
        void $this$foldIndexed$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        int n = indices.length == this.nDim ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "broadcasting get is not supported";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n = 0;
        n2 = this.nDim;
        while (n < n2) {
            void pos$iv;
            void d;
            String string = "index";
            int bl2 = indices[d];
            int size$iv = this.shape[d];
            boolean $i$f$checkIndex = false;
            if (pos$iv < 0 || pos$iv >= size$iv) {
                void label$iv;
                throw (Throwable)new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + (int)pos$iv);
            }
            ++d;
        }
        F64Array d = this;
        double[] dArray = this.data;
        boolean $i$f$unsafeIndex = false;
        int[] label$iv = this_$iv.getStrides();
        int initial$iv$iv = this_$iv.getOffset();
        boolean $i$f$foldIndexed = false;
        int index$iv$iv = 0;
        int accumulator$iv$iv = initial$iv$iv;
        for (void element$iv$iv : $this$foldIndexed$iv$iv) {
            void stride$iv;
            void acc$iv;
            int n3 = index$iv$iv++;
            void var13_19 = element$iv$iv;
            int n4 = accumulator$iv$iv;
            int i$iv = n3;
            boolean bl3 = false;
            accumulator$iv$iv = acc$iv + indices[i$iv] * stride$iv;
        }
        int n5 = accumulator$iv$iv;
        return dArray[n5];
    }

    public double get(int pos) {
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public final double get(int r, int c) {
        String label$iv;
        boolean bl = this.nDim == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "broadcasting get is not supported";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = "row";
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (r < 0 || r >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + r);
        }
        label$iv = "column";
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (c < 0 || c >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + c);
        }
        F64Array this_$iv = this;
        boolean $i$f$unsafeIndex = false;
        return this.data[this_$iv.getOffset() + r * this_$iv.getStrides()[0] + c * this_$iv.getStrides()[1]];
    }

    public final double get(int d, int r, int c) {
        String label$iv;
        boolean bl = this.nDim == 3;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "broadcasting get is not supported";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = "depth";
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (r < 0 || r >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + r);
        }
        label$iv = "row";
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (r < 0 || r >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + r);
        }
        label$iv = "column";
        size$iv = this.shape[2];
        $i$f$checkIndex = false;
        if (c < 0 || c >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + c);
        }
        F64Array this_$iv = this;
        boolean $i$f$unsafeIndex = false;
        return this.data[this_$iv.getOffset() + d * this_$iv.getStrides()[0] + r * this_$iv.getStrides()[1] + c * this_$iv.getStrides()[2]];
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull int[] indices, double value) {
        void $this$foldIndexed$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        int n = indices.length == this.nDim ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "broadcasting set is not supported";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n = 0;
        n2 = this.nDim;
        while (n < n2) {
            void pos$iv;
            void d;
            String string = "index";
            int bl2 = indices[d];
            int size$iv = this.shape[d];
            boolean $i$f$checkIndex = false;
            if (pos$iv < 0 || pos$iv >= size$iv) {
                void label$iv;
                throw (Throwable)new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + (int)pos$iv);
            }
            ++d;
        }
        F64Array d = this;
        double[] dArray = this.data;
        boolean $i$f$unsafeIndex = false;
        int[] label$iv = this_$iv.getStrides();
        int initial$iv$iv = this_$iv.getOffset();
        boolean $i$f$foldIndexed = false;
        int index$iv$iv = 0;
        int accumulator$iv$iv = initial$iv$iv;
        for (void element$iv$iv : $this$foldIndexed$iv$iv) {
            void stride$iv;
            void acc$iv;
            int n3 = index$iv$iv++;
            void var15_20 = element$iv$iv;
            int n4 = accumulator$iv$iv;
            int i$iv = n3;
            boolean bl3 = false;
            accumulator$iv$iv = acc$iv + indices[i$iv] * stride$iv;
        }
        int n5 = accumulator$iv$iv;
        dArray[n5] = value;
    }

    public void set(int pos, double value) {
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public final void set(int r, int c, double value) {
        String label$iv;
        boolean bl = this.nDim == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "broadcasting set is not supported";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = "row";
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (r < 0 || r >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + r);
        }
        label$iv = "column";
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (c < 0 || c >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + c);
        }
        F64Array this_$iv = this;
        boolean $i$f$unsafeIndex = false;
        this.data[this_$iv.getOffset() + r * this_$iv.getStrides()[0] + c * this_$iv.getStrides()[1]] = value;
    }

    public final void set(int d, int r, int c, double value) {
        String label$iv;
        boolean bl = this.nDim == 3;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "broadcasting set is not supported";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = "depth";
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (d < 0 || d >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + d);
        }
        label$iv = "row";
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (r < 0 || r >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + r);
        }
        label$iv = "column";
        size$iv = this.shape[2];
        $i$f$checkIndex = false;
        if (c < 0 || c >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + c);
        }
        F64Array this_$iv = this;
        boolean $i$f$unsafeIndex = false;
        this.data[this_$iv.getOffset() + d * this_$iv.getStrides()[0] + r * this_$iv.getStrides()[1] + c * this_$iv.getStrides()[2]] = value;
    }

    private final int unsafeIndex(int r, int c) {
        int $i$f$unsafeIndex = 0;
        return this.getOffset() + r * this.getStrides()[0] + c * this.getStrides()[1];
    }

    private final int unsafeIndex(int d, int r, int c) {
        int $i$f$unsafeIndex = 0;
        return this.getOffset() + d * this.getStrides()[0] + r * this.getStrides()[1] + c * this.getStrides()[2];
    }

    /*
     * WARNING - void declaration
     */
    private final int unsafeIndex(int[] indices) {
        void $this$foldIndexed$iv;
        int $i$f$unsafeIndex = 0;
        int[] nArray = this.getStrides();
        int initial$iv = this.getOffset();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void stride;
            void acc;
            int n = index$iv++;
            void var12_12 = element$iv;
            int n2 = accumulator$iv;
            int i = n;
            boolean bl = false;
            accumulator$iv = acc + indices[i] * stride;
        }
        return accumulator$iv;
    }

    @NotNull
    public Sequence<F64Array> along(int axis) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.shape[axis]))), (Function1)((Function1)new Function1<Integer, F64Array>(this, axis){
            final /* synthetic */ F64Array this$0;
            final /* synthetic */ int $axis;

            @NotNull
            public final F64Array invoke(int it) {
                return this.this$0.view(it, this.$axis);
            }
            {
                this.this$0 = f64Array;
                this.$axis = n;
                super(1);
            }
        }));
    }

    @NotNull
    public F64Array view(int index, int axis) {
        String label$iv;
        String string = "axis";
        int size$iv = this.nDim;
        boolean $i$f$checkIndex = false;
        if (axis < 0 || axis >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + axis);
        }
        label$iv = "index";
        size$iv = this.shape[axis];
        $i$f$checkIndex = false;
        if (index < 0 || index >= size$iv) {
            throw (Throwable)new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + index);
        }
        return Companion.create$viktor(this.data, this.offset + this.strides[axis] * index, InternalsKt.remove(this.strides, axis), InternalsKt.remove(this.shape, axis));
    }

    public static /* synthetic */ F64Array view$default(F64Array f64Array, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: view");
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return f64Array.view(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final F64Array view0(int[] indices) {
        void $this$fold$iv;
        int $i$f$view0 = 0;
        boolean bl = indices.length < this.getNDim();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "too many indices";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int[] nArray = indices;
        F64Array initial$iv = this;
        boolean $i$f$fold = false;
        F64Array accumulator$iv = initial$iv;
        void var7_11 = $this$fold$iv;
        int n = ((void)var7_11).length;
        for (int i = 0; i < n; ++i) {
            void pos;
            void element$iv;
            void var11_15 = element$iv = var7_11[i];
            F64Array m = accumulator$iv;
            boolean bl5 = false;
            accumulator$iv = F64Array.view$default(m, (int)pos, 0, 2, null);
        }
        return accumulator$iv;
    }

    private final Sequence<F64FlatArray> unrollToFlat() {
        if (this.isFlattenable) {
            return SequencesKt.sequenceOf((Object[])new F64FlatArray[]{this.flatten()});
        }
        return SequencesKt.flatMap((Sequence)F64Array.unrollOnce$default(this, 0, 1, null), (Function1)unrollToFlat.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void commonUnrollToFlat(F64Array other, Function2<? super F64FlatArray, ? super F64FlatArray, Unit> action) {
        this.checkShape(other);
        int n = this.unrollDim;
        int n2 = other.unrollDim;
        boolean bl = false;
        int commonUnrollDim = Math.min(n, n2);
        if (commonUnrollDim == this.nDim) {
            action.invoke((Object)this.flatten(), (Object)other.flatten());
        } else {
            Sequence $this$forEach$iv = SequencesKt.zip(this.unrollOnce(commonUnrollDim), other.unrollOnce(commonUnrollDim));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void a;
                Pair $dstr$a$b = (Pair)element$iv;
                boolean bl2 = false;
                F64Array f64Array = (F64Array)$dstr$a$b.component1();
                F64Array b = (F64Array)$dstr$a$b.component2();
                super.commonUnrollToFlat(b, action);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<F64Array> unrollOnce(int n) {
        int n2;
        Object $this$run;
        int n3;
        boolean bl = n <= this.unrollDim;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "can't unroll " + n + " dimensions, only " + this.unrollDim + " are unrollable";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int[] newStrides = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])this.strides, (IntRange)RangesKt.until((int)n, (int)this.nDim)));
        int[] newShape = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])this.shape, (IntRange)RangesKt.until((int)n, (int)this.nDim)));
        if (n == this.unrollDim) {
            n3 = this.unrollStride;
        } else {
            int nonTrivialN;
            F64Array bl4 = this;
            boolean bl5 = false;
            boolean bl6 = false;
            $this$run = bl4;
            boolean bl7 = false;
            for (nonTrivialN = n - 1; nonTrivialN >= 0 && ((F64Array)$this$run).shape[nonTrivialN] <= 1; --nonTrivialN) {
            }
            n3 = nonTrivialN >= 0 ? ((F64Array)$this$run).strides[nonTrivialN] : 0;
        }
        int currentUnrollStride = n3;
        if (n == this.unrollDim) {
            n2 = this.unrollSize;
        } else {
            void $this$fold$iv$iv;
            int[] $this$product$iv = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])this.shape, (IntRange)RangesKt.until((int)0, (int)n)));
            boolean $i$f$product = false;
            $this$run = $this$product$iv;
            int initial$iv$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv$iv = initial$iv$iv;
            void var12_18 = $this$fold$iv$iv;
            int n4 = ((void)var12_18).length;
            for (int i = 0; i < n4; ++i) {
                void p2$iv;
                void element$iv$iv;
                void var16_22 = element$iv$iv = var12_18[i];
                int p1$iv = accumulator$iv$iv;
                boolean bl8 = false;
                accumulator$iv$iv = p1$iv * p2$iv;
            }
            n2 = accumulator$iv$iv;
        }
        int currentUnrollSize = n2;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)currentUnrollSize))), (Function1)((Function1)new Function1<Integer, F64Array>(this, currentUnrollStride, newStrides, newShape){
            final /* synthetic */ F64Array this$0;
            final /* synthetic */ int $currentUnrollStride;
            final /* synthetic */ int[] $newStrides;
            final /* synthetic */ int[] $newShape;

            @NotNull
            public final F64Array invoke(int i) {
                return F64Array.Companion.create$viktor(this.this$0.getData(), this.this$0.getOffset() + this.$currentUnrollStride * i, this.$newStrides, this.$newShape);
            }
            {
                this.this$0 = f64Array;
                this.$currentUnrollStride = n;
                this.$newStrides = nArray;
                this.$newShape = nArray2;
                super(1);
            }
        }));
    }

    static /* synthetic */ Sequence unrollOnce$default(F64Array f64Array, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: unrollOnce");
        }
        if ((n2 & 1) != 0) {
            n = f64Array.unrollDim;
        }
        return f64Array.unrollOnce(n);
    }

    public static /* synthetic */ void getV$annotations() {
    }

    @NotNull
    public final Viewer getV() {
        Lazy lazy = this.V$delegate;
        F64Array f64Array = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Viewer)lazy.getValue();
    }

    @NotNull
    public F64Array copy() {
        F64Array copy = Companion.invoke(Arrays.copyOf(this.shape, this.shape.length));
        this.copyTo(copy);
        return copy;
    }

    public void copyTo(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)copyTo.1.INSTANCE));
    }

    @NotNull
    public F64Array reshape(int ... shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.flatten().reshape(Arrays.copyOf(shape, shape.length));
    }

    @NotNull
    public final F64Array append(@NotNull F64Array other, int axis) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.concatenate(this, new F64Array[]{other}, axis);
    }

    public static /* synthetic */ F64Array append$default(F64Array f64Array, F64Array f64Array2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return f64Array.append(f64Array2, n);
    }

    @NotNull
    public F64FlatArray flatten() {
        boolean bl = this.isFlattenable;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "array can't be flattened";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return F64FlatArray.Companion.create$viktor(this.data, this.offset, this.unrollStride, this.unrollSize);
    }

    @NotNull
    public final F64Array slice(int from, int to, int step, int axis) {
        int n;
        boolean bl;
        int n2 = step > 0 ? 1 : 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 == 0) {
            boolean bl4 = false;
            String string = "slicing step must be positive, but was " + step;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n2 = axis;
        n2 = 0 <= n2 && this.nDim > n2 ? 1 : 0;
        bl2 = false;
        bl3 = false;
        if (n2 == 0) {
            boolean bl5 = false;
            String string = "axis out of bounds: " + axis;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n2 = from >= 0 ? 1 : 0;
        bl2 = false;
        bl3 = false;
        if (n2 == 0) {
            boolean bl6 = false;
            String string = "slicing start index must be positive, but was " + from;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (to != -1) {
            bl2 = to > from;
            bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl7 = false;
                String string = "slicing end index " + to + " must be greater than start index " + from;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = to <= this.shape[axis];
            bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl8 = false;
                String string = "slicing end index out of bounds: " + to + " > " + this.shape[axis];
                throw (Throwable)new IllegalStateException(string.toString());
            }
            n = to;
        } else {
            bl2 = this.shape[axis] > from;
            bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl9 = false;
                String string = "slicing start index out of bounds: " + from + " >= " + this.shape[axis];
                throw (Throwable)new IllegalStateException(string.toString());
            }
            n = this.shape[axis];
        }
        int actualTo = n;
        Object object = this.strides.clone();
        bl = false;
        boolean bl10 = false;
        int[] $this$apply = (int[])object;
        boolean bl11 = false;
        int n3 = axis;
        $this$apply[n3] = $this$apply[n3] * step;
        int[] sliceStrides = (int[])object;
        Object object2 = this.shape.clone();
        bl10 = false;
        boolean bl12 = false;
        int[] $this$apply2 = (int[])object2;
        boolean bl13 = false;
        $this$apply2[axis] = (actualTo - from + step - 1) / step;
        int[] sliceShape = (int[])object2;
        return Companion.create$viktor(this.data, this.offset + from * this.strides[axis], sliceStrides, sliceShape);
    }

    public static /* synthetic */ F64Array slice$default(F64Array f64Array, int n, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: slice");
        }
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = -1;
        }
        if ((n5 & 4) != 0) {
            n3 = 1;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return f64Array.slice(n, n2, n3, n4);
    }

    public boolean contains(double other) {
        boolean bl;
        block1: {
            Sequence<F64FlatArray> $this$any$iv = this.unrollToFlat();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                F64FlatArray it = (F64FlatArray)element$iv;
                boolean bl2 = false;
                if (!it.contains(other)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public void fill(double init) {
        this.flatten().fill(init);
    }

    /*
     * WARNING - void declaration
     */
    public void reorder(@NotNull int[] indices, int axis) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        F64Array a$iv = this;
        boolean $i$f$reorderInternal = false;
        boolean bl = indices.length == a$iv.getShape()[axis];
        int n = 0;
        int n2 = 0;
        n2 = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int[] copy$iv = (int[])indices.clone();
        n = 0;
        n2 = a$iv.getShape()[axis];
        while (n < n2) {
            void value;
            boolean bl4;
            int pos;
            void pos$iv;
            void pos2 = pos$iv;
            boolean bl5 = false;
            F64Array value$iv = this.view((int)pos2, axis).copy();
            int j$iv = pos$iv;
            while (true) {
                F64Array f64Array;
                int k$iv = copy$iv[j$iv];
                copy$iv[j$iv] = j$iv;
                if (k$iv == pos$iv) break;
                pos = k$iv;
                void var14_19 = j$iv;
                f64Array2 = false;
                F64Array f64Array2 = f64Array = this.view(pos, axis).copy();
                pos = var14_19;
                bl4 = false;
                value.copyTo(this.view(pos, axis));
                j$iv = k$iv;
            }
            F64Array f64Array = value$iv;
            pos = j$iv;
            bl4 = false;
            value.copyTo(this.view(pos, axis));
            ++pos$iv;
        }
    }

    public static /* synthetic */ void reorder$default(F64Array f64Array, int[] nArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reorder");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        f64Array.reorder(nArray, n);
    }

    public double dot(@NotNull short[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public double dot(@NotNull int[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public final double dot(@NotNull double[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.dot(F64ArrayKt.asF64Array(other));
    }

    public double dot(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public final double mean() {
        void $this$fold$iv$iv;
        void $this$product$iv;
        int[] nArray = this.shape;
        double d = this.sum();
        boolean $i$f$product = false;
        void var3_4 = $this$product$iv;
        int initial$iv$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv$iv = initial$iv$iv;
        void var7_8 = $this$fold$iv$iv;
        int n = ((void)var7_8).length;
        for (int i = 0; i < n; ++i) {
            void p2$iv;
            void element$iv$iv;
            void var11_12 = element$iv$iv = var7_8[i];
            int p1$iv = accumulator$iv$iv;
            boolean bl = false;
            accumulator$iv$iv = p1$iv * p2$iv;
        }
        int n2 = accumulator$iv$iv;
        return d / (double)n2;
    }

    public double sd() {
        double s = this.sum();
        double s2 = this.dot(this);
        double d = (s2 - s * s / (double)this.size) / (double)(this.size - 1);
        boolean bl = false;
        return Math.sqrt(d);
    }

    public double sum() {
        KahanSum acc = new KahanSum(0.0, 1, null);
        Sequence<F64FlatArray> $this$forEach$iv = this.unrollToFlat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            F64FlatArray it = (F64FlatArray)element$iv;
            boolean bl = false;
            acc.plusAssign(it.sum());
        }
        return acc.result();
    }

    public void cumSum() {
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public double max() {
        Double d = SequencesKt.maxOrNull((Sequence)SequencesKt.map(this.unrollToFlat(), (Function1)max.1.INSTANCE));
        return d != null ? d : Double.NEGATIVE_INFINITY;
    }

    public int argMax() {
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public double min() {
        Double d = SequencesKt.minOrNull((Sequence)SequencesKt.map(this.unrollToFlat(), (Function1)min.1.INSTANCE));
        return d != null ? d : Double.POSITIVE_INFINITY;
    }

    public int argMin() {
        boolean $i$f$unsupported = false;
        throw (Throwable)new UnsupportedOperationException();
    }

    public void transformInPlace(@NotNull Function1<? super Double, Double> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        Sequence<F64FlatArray> $this$forEach$iv = this.unrollToFlat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            F64FlatArray it = (F64FlatArray)element$iv;
            boolean bl = false;
            it.transformInPlace(op);
        }
    }

    @NotNull
    public F64Array transform(@NotNull Function1<? super Double, Double> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (this.isFlattenable) {
            return ((F64FlatArray)this.flatten().transform((Function1)op)).reshape(Arrays.copyOf(this.shape, this.shape.length));
        }
        F64Array f64Array = this.copy();
        boolean bl = false;
        boolean bl2 = false;
        F64Array $this$apply = f64Array;
        boolean bl3 = false;
        $this$apply.transformInPlace(op);
        return f64Array;
    }

    public void expInPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)expInPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array exp() {
        return this.transform((Function1<? super Double, Double>)((Function1)exp.1.INSTANCE));
    }

    public void expm1InPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)expm1InPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array expm1() {
        return this.transform((Function1<? super Double, Double>)((Function1)expm1.1.INSTANCE));
    }

    public void logInPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)logInPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array log() {
        return this.transform((Function1<? super Double, Double>)((Function1)log.1.INSTANCE));
    }

    public void log1pInPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)log1pInPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array log1p() {
        return this.transform((Function1<? super Double, Double>)((Function1)log1p.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public final void rescale() {
        void $this$fold$iv$iv;
        void $this$product$iv;
        int[] nArray = this.shape;
        double d = Precision.EPSILON;
        double d2 = this.sum();
        F64Array f64Array = this;
        boolean $i$f$product = false;
        void var3_6 = $this$product$iv;
        int initial$iv$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv$iv = initial$iv$iv;
        void var7_10 = $this$fold$iv$iv;
        int n = ((void)var7_10).length;
        for (int i = 0; i < n; ++i) {
            void p2$iv;
            void element$iv$iv;
            void var11_14 = element$iv$iv = var7_10[i];
            int p1$iv = accumulator$iv$iv;
            boolean bl = false;
            accumulator$iv$iv = p1$iv * p2$iv;
        }
        int n2 = accumulator$iv$iv;
        f64Array.divAssign(d2 + d * (double)n2);
    }

    public final void logRescale() {
        this.minusAssign(this.logSumExp());
    }

    public double logSumExp() {
        return MoreMathKt.logSumExp((Sequence<Double>)SequencesKt.map(this.unrollToFlat(), (Function1)logSumExp.1.INSTANCE));
    }

    public void logAddExpAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)logAddExpAssign.1.INSTANCE));
    }

    @NotNull
    public F64Array logAddExp(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array f64Array = this.copy();
        boolean bl = false;
        boolean bl2 = false;
        F64Array $this$apply = f64Array;
        boolean bl3 = false;
        $this$apply.logAddExpAssign(other);
        return f64Array;
    }

    @NotNull
    public final F64Array unaryPlus() {
        return this;
    }

    @NotNull
    public F64Array unaryMinus() {
        return this.transform((Function1<? super Double, Double>)((Function1)unaryMinus.1.INSTANCE));
    }

    public void plusAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)plusAssign.1.INSTANCE));
    }

    @NotNull
    public F64Array plus(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array f64Array = this.copy();
        boolean bl = false;
        boolean bl2 = false;
        F64Array $this$apply = f64Array;
        boolean bl3 = false;
        $this$apply.plusAssign(other);
        return f64Array;
    }

    public void plusAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it + this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    @NotNull
    public final F64Array plus(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it + this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    public void minusAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)minusAssign.1.INSTANCE));
    }

    @NotNull
    public F64Array minus(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array f64Array = this.copy();
        boolean bl = false;
        boolean bl2 = false;
        F64Array $this$apply = f64Array;
        boolean bl3 = false;
        $this$apply.minusAssign(other);
        return f64Array;
    }

    public void minusAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it - this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    @NotNull
    public final F64Array minus(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it - this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    public void timesAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)timesAssign.1.INSTANCE));
    }

    @NotNull
    public F64Array times(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array f64Array = this.copy();
        boolean bl = false;
        boolean bl2 = false;
        F64Array $this$apply = f64Array;
        boolean bl3 = false;
        $this$apply.timesAssign(other);
        return f64Array;
    }

    public void timesAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it * this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    @NotNull
    public final F64Array times(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it * this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    public void divAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)divAssign.1.INSTANCE));
    }

    @NotNull
    public F64Array div(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array f64Array = this.copy();
        boolean bl = false;
        boolean bl2 = false;
        F64Array $this$apply = f64Array;
        boolean bl3 = false;
        $this$apply.divAssign(other);
        return f64Array;
    }

    public void divAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it / this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    @NotNull
    public final F64Array div(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(update){
            final /* synthetic */ double $update;

            public final double invoke(double it) {
                return it / this.$update;
            }
            {
                this.$update = d;
                super(1);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final void checkShape(F64Array other) {
        if (this == other) ** GOTO lbl-1000
        var2_2 = this.shape;
        var3_4 = other.shape;
        var4_6 = false;
        if (Arrays.equals(var2_2, var3_4)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        var2_3 = v0;
        var3_5 = false;
        var4_6 = false;
        if (!var2_3) {
            $i$a$-check-F64Array$checkShape$1 = false;
            v1 = new StringBuilder().append("operands shapes do not match: ");
            var6_9 = this.shape;
            var7_10 = false;
            v2 = Arrays.toString(var6_9);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"java.util.Arrays.toString(this)");
            v3 = v1.append(v2).append(" vs ");
            var6_9 = other.shape;
            var7_10 = false;
            v4 = Arrays.toString(var6_9);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"java.util.Arrays.toString(this)");
            var4_7 = v3.append(v4).toString();
            throw (Throwable)new IllegalStateException(var4_7.toString());
        }
    }

    @NotNull
    public Sequence<Double> asSequence$viktor() {
        return SequencesKt.flatMap(this.unrollToFlat(), (Function1)asSequence.1.INSTANCE);
    }

    @NotNull
    public F64Array clone$viktor() {
        return new F64Array((double[])this.data.clone(), this.offset, (int[])this.strides.clone(), (int[])this.shape.clone(), this.unrollDim, this.unrollStride, this.unrollSize);
    }

    @NotNull
    public Object toArray() {
        return this.toGenericArray();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] toGenericArray() {
        int n = this.size;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            void it;
            Object object;
            int n3 = n2;
            int n4 = n2++;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = object = F64Array.view$default(this, (int)it, 0, 2, null).toArray();
        }
        return objectArray;
    }

    @NotNull
    public double[] toDoubleArray() {
        throw (Throwable)new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString(int maxDisplay, @NotNull DecimalFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (maxDisplay < this.size) {
            int n = 0;
            int n2 = maxDisplay / 2;
            while (n < n2) {
                void r;
                sb.append(this.getV().get(new int[]{r++}).toString(maxDisplay, format)).append(", ");
            }
            sb.append("..., ");
            int leftover = maxDisplay - maxDisplay / 2;
            n2 = this.size - leftover;
            int n3 = this.size;
            while (n2 < n3) {
                void r;
                sb.append(this.getV().get(new int[]{r}).toString(maxDisplay, format));
                if (r < this.size - 1) {
                    sb.append(", ");
                }
                ++r;
            }
        } else {
            int leftover = 0;
            int n = this.size;
            while (leftover < n) {
                void r;
                sb.append(this.getV().get(new int[]{r}).toString(maxDisplay, format));
                if (r < this.size - 1) {
                    sb.append(", ");
                }
                ++r;
            }
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String toString$default(F64Array f64Array, int n, DecimalFormat decimalFormat, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toString");
        }
        if ((n2 & 2) != 0) {
            decimalFormat = new DecimalFormat("#.####");
        }
        return f64Array.toString(n, decimalFormat);
    }

    @NotNull
    public String toString() {
        return F64Array.toString$default(this, 8, null, 2, null);
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        block9: {
            if (this == other) {
                bl = true;
            } else if (!(other instanceof F64Array)) {
                bl = false;
            } else {
                int[] nArray = this.shape;
                int[] nArray2 = ((F64Array)other).shape;
                boolean bl2 = false;
                if (!Arrays.equals(nArray, nArray2)) {
                    bl = false;
                } else {
                    Iterable $this$all$iv = (Iterable)RangesKt.until((int)0, (int)this.size);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)F64Array.view$default(this, it, 0, 2, null), (Object)F64Array.view$default((F64Array)other, it, 0, 2, null))) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $this$fold$iv;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.size);
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            void r;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator).nextInt();
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31 * acc + F64Array.view$default(this, (int)r, 0, 2, null).hashCode();
        }
        return accumulator$iv;
    }

    @NotNull
    public final double[] getData() {
        return this.data;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    @NotNull
    public final int[] getShape() {
        return this.shape;
    }

    protected F64Array(@NotNull double[] data, int offset, @NotNull int[] strides, @NotNull int[] shape, int unrollDim, int unrollStride, int unrollSize) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.data = data;
        this.offset = offset;
        this.strides = strides;
        this.shape = shape;
        this.unrollDim = unrollDim;
        this.unrollStride = unrollStride;
        this.unrollSize = unrollSize;
        this.nDim = this.shape.length;
        this.size = this.shape[0];
        this.isFlattenable = this.unrollDim == this.nDim;
        this.V$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Viewer>(this){
            final /* synthetic */ F64Array this$0;

            @NotNull
            public final Viewer invoke() {
                return new Viewer(this.this$0);
            }
            {
                this.this$0 = f64Array;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ F64Array access$view0(F64Array $this, int[] indices) {
        return $this.view0(indices);
    }

    public static final /* synthetic */ Sequence access$unrollToFlat(F64Array $this) {
        return $this.unrollToFlat();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00032\n\u0010\u0006\u001a\u00020\u0007\"\u00020\bH\u0086\u0002J\u0019\u0010\u0005\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0086\u0002J\u001d\u0010\f\u001a\u00020\r2\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u001d\u0010\f\u001a\u00020\r2\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086\u0002J!\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J!\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bio/viktor/F64Array$Viewer;", "", "a", "Lorg/jetbrains/bio/viktor/F64Array;", "(Lorg/jetbrains/bio/viktor/F64Array;)V", "get", "indices", "", "", "any", "Lorg/jetbrains/bio/viktor/_I;", "c", "set", "", "init", "", "other", "viktor"})
    public static final class Viewer {
        private final F64Array a;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array get(int ... indices) {
            void $this$fold$iv$iv;
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            F64Array this_$iv = this.a;
            boolean $i$f$view0 = false;
            boolean bl = indices.length < this_$iv.getNDim();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "too many indices";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int[] nArray = indices;
            F64Array initial$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            F64Array accumulator$iv$iv = initial$iv$iv;
            void var8_12 = $this$fold$iv$iv;
            int n = ((void)var8_12).length;
            for (int i = 0; i < n; ++i) {
                void pos$iv;
                void element$iv$iv;
                void var12_16 = element$iv$iv = var8_12[i];
                F64Array m$iv = accumulator$iv$iv;
                boolean bl5 = false;
                accumulator$iv$iv = F64Array.view$default(m$iv, (int)pos$iv, 0, 2, null);
            }
            return accumulator$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull int[] indices, @NotNull F64Array other) {
            void $this$fold$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            F64Array f64Array = this.a;
            F64Array f64Array2 = other;
            boolean $i$f$view0 = false;
            boolean bl = indices.length < this_$iv.getNDim();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "too many indices";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int[] nArray = indices;
            void initial$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            F64Array accumulator$iv$iv = initial$iv$iv;
            void var9_14 = $this$fold$iv$iv;
            int n = ((void)var9_14).length;
            for (int i = 0; i < n; ++i) {
                void pos$iv;
                void element$iv$iv;
                void var13_18 = element$iv$iv = var9_14[i];
                void m$iv = accumulator$iv$iv;
                boolean bl5 = false;
                accumulator$iv$iv = F64Array.view$default((F64Array)m$iv, (int)pos$iv, 0, 2, null);
            }
            void var17_21 = accumulator$iv$iv;
            f64Array2.copyTo((F64Array)var17_21);
        }

        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull int[] indices, double init) {
            void $this$fold$iv$iv;
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            F64Array this_$iv = this.a;
            boolean $i$f$view0 = false;
            boolean bl = indices.length < this_$iv.getNDim();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "too many indices";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int[] nArray = indices;
            F64Array initial$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            F64Array accumulator$iv$iv = initial$iv$iv;
            void var10_13 = $this$fold$iv$iv;
            int n = ((void)var10_13).length;
            for (int i = 0; i < n; ++i) {
                void pos$iv;
                void element$iv$iv;
                void var14_17 = element$iv$iv = var10_13[i];
                F64Array m$iv = accumulator$iv$iv;
                boolean bl5 = false;
                accumulator$iv$iv = F64Array.view$default(m$iv, (int)pos$iv, 0, 2, null);
            }
            accumulator$iv$iv.fill(init);
        }

        public final void set(@NotNull _I any, @NotNull F64Array other) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            other.copyTo(this.a);
        }

        public final void set(@NotNull _I any, double other) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            this.a.fill(other);
        }

        @NotNull
        public final F64Array get(@NotNull _I any, int c) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.a.view(c, 1);
        }

        public final void set(@NotNull _I any, int c, @NotNull F64Array other) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            other.copyTo(this.a.view(c, 1));
        }

        public final void set(@NotNull _I any, int c, double init) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            this.a.view(c, 1).fill(init);
        }

        public Viewer(@NotNull F64Array a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            this.a = a;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\f\"\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0015\u001a\u00020\t2\n\u0010\u0007\u001a\u00020\u0006\"\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000e2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180\u001bH\u0086\n\u00f8\u0001\u0000J6\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180\u001eH\u0086\n\u00f8\u0001\u0000JD\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180 H\u0086\n\u00f8\u0001\u0000J\u0015\u0010\u0019\u001a\u00020\t2\n\u0010\u0007\u001a\u00020\u0006\"\u00020\u000eH\u0086\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u00182\n\u0010\u000b\u001a\u00020\u0012\"\u00020\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lorg/jetbrains/bio/viktor/F64Array$Companion;", "", "()V", "calculateUnroll", "Lorg/jetbrains/bio/viktor/F64Array$Companion$Unroll;", "strides", "", "shape", "concatenate", "Lorg/jetbrains/bio/viktor/F64Array;", "first", "rest", "", "axis", "", "(Lorg/jetbrains/bio/viktor/F64Array;[Lorg/jetbrains/bio/viktor/F64Array;I)Lorg/jetbrains/bio/viktor/F64Array;", "create", "data", "", "offset", "create$viktor", "full", "size", "init", "", "invoke", "block", "Lkotlin/Function1;", "numRows", "numColumns", "Lkotlin/Function2;", "depth", "Lkotlin/Function3;", "of", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "Unroll", "viktor"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array invoke(int ... shape) {
            void $this$fold$iv$iv;
            void $this$product$iv;
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            int[] nArray = shape;
            F64FlatArray.Companion companion = F64FlatArray.Companion;
            boolean $i$f$product = false;
            void var4_5 = $this$product$iv;
            int initial$iv$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv$iv = initial$iv$iv;
            void var8_9 = $this$fold$iv$iv;
            int n = ((void)var8_9).length;
            for (int i = 0; i < n; ++i) {
                void p2$iv;
                void element$iv$iv;
                void var12_13 = element$iv$iv = var8_9[i];
                int p1$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = p1$iv * p2$iv;
            }
            int n2 = accumulator$iv$iv;
            return F64FlatArray.Companion.create$viktor$default(companion, new double[n2], 0, 0, 0, 14, null).reshape(Arrays.copyOf(shape, shape.length));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array invoke(int size, @NotNull Function1<? super Integer, Double> block) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            F64Array f64Array = this.invoke(size);
            boolean bl = false;
            boolean bl2 = false;
            F64Array $this$apply = f64Array;
            boolean bl3 = false;
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void i;
                $this$apply.set((int)i, ((Number)block.invoke((Object)((int)i))).doubleValue());
                ++i;
            }
            return f64Array;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array invoke(int numRows, int numColumns, @NotNull Function2<? super Integer, ? super Integer, Double> block) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            F64Array f64Array = this.invoke(numRows, numColumns);
            boolean bl = false;
            boolean bl2 = false;
            F64Array $this$apply = f64Array;
            boolean bl3 = false;
            int n = 0;
            int n2 = numRows;
            while (n < n2) {
                void r;
                int n3 = 0;
                int n4 = numColumns;
                while (n3 < n4) {
                    void c;
                    $this$apply.set((int)r, (int)c, ((Number)block.invoke((Object)((int)r), (Object)((int)c))).doubleValue());
                    ++c;
                }
                ++r;
            }
            return f64Array;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array invoke(int depth, int numRows, int numColumns, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Double> block) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            F64Array f64Array = this.invoke(depth, numRows, numColumns);
            boolean bl = false;
            boolean bl2 = false;
            F64Array $this$apply = f64Array;
            boolean bl3 = false;
            int n = 0;
            int n2 = depth;
            while (n < n2) {
                void d;
                int n3 = 0;
                int n4 = numRows;
                while (n3 < n4) {
                    void r;
                    int n5 = 0;
                    int n6 = numColumns;
                    while (n5 < n6) {
                        void c;
                        $this$apply.set((int)d, (int)r, (int)c, ((Number)block.invoke((Object)((int)d), (Object)((int)r), (Object)((int)c))).doubleValue());
                        ++c;
                    }
                    ++r;
                }
                ++d;
            }
            return f64Array;
        }

        @NotNull
        public final F64FlatArray of(double first, double ... rest) {
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            double[] data = new double[rest.length + 1];
            data[0] = first;
            System.arraycopy(rest, 0, data, 1, rest.length);
            return F64ArrayKt.asF64Array(data);
        }

        @NotNull
        public final F64Array full(int size, double init) {
            F64Array f64Array = this.invoke(size);
            boolean bl = false;
            boolean bl2 = false;
            F64Array $this$apply = f64Array;
            boolean bl3 = false;
            $this$apply.fill(init);
            return f64Array;
        }

        @NotNull
        public final F64Array full(@NotNull int[] shape, double init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            F64Array f64Array = this.invoke(Arrays.copyOf(shape, shape.length));
            boolean bl = false;
            boolean bl2 = false;
            F64Array $this$apply = f64Array;
            boolean bl3 = false;
            $this$apply.fill(init);
            return f64Array;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array concatenate(@NotNull F64Array first, @NotNull F64Array[] rest, int axis) {
            int n;
            void $this$sumBy$iv;
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            for (F64Array other : rest) {
                int[] nArray = InternalsKt.remove(other.getShape(), axis);
                int[] nArray2 = InternalsKt.remove(first.getShape(), axis);
                boolean bl = false;
                boolean bl2 = Arrays.equals(nArray, nArray2);
                boolean bl3 = false;
                bl = false;
                if (bl2) continue;
                boolean bl4 = false;
                String string = "input array shapes must be exactly equal for all dimensions except " + axis;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object object = first.getShape().clone();
            boolean bl = false;
            int n2 = 0;
            int[] $this$apply = (int[])object;
            boolean bl5 = false;
            F64Array[] f64ArrayArray = rest;
            int n3 = first.getShape()[axis];
            int n4 = axis;
            int[] nArray = $this$apply;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            void var16_28 = $this$sumBy$iv;
            int n5 = ((void)var16_28).length;
            for (int i = 0; i < n5; ++i) {
                void it;
                void element$iv;
                void var20_32 = element$iv = var16_28[i];
                n = sum$iv;
                boolean bl6 = false;
                int n6 = it.getShape()[axis];
                sum$iv = n + n6;
            }
            n = sum$iv;
            nArray[n4] = n3 + n;
            int[] shape = (int[])object;
            F64Array result = this.invoke(Arrays.copyOf(shape, shape.length));
            int offset = 0;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)first);
            spreadBuilder.addSpread((Object)rest);
            for (F64Array a : (F64Array[])spreadBuilder.toArray((Object[])new F64Array[spreadBuilder.size()])) {
                if (a.getSize() <= 0) continue;
                a.copyTo(F64Array.slice$default(result, offset, offset + a.getShape()[axis], 0, axis, 4, null));
                offset += a.getShape()[axis];
            }
            return result;
        }

        public static /* synthetic */ F64Array concatenate$default(Companion companion, F64Array f64Array, F64Array[] f64ArrayArray, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.concatenate(f64Array, f64ArrayArray, n);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array create$viktor(@NotNull double[] data, int offset, @NotNull int[] strides, @NotNull int[] shape) {
            F64Array f64Array;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            boolean bl = strides.length == shape.length;
            int n = 0;
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = false;
                String string = "strides and shape size don't match";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int[] nArray = strides;
            n = 0;
            int[] nArray2 = nArray;
            boolean bl3 = false;
            int n2 = !(nArray2.length == 0) ? 1 : 0;
            n = 0;
            boolean bl4 = false;
            if (n2 == 0) {
                boolean bl5 = false;
                String string = "singleton arrays are not supported";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (shape.length == 1) {
                f64Array = F64FlatArray.Companion.create$viktor(data, offset, ArraysKt.single((int[])strides), ArraysKt.single((int[])shape));
            } else {
                void unrollStride;
                void unrollDim;
                Unroll unroll = this.calculateUnroll(strides, shape);
                n2 = unroll.component1();
                n = unroll.component2();
                int unrollSize = unroll.component3();
                f64Array = new F64Array(data, offset, strides, shape, (int)unrollDim, (int)unrollStride, unrollSize);
            }
            return f64Array;
        }

        /*
         * WARNING - void declaration
         */
        private final Unroll calculateUnroll(int[] strides, int[] shape) {
            int n;
            void $this$fold$iv$iv;
            void $this$product$iv;
            int prevStride = 0;
            boolean unrollable = true;
            int d = 0;
            int s = 0;
            int n2 = 0;
            int n3 = strides.length;
            while (n2 < n3) {
                void i;
                if (shape[i] == 1) {
                    if (unrollable) {
                        d = i + true;
                    }
                } else {
                    if (unrollable && (prevStride == 0 || prevStride == strides[i] * shape[i])) {
                        d = i + true;
                        s = strides[i];
                    } else {
                        unrollable = false;
                    }
                    prevStride = strides[i];
                }
                ++i;
            }
            int[] i = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])shape, (IntRange)RangesKt.until((int)0, (int)d)));
            int n4 = s;
            int n5 = d;
            boolean $i$f$product = false;
            void var9_12 = $this$product$iv;
            int initial$iv$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv$iv = initial$iv$iv;
            void var13_16 = $this$fold$iv$iv;
            int n6 = ((void)var13_16).length;
            for (int j = 0; j < n6; ++j) {
                void p2$iv;
                void element$iv$iv;
                void var17_20 = element$iv$iv = var13_16[j];
                int p1$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = p1$iv * p2$iv;
            }
            int n7 = n = accumulator$iv$iv;
            int n8 = n4;
            int n9 = n5;
            return new Unroll(n9, n8, n7);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/bio/viktor/F64Array$Companion$Unroll;", "", "dim", "", "stride", "size", "(III)V", "getDim", "()I", "getSize", "getStride", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "viktor"})
        private static final class Unroll {
            private final int dim;
            private final int stride;
            private final int size;

            public final int getDim() {
                return this.dim;
            }

            public final int getStride() {
                return this.stride;
            }

            public final int getSize() {
                return this.size;
            }

            public Unroll(int dim, int stride, int size) {
                this.dim = dim;
                this.stride = stride;
                this.size = size;
            }

            public final int component1() {
                return this.dim;
            }

            public final int component2() {
                return this.stride;
            }

            public final int component3() {
                return this.size;
            }

            @NotNull
            public final Unroll copy(int dim, int stride, int size) {
                return new Unroll(dim, stride, size);
            }

            public static /* synthetic */ Unroll copy$default(Unroll unroll, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = unroll.dim;
                }
                if ((n4 & 2) != 0) {
                    n2 = unroll.stride;
                }
                if ((n4 & 4) != 0) {
                    n3 = unroll.size;
                }
                return unroll.copy(n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "Unroll(dim=" + this.dim + ", stride=" + this.stride + ", size=" + this.size + ")";
            }

            public int hashCode() {
                return (Integer.hashCode(this.dim) * 31 + Integer.hashCode(this.stride)) * 31 + Integer.hashCode(this.size);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Unroll)) break block3;
                        Unroll unroll = (Unroll)object;
                        if (this.dim != unroll.dim || this.stride != unroll.stride || this.size != unroll.size) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

