/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.viktor.F64Array;
import org.jetbrains.bio.viktor.F64ArrayKt;
import org.jetbrains.bio.viktor.F64FlatArray;
import org.jetbrains.bio.viktor.InternalsKt;
import org.jetbrains.bio.viktor.KahanSum;
import org.jetbrains.bio.viktor.MoreMathKt;
import org.jetbrains.bio.viktor._I;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0017\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u0089\u00012\u00020\u0001:\u0004\u0088\u0001\u0089\u0001BA\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00020\u0007\"\u00020\u0005H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0005H\u0096\u0002J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0086\u0002J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0086\u0002J\u001d\u0010#\u001a\u00020$2\n\u0010\u001e\u001a\u00020\u0007\"\u00020\u00052\u0006\u0010%\u001a\u00020\u001dH\u0086\u0002J\u0019\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001dH\u0096\u0002J!\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001dH\u0086\u0002J)\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001dH\u0086\u0002J\u0019\u0010&\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0082\bJ!\u0010&\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0082\bJ\u0011\u0010&\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0007H\u0082\bJ\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000(2\u0006\u0010)\u001a\u00020\u0005H\u0016J\u001a\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0005H\u0016J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0007H\u0082\bJ\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0(H\u0002J*\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00002\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020$02H\u0002J\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020\u00000(2\b\b\u0002\u00104\u001a\u00020\u0005H\u0002J\b\u0010=\u001a\u00020\u0000H\u0016J\u0010\u0010>\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0016J\u0014\u0010?\u001a\u00020\u00002\n\u0010\b\u001a\u00020\u0007\"\u00020\u0005H\u0016J\u0018\u0010@\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\b\b\u0002\u0010)\u001a\u00020\u0005J\b\u0010A\u001a\u00020.H\u0016J.\u0010B\u001a\u00020\u00002\b\b\u0002\u0010C\u001a\u00020\u00052\b\b\u0002\u0010D\u001a\u00020\u00052\b\b\u0002\u0010E\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0005J\u0011\u0010F\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001dH\u0096\u0002J\u0010\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020\u001dH\u0016J\u001a\u0010I\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u00072\b\b\u0002\u0010)\u001a\u00020\u0005H\u0016J\u0011\u0010J\u001a\u00020\u001d2\u0006\u00100\u001a\u00020KH\u0096\u0004J\u0011\u0010J\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0007H\u0096\u0004J\u0011\u0010J\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0003H\u0086\u0004J\u0011\u0010J\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0000H\u0096\u0004J\u0006\u0010L\u001a\u00020\u001dJ\b\u0010M\u001a\u00020\u001dH\u0016J\b\u0010N\u001a\u00020\u001dH\u0016J\b\u0010O\u001a\u00020$H\u0016J\b\u0010P\u001a\u00020\u001dH\u0016J\b\u0010Q\u001a\u00020\u0005H\u0016J\b\u0010R\u001a\u00020\u001dH\u0016J\b\u0010S\u001a\u00020\u0005H\u0016J\u001c\u0010T\u001a\u00020$2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0VH\u0016J\u001c\u0010W\u001a\u00020\u00002\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0VH\u0016J5\u0010X\u001a\u0002HY\"\u0004\b\u0000\u0010Y2\u0006\u0010Z\u001a\u0002HY2\u0018\u0010U\u001a\u0014\u0012\u0004\u0012\u0002HY\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002HY02H\u0016\u00a2\u0006\u0002\u0010[J\"\u0010\\\u001a\u00020\u001d2\u0018\u0010U\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d02H\u0016J*\u0010]\u001a\u00020$2\u0006\u00100\u001a\u00020\u00002\u0018\u0010U\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d02H\u0016J*\u0010^\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0018\u0010U\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d02H\u0016J\b\u0010_\u001a\u00020$H\u0016J\b\u0010`\u001a\u00020\u0000H\u0016J\b\u0010a\u001a\u00020$H\u0016J\b\u0010b\u001a\u00020\u0000H\u0016J\b\u0010c\u001a\u00020$H\u0016J\b\u0010d\u001a\u00020\u0000H\u0016J\b\u0010e\u001a\u00020$H\u0016J\b\u0010f\u001a\u00020\u0000H\u0016J\u0006\u0010g\u001a\u00020$J\u0006\u0010h\u001a\u00020$J\b\u0010i\u001a\u00020\u001dH\u0016J\u0010\u0010j\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0016J\u0011\u0010k\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0096\u0004J\t\u0010l\u001a\u00020\u0000H\u0086\u0002J\t\u0010m\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010n\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010o\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010n\u001a\u00020$2\u0006\u0010p\u001a\u00020\u001dH\u0096\u0002J\u0011\u0010o\u001a\u00020\u00002\u0006\u0010p\u001a\u00020\u001dH\u0086\u0002J\u0011\u0010q\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010r\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010q\u001a\u00020$2\u0006\u0010p\u001a\u00020\u001dH\u0096\u0002J\u0011\u0010r\u001a\u00020\u00002\u0006\u0010p\u001a\u00020\u001dH\u0086\u0002J\u0011\u0010s\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010t\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010s\u001a\u00020$2\u0006\u0010p\u001a\u00020\u001dH\u0096\u0002J\u0011\u0010t\u001a\u00020\u00002\u0006\u0010p\u001a\u00020\u001dH\u0086\u0002J\u0011\u0010u\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010v\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010u\u001a\u00020$2\u0006\u0010p\u001a\u00020\u001dH\u0096\u0002J\u0011\u0010v\u001a\u00020\u00002\u0006\u0010p\u001a\u00020\u001dH\u0086\u0002J\u0010\u0010w\u001a\u00020$2\u0006\u00100\u001a\u00020\u0000H\u0002J\u0013\u0010x\u001a\b\u0012\u0004\u0012\u00020\u001d0(H\u0010\u00a2\u0006\u0002\byJ\r\u0010z\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b{J\b\u0010|\u001a\u00020\u0001H\u0016J\u0011\u0010}\u001a\u0006\u0012\u0002\b\u00030~H\u0016\u00a2\u0006\u0002\u0010\u007fJ\t\u0010\u0080\u0001\u001a\u00020\u0003H\u0016J\u001f\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020\u00052\n\b\u0002\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016J\n\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J\u0014\u0010\u0086\u0001\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010\u0087\u0001\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001bR!\u00105\u001a\u0002068FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b;\u0010<\u0012\u0004\b7\u00108\u001a\u0004\b9\u0010:\u00a8\u0006\u008a\u0001"}, d2={"Lorg/jetbrains/bio/viktor/F64Array;", "", "data", "", "offset", "", "strides", "", "shape", "unrollDim", "unrollStride", "unrollSize", "<init>", "([DI[I[IIII)V", "getData", "()[D", "getOffset", "()I", "getStrides", "()[I", "getShape", "nDim", "getNDim", "length", "getLength", "isFlattenable", "", "()Z", "get", "", "indices", "pos", "r", "c", "d", "set", "", "value", "unsafeIndex", "along", "Lkotlin/sequences/Sequence;", "axis", "view", "index", "view0", "unrollToFlat", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "commonUnrollToFlat", "other", "action", "Lkotlin/Function2;", "unrollOnce", "n", "V", "Lorg/jetbrains/bio/viktor/F64Array$Viewer;", "getV$annotations", "()V", "getV", "()Lorg/jetbrains/bio/viktor/F64Array$Viewer;", "V$delegate", "Lkotlin/Lazy;", "copy", "copyTo", "reshape", "append", "flatten", "slice", "from", "to", "step", "contains", "fill", "init", "reorder", "dot", "", "mean", "sd", "sum", "cumSum", "max", "argMax", "min", "argMin", "transformInPlace", "op", "Lkotlin/Function1;", "transform", "fold", "T", "initial", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "reduce", "combineInPlace", "combine", "expInPlace", "exp", "expm1InPlace", "expm1", "logInPlace", "log", "log1pInPlace", "log1p", "rescale", "logRescale", "logSumExp", "logAddExpAssign", "logAddExp", "unaryPlus", "unaryMinus", "plusAssign", "plus", "update", "minusAssign", "minus", "timesAssign", "times", "divAssign", "div", "checkShape", "asSequence", "asSequence$8a17064c705b2ef1", "clone", "clone$8a17064c705b2ef1", "toArray", "toGenericArray", "", "()[Ljava/lang/Object;", "toDoubleArray", "toString", "", "maxDisplay", "format", "Ljava/text/DecimalFormat;", "equals", "hashCode", "Viewer", "Companion", "8a17064c705b2ef1"})
@SourceDebugExtension(value={"SMAP\nF64Array.kt\nKotlin\n*S Kotlin\n*F\n+ 1 F64Array.kt\norg/jetbrains/bio/viktor/F64Array\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Internals.kt\norg/jetbrains/bio/viktor/InternalsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Sorting.kt\norg/jetbrains/bio/viktor/SortingKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1239:1\n157#1:1245\n147#1:1259\n152#1:1272\n157#1:1277\n147#1:1291\n152#1:1304\n1#2:1240\n14#3,4:1241\n20#3:1250\n14#3,4:1251\n14#3,4:1255\n14#3,4:1260\n14#3,4:1264\n14#3,4:1268\n14#3,4:1273\n20#3:1282\n14#3,4:1283\n14#3,4:1287\n14#3,4:1292\n14#3,4:1296\n14#3,4:1300\n14#3,4:1309\n14#3,4:1313\n4#3:1322\n20#3:1347\n20#3:1348\n20#3:1349\n4#3:1350\n20#3:1356\n20#3:1357\n20#3:1358\n4#3:1367\n13058#4,4:1246\n13058#4,4:1278\n13058#4,4:1305\n12925#4,3:1317\n12925#4,3:1323\n12925#4,3:1351\n12925#4,3:1368\n1321#5,2:1320\n1255#5,2:1326\n1321#5,2:1354\n1321#5,2:1359\n1292#5,3:1361\n1292#5,3:1364\n48#6,19:1328\n1740#7,3:1371\n1803#7,3:1374\n*S KotlinDebug\n*F\n+ 1 F64Array.kt\norg/jetbrains/bio/viktor/F64Array\n*L\n95#1:1245\n104#1:1259\n112#1:1272\n125#1:1277\n134#1:1291\n142#1:1304\n93#1:1241,4\n98#1:1250\n102#1:1251,4\n103#1:1255,4\n109#1:1260,4\n110#1:1264,4\n111#1:1268,4\n123#1:1273,4\n128#1:1282\n132#1:1283,4\n133#1:1287,4\n139#1:1292,4\n140#1:1296,4\n141#1:1300,4\n180#1:1309,4\n181#1:1313,4\n256#1:1322\n512#1:1347\n519#1:1348\n533#1:1349\n540#1:1350\n571#1:1356\n589#1:1357\n607#1:1358\n815#1:1367\n95#1:1246,4\n125#1:1278,4\n157#1:1305,4\n196#1:1317,3\n256#1:1323,3\n540#1:1351,3\n815#1:1368,3\n229#1:1320,2\n485#1:1326,2\n562#1:1354,2\n622#1:1359,2\n668#1:1361,3\n696#1:1364,3\n500#1:1328,19\n997#1:1371,3\n1000#1:1374,3\n*E\n"})
public class F64Array {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] data;
    private final int offset;
    @NotNull
    private final int[] strides;
    @NotNull
    private final int[] shape;
    private final int unrollDim;
    private final int unrollStride;
    private final int unrollSize;
    private final int nDim;
    private final int length;
    private final boolean isFlattenable;
    @NotNull
    private final transient Lazy V$delegate;

    protected F64Array(@NotNull double[] data, int offset, @NotNull int[] strides, @NotNull int[] shape, int unrollDim, int unrollStride, int unrollSize) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.data = data;
        this.offset = offset;
        this.strides = strides;
        this.shape = shape;
        this.unrollDim = unrollDim;
        this.unrollStride = unrollStride;
        this.unrollSize = unrollSize;
        this.nDim = this.shape.length;
        this.length = this.shape[0];
        this.isFlattenable = this.unrollDim == this.nDim;
        this.V$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> F64Array.V_delegate$lambda$14(this));
    }

    @NotNull
    public final double[] getData() {
        return this.data;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    @NotNull
    public final int[] getShape() {
        return this.shape;
    }

    public final int getNDim() {
        return this.nDim;
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean isFlattenable() {
        return this.isFlattenable;
    }

    /*
     * WARNING - void declaration
     */
    public final double get(int ... indices) {
        void $this$foldIndexed$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        if (!(indices.length == this.nDim)) {
            boolean $i$a$-check-F64Array$get$322 = false;
            String $i$a$-check-F64Array$get$322 = "broadcasting get is not supported";
            throw new IllegalStateException($i$a$-check-F64Array$get$322.toString());
        }
        int $i$a$-check-F64Array$get$322 = this.nDim;
        for (int d = 0; d < $i$a$-check-F64Array$get$322; ++d) {
            void label$iv;
            void pos$iv;
            String string = "index";
            int n = indices[d];
            int size$iv = this.shape[d];
            boolean $i$f$checkIndex = false;
            if (pos$iv >= 0 && pos$iv < size$iv) continue;
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + (int)pos$iv);
        }
        F64Array d = this;
        int[] $i$a$-check-F64Array$get$322 = indices;
        double[] dArray = this.data;
        boolean $i$f$unsafeIndex = false;
        int[] pos$iv = this_$iv.strides;
        int initial$iv$iv = this_$iv.offset;
        boolean $i$f$foldIndexed = false;
        int index$iv$iv = 0;
        int accumulator$iv$iv = initial$iv$iv;
        for (void element$iv$iv : $this$foldIndexed$iv$iv) {
            void stride$iv;
            void indices$iv;
            void acc$iv;
            int n = index$iv$iv++;
            void var13_20 = element$iv$iv;
            int n2 = accumulator$iv$iv;
            int i$iv = n;
            boolean bl = false;
            accumulator$iv$iv = acc$iv + indices$iv[i$iv] * stride$iv;
        }
        int n = accumulator$iv$iv;
        return dArray[n];
    }

    public double get(int pos) {
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public final double get(int r, int c) {
        void r$iv;
        void this_$iv;
        Object label$iv;
        int pos$iv;
        if (!(this.nDim == 2)) {
            boolean $i$a$-check-F64Array$get$32 = false;
            String $i$a$-check-F64Array$get$32 = "broadcasting get is not supported";
            throw new IllegalStateException($i$a$-check-F64Array$get$32.toString());
        }
        String string = "row";
        int $i$a$-check-F64Array$get$32 = r;
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "column";
        pos$iv = c;
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = this;
        pos$iv = r;
        int c$iv = c;
        boolean $i$f$unsafeIndex = false;
        return this.data[this_$iv.offset + r$iv * this_$iv.strides[0] + c$iv * this_$iv.strides[1]];
    }

    /*
     * WARNING - void declaration
     */
    public final double get(int d, int r, int c) {
        void r$iv;
        void d$iv;
        void this_$iv;
        Object label$iv;
        int pos$iv;
        if (!(this.nDim == 3)) {
            boolean $i$a$-check-F64Array$get$42 = false;
            String $i$a$-check-F64Array$get$42 = "broadcasting get is not supported";
            throw new IllegalStateException($i$a$-check-F64Array$get$42.toString());
        }
        String string = "depth";
        int $i$a$-check-F64Array$get$42 = r;
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "row";
        pos$iv = r;
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "column";
        pos$iv = c;
        size$iv = this.shape[2];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = this;
        pos$iv = d;
        size$iv = r;
        int c$iv = c;
        boolean $i$f$unsafeIndex = false;
        return this.data[this_$iv.offset + d$iv * this_$iv.strides[0] + r$iv * this_$iv.strides[1] + c$iv * this_$iv.strides[2]];
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull int[] indices, double value) {
        void $this$foldIndexed$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        if (!(indices.length == this.nDim)) {
            boolean $i$a$-check-F64Array$set$322 = false;
            String $i$a$-check-F64Array$set$322 = "broadcasting set is not supported";
            throw new IllegalStateException($i$a$-check-F64Array$set$322.toString());
        }
        int $i$a$-check-F64Array$set$322 = this.nDim;
        for (int d = 0; d < $i$a$-check-F64Array$set$322; ++d) {
            void label$iv;
            void pos$iv;
            String string = "index";
            int n = indices[d];
            int size$iv = this.shape[d];
            boolean $i$f$checkIndex = false;
            if (pos$iv >= 0 && pos$iv < size$iv) continue;
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + (int)pos$iv);
        }
        F64Array d = this;
        int[] $i$a$-check-F64Array$set$322 = indices;
        double[] dArray = this.data;
        boolean $i$f$unsafeIndex = false;
        int[] pos$iv = this_$iv.strides;
        int initial$iv$iv = this_$iv.offset;
        boolean $i$f$foldIndexed = false;
        int index$iv$iv = 0;
        int accumulator$iv$iv = initial$iv$iv;
        for (void element$iv$iv : $this$foldIndexed$iv$iv) {
            void stride$iv;
            void indices$iv;
            void acc$iv;
            int n = index$iv$iv++;
            void var15_21 = element$iv$iv;
            int n2 = accumulator$iv$iv;
            int i$iv = n;
            boolean bl = false;
            accumulator$iv$iv = acc$iv + indices$iv[i$iv] * stride$iv;
        }
        int n = accumulator$iv$iv;
        dArray[n] = value;
    }

    public void set(int pos, double value) {
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    public final void set(int r, int c, double value) {
        Object label$iv;
        int pos$iv;
        if (!(this.nDim == 2)) {
            boolean $i$a$-check-F64Array$set$32 = false;
            String $i$a$-check-F64Array$set$32 = "broadcasting set is not supported";
            throw new IllegalStateException($i$a$-check-F64Array$set$32.toString());
        }
        String string = "row";
        int $i$a$-check-F64Array$set$32 = r;
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "column";
        pos$iv = c;
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = this;
        pos$iv = r;
        int c$iv = c;
        boolean $i$f$unsafeIndex = false;
        this.data[this_$iv.offset + r$iv * this_$iv.strides[0] + c$iv * this_$iv.strides[1]] = value;
    }

    public final void set(int d, int r, int c, double value) {
        Object label$iv;
        int pos$iv;
        if (!(this.nDim == 3)) {
            boolean $i$a$-check-F64Array$set$42 = false;
            String $i$a$-check-F64Array$set$42 = "broadcasting set is not supported";
            throw new IllegalStateException($i$a$-check-F64Array$set$42.toString());
        }
        String string = "depth";
        int $i$a$-check-F64Array$set$42 = d;
        int size$iv = this.shape[0];
        boolean $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "row";
        pos$iv = r;
        size$iv = this.shape[1];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "column";
        pos$iv = c;
        size$iv = this.shape[2];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException((String)label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = this;
        pos$iv = d;
        size$iv = r;
        int c$iv = c;
        boolean $i$f$unsafeIndex = false;
        this.data[this_$iv.offset + d$iv * this_$iv.strides[0] + r$iv * this_$iv.strides[1] + c$iv * this_$iv.strides[2]] = value;
    }

    private final int unsafeIndex(int r, int c) {
        boolean $i$f$unsafeIndex = false;
        return this.offset + r * this.strides[0] + c * this.strides[1];
    }

    private final int unsafeIndex(int d, int r, int c) {
        boolean $i$f$unsafeIndex = false;
        return this.offset + d * this.strides[0] + r * this.strides[1] + c * this.strides[2];
    }

    /*
     * WARNING - void declaration
     */
    private final int unsafeIndex(int[] indices) {
        void $this$foldIndexed$iv;
        boolean $i$f$unsafeIndex = false;
        int[] nArray = this.strides;
        int initial$iv = this.offset;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void stride;
            void acc;
            int n = index$iv++;
            void var11_11 = element$iv;
            int n2 = accumulator$iv;
            int i = n;
            boolean bl = false;
            accumulator$iv = acc + indices[i] * stride;
        }
        return accumulator$iv;
    }

    @NotNull
    public Sequence<F64Array> along(int axis) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.shape[axis]))), arg_0 -> F64Array.along$lambda$7(this, axis, arg_0));
    }

    @NotNull
    public F64Array view(int index, int axis) {
        String label$iv;
        int pos$iv;
        String string = "axis";
        int n = axis;
        int size$iv = this.nDim;
        boolean $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        label$iv = "index";
        pos$iv = index;
        size$iv = this.shape[axis];
        $i$f$checkIndex = false;
        if (pos$iv < 0 || pos$iv >= size$iv) {
            throw new IndexOutOfBoundsException(label$iv + " must be in [0, " + size$iv + "), but was " + pos$iv);
        }
        return Companion.create$8a17064c705b2ef1(this.data, this.offset + this.strides[axis] * index, InternalsKt.remove(this.strides, axis), InternalsKt.remove(this.shape, axis));
    }

    public static /* synthetic */ F64Array view$default(F64Array f64Array, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: view");
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return f64Array.view(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final F64Array view0(int[] indices) {
        void $this$fold$iv;
        boolean $i$f$view0 = false;
        if (!(indices.length < this.getNDim())) {
            boolean $i$a$-require-F64Array$view0$22 = false;
            String $i$a$-require-F64Array$view0$22 = "too many indices";
            throw new IllegalArgumentException($i$a$-require-F64Array$view0$22.toString());
        }
        int[] nArray = indices;
        F64Array initial$iv = this;
        boolean $i$f$fold = false;
        F64Array accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void pos;
            void element$iv;
            void var10_12 = element$iv = $this$fold$iv[i];
            F64Array m = accumulator$iv;
            boolean bl = false;
            accumulator$iv = F64Array.view$default(m, (int)pos, 0, 2, null);
        }
        return accumulator$iv;
    }

    private final Sequence<F64FlatArray> unrollToFlat() {
        if (this.isFlattenable) {
            Object[] objectArray = new F64FlatArray[]{this.flatten()};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }
        return SequencesKt.flatMap((Sequence)F64Array.unrollOnce$default(this, 0, 1, null), F64Array::unrollToFlat$lambda$10);
    }

    private final void commonUnrollToFlat(F64Array other, Function2<? super F64FlatArray, ? super F64FlatArray, Unit> action) {
        this.checkShape(other);
        int commonUnrollDim = Math.min(this.unrollDim, other.unrollDim);
        if (commonUnrollDim == this.nDim) {
            action.invoke((Object)this.flatten(), (Object)other.flatten());
        } else {
            Sequence $this$forEach$iv = SequencesKt.zip(this.unrollOnce(commonUnrollDim), other.unrollOnce(commonUnrollDim));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                F64Array a = (F64Array)pair.component1();
                F64Array b = (F64Array)pair.component2();
                a.commonUnrollToFlat(b, action);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<F64Array> unrollOnce(int n) {
        int n2;
        int n3;
        int[] newStrides = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])this.strides, (IntRange)RangesKt.until((int)n, (int)this.nDim)));
        int[] newShape = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])this.shape, (IntRange)RangesKt.until((int)n, (int)this.nDim)));
        if (n == this.unrollDim) {
            n3 = this.unrollStride;
        } else {
            int nonTrivialN;
            F64Array $this$unrollOnce_u24lambda_u2412 = this;
            boolean bl = false;
            for (nonTrivialN = n - 1; nonTrivialN >= 0 && $this$unrollOnce_u24lambda_u2412.shape[nonTrivialN] <= 1; --nonTrivialN) {
            }
            n3 = nonTrivialN >= 0 ? $this$unrollOnce_u24lambda_u2412.strides[nonTrivialN] : 0;
        }
        int currentUnrollStride = n3;
        if (n == this.unrollDim) {
            n2 = this.unrollSize;
        } else {
            void $this$fold$iv$iv;
            int[] $this$product$iv = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])this.shape, (IntRange)RangesKt.until((int)0, (int)n)));
            boolean $i$f$product = false;
            int[] nonTrivialN = $this$product$iv;
            int initial$iv$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv$iv = initial$iv$iv;
            int n4 = ((void)$this$fold$iv$iv).length;
            for (int i = 0; i < n4; ++i) {
                void p1$iv;
                void element$iv$iv;
                void var15_15 = element$iv$iv = $this$fold$iv$iv[i];
                int p0$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = p0$iv * p1$iv;
            }
            n2 = accumulator$iv$iv;
        }
        int currentUnrollSize = n2;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)currentUnrollSize))), arg_0 -> F64Array.unrollOnce$lambda$13(this, currentUnrollStride, newStrides, newShape, arg_0));
    }

    static /* synthetic */ Sequence unrollOnce$default(F64Array f64Array, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: unrollOnce");
        }
        if ((n2 & 1) != 0) {
            n = f64Array.unrollDim;
        }
        return f64Array.unrollOnce(n);
    }

    @NotNull
    public final Viewer getV() {
        Lazy lazy = this.V$delegate;
        return (Viewer)lazy.getValue();
    }

    public static /* synthetic */ void getV$annotations() {
    }

    @NotNull
    public F64Array copy() {
        int[] nArray = this.shape;
        F64Array copy = Companion.invoke(Arrays.copyOf(nArray, nArray.length));
        this.copyTo(copy);
        return copy;
    }

    public void copyTo(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)F64Array::copyTo$lambda$15));
    }

    @NotNull
    public F64Array reshape(int ... shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.flatten().reshape(Arrays.copyOf(shape, shape.length));
    }

    @NotNull
    public final F64Array append(@NotNull F64Array other, int axis) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array[] f64ArrayArray = new F64Array[]{other};
        return Companion.concatenate(this, f64ArrayArray, axis);
    }

    public static /* synthetic */ F64Array append$default(F64Array f64Array, F64Array f64Array2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return f64Array.append(f64Array2, n);
    }

    @NotNull
    public F64FlatArray flatten() {
        if (!this.isFlattenable) {
            boolean bl = false;
            String string = "array can't be flattened";
            throw new IllegalStateException(string.toString());
        }
        return F64FlatArray.Companion.create$8a17064c705b2ef1(this.data, this.offset, this.unrollStride, this.unrollSize);
    }

    @NotNull
    public final F64Array slice(int from, int to, int step, int axis) {
        int n;
        if (!(step > 0)) {
            boolean $i$a$-require-F64Array$slice$42 = false;
            String $i$a$-require-F64Array$slice$42 = "slicing step must be positive, but was " + step;
            throw new IllegalArgumentException($i$a$-require-F64Array$slice$42.toString());
        }
        if (!(0 <= axis ? axis < this.nDim : false)) {
            boolean $i$a$-require-F64Array$slice$52 = false;
            String $i$a$-require-F64Array$slice$52 = "axis out of bounds: " + axis;
            throw new IllegalArgumentException($i$a$-require-F64Array$slice$52.toString());
        }
        if (!(from >= 0)) {
            boolean $i$a$-require-F64Array$slice$62 = false;
            String $i$a$-require-F64Array$slice$62 = "slicing start index must be positive, but was " + from;
            throw new IllegalArgumentException($i$a$-require-F64Array$slice$62.toString());
        }
        if (to != -1) {
            if (!(to > from)) {
                boolean $i$a$-require-F64Array$slice$actualTo$22 = false;
                String $i$a$-require-F64Array$slice$actualTo$22 = "slicing end index " + to + " must be greater than start index " + from;
                throw new IllegalArgumentException($i$a$-require-F64Array$slice$actualTo$22.toString());
            }
            if (!(to <= this.shape[axis])) {
                boolean $i$a$-check-F64Array$slice$actualTo$42 = false;
                String $i$a$-check-F64Array$slice$actualTo$42 = "slicing end index out of bounds: " + to + " > " + this.shape[axis];
                throw new IllegalStateException($i$a$-check-F64Array$slice$actualTo$42.toString());
            }
            n = to;
        } else {
            if (!(this.shape[axis] > from)) {
                boolean $i$a$-check-F64Array$slice$actualTo$52 = false;
                String $i$a$-check-F64Array$slice$actualTo$52 = "slicing start index out of bounds: " + from + " >= " + this.shape[axis];
                throw new IllegalStateException($i$a$-check-F64Array$slice$actualTo$52.toString());
            }
            n = this.shape[axis];
        }
        int actualTo = n;
        Object $i$a$-check-F64Array$slice$actualTo$52 = this.strides.clone();
        int[] $this$slice_u24lambda_u2423 = (int[])$i$a$-check-F64Array$slice$actualTo$52;
        boolean bl = false;
        $this$slice_u24lambda_u2423[axis] = $this$slice_u24lambda_u2423[axis] * step;
        int[] sliceStrides = (int[])$i$a$-check-F64Array$slice$actualTo$52;
        Object object = this.shape.clone();
        int[] $this$slice_u24lambda_u2424 = (int[])object;
        boolean bl2 = false;
        $this$slice_u24lambda_u2424[axis] = (actualTo - from + step - 1) / step;
        int[] sliceShape = (int[])object;
        return Companion.create$8a17064c705b2ef1(this.data, this.offset + from * this.strides[axis], sliceStrides, sliceShape);
    }

    public static /* synthetic */ F64Array slice$default(F64Array f64Array, int n, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: slice");
        }
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = -1;
        }
        if ((n5 & 4) != 0) {
            n3 = 1;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return f64Array.slice(n, n2, n3, n4);
    }

    public boolean contains(double other) {
        boolean bl;
        block1: {
            Sequence<F64FlatArray> $this$any$iv = this.unrollToFlat();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                F64FlatArray it = (F64FlatArray)element$iv;
                boolean bl2 = false;
                if (!it.contains(other)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public void fill(double init) {
        this.flatten().fill(init);
    }

    /*
     * WARNING - void declaration
     */
    public void reorder(@NotNull int[] indices, int axis) {
        void axis$iv;
        void a$iv;
        void indices$iv;
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        F64Array f64Array = this;
        int[] nArray = indices;
        int n = axis;
        boolean $i$f$reorderInternal = false;
        if (!(((void)indices$iv).length == a$iv.getShape()[axis$iv])) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] copy$iv = (int[])indices$iv.clone();
        int n2 = a$iv.getShape()[axis$iv];
        for (int pos$iv = 0; pos$iv < n2; ++pos$iv) {
            void value;
            boolean bl;
            int pos;
            int pos2 = pos$iv;
            boolean bl2 = false;
            F64Array value$iv = this.view(pos2, axis).copy();
            int j$iv = pos$iv;
            while (true) {
                F64Array f64Array2;
                int k$iv = copy$iv[j$iv];
                copy$iv[j$iv] = j$iv;
                if (k$iv == pos$iv) break;
                pos = k$iv;
                int n3 = j$iv;
                f64Array3 = false;
                F64Array f64Array3 = f64Array2 = this.view(pos, axis).copy();
                pos = n3;
                bl = false;
                value.copyTo(this.view(pos, axis));
                j$iv = k$iv;
            }
            F64Array f64Array4 = value$iv;
            pos = j$iv;
            bl = false;
            value.copyTo(this.view(pos, axis));
        }
    }

    public static /* synthetic */ void reorder$default(F64Array f64Array, int[] nArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reorder");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        f64Array.reorder(nArray, n);
    }

    public double dot(@NotNull short[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    public double dot(@NotNull int[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    public final double dot(@NotNull double[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.dot(F64ArrayKt.asF64Array(other));
    }

    public double dot(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public final double mean() {
        void $this$fold$iv$iv;
        void $this$product$iv;
        int[] nArray = this.shape;
        double d = this.sum();
        boolean $i$f$product = false;
        void var3_4 = $this$product$iv;
        int initial$iv$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv$iv = initial$iv$iv;
        int n = ((void)$this$fold$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p1$iv;
            void element$iv$iv;
            void var10_11 = element$iv$iv = $this$fold$iv$iv[i];
            int p0$iv = accumulator$iv$iv;
            boolean bl = false;
            accumulator$iv$iv = p0$iv * p1$iv;
        }
        int n2 = accumulator$iv$iv;
        return d / (double)n2;
    }

    public double sd() {
        double s = this.sum();
        double s2 = this.dot(this);
        return Math.sqrt((s2 - s * s / (double)this.length) / (double)(this.length - 1));
    }

    public double sum() {
        KahanSum acc = new KahanSum(0.0, 1, null);
        Sequence<F64FlatArray> $this$forEach$iv = this.unrollToFlat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            F64FlatArray it = (F64FlatArray)element$iv;
            boolean bl = false;
            acc.plusAssign(it.sum());
        }
        return acc.result();
    }

    public void cumSum() {
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    public double max() {
        Double d = SequencesKt.maxOrNull((Sequence)SequencesKt.map(this.unrollToFlat(), F64Array::max$lambda$29));
        return d != null ? d : Double.NEGATIVE_INFINITY;
    }

    public int argMax() {
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    public double min() {
        Double d = SequencesKt.minOrNull((Sequence)SequencesKt.map(this.unrollToFlat(), F64Array::min$lambda$30));
        return d != null ? d : Double.POSITIVE_INFINITY;
    }

    public int argMin() {
        boolean $i$f$unsupported = false;
        throw new UnsupportedOperationException();
    }

    public void transformInPlace(@NotNull Function1<? super Double, Double> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        Sequence<F64FlatArray> $this$forEach$iv = this.unrollToFlat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            F64FlatArray it = (F64FlatArray)element$iv;
            boolean bl = false;
            it.transformInPlace(op);
        }
    }

    @NotNull
    public F64Array transform(@NotNull Function1<? super Double, Double> op) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (this.isFlattenable) {
            int[] nArray = this.shape;
            return ((F64FlatArray)this.flatten().transform((Function1)op)).reshape(Arrays.copyOf(nArray, nArray.length));
        }
        F64Array $this$transform_u24lambda_u2432 = f64Array = this.copy();
        boolean bl = false;
        $this$transform_u24lambda_u2432.transformInPlace(op);
        return f64Array;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fold(T initial, @NotNull Function2<? super T, ? super Double, ? extends T> op) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (this.isFlattenable) {
            return this.flatten().fold(initial, op);
        }
        Sequence<F64FlatArray> sequence = this.unrollToFlat();
        T initial$iv = initial;
        boolean $i$f$fold = false;
        T accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void f64FlatArray;
            F64FlatArray f64FlatArray2 = (F64FlatArray)element$iv;
            T acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = f64FlatArray.fold(acc, op);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    public double reduce(@NotNull Function2<? super Double, ? super Double, Double> op) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (this.isFlattenable) {
            return this.flatten().reduce(op);
        }
        Sequence<F64FlatArray> sequence = this.unrollToFlat();
        double initial = ((F64FlatArray)SequencesKt.first(sequence)).reduce(op);
        Sequence sequence2 = SequencesKt.drop(sequence, (int)1);
        double initial$iv = initial;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void f64FlatArray;
            F64FlatArray f64FlatArray2 = (F64FlatArray)element$iv;
            double acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ((Number)f64FlatArray.fold(acc, op)).doubleValue();
        }
        return accumulator$iv;
    }

    public void combineInPlace(@NotNull F64Array other, @NotNull Function2<? super Double, ? super Double, Double> op) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)(arg_0, arg_1) -> F64Array.combineInPlace$lambda$35(op, arg_0, arg_1)));
    }

    @NotNull
    public F64Array combine(@NotNull F64Array other, @NotNull Function2<? super Double, ? super Double, Double> op) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (this.isFlattenable && other.isFlattenable) {
            int[] nArray = this.shape;
            return ((F64FlatArray)this.flatten().combine((F64Array)other.flatten(), (Function2)op)).reshape(Arrays.copyOf(nArray, nArray.length));
        }
        F64Array $this$combine_u24lambda_u2436 = f64Array = this.copy();
        boolean bl = false;
        $this$combine_u24lambda_u2436.combineInPlace(other, op);
        return f64Array;
    }

    public void expInPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)expInPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array exp() {
        return this.transform((Function1<? super Double, Double>)((Function1)exp.1.INSTANCE));
    }

    public void expm1InPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)expm1InPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array expm1() {
        return this.transform((Function1<? super Double, Double>)((Function1)expm1.1.INSTANCE));
    }

    public void logInPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)logInPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array log() {
        return this.transform((Function1<? super Double, Double>)((Function1)log.1.INSTANCE));
    }

    public void log1pInPlace() {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)log1pInPlace.1.INSTANCE));
    }

    @NotNull
    public F64Array log1p() {
        return this.transform((Function1<? super Double, Double>)((Function1)log1p.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public final void rescale() {
        void $this$fold$iv$iv;
        void $this$product$iv;
        int[] nArray = this.shape;
        double d = Precision.EPSILON;
        double d2 = this.sum();
        F64Array f64Array = this;
        boolean $i$f$product = false;
        void var3_6 = $this$product$iv;
        int initial$iv$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv$iv = initial$iv$iv;
        int n = ((void)$this$fold$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p1$iv;
            void element$iv$iv;
            void var10_13 = element$iv$iv = $this$fold$iv$iv[i];
            int p0$iv = accumulator$iv$iv;
            boolean bl = false;
            accumulator$iv$iv = p0$iv * p1$iv;
        }
        int n2 = accumulator$iv$iv;
        f64Array.divAssign(d2 + d * (double)n2);
    }

    public final void logRescale() {
        this.minusAssign(this.logSumExp());
    }

    public double logSumExp() {
        return MoreMathKt.logSumExp((Sequence<Double>)SequencesKt.map(this.unrollToFlat(), F64Array::logSumExp$lambda$37));
    }

    public void logAddExpAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)F64Array::logAddExpAssign$lambda$38));
    }

    @NotNull
    public F64Array logAddExp(@NotNull F64Array other) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array $this$logAddExp_u24lambda_u2439 = f64Array = this.copy();
        boolean bl = false;
        $this$logAddExp_u24lambda_u2439.logAddExpAssign(other);
        return f64Array;
    }

    @NotNull
    public final F64Array unaryPlus() {
        return this;
    }

    @NotNull
    public F64Array unaryMinus() {
        return this.transform((Function1<? super Double, Double>)((Function1)F64Array::unaryMinus$lambda$40));
    }

    public void plusAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)F64Array::plusAssign$lambda$41));
    }

    @NotNull
    public F64Array plus(@NotNull F64Array other) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array $this$plus_u24lambda_u2442 = f64Array = this.copy();
        boolean bl = false;
        $this$plus_u24lambda_u2442.plusAssign(other);
        return f64Array;
    }

    public void plusAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.plusAssign$lambda$43(update, arg_0)));
    }

    @NotNull
    public final F64Array plus(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.plus$lambda$44(update, arg_0)));
    }

    public void minusAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)F64Array::minusAssign$lambda$45));
    }

    @NotNull
    public F64Array minus(@NotNull F64Array other) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array $this$minus_u24lambda_u2446 = f64Array = this.copy();
        boolean bl = false;
        $this$minus_u24lambda_u2446.minusAssign(other);
        return f64Array;
    }

    public void minusAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.minusAssign$lambda$47(update, arg_0)));
    }

    @NotNull
    public final F64Array minus(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.minus$lambda$48(update, arg_0)));
    }

    public void timesAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)F64Array::timesAssign$lambda$49));
    }

    @NotNull
    public F64Array times(@NotNull F64Array other) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array $this$times_u24lambda_u2450 = f64Array = this.copy();
        boolean bl = false;
        $this$times_u24lambda_u2450.timesAssign(other);
        return f64Array;
    }

    public void timesAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.timesAssign$lambda$51(update, arg_0)));
    }

    @NotNull
    public final F64Array times(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.times$lambda$52(update, arg_0)));
    }

    public void divAssign(@NotNull F64Array other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commonUnrollToFlat(other, (Function2<? super F64FlatArray, ? super F64FlatArray, Unit>)((Function2)F64Array::divAssign$lambda$53));
    }

    @NotNull
    public F64Array div(@NotNull F64Array other) {
        F64Array f64Array;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        F64Array $this$div_u24lambda_u2454 = f64Array = this.copy();
        boolean bl = false;
        $this$div_u24lambda_u2454.divAssign(other);
        return f64Array;
    }

    public void divAssign(double update) {
        this.transformInPlace((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.divAssign$lambda$55(update, arg_0)));
    }

    @NotNull
    public final F64Array div(double update) {
        return this.transform((Function1<? super Double, Double>)((Function1)arg_0 -> F64Array.div$lambda$56(update, arg_0)));
    }

    private final void checkShape(F64Array other) {
        if (!(this == other || Arrays.equals(this.shape, other.shape))) {
            boolean bl = false;
            String string = Arrays.toString(this.shape);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = Arrays.toString(other.shape);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = "operands shapes do not match: " + string + " vs " + string2;
            throw new IllegalStateException(string3.toString());
        }
    }

    @NotNull
    public Sequence<Double> asSequence$8a17064c705b2ef1() {
        return SequencesKt.flatMap(this.unrollToFlat(), F64Array::asSequence$lambda$58);
    }

    @NotNull
    public F64Array clone$8a17064c705b2ef1() {
        return new F64Array((double[])this.data.clone(), this.offset, (int[])this.strides.clone(), (int[])this.shape.clone(), this.unrollDim, this.unrollStride, this.unrollSize);
    }

    @NotNull
    public Object toArray() {
        return this.toGenericArray();
    }

    @NotNull
    public Object[] toGenericArray() {
        int n = 0;
        int n2 = this.length;
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = F64Array.view$default(this, n3, 0, 2, null).toArray();
        }
        return objectArray;
    }

    @NotNull
    public double[] toDoubleArray() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String toString(int maxDisplay, @NotNull DecimalFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (maxDisplay < this.length) {
            int r = 0;
            int n = maxDisplay / 2;
            while (r < n) {
                int[] nArray = new int[]{r++};
                sb.append(this.getV().get(nArray).toString(maxDisplay, format)).append(", ");
            }
            sb.append("..., ");
            int leftover = maxDisplay - maxDisplay / 2;
            int n2 = this.length;
            for (int r2 = this.length - leftover; r2 < n2; ++r2) {
                int[] nArray = new int[]{r2};
                sb.append(this.getV().get(nArray).toString(maxDisplay, format));
                if (r2 >= this.length - 1) continue;
                sb.append(", ");
            }
        } else {
            int n = this.length;
            for (int r = 0; r < n; ++r) {
                int[] nArray = new int[]{r};
                sb.append(this.getV().get(nArray).toString(maxDisplay, format));
                if (r >= this.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toString$default(F64Array f64Array, int n, DecimalFormat decimalFormat, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toString");
        }
        if ((n2 & 2) != 0) {
            decimalFormat = new DecimalFormat("#.####");
        }
        return f64Array.toString(n, decimalFormat);
    }

    @NotNull
    public String toString() {
        return F64Array.toString$default(this, 8, null, 2, null);
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        block9: {
            if (this == other) {
                bl = true;
            } else if (!(other instanceof F64Array)) {
                bl = false;
            } else if (!Arrays.equals(this.shape, ((F64Array)other).shape)) {
                bl = false;
            } else {
                Iterable $this$all$iv = (Iterable)RangesKt.until((int)0, (int)this.length);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)F64Array.view$default(this, it, 0, 2, null), (Object)F64Array.view$default((F64Array)other, it, 0, 2, null))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $this$fold$iv;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.length);
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            void r;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator).nextInt();
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31 * acc + F64Array.view$default(this, (int)r, 0, 2, null).hashCode();
        }
        return accumulator$iv;
    }

    private static final F64Array along$lambda$7(F64Array this$0, int $axis, int it) {
        return this$0.view(it, $axis);
    }

    private static final Sequence unrollToFlat$lambda$10(F64Array it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.unrollToFlat();
    }

    private static final F64Array unrollOnce$lambda$13(F64Array this$0, int $currentUnrollStride, int[] $newStrides, int[] $newShape, int i) {
        return Companion.create$8a17064c705b2ef1(this$0.data, this$0.offset + $currentUnrollStride * i, $newStrides, $newShape);
    }

    private static final Viewer V_delegate$lambda$14(F64Array this$0) {
        return new Viewer(this$0);
    }

    private static final Unit copyTo$lambda$15(F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.copyTo(b);
        return Unit.INSTANCE;
    }

    private static final double max$lambda$29(F64FlatArray it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.max();
    }

    private static final double min$lambda$30(F64FlatArray it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.min();
    }

    private static final Unit combineInPlace$lambda$35(Function2 $op, F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.combineInPlace(b, (Function2<? super Double, ? super Double, Double>)$op);
        return Unit.INSTANCE;
    }

    private static final double logSumExp$lambda$37(F64FlatArray it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.logSumExp();
    }

    private static final Unit logAddExpAssign$lambda$38(F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.logAddExpAssign(b);
        return Unit.INSTANCE;
    }

    private static final double unaryMinus$lambda$40(double it) {
        return -it;
    }

    private static final Unit plusAssign$lambda$41(F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.plusAssign(b);
        return Unit.INSTANCE;
    }

    private static final double plusAssign$lambda$43(double $update, double it) {
        return it + $update;
    }

    private static final double plus$lambda$44(double $update, double it) {
        return it + $update;
    }

    private static final Unit minusAssign$lambda$45(F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.minusAssign(b);
        return Unit.INSTANCE;
    }

    private static final double minusAssign$lambda$47(double $update, double it) {
        return it - $update;
    }

    private static final double minus$lambda$48(double $update, double it) {
        return it - $update;
    }

    private static final Unit timesAssign$lambda$49(F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.timesAssign(b);
        return Unit.INSTANCE;
    }

    private static final double timesAssign$lambda$51(double $update, double it) {
        return it * $update;
    }

    private static final double times$lambda$52(double $update, double it) {
        return it * $update;
    }

    private static final Unit divAssign$lambda$53(F64FlatArray a, F64FlatArray b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        a.divAssign(b);
        return Unit.INSTANCE;
    }

    private static final double divAssign$lambda$55(double $update, double it) {
        return it / $update;
    }

    private static final double div$lambda$56(double $update, double it) {
        return it / $update;
    }

    private static final Sequence asSequence$lambda$58(F64FlatArray it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.asSequence$8a17064c705b2ef1();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00020\u0007\"\u00020\bH\u0086\u0002J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bH\u0086\n\u00f8\u0001\u0000J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000fH\u0086\n\u00f8\u0001\u0000JD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0011H\u0086\n\u00f8\u0001\u0000J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u00020\u0016\"\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\fJ\u001a\u0010\u0017\u001a\u00020\u00052\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b2\u0006\u0010\u0018\u001a\u00020\fJ1\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001a\"\u00020\u00052\b\b\u0002\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Lorg/jetbrains/bio/viktor/F64Array$Companion;", "", "<init>", "()V", "invoke", "Lorg/jetbrains/bio/viktor/F64Array;", "shape", "", "", "size", "block", "Lkotlin/Function1;", "", "numRows", "numColumns", "Lkotlin/Function2;", "depth", "Lkotlin/Function3;", "of", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "first", "rest", "", "full", "init", "concatenate", "", "axis", "(Lorg/jetbrains/bio/viktor/F64Array;[Lorg/jetbrains/bio/viktor/F64Array;I)Lorg/jetbrains/bio/viktor/F64Array;", "create", "data", "offset", "strides", "create$8a17064c705b2ef1", "calculateUnroll", "Lorg/jetbrains/bio/viktor/F64Array$Companion$Unroll;", "Unroll", "8a17064c705b2ef1"})
    @SourceDebugExtension(value={"SMAP\nF64Array.kt\nKotlin\n*S Kotlin\n*F\n+ 1 F64Array.kt\norg/jetbrains/bio/viktor/F64Array$Companion\n+ 2 Internals.kt\norg/jetbrains/bio/viktor/InternalsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1239:1\n4#2:1240\n4#2:1245\n12925#3,3:1241\n12925#3,3:1246\n1#4:1244\n*S KotlinDebug\n*F\n+ 1 F64Array.kt\norg/jetbrains/bio/viktor/F64Array$Companion\n*L\n1009#1:1240\n1149#1:1245\n1009#1:1241,3\n1149#1:1246,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array invoke(int ... shape) {
            void $this$fold$iv$iv;
            void $this$product$iv;
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            int[] nArray = shape;
            F64FlatArray.Companion companion = F64FlatArray.Companion;
            boolean $i$f$product = false;
            void var4_5 = $this$product$iv;
            int initial$iv$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv$iv = initial$iv$iv;
            int n = ((void)$this$fold$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p1$iv;
                void element$iv$iv;
                void var11_12 = element$iv$iv = $this$fold$iv$iv[i];
                int p0$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = p0$iv * p1$iv;
            }
            int n2 = accumulator$iv$iv;
            return F64FlatArray.Companion.create$8a17064c705b2ef1$default(companion, new double[n2], 0, 0, 0, 14, null).reshape(Arrays.copyOf(shape, shape.length));
        }

        @NotNull
        public final F64Array invoke(int size, @NotNull Function1<? super Integer, Double> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Object object = new int[]{size};
            int[] $this$invoke_u24lambda_u240 = object = (Object)this.invoke((int)object);
            boolean bl = false;
            for (int i = 0; i < size; ++i) {
                $this$invoke_u24lambda_u240.set(i, ((Number)block.invoke((Object)i)).doubleValue());
            }
            return object;
        }

        @NotNull
        public final F64Array invoke(int numRows, int numColumns, @NotNull Function2<? super Integer, ? super Integer, Double> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Object object = new int[]{numRows, numColumns};
            int[] $this$invoke_u24lambda_u241 = object = (Object)this.invoke((int)object);
            boolean bl = false;
            for (int r = 0; r < numRows; ++r) {
                for (int c = 0; c < numColumns; ++c) {
                    $this$invoke_u24lambda_u241.set(r, c, ((Number)block.invoke((Object)r, (Object)c)).doubleValue());
                }
            }
            return object;
        }

        @NotNull
        public final F64Array invoke(int depth, int numRows, int numColumns, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Double> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Object object = new int[]{depth, numRows, numColumns};
            int[] $this$invoke_u24lambda_u242 = object = (Object)this.invoke((int)object);
            boolean bl = false;
            for (int d = 0; d < depth; ++d) {
                for (int r = 0; r < numRows; ++r) {
                    for (int c = 0; c < numColumns; ++c) {
                        $this$invoke_u24lambda_u242.set(d, r, c, ((Number)block.invoke((Object)d, (Object)r, (Object)c)).doubleValue());
                    }
                }
            }
            return object;
        }

        @NotNull
        public final F64FlatArray of(double first, double ... rest) {
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            double[] data = new double[rest.length + 1];
            data[0] = first;
            System.arraycopy(rest, 0, data, 1, rest.length);
            return F64ArrayKt.asF64Array(data);
        }

        @NotNull
        public final F64Array full(int size, double init) {
            Object object = new int[]{size};
            int[] $this$full_u24lambda_u243 = object = (Object)this.invoke((int)object);
            boolean bl = false;
            $this$full_u24lambda_u243.fill(init);
            return object;
        }

        @NotNull
        public final F64Array full(@NotNull int[] shape, double init) {
            F64Array f64Array;
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            F64Array $this$full_u24lambda_u244 = f64Array = this.invoke(Arrays.copyOf(shape, shape.length));
            boolean bl = false;
            $this$full_u24lambda_u244.fill(init);
            return f64Array;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array concatenate(@NotNull F64Array first, @NotNull F64Array[] rest, int axis) {
            int n;
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            int n2 = ((F64Array[])rest).length;
            for (int i = 0; i < n2; ++i) {
                F64Array other = rest[i];
                if (Arrays.equals(InternalsKt.remove(other.getShape(), axis), InternalsKt.remove(first.getShape(), axis))) continue;
                boolean bl = false;
                String string = "input array shapes must be exactly equal for all dimensions except " + axis;
                throw new IllegalArgumentException(string.toString());
            }
            Object object = first.getShape().clone();
            int[] $this$concatenate_u24lambda_u247 = (int[])object;
            boolean bl = false;
            SpreadBuilder spreadBuilder = rest;
            int n3 = first.getShape()[axis];
            int n4 = axis;
            int[] nArray = $this$concatenate_u24lambda_u247;
            int n5 = 0;
            int n6 = ((F64Array[])spreadBuilder).length;
            for (int i = 0; i < n6; ++i) {
                void it;
                F64Array f64Array;
                F64Array f64Array2 = f64Array = spreadBuilder[i];
                n = n5;
                boolean bl2 = false;
                int n7 = it.getShape()[axis];
                n5 = n + n7;
            }
            n = n5;
            nArray[n4] = n3 + n;
            int[] shape = (int[])object;
            F64Array result = this.invoke(Arrays.copyOf(shape, shape.length));
            int offset = 0;
            spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)first);
            spreadBuilder.addSpread((Object)rest);
            for (F64Array a : (F64Array[])spreadBuilder.toArray((Object[])new F64Array[spreadBuilder.size()])) {
                if (a.getLength() <= 0) continue;
                a.copyTo(F64Array.slice$default(result, offset, offset + a.getShape()[axis], 0, axis, 4, null));
                offset += a.getShape()[axis];
            }
            return result;
        }

        public static /* synthetic */ F64Array concatenate$default(Companion companion, F64Array f64Array, F64Array[] f64ArrayArray, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.concatenate(f64Array, f64ArrayArray, n);
        }

        @NotNull
        public final F64Array create$8a17064c705b2ef1(@NotNull double[] data, int offset, @NotNull int[] strides, @NotNull int[] shape) {
            F64Array f64Array;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            if (!(strides.length == shape.length)) {
                boolean $i$a$-require-F64Array$Companion$create$32 = false;
                String $i$a$-require-F64Array$Companion$create$32 = "strides and shape size don't match";
                throw new IllegalArgumentException($i$a$-require-F64Array$Companion$create$32.toString());
            }
            if (!(!(strides.length == 0))) {
                boolean $i$a$-require-F64Array$Companion$create$42 = false;
                String $i$a$-require-F64Array$Companion$create$42 = "singleton arrays are not supported";
                throw new IllegalArgumentException($i$a$-require-F64Array$Companion$create$42.toString());
            }
            if (shape.length == 1) {
                f64Array = F64FlatArray.Companion.create$8a17064c705b2ef1(data, offset, ArraysKt.single((int[])strides), ArraysKt.single((int[])shape));
            } else {
                Unroll unroll = this.calculateUnroll(strides, shape);
                int unrollDim = unroll.component1();
                int unrollStride = unroll.component2();
                int unrollSize = unroll.component3();
                f64Array = new F64Array(data, offset, strides, shape, unrollDim, unrollStride, unrollSize);
            }
            return f64Array;
        }

        /*
         * WARNING - void declaration
         */
        private final Unroll calculateUnroll(int[] strides, int[] shape) {
            int n;
            void $this$fold$iv$iv;
            void $this$product$iv;
            int prevStride = 0;
            boolean unrollable = true;
            int d = 0;
            int s = 0;
            int n2 = strides.length;
            for (int i = 0; i < n2; ++i) {
                if (shape[i] == 1) {
                    if (!unrollable) continue;
                    d = i + 1;
                    continue;
                }
                if (unrollable && (prevStride == 0 || prevStride == strides[i] * shape[i])) {
                    d = i + 1;
                    s = strides[i];
                } else {
                    unrollable = false;
                }
                prevStride = strides[i];
            }
            int[] i = CollectionsKt.toIntArray((Collection)ArraysKt.slice((int[])shape, (IntRange)RangesKt.until((int)0, (int)d)));
            int n3 = s;
            int n4 = d;
            boolean $i$f$product = false;
            void var9_12 = $this$product$iv;
            int initial$iv$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv$iv = initial$iv$iv;
            int n5 = ((void)$this$fold$iv$iv).length;
            for (int j = 0; j < n5; ++j) {
                void p1$iv;
                void element$iv$iv;
                void var16_19 = element$iv$iv = $this$fold$iv$iv[j];
                int p0$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = p0$iv * p1$iv;
            }
            int n6 = n = accumulator$iv$iv;
            int n7 = n3;
            int n8 = n4;
            return new Unroll(n8, n7, n6);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/bio/viktor/F64Array$Companion$Unroll;", "", "dim", "", "stride", "size", "<init>", "(III)V", "getDim", "()I", "getStride", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "8a17064c705b2ef1"})
        private static final class Unroll {
            private final int dim;
            private final int stride;
            private final int size;

            public Unroll(int dim, int stride, int size) {
                this.dim = dim;
                this.stride = stride;
                this.size = size;
            }

            public final int getDim() {
                return this.dim;
            }

            public final int getStride() {
                return this.stride;
            }

            public final int getSize() {
                return this.size;
            }

            public final int component1() {
                return this.dim;
            }

            public final int component2() {
                return this.stride;
            }

            public final int component3() {
                return this.size;
            }

            @NotNull
            public final Unroll copy(int dim, int stride, int size) {
                return new Unroll(dim, stride, size);
            }

            public static /* synthetic */ Unroll copy$default(Unroll unroll, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = unroll.dim;
                }
                if ((n4 & 2) != 0) {
                    n2 = unroll.stride;
                }
                if ((n4 & 4) != 0) {
                    n3 = unroll.size;
                }
                return unroll.copy(n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "Unroll(dim=" + this.dim + ", stride=" + this.stride + ", size=" + this.size + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.dim);
                result = result * 31 + Integer.hashCode(this.stride);
                result = result * 31 + Integer.hashCode(this.size);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unroll)) {
                    return false;
                }
                Unroll unroll = (Unroll)other;
                if (this.dim != unroll.dim) {
                    return false;
                }
                if (this.stride != unroll.stride) {
                    return false;
                }
                return this.size == unroll.size;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00032\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0086\u0002J\u001d\u0010\n\u001a\u00020\u000b2\n\u0010\u0007\u001a\u00020\b\"\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\u001d\u0010\n\u001a\u00020\u000b2\n\u0010\u0007\u001a\u00020\b\"\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000eH\u0086\u0002J\u0019\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0086\u0002J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/bio/viktor/F64Array$Viewer;", "", "a", "Lorg/jetbrains/bio/viktor/F64Array;", "<init>", "(Lorg/jetbrains/bio/viktor/F64Array;)V", "get", "indices", "", "", "set", "", "other", "init", "", "any", "Lorg/jetbrains/bio/viktor/_I;", "c", "8a17064c705b2ef1"})
    @SourceDebugExtension(value={"SMAP\nF64Array.kt\nKotlin\n*S Kotlin\n*F\n+ 1 F64Array.kt\norg/jetbrains/bio/viktor/F64Array$Viewer\n+ 2 F64Array.kt\norg/jetbrains/bio/viktor/F64Array\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1239:1\n195#2:1240\n196#2:1242\n195#2:1246\n196#2:1248\n195#2:1252\n196#2:1254\n1#3:1241\n1#3:1247\n1#3:1253\n12925#4,3:1243\n12925#4,3:1249\n12925#4,3:1255\n*S KotlinDebug\n*F\n+ 1 F64Array.kt\norg/jetbrains/bio/viktor/F64Array$Viewer\n*L\n298#1:1240\n298#1:1242\n311#1:1246\n311#1:1248\n325#1:1252\n325#1:1254\n298#1:1241\n311#1:1247\n325#1:1253\n298#1:1243,3\n311#1:1249,3\n325#1:1255,3\n*E\n"})
    public static final class Viewer {
        @NotNull
        private final F64Array a;

        public Viewer(@NotNull F64Array a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            this.a = a;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final F64Array get(int ... indices) {
            void $this$fold$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            F64Array f64Array = this.a;
            int[] indices$iv = indices;
            boolean $i$f$view0 = false;
            if (!(indices$iv.length < this_$iv.getNDim())) {
                boolean $i$a$-require-F64Array$view0$1$iv22 = false;
                String $i$a$-require-F64Array$view0$1$iv22 = "too many indices";
                throw new IllegalArgumentException($i$a$-require-F64Array$view0$1$iv22.toString());
            }
            int[] nArray = indices$iv;
            void initial$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            F64Array accumulator$iv$iv = initial$iv$iv;
            int n = ((void)$this$fold$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void pos$iv;
                void element$iv$iv;
                void var12_14 = element$iv$iv = $this$fold$iv$iv[i];
                void m$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = F64Array.view$default((F64Array)m$iv, (int)pos$iv, 0, 2, null);
            }
            return accumulator$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull int[] indices, @NotNull F64Array other) {
            void $this$fold$iv$iv;
            void this_$iv;
            void indices$iv;
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            F64Array f64Array = this.a;
            int[] nArray = indices;
            F64Array f64Array2 = other;
            boolean $i$f$view0 = false;
            if (!(((void)indices$iv).length < this_$iv.getNDim())) {
                boolean $i$a$-require-F64Array$view0$1$iv22 = false;
                String $i$a$-require-F64Array$view0$1$iv22 = "too many indices";
                throw new IllegalArgumentException($i$a$-require-F64Array$view0$1$iv22.toString());
            }
            void var7_10 = indices$iv;
            void initial$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            F64Array accumulator$iv$iv = initial$iv$iv;
            int n = ((void)$this$fold$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void pos$iv;
                void element$iv$iv;
                void var13_16 = element$iv$iv = $this$fold$iv$iv[i];
                void m$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = F64Array.view$default((F64Array)m$iv, (int)pos$iv, 0, 2, null);
            }
            f64Array2.copyTo(accumulator$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull int[] indices, double init) {
            void $this$fold$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            F64Array f64Array = this.a;
            int[] indices$iv = indices;
            boolean $i$f$view0 = false;
            if (!(indices$iv.length < this_$iv.getNDim())) {
                boolean $i$a$-require-F64Array$view0$1$iv22 = false;
                String $i$a$-require-F64Array$view0$1$iv22 = "too many indices";
                throw new IllegalArgumentException($i$a$-require-F64Array$view0$1$iv22.toString());
            }
            int[] nArray = indices$iv;
            void initial$iv$iv = this_$iv;
            boolean $i$f$fold = false;
            F64Array accumulator$iv$iv = initial$iv$iv;
            int n = ((void)$this$fold$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void pos$iv;
                void element$iv$iv;
                void var14_15 = element$iv$iv = $this$fold$iv$iv[i];
                void m$iv = accumulator$iv$iv;
                boolean bl = false;
                accumulator$iv$iv = F64Array.view$default((F64Array)m$iv, (int)pos$iv, 0, 2, null);
            }
            accumulator$iv$iv.fill(init);
        }

        public final void set(@NotNull _I any, @NotNull F64Array other) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            other.copyTo(this.a);
        }

        public final void set(@NotNull _I any, double other) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            this.a.fill(other);
        }

        @NotNull
        public final F64Array get(@NotNull _I any, int c) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.a.view(c, 1);
        }

        public final void set(@NotNull _I any, int c, @NotNull F64Array other) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            other.copyTo(this.a.view(c, 1));
        }

        public final void set(@NotNull _I any, int c, double init) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            this.a.view(c, 1).fill(init);
        }
    }
}

