/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.viktor.F64Array;
import org.jetbrains.bio.viktor.F64DenseFlatArray;
import org.jetbrains.bio.viktor.F64FlatArray;
import org.jetbrains.bio.viktor.InternalsKt;
import org.jetbrains.bio.viktor.VectorApiSpeedups;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0011\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0004J5\u0010\u000f\u001a\u00020\u00102*\u0010\u0011\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/bio/viktor/F64LargeDenseArray;", "Lorg/jetbrains/bio/viktor/F64DenseFlatArray;", "data", "", "offset", "", "size", "<init>", "([DII)V", "sd", "", "sum", "dot", "other", "Lorg/jetbrains/bio/viktor/F64Array;", "nativeTransform", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "nativeOp", "Lkotlin/Function5;", "", "expInPlace", "exp", "expm1InPlace", "expm1", "logInPlace", "log", "log1pInPlace", "log1p", "logSumExp", "8a17064c705b2ef1"})
@SourceDebugExtension(value={"SMAP\nF64LargeDenseArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 F64LargeDenseArray.kt\norg/jetbrains/bio/viktor/F64LargeDenseArray\n*L\n1#1,93:1\n33#1,3:94\n33#1,3:97\n33#1,3:100\n33#1,3:103\n*S KotlinDebug\n*F\n+ 1 F64LargeDenseArray.kt\norg/jetbrains/bio/viktor/F64LargeDenseArray\n*L\n46#1:94,3\n58#1:97,3\n70#1:100,3\n82#1:103,3\n*E\n"})
public final class F64LargeDenseArray
extends F64DenseFlatArray {
    public F64LargeDenseArray(@NotNull double[] data, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data, offset, size, null);
    }

    @Override
    public double sd() {
        return VectorApiSpeedups.INSTANCE.unsafeSD(this.getData(), this.getOffset(), this.getLength());
    }

    @Override
    public double sum() {
        return VectorApiSpeedups.INSTANCE.unsafeSum(this.getData(), this.getOffset(), this.getLength());
    }

    @Override
    public double dot(@NotNull F64Array other) {
        double d;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ((InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) && other instanceof F64LargeDenseArray) {
            this.checkShape(other);
            d = VectorApiSpeedups.INSTANCE.unsafeDot(this.getData(), this.getOffset(), other.getData(), other.getOffset(), this.getLength());
        } else {
            d = super.dot(other);
        }
        return d;
    }

    private final F64FlatArray nativeTransform(Function5<? super double[], ? super Integer, ? super double[], ? super Integer, ? super Integer, Unit> nativeOp) {
        boolean $i$f$nativeTransform = false;
        double[] dst = new double[this.getLength()];
        nativeOp.invoke((Object)dst, (Object)0, (Object)this.getData(), (Object)this.getOffset(), (Object)this.getLength());
        return F64DenseFlatArray.Companion.create$8a17064c705b2ef1(dst, 0, this.getLength());
    }

    @Override
    public void expInPlace() {
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            VectorApiSpeedups.INSTANCE.unsafeExp(this.getData(), this.getOffset(), this.getData(), this.getOffset(), this.getLength());
        } else {
            super.expInPlace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public F64FlatArray exp() {
        F64FlatArray f64FlatArray;
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            void p4;
            void p3;
            void p2;
            void p1;
            void this_$iv;
            F64LargeDenseArray f64LargeDenseArray = this;
            VectorApiSpeedups vectorApiSpeedups = VectorApiSpeedups.INSTANCE;
            boolean $i$f$nativeTransform = false;
            double[] dst$iv = new double[this_$iv.getLength()];
            int n = this_$iv.getLength();
            int n2 = this_$iv.getOffset();
            double[] dArray = this_$iv.getData();
            boolean bl = false;
            double[] p0 = dst$iv;
            boolean bl2 = false;
            vectorApiSpeedups.unsafeExp(p0, (int)p1, (double[])p2, (int)p3, (int)p4);
            f64FlatArray = F64DenseFlatArray.Companion.create$8a17064c705b2ef1(dst$iv, 0, this_$iv.getLength());
        } else {
            f64FlatArray = super.exp();
        }
        return f64FlatArray;
    }

    @Override
    public void expm1InPlace() {
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            VectorApiSpeedups.INSTANCE.unsafeExpm1(this.getData(), this.getOffset(), this.getData(), this.getOffset(), this.getLength());
        } else {
            super.expm1InPlace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public F64FlatArray expm1() {
        F64FlatArray f64FlatArray;
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            void p4;
            void p3;
            void p2;
            void p1;
            void this_$iv;
            F64LargeDenseArray f64LargeDenseArray = this;
            VectorApiSpeedups vectorApiSpeedups = VectorApiSpeedups.INSTANCE;
            boolean $i$f$nativeTransform = false;
            double[] dst$iv = new double[this_$iv.getLength()];
            int n = this_$iv.getLength();
            int n2 = this_$iv.getOffset();
            double[] dArray = this_$iv.getData();
            boolean bl = false;
            double[] p0 = dst$iv;
            boolean bl2 = false;
            vectorApiSpeedups.unsafeExpm1(p0, (int)p1, (double[])p2, (int)p3, (int)p4);
            f64FlatArray = F64DenseFlatArray.Companion.create$8a17064c705b2ef1(dst$iv, 0, this_$iv.getLength());
        } else {
            f64FlatArray = super.expm1();
        }
        return f64FlatArray;
    }

    @Override
    public void logInPlace() {
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            VectorApiSpeedups.INSTANCE.unsafeLog(this.getData(), this.getOffset(), this.getData(), this.getOffset(), this.getLength());
        } else {
            super.logInPlace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public F64FlatArray log() {
        F64FlatArray f64FlatArray;
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            void p4;
            void p3;
            void p2;
            void p1;
            void this_$iv;
            F64LargeDenseArray f64LargeDenseArray = this;
            VectorApiSpeedups vectorApiSpeedups = VectorApiSpeedups.INSTANCE;
            boolean $i$f$nativeTransform = false;
            double[] dst$iv = new double[this_$iv.getLength()];
            int n = this_$iv.getLength();
            int n2 = this_$iv.getOffset();
            double[] dArray = this_$iv.getData();
            boolean bl = false;
            double[] p0 = dst$iv;
            boolean bl2 = false;
            vectorApiSpeedups.unsafeLog(p0, (int)p1, (double[])p2, (int)p3, (int)p4);
            f64FlatArray = F64DenseFlatArray.Companion.create$8a17064c705b2ef1(dst$iv, 0, this_$iv.getLength());
        } else {
            f64FlatArray = super.log();
        }
        return f64FlatArray;
    }

    @Override
    public void log1pInPlace() {
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            VectorApiSpeedups.INSTANCE.unsafeLog1p(this.getData(), this.getOffset(), this.getData(), this.getOffset(), this.getLength());
        } else {
            super.log1pInPlace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public F64FlatArray log1p() {
        F64FlatArray f64FlatArray;
        if (InternalsKt.forceVectorApi() || !InternalsKt.isAarch64()) {
            void p4;
            void p3;
            void p2;
            void p1;
            void this_$iv;
            F64LargeDenseArray f64LargeDenseArray = this;
            VectorApiSpeedups vectorApiSpeedups = VectorApiSpeedups.INSTANCE;
            boolean $i$f$nativeTransform = false;
            double[] dst$iv = new double[this_$iv.getLength()];
            int n = this_$iv.getLength();
            int n2 = this_$iv.getOffset();
            double[] dArray = this_$iv.getData();
            boolean bl = false;
            double[] p0 = dst$iv;
            boolean bl2 = false;
            vectorApiSpeedups.unsafeLog1p(p0, (int)p1, (double[])p2, (int)p3, (int)p4);
            f64FlatArray = F64DenseFlatArray.Companion.create$8a17064c705b2ef1(dst$iv, 0, this_$iv.getLength());
        } else {
            f64FlatArray = super.log1p();
        }
        return f64FlatArray;
    }

    @Override
    public double logSumExp() {
        return InternalsKt.forceVectorApi() || !InternalsKt.isAarch64() ? VectorApiSpeedups.INSTANCE.unsafeLogSumExp(this.getData(), this.getOffset(), this.getLength()) : super.logSumExp();
    }
}

