/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.viktor.F64FlatArray;
import org.jetbrains.bio.viktor.SortingKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0086\u0010\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/bio/viktor/QuickSelect;", "", "<init>", "()V", "select", "", "values", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "left", "", "right", "n", "randomGenerator", "Lorg/apache/commons/math3/random/RandomGenerator;", "8a17064c705b2ef1"})
public final class QuickSelect {
    @NotNull
    public static final QuickSelect INSTANCE = new QuickSelect();

    private QuickSelect() {
    }

    public final double select(@NotNull F64FlatArray values, int left, int right, int n, @NotNull RandomGenerator randomGenerator) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)randomGenerator, (String)"randomGenerator");
        QuickSelect quickSelect = this;
        while (true) {
            RandomGenerator randomGenerator2;
            int n2;
            int n3;
            int n4;
            F64FlatArray f64FlatArray;
            QuickSelect quickSelect2;
            if (left == right) {
                return values.get(left);
            }
            int split = left + randomGenerator.nextInt(right - left + 1);
            split = SortingKt.partition(values, split, left, right);
            if (split == n) break;
            if (split > n) {
                quickSelect2 = quickSelect;
                f64FlatArray = values;
                n4 = left;
                n3 = split - 1;
                n2 = n;
                randomGenerator2 = randomGenerator;
                quickSelect = quickSelect2;
                values = f64FlatArray;
                left = n4;
                right = n3;
                n = n2;
                randomGenerator = randomGenerator2;
                continue;
            }
            quickSelect2 = quickSelect;
            f64FlatArray = values;
            n4 = split + 1;
            n3 = right;
            n2 = n;
            randomGenerator2 = randomGenerator;
            quickSelect = quickSelect2;
            values = f64FlatArray;
            left = n4;
            right = n3;
            n = n2;
            randomGenerator = randomGenerator2;
        }
        return values.get(n);
    }
}

