/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ.\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ.\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ.\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ.\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/bio/viktor/VectorApiSpeedups;", "", "<init>", "()V", "unsafeExp", "", "dst", "", "dstOffset", "", "src", "srcOffset", "size", "unsafeExpm1", "unsafeLog", "unsafeLog1p", "unsafeSum", "", "unsafeSD", "unsafeDot", "src1", "src1Offset", "src2", "src2Offset", "unsafeLogSumExp", "8a17064c705b2ef1"})
public final class VectorApiSpeedups {
    @NotNull
    public static final VectorApiSpeedups INSTANCE = new VectorApiSpeedups();

    private VectorApiSpeedups() {
    }

    public final void unsafeExp(@NotNull double[] dst, int dstOffset, @NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        VectorApiSpeedups $this$unsafeExp_u24lambda_u240 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            v = v.lanewise(VectorOperators.EXP);
            v.intoArray(dst, dstOffset + i);
        }
        for (int i = upperBound; i < size; ++i) {
            dst[dstOffset + i] = Math.exp(src[srcOffset + i]);
        }
    }

    public final void unsafeExpm1(@NotNull double[] dst, int dstOffset, @NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        VectorApiSpeedups $this$unsafeExpm1_u24lambda_u241 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            v = v.lanewise(VectorOperators.EXPM1);
            v.intoArray(dst, dstOffset + i);
        }
        for (int i = upperBound; i < size; ++i) {
            dst[dstOffset + i] = Math.expm1(src[srcOffset + i]);
        }
    }

    public final void unsafeLog(@NotNull double[] dst, int dstOffset, @NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        VectorApiSpeedups $this$unsafeLog_u24lambda_u242 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            v = v.lanewise(VectorOperators.LOG);
            v.intoArray(dst, dstOffset + i);
        }
        for (int i = upperBound; i < size; ++i) {
            dst[dstOffset + i] = Math.log(src[srcOffset + i]);
        }
    }

    public final void unsafeLog1p(@NotNull double[] dst, int dstOffset, @NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        VectorApiSpeedups $this$unsafeLog1p_u24lambda_u243 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            v = v.lanewise(VectorOperators.LOG1P);
            v.intoArray(dst, dstOffset + i);
        }
        for (int i = upperBound; i < size; ++i) {
            dst[dstOffset + i] = Math.log1p(src[srcOffset + i]);
        }
    }

    public final double unsafeSum(@NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        DoubleVector sum = null;
        sum = DoubleVector.zero((VectorSpecies)species);
        VectorApiSpeedups $this$unsafeSum_u24lambda_u244 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            sum = sum.add((Vector)v);
        }
        double result = sum.reduceLanes(VectorOperators.ADD);
        for (int i = upperBound; i < size; ++i) {
            result += src[srcOffset + i];
        }
        return result;
    }

    public final double unsafeSD(@NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        DoubleVector sumVector = null;
        sumVector = DoubleVector.zero((VectorSpecies)species);
        DoubleVector sumSqVector = null;
        sumSqVector = DoubleVector.zero((VectorSpecies)species);
        VectorApiSpeedups $this$unsafeSD_u24lambda_u245 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            sumVector = sumVector.add((Vector)v);
            sumSqVector = sumSqVector.add((Vector)v.mul((Vector)v));
        }
        double sum = sumVector.reduceLanes(VectorOperators.ADD);
        double sumSq = sumSqVector.reduceLanes(VectorOperators.ADD);
        for (int i = upperBound; i < size; ++i) {
            double value = src[srcOffset + i];
            sum += value;
            sumSq += value * value;
        }
        return Math.sqrt((sumSq - sum * sum / (double)size) / (double)(size - 1));
    }

    public final double unsafeDot(@NotNull double[] src1, int src1Offset, @NotNull double[] src2, int src2Offset, int size) {
        Intrinsics.checkNotNullParameter((Object)src1, (String)"src1");
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src2");
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        DoubleVector resultVector = null;
        resultVector = DoubleVector.zero((VectorSpecies)species);
        VectorApiSpeedups $this$unsafeDot_u24lambda_u246 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v1 = DoubleVector.fromArray((VectorSpecies)species, (double[])src1, (int)(src1Offset + i));
            DoubleVector v2 = DoubleVector.fromArray((VectorSpecies)species, (double[])src2, (int)(src2Offset + i));
            resultVector = resultVector.add((Vector)v1.mul((Vector)v2));
        }
        double result = resultVector.reduceLanes(VectorOperators.ADD);
        for (int i = upperBound; i < size; ++i) {
            result += src1[src1Offset + i] * src2[src2Offset + i];
        }
        return result;
    }

    public final double unsafeLogSumExp(@NotNull double[] src, int srcOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            max = Math.max(max, src[srcOffset + i]);
        }
        VectorSpecies species = DoubleVector.SPECIES_PREFERRED;
        int upperBound = size - size % species.length();
        DoubleVector maxVector = DoubleVector.broadcast((VectorSpecies)species, (double)max);
        DoubleVector sumVector = null;
        sumVector = DoubleVector.zero((VectorSpecies)species);
        VectorApiSpeedups $this$unsafeLogSumExp_u24lambda_u247 = this;
        boolean bl = false;
        for (int i = 0; i < upperBound; i += species.length()) {
            DoubleVector v = DoubleVector.fromArray((VectorSpecies)species, (double[])src, (int)(srcOffset + i));
            DoubleVector expVector = v.sub((Vector)maxVector).lanewise(VectorOperators.EXP);
            sumVector = sumVector.add((Vector)expVector);
        }
        double sum = sumVector.reduceLanes(VectorOperators.ADD);
        for (int i = upperBound; i < size; ++i) {
            sum += Math.exp(src[srcOffset + i] - max);
        }
        return max + Math.log(sum);
    }
}

