/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.base.parsers.factories;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.links.DRI;
import org.jetbrains.dokka.model.doc.A;
import org.jetbrains.dokka.model.doc.B;
import org.jetbrains.dokka.model.doc.Big;
import org.jetbrains.dokka.model.doc.BlockQuote;
import org.jetbrains.dokka.model.doc.Br;
import org.jetbrains.dokka.model.doc.Cite;
import org.jetbrains.dokka.model.doc.Code;
import org.jetbrains.dokka.model.doc.CodeBlock;
import org.jetbrains.dokka.model.doc.CodeInline;
import org.jetbrains.dokka.model.doc.CustomDocTag;
import org.jetbrains.dokka.model.doc.Dd;
import org.jetbrains.dokka.model.doc.Dfn;
import org.jetbrains.dokka.model.doc.Dir;
import org.jetbrains.dokka.model.doc.Div;
import org.jetbrains.dokka.model.doc.Dl;
import org.jetbrains.dokka.model.doc.DocTag;
import org.jetbrains.dokka.model.doc.DocumentationLink;
import org.jetbrains.dokka.model.doc.Dt;
import org.jetbrains.dokka.model.doc.Em;
import org.jetbrains.dokka.model.doc.Font;
import org.jetbrains.dokka.model.doc.Footer;
import org.jetbrains.dokka.model.doc.Frame;
import org.jetbrains.dokka.model.doc.FrameSet;
import org.jetbrains.dokka.model.doc.H1;
import org.jetbrains.dokka.model.doc.H2;
import org.jetbrains.dokka.model.doc.H3;
import org.jetbrains.dokka.model.doc.H4;
import org.jetbrains.dokka.model.doc.H5;
import org.jetbrains.dokka.model.doc.H6;
import org.jetbrains.dokka.model.doc.Head;
import org.jetbrains.dokka.model.doc.Header;
import org.jetbrains.dokka.model.doc.HorizontalRule;
import org.jetbrains.dokka.model.doc.Html;
import org.jetbrains.dokka.model.doc.I;
import org.jetbrains.dokka.model.doc.IFrame;
import org.jetbrains.dokka.model.doc.Img;
import org.jetbrains.dokka.model.doc.Input;
import org.jetbrains.dokka.model.doc.Li;
import org.jetbrains.dokka.model.doc.Link;
import org.jetbrains.dokka.model.doc.Listing;
import org.jetbrains.dokka.model.doc.Main;
import org.jetbrains.dokka.model.doc.Menu;
import org.jetbrains.dokka.model.doc.Meta;
import org.jetbrains.dokka.model.doc.Nav;
import org.jetbrains.dokka.model.doc.NoFrames;
import org.jetbrains.dokka.model.doc.NoScript;
import org.jetbrains.dokka.model.doc.Ol;
import org.jetbrains.dokka.model.doc.P;
import org.jetbrains.dokka.model.doc.Pre;
import org.jetbrains.dokka.model.doc.Script;
import org.jetbrains.dokka.model.doc.Section;
import org.jetbrains.dokka.model.doc.Small;
import org.jetbrains.dokka.model.doc.Span;
import org.jetbrains.dokka.model.doc.Strong;
import org.jetbrains.dokka.model.doc.Sub;
import org.jetbrains.dokka.model.doc.Sup;
import org.jetbrains.dokka.model.doc.TBody;
import org.jetbrains.dokka.model.doc.TFoot;
import org.jetbrains.dokka.model.doc.THead;
import org.jetbrains.dokka.model.doc.Table;
import org.jetbrains.dokka.model.doc.Td;
import org.jetbrains.dokka.model.doc.Text;
import org.jetbrains.dokka.model.doc.Th;
import org.jetbrains.dokka.model.doc.Title;
import org.jetbrains.dokka.model.doc.Tr;
import org.jetbrains.dokka.model.doc.Tt;
import org.jetbrains.dokka.model.doc.U;
import org.jetbrains.dokka.model.doc.Ul;
import org.jetbrains.dokka.model.doc.Var;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/dokka/base/parsers/factories/DocTagsFromStringFactory;", "", "()V", "getInstance", "Lorg/jetbrains/dokka/model/doc/DocTag;", "name", "", "children", "", "params", "", "body", "dri", "Lorg/jetbrains/dokka/links/DRI;", "base"})
public final class DocTagsFromStringFactory {
    @NotNull
    public static final DocTagsFromStringFactory INSTANCE;

    @NotNull
    public final DocTag getInstance(@NotNull String name, @NotNull List<? extends DocTag> children, @NotNull Map<String, String> params, @Nullable String body, @Nullable DRI dri) {
        DocTag docTag;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        switch (name) {
            case "a": {
                docTag = (DocTag)new A(children, params);
                break;
            }
            case "big": {
                docTag = (DocTag)new Big(children, params);
                break;
            }
            case "b": {
                docTag = (DocTag)new B(children, params);
                break;
            }
            case "blockquote": {
                docTag = (DocTag)new BlockQuote(children, params);
                break;
            }
            case "br": {
                docTag = (DocTag)Br.INSTANCE;
                break;
            }
            case "cite": {
                docTag = (DocTag)new Cite(children, params);
                break;
            }
            case "code": {
                docTag = (DocTag)(params.isEmpty() ? (Code)new CodeInline(children, params) : (Code)new CodeBlock(children, params));
                break;
            }
            case "dd": {
                docTag = (DocTag)new Dd(children, params);
                break;
            }
            case "dfn": {
                docTag = (DocTag)new Dfn(children, params);
                break;
            }
            case "dir": {
                docTag = (DocTag)new Dir(children, params);
                break;
            }
            case "div": {
                docTag = (DocTag)new Div(children, params);
                break;
            }
            case "dl": {
                docTag = (DocTag)new Dl(children, params);
                break;
            }
            case "dt": {
                docTag = (DocTag)new Dt(children, params);
                break;
            }
            case "Em": {
                docTag = (DocTag)new Em(children, params);
                break;
            }
            case "font": {
                docTag = (DocTag)new Font(children, params);
                break;
            }
            case "footer": {
                docTag = (DocTag)new Footer(children, params);
                break;
            }
            case "frame": {
                docTag = (DocTag)new Frame(children, params);
                break;
            }
            case "frameset": {
                docTag = (DocTag)new FrameSet(children, params);
                break;
            }
            case "h1": {
                docTag = (DocTag)new H1(children, params);
                break;
            }
            case "h2": {
                docTag = (DocTag)new H2(children, params);
                break;
            }
            case "h3": {
                docTag = (DocTag)new H3(children, params);
                break;
            }
            case "h4": {
                docTag = (DocTag)new H4(children, params);
                break;
            }
            case "h5": {
                docTag = (DocTag)new H5(children, params);
                break;
            }
            case "h6": {
                docTag = (DocTag)new H6(children, params);
                break;
            }
            case "head": {
                docTag = (DocTag)new Head(children, params);
                break;
            }
            case "header": {
                docTag = (DocTag)new Header(children, params);
                break;
            }
            case "html": {
                docTag = (DocTag)new Html(children, params);
                break;
            }
            case "i": {
                docTag = (DocTag)new I(children, params);
                break;
            }
            case "iframe": {
                docTag = (DocTag)new IFrame(children, params);
                break;
            }
            case "img": {
                docTag = (DocTag)new Img(children, params);
                break;
            }
            case "input": {
                docTag = (DocTag)new Input(children, params);
                break;
            }
            case "li": {
                docTag = (DocTag)new Li(children, params);
                break;
            }
            case "link": {
                docTag = (DocTag)new Link(children, params);
                break;
            }
            case "listing": {
                docTag = (DocTag)new Listing(children, params);
                break;
            }
            case "main": {
                docTag = (DocTag)new Main(children, params);
                break;
            }
            case "menu": {
                docTag = (DocTag)new Menu(children, params);
                break;
            }
            case "meta": {
                docTag = (DocTag)new Meta(children, params);
                break;
            }
            case "nav": {
                docTag = (DocTag)new Nav(children, params);
                break;
            }
            case "noframes": {
                docTag = (DocTag)new NoFrames(children, params);
                break;
            }
            case "noscript": {
                docTag = (DocTag)new NoScript(children, params);
                break;
            }
            case "ol": {
                docTag = (DocTag)new Ol(children, params);
                break;
            }
            case "p": {
                docTag = (DocTag)new P(children, params);
                break;
            }
            case "pre": {
                docTag = (DocTag)new Pre(children, params);
                break;
            }
            case "script": {
                docTag = (DocTag)new Script(children, params);
                break;
            }
            case "section": {
                docTag = (DocTag)new Section(children, params);
                break;
            }
            case "small": {
                docTag = (DocTag)new Small(children, params);
                break;
            }
            case "span": {
                docTag = (DocTag)new Span(children, params);
                break;
            }
            case "strong": {
                docTag = (DocTag)new Strong(children, params);
                break;
            }
            case "sub": {
                docTag = (DocTag)new Sub(children, params);
                break;
            }
            case "sup": {
                docTag = (DocTag)new Sup(children, params);
                break;
            }
            case "table": {
                docTag = (DocTag)new Table(children, params);
                break;
            }
            case "#text": {
                String string = body;
                if (string == null) {
                    throw (Throwable)new NullPointerException("Text body should be at least empty string passed to DocNodes factory!");
                }
                docTag = (DocTag)new Text(string, children, params);
                break;
            }
            case "tBody": {
                docTag = (DocTag)new TBody(children, params);
                break;
            }
            case "td": {
                docTag = (DocTag)new Td(children, params);
                break;
            }
            case "tFoot": {
                docTag = (DocTag)new TFoot(children, params);
                break;
            }
            case "th": {
                docTag = (DocTag)new Th(children, params);
                break;
            }
            case "tHead": {
                docTag = (DocTag)new THead(children, params);
                break;
            }
            case "title": {
                docTag = (DocTag)new Title(children, params);
                break;
            }
            case "tr": {
                docTag = (DocTag)new Tr(children, params);
                break;
            }
            case "tt": {
                docTag = (DocTag)new Tt(children, params);
                break;
            }
            case "u": {
                docTag = (DocTag)new U(children, params);
                break;
            }
            case "ul": {
                docTag = (DocTag)new Ul(children, params);
                break;
            }
            case "var": {
                docTag = (DocTag)new Var(children, params);
                break;
            }
            case "documentationlink": {
                DRI dRI = dri;
                if (dRI == null) {
                    throw (Throwable)new NullPointerException("DRI cannot be passed null while constructing documentation link!");
                }
                docTag = (DocTag)new DocumentationLink(dRI, children, params);
                break;
            }
            case "hr": {
                docTag = (DocTag)HorizontalRule.INSTANCE;
                break;
            }
            default: {
                docTag = (DocTag)new CustomDocTag(children, params, name);
            }
        }
        return docTag;
    }

    public static /* synthetic */ DocTag getInstance$default(DocTagsFromStringFactory docTagsFromStringFactory, String string, List list, Map map2, String string2, DRI dRI, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            dRI = null;
        }
        return docTagsFromStringFactory.getInstance(string, list, map2, string2, dRI);
    }

    private DocTagsFromStringFactory() {
    }

    static {
        DocTagsFromStringFactory docTagsFromStringFactory;
        INSTANCE = docTagsFromStringFactory = new DocTagsFromStringFactory();
    }
}

