<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1" charset="UTF-8">
    <title>${pageName}</title>
    <@template_cmd name="pathToRoot">
    <link href="${pathToRoot}images/logo-icon.svg" rel="icon" type="image/svg">
    <script>var pathToRoot = "${pathToRoot}";</script>
    </@template_cmd>
    <#-- This script doesn't need to be there but it is nice to have
    since app in dark mode doesn't 'blink' (class is added before it is rendered) -->
    <script>const storage = localStorage.getItem("dokka-dark-mode")
const savedDarkMode = storage ? JSON.parse(storage) : false
if(savedDarkMode === true){
    document.getElementsByTagName("html")[0].classList.add("theme-dark")
}</script>
    <#-- Resources (scripts, stylesheets) are handled by Dokka.
    Use customStyleSheets and customAssets to change them. -->
    <@resources/>
</head>
<body>
<div class="navigation-wrapper" id="navigation-wrapper">
    <div id="leftToggler"><span class="icon-toggler"></span></div>
    <div class="library-name">
        <@template_cmd name="pathToRoot">
            <a href="${pathToRoot}index.html">
                <@template_cmd name="projectName">
                    <span>${projectName}</span>
                </@template_cmd>
            </a>
        </@template_cmd>
    </div>
    <div>
        <#-- This can be handled by a versioning plugin -->
        <@version/>
    </div>
    <div class="pull-right d-flex">
        <#if sourceSets??>
            <div class="filter-section" id="filter-section">
                <#list sourceSets as ss>
                    <button class="platform-tag platform-selector ${ss.platform}-like" data-active="" data-filter="${ss.filter}">${ss.name}</button>
                </#list>
            </div>
        </#if>
        <button id="theme-toggle-button"><span id="theme-toggle"></span></button>
        <div id="searchBar"></div>
    </div>
</div>
<div id="container">
    <div id="leftColumn">
        <div id="sideMenu"></div>
    </div>
    <div id="main">
        <@content/>
        <div class="footer"><span class="go-to-top-icon"><a href="#content" id="go-to-top-link"></a></span><span>${footerMessage}</span><span
                class="pull-right"><span>Generated by </span><a
                href="https://github.com/Kotlin/dokka"><span>dokka</span><span class="padded-icon"></span></a></span>
        </div>
    </div>
</div>
</body>
</html>