/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.PossiblyExternalAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnnotationMapper {
    private static final FqName JAVA_TARGET_FQ_NAME;
    private static final FqName JAVA_RETENTION_FQ_NAME;
    private static final FqName JAVA_DEPRECATED_FQ_NAME;
    private static final FqName JAVA_DOCUMENTED_FQ_NAME;
    private static final FqName JAVA_REPEATABLE_FQ_NAME;
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    private static final Name RETENTION_ANNOTATION_VALUE;
    private static final Map<FqName, FqName> kotlinToJavaNameMap;
    private static final Map<FqName, FqName> javaToKotlinNameMap;
    @NotNull
    public static final JavaAnnotationMapper INSTANCE;

    @NotNull
    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    @NotNull
    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    @NotNull
    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation, @NotNull LazyJavaResolverContext c) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        Intrinsics.checkNotNullParameter(c, "c");
        ClassId classId = annotation.getClassId();
        return (AnnotationDescriptor)(Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_TARGET_FQ_NAME)) ? (PossiblyExternalAnnotationDescriptor)new JavaTargetAnnotationDescriptor(annotation, c) : (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_RETENTION_FQ_NAME)) ? (PossiblyExternalAnnotationDescriptor)new JavaRetentionAnnotationDescriptor(annotation, c) : (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_REPEATABLE_FQ_NAME)) ? (PossiblyExternalAnnotationDescriptor)new JavaAnnotationDescriptor(c, annotation, StandardNames.FqNames.repeatable) : (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_DOCUMENTED_FQ_NAME)) ? (PossiblyExternalAnnotationDescriptor)new JavaAnnotationDescriptor(c, annotation, StandardNames.FqNames.mustBeDocumented) : (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_DEPRECATED_FQ_NAME)) ? null : (PossiblyExternalAnnotationDescriptor)new LazyJavaAnnotationDescriptor(c, annotation))))));
    }

    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        JavaAnnotation javaAnnotation;
        Intrinsics.checkNotNullParameter(kotlinName, "kotlinName");
        Intrinsics.checkNotNullParameter(annotationOwner, "annotationOwner");
        Intrinsics.checkNotNullParameter(c, "c");
        if (Intrinsics.areEqual(kotlinName, StandardNames.FqNames.deprecated) && ((javaAnnotation = annotationOwner.findAnnotation(JAVA_DEPRECATED_FQ_NAME)) != null || annotationOwner.isDeprecatedInJavaDoc())) {
            return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c);
        }
        FqName fqName2 = kotlinToJavaNameMap.get(kotlinName);
        if (fqName2 != null) {
            FqName fqName3 = fqName2;
            boolean bl = false;
            boolean bl2 = false;
            FqName javaName = fqName3;
            boolean bl3 = false;
            JavaAnnotation javaAnnotation2 = annotationOwner.findAnnotation(javaName);
            if (javaAnnotation2 != null) {
                JavaAnnotation javaAnnotation3 = javaAnnotation2;
                boolean bl4 = false;
                boolean bl5 = false;
                JavaAnnotation annotation = javaAnnotation3;
                boolean bl6 = false;
                annotationDescriptor = INSTANCE.mapOrResolveJavaAnnotation(annotation, c);
            } else {
                annotationDescriptor = null;
            }
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    private JavaAnnotationMapper() {
    }

    static {
        JavaAnnotationMapper javaAnnotationMapper;
        INSTANCE = javaAnnotationMapper = new JavaAnnotationMapper();
        JAVA_TARGET_FQ_NAME = new FqName(Target.class.getCanonicalName());
        JAVA_RETENTION_FQ_NAME = new FqName(Retention.class.getCanonicalName());
        JAVA_DEPRECATED_FQ_NAME = new FqName(Deprecated.class.getCanonicalName());
        JAVA_DOCUMENTED_FQ_NAME = new FqName(Documented.class.getCanonicalName());
        JAVA_REPEATABLE_FQ_NAME = new FqName("java.lang.annotation.Repeatable");
        Name name2 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(name2, "Name.identifier(\"message\")");
        DEPRECATED_ANNOTATION_MESSAGE = name2;
        Name name3 = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue(name3, "Name.identifier(\"allowedTargets\")");
        TARGET_ANNOTATION_ALLOWED_TARGETS = name3;
        Name name4 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue(name4, "Name.identifier(\"value\")");
        RETENTION_ANNOTATION_VALUE = name4;
        kotlinToJavaNameMap = MapsKt.mapOf(TuplesKt.to(StandardNames.FqNames.target, JAVA_TARGET_FQ_NAME), TuplesKt.to(StandardNames.FqNames.retention, JAVA_RETENTION_FQ_NAME), TuplesKt.to(StandardNames.FqNames.repeatable, JAVA_REPEATABLE_FQ_NAME), TuplesKt.to(StandardNames.FqNames.mustBeDocumented, JAVA_DOCUMENTED_FQ_NAME));
        javaToKotlinNameMap = MapsKt.mapOf(TuplesKt.to(JAVA_TARGET_FQ_NAME, StandardNames.FqNames.target), TuplesKt.to(JAVA_RETENTION_FQ_NAME, StandardNames.FqNames.retention), TuplesKt.to(JAVA_DEPRECATED_FQ_NAME, StandardNames.FqNames.deprecated), TuplesKt.to(JAVA_REPEATABLE_FQ_NAME, StandardNames.FqNames.repeatable), TuplesKt.to(JAVA_DOCUMENTED_FQ_NAME, StandardNames.FqNames.mustBeDocumented));
    }
}

