/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.commonmark;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.html.CodeFenceGeneratingProvider;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlBlockGeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.ImageGeneratingProvider;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.ListItemGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.lexer._MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "()V", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "3ce148cfd89a773"})
public class CommonMarkFlavourDescriptor
implements MarkdownFlavourDescriptor {
    @NotNull
    private final MarkerProcessorFactory markerProcessorFactory = CommonMarkMarkerProcessor.Factory.INSTANCE;
    @NotNull
    private final SequentialParserManager sequentialParserManager = new SequentialParserManager(){

        @NotNull
        public List<SequentialParser> getParserSequence() {
            return CollectionsKt.listOf(new AutolinkParser(CollectionsKt.listOf(MarkdownTokenTypes.AUTOLINK)), new BacktickParser(), new ImageParser(), new InlineLinkParser(), new ReferenceLinkParser(), new EmphStrongParser());
        }
    };

    @Override
    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _MarkdownLexer(null));
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkParameterIsNotNull(linkMap, "linkMap");
        return MapsKt.hashMapOf(TuplesKt.to(MarkdownElementTypes.MARKDOWN_FILE, new SimpleTagProvider("body")), TuplesKt.to(MarkdownElementTypes.HTML_BLOCK, new HtmlBlockGeneratingProvider()), TuplesKt.to(MarkdownTokenTypes.HTML_TAG, new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                visitor2.consumeHtml(ASTUtilKt.getTextInNode(node, text));
            }
        }), TuplesKt.to(MarkdownElementTypes.BLOCK_QUOTE, new SimpleTagProvider("blockquote")), TuplesKt.to(MarkdownElementTypes.ORDERED_LIST, new SimpleTagProvider("ol"){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                String attribute = null;
                Object object = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.LIST_ITEM);
                if (object != null && (object = ASTUtilKt.findChildOfType((ASTNode)object, MarkdownTokenTypes.LIST_NUMBER)) != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, text)) != null && (object = object.toString()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    object = ((Object)StringsKt.trim((CharSequence)object3)).toString();
                    if (object != null) {
                        object2 = object;
                        bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        Object object4 = it;
                        int n = 0;
                        int n2 = ((String)it).length() - 1;
                        boolean bl4 = false;
                        Object object5 = object4;
                        if (object5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)object5).substring(n, n2);
                        Intrinsics.checkExpressionValueIsNotNull(string, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String number = StringsKt.trimStart(string, '0');
                        if (!number.equals("1")) {
                            object4 = number;
                            StringBuilder stringBuilder = new StringBuilder().append("start=\"");
                            n = 0;
                            boolean bl5 = object4.length() == 0;
                            attribute = stringBuilder.append(bl5 ? "0" : number).append('\"').toString();
                        }
                    }
                }
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "ol", new CharSequence[]{attribute}, false, 8, null);
            }
        }), TuplesKt.to(MarkdownElementTypes.UNORDERED_LIST, new SimpleTagProvider("ul")), TuplesKt.to(MarkdownElementTypes.LIST_ITEM, new ListItemGeneratingProvider()), TuplesKt.to(MarkdownTokenTypes.SETEXT_CONTENT, new TrimmingInlineHolderProvider()), TuplesKt.to(MarkdownElementTypes.SETEXT_1, new SimpleTagProvider("h1")), TuplesKt.to(MarkdownElementTypes.SETEXT_2, new SimpleTagProvider("h2")), TuplesKt.to(MarkdownTokenTypes.ATX_CONTENT, new TrimmingInlineHolderProvider()), TuplesKt.to(MarkdownElementTypes.ATX_1, new SimpleTagProvider("h1")), TuplesKt.to(MarkdownElementTypes.ATX_2, new SimpleTagProvider("h2")), TuplesKt.to(MarkdownElementTypes.ATX_3, new SimpleTagProvider("h3")), TuplesKt.to(MarkdownElementTypes.ATX_4, new SimpleTagProvider("h4")), TuplesKt.to(MarkdownElementTypes.ATX_5, new SimpleTagProvider("h5")), TuplesKt.to(MarkdownElementTypes.ATX_6, new SimpleTagProvider("h6")), TuplesKt.to(MarkdownElementTypes.AUTOLINK, new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                CharSequence linkText = ASTUtilKt.getTextInNode(node, text);
                String link = EntityConverter.INSTANCE.replaceEntities(linkText.subSequence(1, linkText.length() - 1), true, false);
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "a", new CharSequence[]{"href=\"" + LinkMap.Builder.normalizeDestination(linkText, false) + '\"'}, false, 8, null);
                visitor2.consumeHtml(link);
                visitor2.consumeTagClose("a");
            }
        }), TuplesKt.to(MarkdownElementTypes.LINK_LABEL, new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to(MarkdownElementTypes.LINK_TEXT, new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to(MarkdownElementTypes.LINK_TITLE, new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to(MarkdownElementTypes.INLINE_LINK, new InlineLinkGeneratingProvider(baseURI)), TuplesKt.to(MarkdownElementTypes.FULL_REFERENCE_LINK, new ReferenceLinksGeneratingProvider(linkMap, baseURI)), TuplesKt.to(MarkdownElementTypes.SHORT_REFERENCE_LINK, new ReferenceLinksGeneratingProvider(linkMap, baseURI)), TuplesKt.to(MarkdownElementTypes.IMAGE, new ImageGeneratingProvider(linkMap, baseURI)), TuplesKt.to(MarkdownElementTypes.LINK_DEFINITION, new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
            }
        }), TuplesKt.to(MarkdownElementTypes.CODE_FENCE, new CodeFenceGeneratingProvider()), TuplesKt.to(MarkdownElementTypes.CODE_BLOCK, new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                visitor2.consumeHtml("<pre>");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "code", new CharSequence[0], false, 8, null);
                for (ASTNode child : node.getChildren()) {
                    if (Intrinsics.areEqual(child.getType(), MarkdownTokenTypes.CODE_LINE)) {
                        visitor2.consumeHtml(HtmlGenerator.Companion.trimIndents(HtmlGenerator.Companion.leafText(text, child, false), 4));
                        continue;
                    }
                    if (!Intrinsics.areEqual(child.getType(), MarkdownTokenTypes.EOL)) continue;
                    visitor2.consumeHtml("\n");
                }
                visitor2.consumeHtml("\n");
                visitor2.consumeTagClose("code");
                visitor2.consumeHtml("</pre>");
            }
        }), TuplesKt.to(MarkdownTokenTypes.HORIZONTAL_RULE, new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                visitor2.consumeHtml("<hr />");
            }
        }), TuplesKt.to(MarkdownTokenTypes.HARD_LINE_BREAK, new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                visitor2.consumeHtml("<br />");
            }
        }), TuplesKt.to(MarkdownElementTypes.PARAGRAPH, new TrimmingInlineHolderProvider(){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "p", new CharSequence[0], false, 8, null);
            }

            public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                visitor2.consumeTagClose("p");
            }
        }), TuplesKt.to(MarkdownElementTypes.EMPH, new SimpleInlineTagProvider("em", 1, -1)), TuplesKt.to(MarkdownElementTypes.STRONG, new SimpleInlineTagProvider("strong", 2, -2)), TuplesKt.to(MarkdownElementTypes.CODE_SPAN, new GeneratingProvider(){

            /*
             * WARNING - void declaration
             */
            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
                Intrinsics.checkParameterIsNotNull(text, "text");
                Intrinsics.checkParameterIsNotNull(node, "node");
                Iterable $this$map$iv = node.getChildren().subList(1, node.getChildren().size() - 1);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void node2;
                    ASTNode aSTNode = (ASTNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    CharSequence charSequence = HtmlGenerator.Companion.leafText(text, (ASTNode)node2, false);
                    collection.add(charSequence);
                }
                String string = CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String output = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "code", new CharSequence[0], false, 8, null);
                visitor2.consumeHtml(output);
                visitor2.consumeTagClose("code");
            }
        }));
    }
}

