/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/InlineLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Companion", "3ce148cfd89a773"})
public final class InlineLinkParser
implements SequentialParser {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull(tokens, "tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, "rangesToGlue");
        SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator2.getType() != null) {
            LocalParsingResult inlineLink;
            if (Intrinsics.areEqual(iterator2.getType(), MarkdownTokenTypes.LBRACKET) && (inlineLink = Companion.parseInlineLink(iterator2)) != null) {
                iterator2 = inlineLink.getIteratorPosition().advance();
                result2 = result2.withOtherParsingResult(inlineLink);
                continue;
            }
            delegateIndices.put(iterator2.getIndex());
            iterator2 = iterator2.advance();
        }
        return result2.withFurtherProcessing(delegateIndices.get());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/InlineLinkParser$Companion;", "", "()V", "parseInlineLink", "Lorg/intellij/markdown/parser/sequentialparsers/LocalParsingResult;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "3ce148cfd89a773"})
    public static final class Companion {
        @Nullable
        public final LocalParsingResult parseInlineLink(@NotNull TokensCache.Iterator iterator2) {
            Object object;
            Object object2;
            LocalParsingResult linkTitle;
            LocalParsingResult linkDestination;
            Intrinsics.checkParameterIsNotNull(iterator2, "iterator");
            int startIndex = iterator2.getIndex();
            TokensCache.Iterator it = iterator2;
            LocalParsingResult localParsingResult = LinkParserUtil.Companion.parseLinkText(it);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkText = localParsingResult;
            it = linkText.getIteratorPosition();
            if (Intrinsics.areEqual(it.rawLookup(1), MarkdownTokenTypes.LPAREN) ^ true) {
                return null;
            }
            if (Intrinsics.areEqual((it = it.advance().advance()).getType(), MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((linkDestination = LinkParserUtil.Companion.parseLinkDestination(it)) != null && Intrinsics.areEqual((it = linkDestination.getIteratorPosition().advance()).getType(), MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((linkTitle = LinkParserUtil.Companion.parseLinkTitle(it)) != null && Intrinsics.areEqual((it = linkTitle.getIteratorPosition().advance()).getType(), MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if (Intrinsics.areEqual(it.getType(), MarkdownTokenTypes.RPAREN) ^ true) {
                return null;
            }
            int n = startIndex;
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus(linkText.getParsedNodes(), (object2 = linkDestination) != null && (object2 = ((LocalParsingResult)object2).getParsedNodes()) != null ? (Iterable)object2 : (Iterable)CollectionsKt.emptyList()), (object = linkTitle) != null && (object = ((LocalParsingResult)object).getParsedNodes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), new SequentialParser.Node(new IntRange(n, it.getIndex() + 1), MarkdownElementTypes.INLINE_LINK)), linkText.getRangesToProcessFurther());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

