/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;

public final class JavaLoadingKt {
    public static final boolean isObjectMethodInInterface(@NotNull JavaMember $this$isObjectMethodInInterface) {
        Intrinsics.checkNotNullParameter($this$isObjectMethodInInterface, "<this>");
        return $this$isObjectMethodInInterface.getContainingClass().isInterface() && $this$isObjectMethodInInterface instanceof JavaMethod && JavaLoadingKt.isObjectMethod((JavaMethod)$this$isObjectMethodInInterface);
    }

    private static final boolean isObjectMethod(JavaMethod method) {
        boolean bl;
        switch (method.getName().asString()) {
            case "hashCode": 
            case "toString": {
                bl = method.getValueParameters().isEmpty();
                break;
            }
            case "equals": {
                bl = JavaLoadingKt.isMethodWithOneObjectParameter(method);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isMethodWithOneObjectParameter(JavaMethod method) {
        JavaClassifierType javaClassifierType;
        List<JavaValueParameter> parameters2 = method.getValueParameters();
        JavaValueParameter javaValueParameter = CollectionsKt.singleOrNull(parameters2);
        JavaType javaType = javaValueParameter == null ? null : javaValueParameter.getType();
        JavaClassifierType javaClassifierType2 = javaClassifierType = javaType instanceof JavaClassifierType ? (JavaClassifierType)javaType : null;
        if (javaClassifierType == null) {
            return false;
        }
        JavaClassifierType type2 = javaClassifierType;
        JavaClassifier classifier2 = type2.getClassifier();
        if (classifier2 instanceof JavaClass) {
            FqName classFqName = ((JavaClass)classifier2).getFqName();
            return classFqName != null && Intrinsics.areEqual(classFqName.asString(), "java.lang.Object");
        }
        return false;
    }
}

