/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes", "markdown"})
public final class EntityConverter {
    private static final String escapeAllowedString = "\\!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}\\~";
    private static final Map<Character, String> replacements;
    private static final Regex REGEX;
    private static final Regex REGEX_ESCAPES;
    public static final EntityConverter INSTANCE;

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkNotNullParameter(text, "text");
        return (processEscapes ? REGEX_ESCAPES : REGEX).replace(text, (Function1<? super MatchResult, ? extends CharSequence>)new Function1<MatchResult, CharSequence>(processEntities){
            final /* synthetic */ boolean $processEntities;

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter(match, "match");
                MatchGroupCollection g = match.getGroups();
                if (g.size() > 5 && g.get(5) != null) {
                    MatchGroup matchGroup = g.get(5);
                    Intrinsics.checkNotNull(matchGroup);
                    char c = matchGroup.getValue().charAt(0);
                    String string = (String)EntityConverter.access$getReplacements$p(EntityConverter.INSTANCE).get(Character.valueOf(c));
                    if (string == null) {
                        string = String.valueOf(c);
                    }
                    charSequence = string;
                } else {
                    String string;
                    if (g.get(4) != null) {
                        Map map2 = EntityConverter.access$getReplacements$p(EntityConverter.INSTANCE);
                        MatchGroup matchGroup = g.get(4);
                        Intrinsics.checkNotNull(matchGroup);
                        string = (String)map2.get(Character.valueOf(matchGroup.getValue().charAt(0)));
                        if (string == null) {
                            string = match.getValue();
                        }
                    } else {
                        Character c;
                        Integer code;
                        int n;
                        int n2;
                        String string2;
                        Integer n3;
                        if (!this.$processEntities) {
                            n3 = null;
                        } else if (g.get(1) != null) {
                            n3 = Entities.INSTANCE.getMap().get(match.getValue());
                        } else if (g.get(2) != null) {
                            MatchGroup matchGroup = g.get(2);
                            Intrinsics.checkNotNull(matchGroup);
                            string2 = matchGroup.getValue();
                            n2 = 0;
                            n3 = Integer.parseInt(string2);
                        } else if (g.get(3) != null) {
                            MatchGroup matchGroup = g.get(3);
                            Intrinsics.checkNotNull(matchGroup);
                            string2 = matchGroup.getValue();
                            n2 = 16;
                            n = 0;
                            n3 = Integer.parseInt(string2, CharsKt.checkRadix(n2));
                        } else {
                            n3 = null;
                        }
                        Integer n4 = code = n3;
                        Character c2 = c = n4 != null ? Character.valueOf((char)n4.intValue()) : null;
                        if (c != null) {
                            string = (String)EntityConverter.access$getReplacements$p(EntityConverter.INSTANCE).get(c);
                            if (string == null) {
                                string = String.valueOf(c.charValue());
                            }
                        } else {
                            StringBuilder stringBuilder = new StringBuilder().append("&amp;");
                            String string3 = match.getValue();
                            n = 1;
                            boolean bl = false;
                            String string4 = string3;
                            if (string4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string5 = string4.substring(n);
                            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
                            string = stringBuilder.append(string5).toString();
                        }
                    }
                    charSequence = string;
                }
                return charSequence;
            }
            {
                this.$processEntities = bl;
                super(1);
            }
        });
    }

    private EntityConverter() {
    }

    static {
        EntityConverter entityConverter;
        INSTANCE = entityConverter = new EntityConverter();
        replacements = MapsKt.mapOf(TuplesKt.to(Character.valueOf('\"'), "&quot;"), TuplesKt.to(Character.valueOf('&'), "&amp;"), TuplesKt.to(Character.valueOf('<'), "&lt;"), TuplesKt.to(Character.valueOf('>'), "&gt;"));
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|\\\\([\\!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}\\~])");
    }

    public static final /* synthetic */ Map access$getReplacements$p(EntityConverter $this) {
        EntityConverter entityConverter = $this;
        return replacements;
    }
}

