/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.CheckedListItemGeneratingProvider;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughParser;
import org.intellij.markdown.flavours.gfm.TablesGeneratingProvider;
import org.intellij.markdown.flavours.gfm.lexer._GFMLexer;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.XssSafeLinksKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "useSafeLinks", "", "absolutizeAnchorLinks", "(ZZ)V", "markerProcessorFactory", "Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "markdown"})
public class GFMFlavourDescriptor
extends CommonMarkFlavourDescriptor {
    @NotNull
    private final GFMMarkerProcessor.Factory markerProcessorFactory;
    @NotNull
    private final SequentialParserManager sequentialParserManager;

    public GFMFlavourDescriptor(boolean useSafeLinks, boolean absolutizeAnchorLinks) {
        super(useSafeLinks, absolutizeAnchorLinks);
        this.markerProcessorFactory = GFMMarkerProcessor.Factory.INSTANCE;
        this.sequentialParserManager = new SequentialParserManager(){

            @NotNull
            public List<SequentialParser> getParserSequence() {
                SequentialParser[] sequentialParserArray = new SequentialParser[7];
                IElementType[] iElementTypeArray = new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK};
                sequentialParserArray[0] = new AutolinkParser(CollectionsKt.listOf(iElementTypeArray));
                sequentialParserArray[1] = new BacktickParser();
                sequentialParserArray[2] = new ImageParser();
                sequentialParserArray[3] = new InlineLinkParser();
                sequentialParserArray[4] = new ReferenceLinkParser();
                sequentialParserArray[5] = new StrikeThroughParser();
                sequentialParserArray[6] = new EmphStrongParser();
                return CollectionsKt.listOf(sequentialParserArray);
            }
        };
    }

    public /* synthetic */ GFMFlavourDescriptor(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @Override
    @NotNull
    public GFMMarkerProcessor.Factory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _GFMLexer());
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter(linkMap, "linkMap");
        Pair[] pairArray = new Pair[]{TuplesKt.to(GFMElementTypes.STRIKETHROUGH, new SimpleInlineTagProvider(){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter(visitor2, "visitor");
                Intrinsics.checkNotNullParameter(text, "text");
                Intrinsics.checkNotNullParameter(node, "node");
                CharSequence[] charSequenceArray = new CharSequence[]{"class=\"user-del\""};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, this.getTagName(), charSequenceArray, false, 8, null);
            }
        }), TuplesKt.to(GFMElementTypes.TABLE, new TablesGeneratingProvider()), TuplesKt.to(GFMTokenTypes.CELL, new TrimmingInlineHolderProvider()), TuplesKt.to(GFMTokenTypes.GFM_AUTOLINK, new GeneratingProvider(this){
            final /* synthetic */ GFMFlavourDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter(visitor2, "visitor");
                Intrinsics.checkNotNullParameter(text, "text");
                Intrinsics.checkNotNullParameter(node, "node");
                CharSequence linkText = ASTUtilKt.getTextInNode(node, text);
                IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.LINK_LABEL, MarkdownElementTypes.LINK_TEXT};
                if (ASTUtilKt.getParentOfType(node, iElementTypeArray) != null) {
                    visitor2.consumeHtml(linkText);
                    return;
                }
                CharSequence absoluteLink = this.hasSchema(linkText) ? linkText : (CharSequence)Intrinsics.stringPlus("http://", linkText);
                String link = EntityConverter.INSTANCE.replaceEntities(linkText, true, false);
                CharSequence[] charSequenceArray = LinkMap.Builder.normalizeDestination(absoluteLink, false);
                GFMFlavourDescriptor gFMFlavourDescriptor = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                CharSequence[] it = charSequenceArray;
                boolean bl3 = false;
                CharSequence[] normalizedDestination = GFMFlavourDescriptor.access$getUseSafeLinks(gFMFlavourDescriptor) ? XssSafeLinksKt.makeXssSafeDestination((CharSequence)it) : it;
                charSequenceArray = new CharSequence[]{"href=\"" + normalizedDestination + '\"'};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "a", charSequenceArray, false, 8, null);
                visitor2.consumeHtml(link);
                visitor2.consumeTagClose("a");
            }

            private final boolean hasSchema(CharSequence linkText) {
                int index = StringsKt.indexOf$default(linkText, '/', 0, false, 6, null);
                if (index == -1) {
                    return false;
                }
                return index != 0 && index + 1 < linkText.length() && linkText.charAt(index - 1) == ':' && linkText.charAt(index + 1) == '/';
            }
        }), TuplesKt.to(MarkdownElementTypes.LIST_ITEM, new CheckedListItemGeneratingProvider())};
        return MapsKt.plus(super.createHtmlGeneratingProviders(linkMap, baseURI), MapsKt.hashMapOf(pairArray));
    }

    public GFMFlavourDescriptor() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ boolean access$getUseSafeLinks(GFMFlavourDescriptor $this) {
        return $this.getUseSafeLinks();
    }
}

