/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class PrimitiveType
extends Enum<PrimitiveType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Name typeName;
    @NotNull
    private final Name arrayTypeName;
    @NotNull
    private final Lazy typeFqName$delegate;
    @NotNull
    private final Lazy arrayTypeFqName$delegate;
    @JvmField
    @NotNull
    public static final Set<PrimitiveType> NUMBER_TYPES;
    public static final /* enum */ PrimitiveType BOOLEAN;
    public static final /* enum */ PrimitiveType CHAR;
    public static final /* enum */ PrimitiveType BYTE;
    public static final /* enum */ PrimitiveType SHORT;
    public static final /* enum */ PrimitiveType INT;
    public static final /* enum */ PrimitiveType FLOAT;
    public static final /* enum */ PrimitiveType LONG;
    public static final /* enum */ PrimitiveType DOUBLE;
    private static final /* synthetic */ PrimitiveType[] $VALUES;

    private PrimitiveType(String typeName) {
        Name name2 = Name.identifier(typeName);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(typeName)");
        this.typeName = name2;
        name2 = Name.identifier(Intrinsics.stringPlus(typeName, "Array"));
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"${typeName}Array\")");
        this.arrayTypeName = name2;
        this.typeFqName$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<FqName>(this){
            final /* synthetic */ PrimitiveType this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FqName invoke() {
                FqName fqName2 = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(this.this$0.getTypeName());
                Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAME.child(this.typeName)");
                return fqName2;
            }
        });
        this.arrayTypeFqName$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<FqName>(this){
            final /* synthetic */ PrimitiveType this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FqName invoke() {
                FqName fqName2 = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(this.this$0.getArrayTypeName());
                Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAME.child(arrayTypeName)");
                return fqName2;
            }
        });
    }

    @NotNull
    public final Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final Name getArrayTypeName() {
        return this.arrayTypeName;
    }

    @NotNull
    public final FqName getTypeFqName() {
        Lazy lazy = this.typeFqName$delegate;
        Object var2_2 = null;
        return (FqName)lazy.getValue();
    }

    @NotNull
    public final FqName getArrayTypeFqName() {
        Lazy lazy = this.arrayTypeFqName$delegate;
        Object var2_2 = null;
        return (FqName)lazy.getValue();
    }

    public static PrimitiveType[] values() {
        return (PrimitiveType[])$VALUES.clone();
    }

    public static PrimitiveType valueOf(String value) {
        return Enum.valueOf(PrimitiveType.class, value);
    }

    static {
        BOOLEAN = new PrimitiveType("Boolean");
        CHAR = new PrimitiveType("Char");
        BYTE = new PrimitiveType("Byte");
        SHORT = new PrimitiveType("Short");
        INT = new PrimitiveType("Int");
        FLOAT = new PrimitiveType("Float");
        LONG = new PrimitiveType("Long");
        DOUBLE = new PrimitiveType("Double");
        $VALUES = primitiveTypeArray = new PrimitiveType[]{PrimitiveType.BOOLEAN, PrimitiveType.CHAR, PrimitiveType.BYTE, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.LONG, PrimitiveType.DOUBLE};
        Companion = new Companion(null);
        PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{CHAR, BYTE, SHORT, INT, FLOAT, LONG, DOUBLE};
        NUMBER_TYPES = SetsKt.setOf(primitiveTypeArray);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

