/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractTypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeAliasConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedTypeAliasDescriptor
extends AbstractTypeAliasDescriptor
implements DeserializedMemberDescriptor {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ProtoBuf.TypeAlias proto;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @NotNull
    private final VersionRequirementTable versionRequirementTable;
    @Nullable
    private final DeserializedContainerSource containerSource;
    private Collection<? extends TypeAliasConstructorDescriptor> constructors;
    private SimpleType underlyingType;
    private SimpleType expandedType;
    private List<? extends TypeParameterDescriptor> typeConstructorParameters;
    private SimpleType defaultTypeImpl;

    public DeserializedTypeAliasDescriptor(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name2, @NotNull DescriptorVisibility visibility, @NotNull ProtoBuf.TypeAlias proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull VersionRequirementTable versionRequirementTable, @Nullable DeserializedContainerSource containerSource) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(containingDeclaration, "containingDeclaration");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
        super(containingDeclaration, annotations2, name2, sourceElement, visibility);
        this.storageManager = storageManager;
        this.proto = proto;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        this.versionRequirementTable = versionRequirementTable;
        this.containerSource = containerSource;
    }

    @Override
    @NotNull
    protected StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    @NotNull
    public ProtoBuf.TypeAlias getProto() {
        return this.proto;
    }

    @Override
    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @Override
    @NotNull
    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    @NotNull
    public VersionRequirementTable getVersionRequirementTable() {
        return this.versionRequirementTable;
    }

    @Override
    @Nullable
    public DeserializedContainerSource getContainerSource() {
        return this.containerSource;
    }

    @Override
    @NotNull
    public SimpleType getUnderlyingType() {
        SimpleType simpleType2 = this.underlyingType;
        if (simpleType2 != null) {
            return simpleType2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("underlyingType");
        return null;
    }

    @Override
    @NotNull
    public SimpleType getExpandedType() {
        SimpleType simpleType2 = this.expandedType;
        if (simpleType2 != null) {
            return simpleType2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("expandedType");
        return null;
    }

    public final void initialize(@NotNull List<? extends TypeParameterDescriptor> declaredTypeParameters, @NotNull SimpleType underlyingType, @NotNull SimpleType expandedType) {
        Intrinsics.checkNotNullParameter(declaredTypeParameters, "declaredTypeParameters");
        Intrinsics.checkNotNullParameter(underlyingType, "underlyingType");
        Intrinsics.checkNotNullParameter(expandedType, "expandedType");
        this.initialize(declaredTypeParameters);
        this.underlyingType = underlyingType;
        this.expandedType = expandedType;
        this.typeConstructorParameters = TypeParameterUtilsKt.computeConstructorTypeParameters(this);
        this.defaultTypeImpl = this.computeDefaultType();
        this.constructors = this.getTypeAliasConstructors();
    }

    @Override
    @Nullable
    public ClassDescriptor getClassDescriptor() {
        ClassifierDescriptor classifierDescriptor;
        return KotlinTypeKt.isError(this.getExpandedType()) ? null : ((classifierDescriptor = this.getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null);
    }

    @Override
    @NotNull
    public SimpleType getDefaultType() {
        SimpleType simpleType2;
        SimpleType simpleType3 = this.defaultTypeImpl;
        if (simpleType3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("defaultTypeImpl");
            simpleType2 = null;
        } else {
            simpleType2 = simpleType3;
        }
        return simpleType2;
    }

    @Override
    @NotNull
    public TypeAliasDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter(substitutor, "substitutor");
        if (substitutor.isEmpty()) {
            return this;
        }
        StorageManager storageManager = this.getStorageManager();
        Object object = this.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(object, "containingDeclaration");
        DeclarationDescriptor declarationDescriptor = object;
        object = this.getAnnotations();
        Intrinsics.checkNotNullExpressionValue(object, "annotations");
        Object object2 = object;
        object = this.getName();
        Intrinsics.checkNotNullExpressionValue(object, "name");
        DeserializedTypeAliasDescriptor substituted = new DeserializedTypeAliasDescriptor(storageManager, declarationDescriptor, (Annotations)object2, (Name)object, this.getVisibility(), this.getProto(), this.getNameResolver(), this.getTypeTable(), this.getVersionRequirementTable(), this.getContainerSource());
        List<TypeParameterDescriptor> list = this.getDeclaredTypeParameters();
        object = substitutor.safeSubstitute(this.getUnderlyingType(), Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue(object, "substitutor.safeSubstitu\u2026Type, Variance.INVARIANT)");
        SimpleType simpleType2 = TypeSubstitutionKt.asSimpleType((KotlinType)object);
        object = substitutor.safeSubstitute(this.getExpandedType(), Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue(object, "substitutor.safeSubstitu\u2026Type, Variance.INVARIANT)");
        substituted.initialize(list, simpleType2, TypeSubstitutionKt.asSimpleType((KotlinType)object));
        return substituted;
    }

    @Override
    @NotNull
    protected List<TypeParameterDescriptor> getTypeConstructorTypeParameters() {
        List<TypeParameterDescriptor> list;
        List<TypeParameterDescriptor> list2 = this.typeConstructorParameters;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("typeConstructorParameters");
            list = null;
        } else {
            list = list2;
        }
        return list;
    }
}

