/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Iterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeVisitor;

public class NodeTraversor {
    public static void traverse(NodeVisitor visitor2, Node root) {
        Validate.notNull(visitor2);
        Validate.notNull(root);
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node parent = node.parentNode();
            visitor2.head(node, depth);
            if (parent != null && !node.hasParent()) {
                node = parent.childNode(node.siblingIndex());
            }
            if (node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node != null);
                if (node.nextSibling() != null || depth <= 0) break;
                visitor2.tail(node, depth);
                node = node.parentNode();
                --depth;
            }
            visitor2.tail(node, depth);
            if (node == root) break;
            node = node.nextSibling();
        }
    }

    public static void traverse(NodeVisitor visitor2, Elements elements) {
        Validate.notNull(visitor2);
        Validate.notNull(elements);
        for (Element el : elements) {
            NodeTraversor.traverse(visitor2, el);
        }
    }

    public static NodeFilter.FilterResult filter(NodeFilter filter2, Node root) {
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node prev;
            NodeFilter.FilterResult result2 = filter2.head(node, depth);
            if (result2 == NodeFilter.FilterResult.STOP) {
                return result2;
            }
            if (result2 == NodeFilter.FilterResult.CONTINUE && node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node != null);
                if (node.nextSibling() != null || depth <= 0) break;
                if ((result2 == NodeFilter.FilterResult.CONTINUE || result2 == NodeFilter.FilterResult.SKIP_CHILDREN) && (result2 = filter2.tail(node, depth)) == NodeFilter.FilterResult.STOP) {
                    return result2;
                }
                prev = node;
                node = node.parentNode();
                --depth;
                if (result2 == NodeFilter.FilterResult.REMOVE) {
                    prev.remove();
                }
                result2 = NodeFilter.FilterResult.CONTINUE;
            }
            if ((result2 == NodeFilter.FilterResult.CONTINUE || result2 == NodeFilter.FilterResult.SKIP_CHILDREN) && (result2 = filter2.tail(node, depth)) == NodeFilter.FilterResult.STOP) {
                return result2;
            }
            if (node == root) {
                return result2;
            }
            prev = node;
            node = node.nextSibling();
            if (result2 != NodeFilter.FilterResult.REMOVE) continue;
            prev.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }

    public static void filter(NodeFilter filter2, Elements elements) {
        Element el;
        Validate.notNull(filter2);
        Validate.notNull(elements);
        Iterator iterator2 = elements.iterator();
        while (iterator2.hasNext() && NodeTraversor.filter(filter2, el = (Element)iterator2.next()) != NodeFilter.FilterResult.STOP) {
        }
    }
}

