/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast.impl;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\tH\u0002R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/intellij/markdown/ast/impl/ListCompositeNode;", "Lorg/intellij/markdown/ast/CompositeASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "children", "", "Lorg/intellij/markdown/ast/ASTNode;", "(Lorg/intellij/markdown/IElementType;Ljava/util/List;)V", "loose", "", "getLoose", "()Z", "loose$delegate", "Lkotlin/Lazy;", "isLoose", "Companion", "markdown"})
public final class ListCompositeNode
extends CompositeASTNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy loose$delegate;

    public ListCompositeNode(@NotNull IElementType type2, @NotNull List<? extends ASTNode> children2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(children2, "children");
        super(type2, children2);
        this.loose$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ ListCompositeNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ListCompositeNode.access$isLoose(this.this$0);
            }
        });
    }

    public final boolean getLoose() {
        Lazy lazy = this.loose$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    private final boolean isLoose() {
        if (ListCompositeNode.Companion.hasLooseContent(this)) {
            return true;
        }
        for (ASTNode child : this.getChildren()) {
            if (!Intrinsics.areEqual(child.getType(), MarkdownElementTypes.LIST_ITEM) || !ListCompositeNode.Companion.hasLooseContent(child)) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isLoose(ListCompositeNode $this) {
        return $this.isLoose();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/intellij/markdown/ast/impl/ListCompositeNode$Companion;", "", "()V", "hasLooseContent", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasLooseContent(ASTNode node) {
            int newlines = 0;
            boolean seenNonWhitespace = false;
            for (ASTNode child : node.getChildren()) {
                IElementType iElementType = child.getType();
                if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.EOL)) {
                    ++newlines;
                    continue;
                }
                if ((Intrinsics.areEqual(iElementType, MarkdownTokenTypes.LIST_BULLET) ? true : Intrinsics.areEqual(iElementType, MarkdownTokenTypes.LIST_NUMBER)) ? true : Intrinsics.areEqual(iElementType, MarkdownTokenTypes.WHITE_SPACE)) continue;
                if (seenNonWhitespace && newlines > 1) {
                    return true;
                }
                seenNonWhitespace = true;
                newlines = 0;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

