/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.utilities;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.utilities.DokkaLogger;
import org.jetbrains.dokka.utilities.LoggingLevel;
import org.jetbrains.dokka.utilities.MessageEmitter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/dokka/utilities/DokkaConsoleLogger;", "Lorg/jetbrains/dokka/utilities/DokkaLogger;", "minLevel", "Lorg/jetbrains/dokka/utilities/LoggingLevel;", "emitter", "Lorg/jetbrains/dokka/utilities/MessageEmitter;", "(Lorg/jetbrains/dokka/utilities/LoggingLevel;Lorg/jetbrains/dokka/utilities/MessageEmitter;)V", "value", "", "errorsCount", "getErrorsCount", "()I", "setErrorsCount", "(I)V", "errorsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "warningsCount", "getWarningsCount", "setWarningsCount", "warningsCounter", "debug", "", "message", "", "error", "info", "progress", "shouldBeDisplayed", "", "messageLevel", "warn", "core"})
public final class DokkaConsoleLogger
implements DokkaLogger {
    private final AtomicInteger warningsCounter;
    private final AtomicInteger errorsCounter;
    private final LoggingLevel minLevel;
    private final MessageEmitter emitter;

    @Override
    public int getWarningsCount() {
        return this.warningsCounter.get();
    }

    @Override
    public void setWarningsCount(int value) {
        this.warningsCounter.set(value);
    }

    @Override
    public int getErrorsCount() {
        return this.errorsCounter.get();
    }

    @Override
    public void setErrorsCount(int value) {
        this.errorsCounter.set(value);
    }

    @Override
    public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.shouldBeDisplayed(LoggingLevel.DEBUG)) {
            this.emitter.invoke(message);
        }
    }

    @Override
    public void progress(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.shouldBeDisplayed(LoggingLevel.PROGRESS)) {
            this.emitter.invoke("PROGRESS: " + message);
        }
    }

    @Override
    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.shouldBeDisplayed(LoggingLevel.INFO)) {
            this.emitter.invoke(message);
        }
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.shouldBeDisplayed(LoggingLevel.WARN)) {
            this.emitter.invoke("WARN: " + message);
        }
        this.warningsCounter.incrementAndGet();
    }

    @Override
    public void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.shouldBeDisplayed(LoggingLevel.ERROR)) {
            this.emitter.invoke("ERROR: " + message);
        }
        this.errorsCounter.incrementAndGet();
    }

    private final boolean shouldBeDisplayed(LoggingLevel messageLevel) {
        return messageLevel.getIndex() >= this.minLevel.getIndex();
    }

    public DokkaConsoleLogger(@NotNull LoggingLevel minLevel, @NotNull MessageEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)minLevel, "minLevel");
        Intrinsics.checkNotNullParameter(emitter, "emitter");
        this.minLevel = minLevel;
        this.emitter = emitter;
        this.warningsCounter = new AtomicInteger();
        this.errorsCounter = new AtomicInteger();
    }

    public /* synthetic */ DokkaConsoleLogger(LoggingLevel loggingLevel2, MessageEmitter messageEmitter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            loggingLevel2 = LoggingLevel.PROGRESS;
        }
        if ((n & 2) != 0) {
            messageEmitter = MessageEmitter.Companion.getConsoleEmitter();
        }
        this(loggingLevel2, messageEmitter);
    }

    public DokkaConsoleLogger() {
        this(null, null, 3, null);
    }
}

