/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public class XmlFactoryBuilder
extends TSFBuilder<XmlFactory, XmlFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;
    protected XMLInputFactory _xmlInputFactory;
    protected XMLOutputFactory _xmlOutputFactory;
    protected String _nameForTextElement;

    protected XmlFactoryBuilder() {
        this._formatParserFeatures = XmlFactory.DEFAULT_XML_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = XmlFactory.DEFAULT_XML_GENERATOR_FEATURE_FLAGS;
    }

    public XmlFactoryBuilder(XmlFactory base) {
        super(base);
        this._formatParserFeatures = base._xmlParserFeatures;
        this._formatGeneratorFeatures = base._xmlGeneratorFeatures;
        this._xmlInputFactory = base._xmlInputFactory;
        this._xmlOutputFactory = base._xmlOutputFactory;
        this._nameForTextElement = base._cfgNameForTextElement;
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    public String nameForTextElement() {
        return this._nameForTextElement;
    }

    public XMLInputFactory xmlInputFactory() {
        if (this._xmlInputFactory == null) {
            return XmlFactoryBuilder.defaultInputFactory();
        }
        return this._xmlInputFactory;
    }

    protected static XMLInputFactory defaultInputFactory() {
        XMLInputFactory xmlIn = XMLInputFactory.newInstance();
        xmlIn.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlIn.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlIn;
    }

    public XMLOutputFactory xmlOutputFactory() {
        if (this._xmlOutputFactory == null) {
            return XmlFactoryBuilder.defaultOutputFactory();
        }
        return this._xmlOutputFactory;
    }

    protected static XMLOutputFactory defaultOutputFactory() {
        XMLOutputFactory xmlOut = XMLOutputFactory.newInstance();
        xmlOut.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        return xmlOut;
    }

    public XmlFactoryBuilder enable(FromXmlParser.Feature f) {
        this._formatParserFeatures |= f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder enable(FromXmlParser.Feature first2, FromXmlParser.Feature ... other) {
        this._formatParserFeatures |= first2.getMask();
        for (FromXmlParser.Feature f : other) {
            this._formatParserFeatures |= f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(FromXmlParser.Feature f) {
        this._formatParserFeatures &= ~f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(FromXmlParser.Feature first2, FromXmlParser.Feature ... other) {
        this._formatParserFeatures &= ~first2.getMask();
        for (FromXmlParser.Feature f : other) {
            this._formatParserFeatures &= ~f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder configure(FromXmlParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public XmlFactoryBuilder enable(ToXmlGenerator.Feature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder enable(ToXmlGenerator.Feature first2, ToXmlGenerator.Feature ... other) {
        this._formatGeneratorFeatures |= first2.getMask();
        for (ToXmlGenerator.Feature f : other) {
            this._formatGeneratorFeatures |= f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(ToXmlGenerator.Feature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(ToXmlGenerator.Feature first2, ToXmlGenerator.Feature ... other) {
        this._formatGeneratorFeatures &= ~first2.getMask();
        for (ToXmlGenerator.Feature f : other) {
            this._formatGeneratorFeatures &= ~f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder configure(ToXmlGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public XmlFactoryBuilder nameForTextElement(String name) {
        this._nameForTextElement = name;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder inputFactory(XMLInputFactory xmlIn) {
        this._xmlInputFactory = xmlIn;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder outputFactory(XMLOutputFactory xmlOut) {
        this._xmlOutputFactory = xmlOut;
        return (XmlFactoryBuilder)this._this();
    }

    @Override
    public XmlFactory build() {
        return new XmlFactory(this);
    }
}

