/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.utilities;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.InternalDokkaApi;
import org.jetbrains.dokka.utilities.ServiceDescriptor;
import org.jetbrains.dokka.utilities.ServiceLocatorKt;
import org.jetbrains.dokka.utilities.ServiceLookupException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J3\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ+\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/dokka/utilities/ServiceLocator;", "", "()V", "allServices", "", "Lorg/jetbrains/dokka/utilities/ServiceDescriptor;", "category", "", "lookup", "T", "clazz", "Ljava/lang/Class;", "implementationName", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "descriptor", "(Ljava/lang/Class;Lorg/jetbrains/dokka/utilities/ServiceDescriptor;)Ljava/lang/Object;", "lookupDescriptor", "toFile", "Ljava/io/File;", "Ljava/net/URL;", "dokka-core"})
@InternalDokkaApi
@SourceDebugExtension(value={"SMAP\nServiceLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceLocator.kt\norg/jetbrains/dokka/utilities/ServiceLocator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1310#2,2:101\n3829#2:106\n4344#2,2:107\n1368#3:103\n1454#3,2:104\n1557#3:109\n1628#3,3:110\n1456#3,3:113\n*E\n*S KotlinDebug\n*F\n+ 1 ServiceLocator.kt\norg/jetbrains/dokka/utilities/ServiceLocator\n*L\n33#1,2:101\n74#1:106\n74#1,2:107\n72#1:103\n72#1,2:104\n74#1:109\n74#1,3:110\n72#1,3:113\n*E\n"})
public final class ServiceLocator {
    @NotNull
    public static final ServiceLocator INSTANCE = new ServiceLocator();

    private ServiceLocator() {
    }

    @NotNull
    public final <T> T lookup(@NotNull Class<T> clazz, @NotNull String category, @NotNull String implementationName) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(implementationName, "implementationName");
        ServiceDescriptor descriptor2 = this.lookupDescriptor(category, implementationName);
        return this.lookup(clazz, descriptor2);
    }

    @NotNull
    public final <T> T lookup(@NotNull Class<T> clazz, @NotNull ServiceDescriptor descriptor2) {
        Object t;
        Object object;
        block5: {
            Intrinsics.checkNotNullParameter(clazz, "clazz");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Class<?> loadedClass = this.getClass().getClassLoader().loadClass(descriptor2.getClassName());
            Constructor<?>[] constructorArray = loadedClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, "loadedClass.constructors");
            Object[] $this$firstOrNull$iv = constructorArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Constructor it = (Constructor)element$iv;
                boolean bl = false;
                Class<?>[] classArray = it.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, "it.parameterTypes");
                boolean bl2 = ((Object[])classArray).length == 0;
                if (!bl2) continue;
                object = element$iv;
                break block5;
            }
            object = null;
        }
        Constructor constructor = (Constructor)object;
        if (constructor == null) {
            throw new ServiceLookupException("Class " + descriptor2.getClassName() + " has no corresponding constructor");
        }
        Constructor constructor2 = constructor;
        Class<?>[] classArray = constructor2.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, "constructor.parameterTypes");
        if (((Object[])classArray).length == 0) {
            t = constructor2.newInstance(new Object[0]);
        } else {
            Object[] objectArray = new Object[]{constructor2};
            t = constructor2.newInstance(objectArray);
        }
        Intrinsics.checkNotNullExpressionValue(t, "if (constructor.paramete\u2026.newInstance(constructor)");
        Object implementationRawType = t;
        if (!clazz.isInstance(implementationRawType)) {
            throw new ServiceLookupException("Class " + descriptor2.getClassName() + " is not a subtype of " + clazz.getName());
        }
        return implementationRawType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceDescriptor lookupDescriptor(String category, String implementationName) {
        Properties properties;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("dokka/" + category + '/' + implementationName + ".properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                Properties properties2 = new Properties();
                boolean bl2 = false;
                properties2.load(stream);
                properties = properties2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else {
            throw new ServiceLookupException("No implementation with name " + implementationName + " found in category " + category);
        }
        Properties properties3 = properties;
        Object object = properties3.get("class");
        if (object == null || (object = object.toString()) == null) {
            throw new ServiceLookupException("Implementation " + implementationName + " has no class configured");
        }
        Object className = object;
        Object object2 = properties3.get("description");
        return new ServiceDescriptor(implementationName, category, object2 != null ? object2.toString() : null, (String)className);
    }

    @NotNull
    public final File toFile(@NotNull URL $this$toFile) {
        File file;
        Intrinsics.checkNotNullParameter($this$toFile, "<this>");
        boolean bl = Intrinsics.areEqual($this$toFile.getProtocol(), "file");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        try {
            file = new File($this$toFile.toURI());
        }
        catch (URISyntaxException e) {
            file = new File($this$toFile.getPath());
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ServiceDescriptor> allServices(@NotNull String category) {
        void $this$flatMapTo$iv$iv;
        Object object;
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter(category, "category");
                object = this.getClass().getClassLoader().getResources("dokka/" + category);
                if (object == null) break block17;
                ArrayList<URL> arrayList = Collections.list(object);
                Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
                object = arrayList;
                if (object != null) break block18;
            }
            object = CollectionsKt.emptyList();
        }
        Enumeration<URL> entries2 = object;
        Iterable $this$flatMap$iv = (Iterable)((Object)entries2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Object object2;
            URL it = (URL)element$iv$iv;
            boolean bl = false;
            String string = it.getProtocol();
            if (Intrinsics.areEqual(string, "file")) {
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (object2 != null) {
                    void $this$mapTo$iv$iv;
                    File it2;
                    void $this$filterTo$iv$iv;
                    object2 = INSTANCE.toFile(it).listFiles();
                    Intrinsics.checkNotNullExpressionValue(object2, "listFiles()");
                    File[] $this$filter$iv = object2;
                    boolean $i$f$filter = false;
                    File[] fileArray = $this$filter$iv;
                    Iterable<void> destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv2 : $this$filterTo$iv$iv) {
                        it2 = element$iv$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue(it2, "it");
                        if (!Intrinsics.areEqual(FilesKt.getExtension(it2), "properties")) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$map = false;
                    destination$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (File)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue(it2, "it");
                        collection.add(INSTANCE.lookupDescriptor(category, FilesKt.getNameWithoutExtension(it2)));
                    }
                    list = (List)destination$iv$iv3;
                } else {
                    list = CollectionsKt.emptyList();
                }
            } else if (Intrinsics.areEqual(string, "jar")) {
                String string2 = it.getFile();
                Intrinsics.checkNotNullExpressionValue(string2, "it.file");
                object2 = new JarFile(INSTANCE.toFile(new URL(StringsKt.substringBefore$default(string2, "!", null, 2, null))));
                Throwable throwable = null;
                try {
                    JarFile file = (JarFile)object2;
                    boolean bl4 = false;
                    String string3 = it.getFile();
                    Intrinsics.checkNotNullExpressionValue(string3, "it.file");
                    String jarPath = StringsKt.removeSuffix(StringsKt.removePrefix(StringsKt.substringAfterLast$default(string3, "!", null, 2, null), (CharSequence)"/"), (CharSequence)"/");
                    Enumeration<JarEntry> enumeration = file.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, "file.entries()");
                    List list2 = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), (Function1)new Function1<JarEntry, Boolean>(jarPath){
                        final /* synthetic */ String $jarPath;
                        {
                            this.$jarPath = $jarPath;
                            super(1);
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final Boolean invoke(JarEntry entry) {
                            boolean bl;
                            if (!entry.isDirectory()) {
                                Intrinsics.checkNotNullExpressionValue(entry, "entry");
                                if (Intrinsics.areEqual(ServiceLocatorKt.access$getPath(entry), this.$jarPath) && Intrinsics.areEqual(ServiceLocatorKt.access$getExtension(entry), "properties")) {
                                    bl = true;
                                    return bl;
                                }
                            }
                            bl = false;
                            return bl;
                        }
                    }), (Function1)new Function1<JarEntry, ServiceDescriptor>(category){
                        final /* synthetic */ String $category;
                        {
                            this.$category = $category;
                            super(1);
                        }

                        public final ServiceDescriptor invoke(JarEntry entry) {
                            Intrinsics.checkNotNullExpressionValue(entry, "entry");
                            return ServiceLocator.access$lookupDescriptor(ServiceLocator.INSTANCE, this.$category, StringsKt.substringBeforeLast$default(ServiceLocatorKt.access$getFileName(entry), ".", null, 2, null));
                        }
                    }));
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, throwable);
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ ServiceDescriptor access$lookupDescriptor(ServiceLocator $this, String category, String implementationName) {
        return $this.lookupDescriptor(category, implementationName);
    }
}

