/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.utilities;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.utilities.DokkaLogger;
import org.jetbrains.dokka.utilities.LoggingLevel;
import org.jetbrains.dokka.utilities.MessageEmitter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/dokka/utilities/DokkaConsoleLogger;", "Lorg/jetbrains/dokka/utilities/DokkaLogger;", "minLevel", "Lorg/jetbrains/dokka/utilities/LoggingLevel;", "emitter", "Lorg/jetbrains/dokka/utilities/MessageEmitter;", "(Lorg/jetbrains/dokka/utilities/LoggingLevel;Lorg/jetbrains/dokka/utilities/MessageEmitter;)V", "errorsCount", "", "getErrorsCount", "()I", "setErrorsCount", "(I)V", "getMinLevel", "()Lorg/jetbrains/dokka/utilities/LoggingLevel;", "warningsCount", "getWarningsCount", "setWarningsCount", "debug", "", "message", "", "error", "info", "progress", "shouldBeDisplayed", "", "messageLevel", "warn", "core"})
public final class DokkaConsoleLogger
implements DokkaLogger {
    private int warningsCount;
    private int errorsCount;
    @NotNull
    private final LoggingLevel minLevel;
    private final MessageEmitter emitter;

    @Override
    public int getWarningsCount() {
        return this.warningsCount;
    }

    @Override
    public void setWarningsCount(int n) {
        this.warningsCount = n;
    }

    @Override
    public int getErrorsCount() {
        return this.errorsCount;
    }

    @Override
    public void setErrorsCount(int n) {
        this.errorsCount = n;
    }

    @Override
    public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.shouldBeDisplayed(LoggingLevel.DEBUG)) {
            this.emitter.invoke(message);
        }
    }

    @Override
    public void progress(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.shouldBeDisplayed(LoggingLevel.PROGRESS)) {
            this.emitter.invoke("PROGRESS: " + message);
        }
    }

    @Override
    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.shouldBeDisplayed(LoggingLevel.INFO)) {
            this.emitter.invoke(message);
        }
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.shouldBeDisplayed(LoggingLevel.WARN)) {
            this.emitter.invoke("WARN: " + message);
        }
        DokkaConsoleLogger dokkaConsoleLogger = this;
        int n = dokkaConsoleLogger.getWarningsCount();
        dokkaConsoleLogger.setWarningsCount(n + 1);
    }

    @Override
    public void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.shouldBeDisplayed(LoggingLevel.ERROR)) {
            this.emitter.invoke("ERROR: " + message);
        }
        DokkaConsoleLogger dokkaConsoleLogger = this;
        int n = dokkaConsoleLogger.getErrorsCount();
        dokkaConsoleLogger.setErrorsCount(n + 1);
    }

    private final boolean shouldBeDisplayed(LoggingLevel messageLevel) {
        return messageLevel.getIndex() >= this.minLevel.getIndex();
    }

    @NotNull
    public final LoggingLevel getMinLevel() {
        return this.minLevel;
    }

    public DokkaConsoleLogger(@NotNull LoggingLevel minLevel, @NotNull MessageEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        this.minLevel = minLevel;
        this.emitter = emitter;
    }

    public /* synthetic */ DokkaConsoleLogger(LoggingLevel loggingLevel, MessageEmitter messageEmitter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            loggingLevel = LoggingLevel.DEBUG;
        }
        if ((n & 2) != 0) {
            messageEmitter = MessageEmitter.Companion.getConsoleEmitter();
        }
        this(loggingLevel, messageEmitter);
    }

    public DokkaConsoleLogger() {
        this(null, null, 3, null);
    }
}

