/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.text.CharSequenceReader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create("EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotationsCache;
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache;
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStampCache;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<PsiModifierListOwner, AnnotationData> cache;
    private final CharTableImpl charTable;
    private static final JavaParserUtil.ParserWrapper ANNOTATION = JavaParser.INSTANCE.getDeclarationParser()::parseAnnotation;

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        this.myExternalAnnotationsCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        this.myAnnotationDataCache = ContainerUtil.createWeakKeyWeakValueMap();
        this.myAnnotationFileToDataAndModStampCache = ContainerUtil.createConcurrentSoftMap();
        this.cache = new ConcurrentMostlySingularMultiMap();
        this.charTable = new CharTableImpl();
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(this::dropCache, psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        return PsiFormatUtil.getExternalName(listOwner, showParamName, Integer.MAX_VALUE);
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    @Override
    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        return this.hasAnyAnnotationsRoots();
    }

    @Override
    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(3);
        }
        return annotation2.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Override
    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> list2;
        AnnotationData data2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(4);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(5);
        }
        return (data2 = BaseExternalAnnotationsManager.findByFQN(list2 = this.collectExternalAnnotations(listOwner), annotationFQN)) == null ? null : data2.getAnnotation(this);
    }

    @Override
    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> map2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(6);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(7);
        }
        return BaseExternalAnnotationsManager.findByFQN(map2 = this.doCollect(listOwner, true), annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, @NotNull String annotationFQN) {
        if (map2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(8);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(9);
        }
        return (AnnotationData)((Object)ContainerUtil.find(map2, data2 -> {
            if (annotationFQN == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(47);
            }
            return ((AnnotationData)data2).annotationClassFqName.equals(annotationFQN);
        }));
    }

    @Override
    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> result2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(10);
        }
        return (result2 = this.collectExternalAnnotations(listOwner)).isEmpty() ? null : ContainerUtil.map2Array(result2, PsiAnnotation.EMPTY_ARRAY, data2 -> data2.getAnnotation(this));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(11);
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list2 = Collections.emptyList();
            if (list2 == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(12);
            }
            return list2;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(listOwner)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list3 = cached;
            if (list3 == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(13);
            }
            return list3;
        } while (!this.cache.replace(listOwner, (Collection<AnnotationData>)cached, computed = this.doCollect(listOwner, false)));
        cached = computed;
        List<AnnotationData> list4 = cached;
        if (list4 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(14);
        }
        return list4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data2) {
        if (data2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(15);
        }
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        // MONITORENTER : map2
        AnnotationData interned = this.myAnnotationDataCache.get(data2);
        if (interned == null) {
            this.myAnnotationDataCache.put(data2, data2);
            interned = data2;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map2
        if (annotationData != null) return annotationData;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(16);
        return annotationData;
    }

    @NotNull
    public MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(17);
        }
        Pair cached = (Pair)this.myAnnotationFileToDataAndModStampCache.get(file2);
        long fileModificationStamp = file2.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(18);
            }
            return mostlySingularMultiMap;
        }
        DataParsingSaxHandler handler2 = new DataParsingSaxHandler(file2);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(file2.getViewProvider().getContents()))), (DefaultHandler)handler2);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(file2.getViewProvider().getVirtualFile().getPath(), e);
        }
        MostlySingularMultiMap<String, AnnotationData> result2 = handler2.getResult();
        this.myAnnotationFileToDataAndModStampCache.put(file2, Pair.create(result2, fileModificationStamp));
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = result2;
        if (mostlySingularMultiMap == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(19);
        }
        return mostlySingularMultiMap;
    }

    protected void duplicateError(@NotNull PsiFile file2, @NotNull String externalName, @NotNull String text2) {
        if (file2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(20);
        }
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(22);
        }
        LOG.error(text2 + "; for signature: '" + externalName + "' in the " + file2.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(23);
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = this.charTable.doIntern(annotationFQN).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(24);
        return string;
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        List<PsiFile> files2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(25);
        }
        if ((files2 = this.findExternalAnnotationsFiles(listOwner)) == null) {
            List<AnnotationData> list2 = NO_DATA;
            if (list2 == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(26);
            }
            return list2;
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner, false);
        if (externalName == null) {
            List<AnnotationData> list3 = NO_DATA;
            if (list3 == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(27);
            }
            return list3;
        }
        SmartList<AnnotationData> result2 = new SmartList<AnnotationData>();
        for (PsiFile file2 : files2) {
            if (!file2.isValid() || onlyWritable && !file2.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file2);
            ContainerUtil.addAll(result2, fileData.get(externalName));
        }
        if (result2.isEmpty()) {
            List<AnnotationData> list4 = NO_DATA;
            if (list4 == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(28);
            }
            return list4;
        }
        result2.trimToSize();
        SmartList<AnnotationData> smartList = result2;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(29);
        }
        return smartList;
    }

    @Override
    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        PsiFile containingFile;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(30);
        }
        if (!((containingFile = PsiUtil.preferCompiledElement(listOwner).getContainingFile()) instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        List files2 = (List)this.myExternalAnnotationsCache.get(virtualFile2);
        if (files2 == NULL_LIST) {
            return null;
        }
        if (files2 != null) {
            boolean allValid = true;
            for (Object file2 : files2) {
                if (file2.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files2;
            }
        }
        THashSet<PsiFile> possibleAnnotationXmls = new THashSet<PsiFile>();
        String relativePath = ((PsiJavaFile)containingFile).getPackageName().replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root2 : this.getExternalAnnotationsRoots(virtualFile2)) {
            PsiFile psiFile;
            VirtualFile ext = root2.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationXmls.add(psiFile);
        }
        if (possibleAnnotationXmls.isEmpty()) {
            this.myExternalAnnotationsCache.put(virtualFile2, NULL_LIST);
            return null;
        }
        SmartList<PsiFile> result2 = new SmartList<PsiFile>((Collection<PsiFile>)possibleAnnotationXmls);
        result2.sort((f1, f2) -> {
            boolean w2;
            boolean w1 = f1.isWritable();
            return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
        });
        this.myExternalAnnotationsCache.put(virtualFile2, result2);
        return result2;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotationsCache.clear();
        this.myAnnotationFileToDataAndModStampCache.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(31);
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(32);
        }
        return stringBuilder;
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(33);
        }
        if (annotationFQName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(34);
        }
        if (fromFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(35);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(36);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(37);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(38);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(39);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(40);
        }
        throw new UnsupportedOperationException();
    }

    void cacheExternalAnnotations(@NotNull String packageName, @NotNull PsiFile fromFile, @NotNull List<PsiFile> annotationFiles) {
        VirtualFile virtualFile2;
        if (packageName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(41);
        }
        if (fromFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(42);
        }
        if (annotationFiles == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(43);
        }
        if ((virtualFile2 = fromFile.getVirtualFile()) != null) {
            this.myExternalAnnotationsCache.put(virtualFile2, annotationFiles);
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(44);
        }
        annotation2.putUserData(EXTERNAL_ANNO_MARKER, Boolean.TRUE);
        ((LightVirtualFile)annotation2.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(45);
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text2, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text2 + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(46);
        return psiAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 25: 
            case 30: 
            case 33: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 23: 
            case 37: 
            case 39: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 22: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidXml";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExternalAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollect";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAttributes";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExternalName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationRootsForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotationWritable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findByFQN";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectExternalAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 46: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "duplicateError";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doCollect";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsFiles";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "escapeAttributes";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternally";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "deannotate";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlace";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "cacheExternalAnnotations";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "markAsExternalAnnotation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByFQN$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData = new MostlySingularMultiMap();
        private final PsiFile myFile;
        private String myExternalName;
        private String myAnnotationFqn;
        private StringBuilder myArguments;

        private DataParsingSaxHandler(PsiFile file2) {
            this.myFile = file2;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.myArguments.append(name);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                String argumentsString = this.myArguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.myArguments.toString());
                for (AnnotationData existingData : this.myData.get(this.myExternalName)) {
                    if (!existingData.annotationClassFqName.equals(this.myAnnotationFqn)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                AnnotationData data2 = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add(this.myExternalName, BaseExternalAnnotationsManager.this.internAnnotationData(data2));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.myData.compact();
            return this.myData;
        }
    }

    public static class AnnotationData {
        private final String annotationClassFqName;
        private final String annotationParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters2) {
            if (fqn == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (parameters2 == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            this.annotationClassFqName = fqn;
            this.annotationParameters = parameters2;
        }

        @NotNull
        public PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            PsiAnnotation a;
            if (context == null) {
                AnnotationData.$$$reportNull$$$0(2);
            }
            if ((a = this.myAnnotation) == null) {
                String text2 = "@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")");
                this.myAnnotation = a = context.createAnnotationFromText(text2);
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                AnnotationData.$$$reportNull$$$0(3);
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data2 = (AnnotationData)o;
            return this.annotationClassFqName.equals(data2.annotationClassFqName) && this.annotationParameters.equals(data2.annotationParameters);
        }

        public int hashCode() {
            int result2 = this.annotationClassFqName.hashCode();
            result2 = 31 * result2 + this.annotationParameters.hashCode();
            return result2;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnnotation";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

