/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    private static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    protected static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "javax.annotation.CheckForNull", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable"};

    public NullableNotNullManager(Project project) {
        this.myProject = project;
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    private static void addAllIfNotPresent(@NotNull Collection<String> collection, String ... annotations2) {
        if (collection == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        if (annotations2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        for (String annotation2 : annotations2) {
            LOG.assertTrue(annotation2 != null);
            if (collection.contains(annotation2)) continue;
            collection.add(annotation2);
        }
    }

    public void setNotNulls(String ... annotations2) {
        if (annotations2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        this.myNotNulls.clear();
        for (String annotation2 : this.getPredefinedNotNulls()) {
            LOG.assertTrue(annotation2 != null);
            if (this.myNotNulls.contains(annotation2)) continue;
            this.myNotNulls.add(annotation2);
        }
        NullableNotNullManager.addAllIfNotPresent(this.myNotNulls, annotations2);
    }

    public void setNullables(String ... annotations2) {
        if (annotations2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        this.myNullables.clear();
        NullableNotNullManager.addAllIfNotPresent(this.myNullables, DEFAULT_NULLABLES);
        NullableNotNullManager.addAllIfNotPresent(this.myNullables, annotations2);
    }

    @NotNull
    public String getDefaultNullable() {
        String string = this.myDefaultNullable;
        if (string == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getNullable(@NotNull PsiModifierListOwner owner) {
        PsiAnnotation annotation2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        return (annotation2 = this.getNullableAnnotation(owner, false)) == null ? null : annotation2.getQualifiedName();
    }

    private String checkContainer(PsiAnnotation annotation2, boolean acceptContainer) {
        if (annotation2 == null) {
            return null;
        }
        if (!acceptContainer && this.isContainerAnnotation(annotation2)) {
            return null;
        }
        return annotation2.getQualifiedName();
    }

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, true);
    }

    public boolean isContainerAnnotation(@NotNull PsiAnnotation anno) {
        PsiAnnotation.TargetType[] acceptAnyTarget;
        if (anno == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        return NullableNotNullManager.isNullabilityDefault(anno, true, acceptAnyTarget = PsiAnnotation.TargetType.values()) || NullableNotNullManager.isNullabilityDefault(anno, false, acceptAnyTarget);
    }

    public void setDefaultNullable(@NotNull String defaultNullable) {
        if (defaultNullable == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
    }

    @NotNull
    public String getDefaultNotNull() {
        String string = this.myDefaultNotNull;
        if (string == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        return this.copyAnnotation(this.getNotNullAnnotation(original, false), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        return this.copyAnnotation(this.getNullableAnnotation(original, false), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        PsiAnnotation annotation2;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        if ((annotation2 = this.getNullableAnnotation(original, false)) == null) {
            annotation2 = this.getNotNullAnnotation(original, false);
        }
        return this.copyAnnotation(annotation2, generated);
    }

    @Nullable
    private PsiAnnotation copyAnnotation(PsiAnnotation annotation2, PsiModifierListOwner target) {
        PsiModifierList modifierList;
        String qualifiedName2;
        if (annotation2 != null && !AnnotationTargetUtil.isTypeAnnotation(annotation2) && (qualifiedName2 = this.checkContainer(annotation2, false)) != null && (modifierList = target.getModifierList()) != null && modifierList.findAnnotation(qualifiedName2) == null) {
            return modifierList.addAnnotation(qualifiedName2);
        }
        return null;
    }

    public PsiAnnotation copyNotNullAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNotNullAnnotation(owner, false));
    }

    public PsiAnnotation copyNullableAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNullableAnnotation(owner, false));
    }

    private PsiAnnotation copyAnnotation(PsiModifierListOwner owner, PsiAnnotation annotation2) {
        String notNull = this.checkContainer(annotation2, false);
        return notNull != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + notNull, owner) : null;
    }

    @Nullable
    public String getNotNull(@NotNull PsiModifierListOwner owner) {
        PsiAnnotation annotation2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        return (annotation2 = this.getNotNullAnnotation(owner, false)) == null ? null : annotation2.getQualifiedName();
    }

    public void setDefaultNotNull(@NotNull String defaultNotNull) {
        if (defaultNotNull == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
    }

    @Nullable
    private PsiAnnotation findNullabilityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        List<PsiParameter> superParameters;
        PsiAnnotation annotation2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(20);
        }
        if ((annotation2 = this.findPlainNullabilityAnnotation(owner, checkBases)) != null) {
            List<String> contradictory;
            String qName = annotation2.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list2 = contradictory = nullable ? this.getNotNullsWithNickNames() : this.getNullablesWithNickNames();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation2;
        }
        PsiType type2 = NullableNotNullManager.getOwnerType(owner);
        if (type2 == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated(owner, nullable ? this.getPredefinedNotNulls() : Arrays.asList(DEFAULT_NULLABLES), checkBases, false)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        if (owner instanceof PsiParameter && !nullable && checkBases && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            return this.takeAnnotationFromSuperParameters((PsiParameter)owner, superParameters);
        }
        return NullableNotNullManager.findNullabilityDefaultInHierarchy(owner, nullable);
    }

    private PsiAnnotation takeAnnotationFromSuperParameters(@NotNull PsiParameter owner, List<PsiParameter> superOwners) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(21);
        }
        return RecursionManager.doPreventingRecursion(owner, true, () -> {
            for (PsiParameter superOwner : superOwners) {
                PsiAnnotation anno = this.findNullabilityAnnotationWithDefault(superOwner, false, false);
                if (anno == null) continue;
                return anno;
            }
            return null;
        });
    }

    private PsiAnnotation findPlainNullabilityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        HashSet<String> qNames = ContainerUtil.newHashSet(this.getNullablesWithNickNames());
        qNames.addAll(this.getNotNullsWithNickNames());
        PsiAnnotation memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qNames) : AnnotationUtil.findAnnotation(owner, qNames);
        PsiType type2 = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null) {
            return NullableNotNullManager.preferTypeAnnotation(memberAnno, type2);
        }
        if (type2 != null) {
            return ContainerUtil.find(type2.getAnnotations(), a -> qNames.contains(a.getQualifiedName()));
        }
        return null;
    }

    private static PsiAnnotation preferTypeAnnotation(@NotNull PsiAnnotation memberAnno, @Nullable PsiType type2) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        if (type2 != null) {
            for (PsiAnnotation typeAnno : type2.getApplicableAnnotations()) {
                if (!NullableNotNullManager.areDifferentNullityAnnotations(memberAnno, typeAnno)) continue;
                return typeAnno;
            }
        }
        return memberAnno;
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, PsiAnnotation typeAnno) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(24);
        }
        return NullableNotNullManager.isNullableAnnotation(typeAnno) && NullableNotNullManager.isNotNullAnnotation(memberAnno) || NullableNotNullManager.isNullableAnnotation(memberAnno) && NullableNotNullManager.isNotNullAnnotation(typeAnno);
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list2 = this.getNullables();
        if (list2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list2 = this.getNotNulls();
        if (list2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        return list2;
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    static PsiAnnotation findNullabilityDefaultInHierarchy(PsiModifierListOwner owner, boolean nullable) {
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            PsiAnnotation annotation2;
            if (element instanceof PsiModifierListOwner && (annotation2 = NullableNotNullManager.getNullabilityDefault((PsiModifierListOwner)element, nullable, placeTargetTypes)) != null) {
                return annotation2;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
            return psiPackage == null ? null : NullableNotNullManager.getNullabilityDefault(psiPackage, nullable, placeTargetTypes);
        }
        return null;
    }

    private static PsiAnnotation getNullabilityDefault(@NotNull PsiModifierListOwner container2, boolean nullable, PsiAnnotation.TargetType[] placeTargetTypes) {
        PsiModifierList modifierList;
        if (container2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        if ((modifierList = container2.getModifierList()) == null) {
            return null;
        }
        for (PsiAnnotation annotation2 : modifierList.getAnnotations()) {
            if (!NullableNotNullManager.isNullabilityDefault(annotation2, nullable, placeTargetTypes)) continue;
            return annotation2;
        }
        return null;
    }

    private static boolean isNullabilityDefault(@NotNull PsiAnnotation annotation2, boolean nullable, PsiAnnotation.TargetType[] placeTargetTypes) {
        String fqn;
        PsiJavaCodeReferenceElement element;
        PsiElement declaration;
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(30);
        }
        PsiElement psiElement = declaration = (element = annotation2.getNameReferenceElement()) == null ? null : element.resolve();
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        String string = fqn = nullable ? JAVAX_ANNOTATION_NULLABLE : JAVAX_ANNOTATION_NONNULL;
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)declaration), fqn, false, true)) {
            return false;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)declaration), true, "javax.annotation.meta.TypeQualifierDefault");
        if (tqDefault == null) {
            return false;
        }
        Set<PsiAnnotation.TargetType> required = AnnotationTargetUtil.extractRequiredAnnotationTargets(tqDefault.findAttributeValue(null));
        return required != null && (required.isEmpty() || ContainerUtil.intersects(required, Arrays.asList(placeTargetTypes)));
    }

    @NotNull
    public List<String> getNullables() {
        JDOMExternalizableStringList jDOMExternalizableStringList = this.myNullables;
        if (jDOMExternalizableStringList == null) {
            NullableNotNullManager.$$$reportNull$$$0(31);
        }
        return jDOMExternalizableStringList;
    }

    @NotNull
    public List<String> getNotNulls() {
        JDOMExternalizableStringList jDOMExternalizableStringList = this.myNotNulls;
        if (jDOMExternalizableStringList == null) {
            NullableNotNullManager.$$$reportNull$$$0(32);
        }
        return jDOMExternalizableStringList;
    }

    boolean hasDefaultValues() {
        int i;
        List<String> predefinedNotNulls = this.getPredefinedNotNulls();
        if (DEFAULT_NULLABLES.length != this.getNullables().size() || predefinedNotNulls.size() != this.getNotNulls().size()) {
            return false;
        }
        if (!this.myDefaultNotNull.equals("org.jetbrains.annotations.NotNull") || !this.myDefaultNullable.equals("org.jetbrains.annotations.Nullable")) {
            return false;
        }
        for (i = 0; i < DEFAULT_NULLABLES.length; ++i) {
            if (this.getNullables().get(i).equals(DEFAULT_NULLABLES[i])) continue;
            return false;
        }
        for (i = 0; i < predefinedNotNulls.size(); ++i) {
            if (this.getNotNulls().get(i).equals(predefinedNotNulls.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(33);
        }
        return NullableNotNullManager.getInstance(owner.getProject()).isNullable(owner, true);
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(34);
        }
        return NullableNotNullManager.getInstance(owner.getProject()).isNotNull(owner, true);
    }

    public abstract List<String> getPredefinedNotNulls();

    public static boolean isNullableAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(35);
        }
        return NullableNotNullManager.getInstance(annotation2.getProject()).getNullablesWithNickNames().contains(annotation2.getQualifiedName());
    }

    public static boolean isNotNullAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(36);
        }
        return NullableNotNullManager.getInstance(annotation2.getProject()).getNotNullsWithNickNames().contains(annotation2.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 5: 
            case 10: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNullable";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNotNull";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberAnno";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 30: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultNullable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultNotNull";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullables";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasNullability";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAllIfNotPresent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNotNulls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNullables";
                break;
            }
            case 5: 
            case 10: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNullable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isContainerAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultNullable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAnnotation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNotNull";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultNotNull";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findNullabilityAnnotationWithDefault";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "takeAnnotationFromSuperParameters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPlainNullabilityAnnotation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "preferTypeAnnotation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "areDifferentNullityAnnotations";
                break;
            }
            case 27: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 28: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityDefault";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityDefault";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isNullableAnnotation";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

