/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.HighlightDisplayKey");
    private static final Map<String, HighlightDisplayKey> ourNameToKeyMap = new THashMap<String, HighlightDisplayKey>();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new THashMap<String, HighlightDisplayKey>();
    private static final Map<HighlightDisplayKey, Computable<String>> ourKeyToDisplayNameMap = new THashMap<HighlightDisplayKey, Computable<String>>();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new THashMap<HighlightDisplayKey, String>();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls @NotNull String name) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(0);
        }
        return ourNameToKeyMap.get(name);
    }

    @Nullable
    public static HighlightDisplayKey findById(@NonNls @NotNull String id) {
        HighlightDisplayKey key;
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(1);
        }
        if ((key = ourIdToKeyMap.get(id)) != null) {
            return key;
        }
        key = ourNameToKeyMap.get(id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name) {
        HighlightDisplayKey key;
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(2);
        }
        if ((key = HighlightDisplayKey.find(name)) != null) {
            LOG.error("Key with name '" + name + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        return new HighlightDisplayKey(name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(4);
        }
        return HighlightDisplayKey.register(name, displayName, name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(6);
        }
        return HighlightDisplayKey.register(name, displayName, name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName, @NotNull @NonNls String id) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(7);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(8);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(9);
        }
        return HighlightDisplayKey.register(name, new Computable.PredefinedValueComputable<String>(displayName), id);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName, @NotNull @NonNls String id) {
        HighlightDisplayKey key;
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(10);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(11);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(12);
        }
        if ((key = HighlightDisplayKey.find(name)) != null) {
            LOG.error("Key with name '" + name + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull Computable<String> displayName, @NonNls @NotNull String id, @NonNls @Nullable String alternativeID) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(13);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(14);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(15);
        }
        HighlightDisplayKey key = HighlightDisplayKey.register(name, displayName, id);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name, @NotNull String displayName) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(16);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(17);
        }
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.findOrRegister(name, displayName, null);
        if (highlightDisplayKey == null) {
            HighlightDisplayKey.$$$reportNull$$$0(18);
        }
        return highlightDisplayKey;
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name, @NotNull String displayName, @NonNls @Nullable String id) {
        HighlightDisplayKey key;
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(19);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(20);
        }
        if ((key = HighlightDisplayKey.find(name)) == null) {
            key = HighlightDisplayKey.register(name, displayName, id != null ? id : name);
            assert (key != null) : name;
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            HighlightDisplayKey.$$$reportNull$$$0(21);
        }
        return highlightDisplayKey;
    }

    @Nullable
    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : computable.compute();
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            HighlightDisplayKey.$$$reportNull$$$0(22);
        }
        return ourKeyToAlternativeIDMap.get(key);
    }

    private HighlightDisplayKey(@NonNls @NotNull String name) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(23);
        }
        this(name, name);
    }

    public HighlightDisplayKey(@NonNls @NotNull String name, @NonNls @NotNull String ID2) {
        if (name == null) {
            HighlightDisplayKey.$$$reportNull$$$0(24);
        }
        if (ID2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(25);
        }
        this.myName = name;
        this.myID = ID2;
        ourNameToKeyMap.put(this.myName, this);
        if (!Comparing.equal(ID2, name)) {
            ourIdToKeyMap.put(ID2, this);
        }
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            HighlightDisplayKey.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrRegister";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findOrRegister";
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeID";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

