/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveSuppressWarningAction
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction");
    @NotNull
    private final String myID;
    private final String myProblemLine;

    public RemoveSuppressWarningAction(@NotNull String ID2, String problemLine) {
        if (ID2 == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(0);
        }
        this.myID = ID2;
        this.myProblemLine = problemLine;
    }

    public RemoveSuppressWarningAction(@NotNull String id) {
        if (id == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(1);
        }
        int idx = id.indexOf(";");
        if (idx > -1) {
            this.myID = id.substring(0, idx);
            this.myProblemLine = id.substring(idx);
        } else {
            this.myID = id;
            this.myProblemLine = null;
        }
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.suppression.action.family", new Object[0]);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(4);
        }
        PsiElement element = descriptor2.getPsiElement();
        try {
            PsiJavaDocumentedElement commentOwner;
            if (element != null && (commentOwner = PsiTreeUtil.getParentOfType(element, PsiJavaDocumentedElement.class)) != null) {
                PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(commentOwner, this.myID);
                if (psiElement instanceof PsiAnnotation) {
                    this.removeFromAnnotation((PsiAnnotation)psiElement);
                } else if (psiElement instanceof PsiDocComment) {
                    this.removeFromJavaDoc((PsiDocComment)psiElement);
                } else {
                    final HashSet comments = new HashSet();
                    commentOwner.accept(new PsiRecursiveElementWalkingVisitor(){

                        @Override
                        public void visitComment(PsiComment comment) {
                            super.visitComment(comment);
                            if (comment.getText().contains(RemoveSuppressWarningAction.this.myID)) {
                                comments.add(comment);
                            }
                        }
                    });
                    for (PsiComment comment : comments) {
                        try {
                            this.removeFromComment(comment, comments.size() > 1);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error(e);
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("remove.suppression.action.name", this.myID);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void removeFromComment(PsiComment comment, boolean checkLine) throws IncorrectOperationException {
        PsiStatement statement2;
        if (checkLine && (statement2 = PsiTreeUtil.getNextSiblingOfType(comment, PsiStatement.class)) != null && !Comparing.strEqual(statement2.getText(), this.myProblemLine)) {
            return;
        }
        String newText = this.removeFromElementText(comment);
        if (newText != null) {
            if (newText.isEmpty()) {
                comment.delete();
            } else {
                PsiComment newComment = JavaPsiFacade.getInstance(comment.getProject()).getElementFactory().createCommentFromText("// noinspection " + newText, comment);
                comment.replace(newComment);
            }
        }
    }

    private void removeFromJavaDoc(PsiDocComment docComment) throws IncorrectOperationException {
        PsiDocTag tag = docComment.findTagByName("noinspection");
        if (tag == null) {
            return;
        }
        String newText = this.removeFromElementText(tag.getDataElements());
        if (newText != null && newText.isEmpty()) {
            tag.delete();
        } else if (newText != null) {
            newText = "@noinspection " + newText;
            PsiDocTag newTag = JavaPsiFacade.getInstance(tag.getProject()).getElementFactory().createDocTagFromText(newText);
            tag.replace(newTag);
        }
    }

    @Nullable
    private String removeFromElementText(PsiElement ... elements) {
        String text2 = "";
        for (PsiElement element : elements) {
            text2 = text2 + StringUtil.trimStart(element.getText(), "//").trim();
        }
        text2 = StringUtil.trimStart(text2, "@").trim();
        List<String> ids = StringUtil.split(text2 = StringUtil.trimStart(text2, "noinspection").trim(), ",");
        int i = ArrayUtil.find(ids.toArray(), this.myID);
        if (i == -1) {
            return null;
        }
        ids.remove(i);
        return StringUtil.join(ids, ",");
    }

    private void removeFromAnnotation(PsiAnnotation annotation2) throws IncorrectOperationException {
        PsiNameValuePair[] attributes;
        for (PsiNameValuePair attribute : attributes = annotation2.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = attribute.getValue();
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer2 : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                    if (!this.removeFromValue(annotation2, initializer2, initializers.length == 1)) continue;
                    return;
                }
            }
            if (!this.removeFromValue(annotation2, value, attributes.length == 1)) continue;
            return;
        }
    }

    private boolean removeFromValue(PsiAnnotationMemberValue parent2, PsiAnnotationMemberValue value, boolean removeParent) throws IncorrectOperationException {
        String text2 = value.getText();
        text2 = StringUtil.trimStart(text2, "\"");
        if (this.myID.equals(text2 = StringUtil.trimEnd(text2, "\""))) {
            if (removeParent) {
                parent2.delete();
            } else {
                value.delete();
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

