/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightClassUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    @Nullable
    static HighlightInfo checkAbstractInstantiation(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            HighlightClassUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent2 = ref.getParent();
        HighlightInfo highlightInfo = null;
        if (parent2 instanceof PsiAnonymousClass && parent2.getParent() instanceof PsiNewExpression && !PsiUtilCore.hasErrorElementChild(parent2.getParent())) {
            PsiAnonymousClass aClass2 = (PsiAnonymousClass)parent2;
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods(aClass2, ref.getTextRange());
        }
        return highlightInfo;
    }

    @Nullable
    private static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass2, TextRange range) {
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass2, aClass2, range);
    }

    @Nullable
    static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass2, PsiElement implementsFixElement, TextRange range) {
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod(aClass2);
        if (abstractMethod == null) {
            return null;
        }
        PsiClass superClass = abstractMethod.getContainingClass();
        if (superClass == null) {
            return null;
        }
        String baseClassName = HighlightUtil.formatClass(aClass2, false);
        String methodName = JavaHighlightUtil.formatMethod(abstractMethod);
        String message = JavaErrorMessages.message(aClass2 instanceof PsiEnumConstantInitializer || implementsFixElement instanceof PsiEnumConstant ? "enum.constant.should.implement.method" : "class.must.be.abstract", baseClassName, methodName, HighlightUtil.formatClass(superClass, false));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        PsiMethod anyMethodToImplement = ClassUtil.getAnyMethodToImplement(aClass2);
        if (anyMethodToImplement != null) {
            if (!anyMethodToImplement.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance(aClass2.getProject()).arePackagesTheSame(aClass2, superClass)) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createImplementMethodsFix(implementsFixElement));
            } else {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(anyMethodToImplement, "protected", true, true));
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(anyMethodToImplement, "public", true, true));
            }
        }
        if (!(aClass2 instanceof PsiAnonymousClass) && HighlightUtil.getIncompatibleModifier("abstract", aClass2.getModifierList()) == null) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "abstract", true, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkClassMustBeAbstract(PsiClass aClass2, TextRange textRange) {
        if (aClass2.hasModifierProperty("abstract") || aClass2.getRBrace() == null || aClass2.isEnum() && HighlightClassUtil.hasEnumConstants(aClass2)) {
            return null;
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass2, textRange);
    }

    @Nullable
    static HighlightInfo checkInstantiationOfAbstractClass(PsiClass aClass2, @NotNull PsiElement highlightElement) {
        if (highlightElement == null) {
            HighlightClassUtil.$$$reportNull$$$0(1);
        }
        HighlightInfo errorResult = null;
        if (!(aClass2 == null || !aClass2.hasModifierProperty("abstract") || highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getType() instanceof PsiArrayType)) {
            String baseClassName = aClass2.getName();
            String message = JavaErrorMessages.message("abstract.cannot.be.instantiated", baseClassName);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(highlightElement).descriptionAndTooltip(message).create();
            PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod(aClass2);
            if (!aClass2.isInterface() && anyAbstractMethod == null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "abstract", false, false));
            }
            if (anyAbstractMethod != null && highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getClassReference() != null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createImplementAbstractClassMethodsFix(highlightElement));
            }
        }
        return errorResult;
    }

    private static boolean hasEnumConstants(PsiClass aClass2) {
        PsiField[] fields2;
        for (PsiField field : fields2 = aClass2.getFields()) {
            if (!(field instanceof PsiEnumConstant)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkDuplicateTopLevelClass(PsiClass aClass2) {
        if (!(aClass2.getParent() instanceof PsiFile)) {
            return null;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        if (qualifiedName2 == null) {
            return null;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName2.contains("$")) {
            qualifiedName2 = qualifiedName2.replaceAll("\\$", ".");
            numOfClassesToFind = 1;
        }
        PsiManager manager = aClass2.getManager();
        Module module2 = ModuleUtilCore.findModuleForPsiElement(aClass2);
        if (module2 == null) {
            return null;
        }
        PsiClass[] classes2 = JavaPsiFacade.getInstance(aClass2.getProject()).findClasses(qualifiedName2, GlobalSearchScope.moduleScope(module2).intersectWith(aClass2.getResolveScope()));
        if (classes2.length < numOfClassesToFind) {
            return null;
        }
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance(module2).getFileIndex();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(aClass2);
        if (virtualFile2 == null) {
            return null;
        }
        boolean isTestSourceRoot = fileIndex.isInTestSourceContent(virtualFile2);
        String dupFileName = null;
        for (PsiClass dupClass : classes2) {
            VirtualFile file2;
            if (dupClass == aClass2 || (file2 = dupClass.getContainingFile().getVirtualFile()) == null || !manager.isInProject(dupClass) || fileIndex.isInTestSourceContent(file2) != isTestSourceRoot) continue;
            dupFileName = FileUtil.toSystemDependentName(file2.getPath());
            break;
        }
        if (dupFileName == null) {
            return null;
        }
        String message = JavaErrorMessages.message("duplicate.class.in.other.file", dupFileName);
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message).create();
    }

    @Nullable
    static HighlightInfo checkDuplicateNestedClass(PsiClass aClass2) {
        String name;
        if (aClass2 == null) {
            return null;
        }
        PsiElement parent2 = aClass2;
        if (aClass2.getParent() instanceof PsiDeclarationStatement) {
            parent2 = aClass2.getParent();
        }
        if ((name = aClass2.getName()) == null) {
            return null;
        }
        boolean duplicateFound = false;
        boolean checkSiblings = true;
        while (parent2 != null && !(parent2 instanceof PsiFile)) {
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent2.getPrevSibling() : null;
            if (element == null && ((element = parent2.getParent()) instanceof PsiMethod || element instanceof PsiClass || element instanceof PsiCodeBlock && element.getParent() instanceof PsiClassInitializer)) {
                checkSiblings = false;
            }
            parent2 = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType(element, PsiClass.class);
            }
            if (!(element instanceof PsiClass) || !name.equals(((PsiClass)element).getName())) continue;
            duplicateFound = true;
            break;
        }
        if (duplicateFound) {
            String message = JavaErrorMessages.message("duplicate.class", name);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPublicClassInRightFile(PsiClass aClass2) {
        PsiFile containingFile = aClass2.getContainingFile();
        if (aClass2.getParent() != containingFile || !aClass2.hasModifierProperty("public") || !(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile file2 = (PsiJavaFile)containingFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null || virtualFile2.getNameWithoutExtension().equals(aClass2.getName())) {
            return null;
        }
        String message = JavaErrorMessages.message("public.class.should.be.named.after.file", aClass2.getName());
        TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(aClass2, range.getStartOffset(), range.getEndOffset()).descriptionAndTooltip(message).create();
        PsiModifierList psiModifierList = aClass2.getModifierList();
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(psiModifierList, "public", false, false));
        PsiClass[] classes2 = file2.getClasses();
        if (classes2.length > 1) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMoveClassToSeparateFileFix(aClass2));
        }
        for (PsiClass otherClass : classes2) {
            if (otherClass.getManager().areElementsEquivalent(otherClass, aClass2) || !otherClass.hasModifierProperty("public") || !virtualFile2.getNameWithoutExtension().equals(otherClass.getName())) continue;
            return errorResult;
        }
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createRenameFileFix(aClass2.getName() + ".java"));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createRenameElementFix(aClass2));
        return errorResult;
    }

    static HighlightInfo checkVarClassConflict(PsiClass psiClass, PsiIdentifier identifier) {
        String className2 = psiClass.getName();
        if (className2 != null && "var".equals(className2)) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("'var' is a restricted local variable type and cannot be used for type declarations").range(identifier).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassAndPackageConflict(@NotNull PsiClass aClass2) {
        String simpleName2;
        PsiDirectory subDirectory;
        PsiElement directory;
        String name;
        if (aClass2 == null) {
            HighlightClassUtil.$$$reportNull$$$0(2);
        }
        if ("java.lang".equals(name = aClass2.getQualifiedName())) {
            String message = JavaErrorMessages.message("class.clashes.with.package", name);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        }
        PsiElement file2 = aClass2.getParent();
        if (file2 instanceof PsiJavaFile && !((PsiJavaFile)file2).getPackageName().isEmpty() && (directory = file2.getParent()) instanceof PsiDirectory && (subDirectory = ((PsiDirectory)directory).findSubdirectory(simpleName2 = aClass2.getName())) != null && simpleName2.equals(subDirectory.getName()) && PsiTreeUtil.findChildOfType(subDirectory, PsiJavaFile.class) != null) {
            String message = JavaErrorMessages.message("class.clashes.with.package", name);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkStaticFieldDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(3);
        }
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiField.class) == null) {
            return null;
        }
        PsiField field = (PsiField)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild(field) || PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(result2, QUICK_FIX_FACTORY.createModifierListFix(field, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(result2, field.getContainingClass());
        return result2;
    }

    private static void registerMakeInnerClassStatic(HighlightInfo result2, PsiClass aClass2) {
        if (aClass2 != null && aClass2.getContainingClass() != null) {
            QuickFixAction.registerQuickFixAction(result2, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "static", true, false));
        }
    }

    @Nullable
    private static HighlightInfo checkStaticMethodDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiMethod.class) == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild(method)) {
            return null;
        }
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(result2, QUICK_FIX_FACTORY.createModifierListFix(method, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(result2, (PsiClass)keyword.getParent().getParent().getParent());
        return result2;
    }

    @Nullable
    private static HighlightInfo checkStaticInitializerDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiClassInitializer.class) == null) {
            return null;
        }
        PsiClassInitializer initializer2 = (PsiClassInitializer)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild(initializer2)) {
            return null;
        }
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(result2, QUICK_FIX_FACTORY.createModifierListFix(initializer2, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(result2, (PsiClass)keyword.getParent().getParent().getParent());
        return result2;
    }

    private static PsiElement getEnclosingStaticClass(@NotNull PsiKeyword keyword, @NotNull Class<?> parentClass) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(4);
        }
        if (parentClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(5);
        }
        return new PsiMatcherImpl(keyword).dot(PsiMatchers.hasText("static")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(parentClass)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement();
    }

    @Nullable
    private static HighlightInfo checkStaticClassDeclarationInInnerClass(PsiKeyword keyword) {
        if (new PsiMatcherImpl(keyword).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", true)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement() == null) {
            return null;
        }
        PsiClass aClass2 = (PsiClass)keyword.getParent();
        if (PsiUtilCore.hasErrorElementChild(aClass2)) {
            return null;
        }
        PsiElement context = null;
        PsiModifierList modifierList = aClass2.getModifierList();
        if (modifierList != null) {
            for (PsiElement element : modifierList.getChildren()) {
                if (!Comparing.equal(element.getText(), "static")) continue;
                context = element;
                break;
            }
        }
        TextRange range = context != null ? context.getTextRange() : HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        if (context != keyword) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "static", false, false));
        }
        PsiClass containingClass = aClass2.getContainingClass();
        HighlightClassUtil.registerMakeInnerClassStatic(info, containingClass);
        return info;
    }

    @Nullable
    static HighlightInfo checkStaticDeclarationInInnerClass(PsiKeyword keyword) {
        HighlightInfo errorResult = HighlightClassUtil.checkStaticFieldDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticMethodDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticClassDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticInitializerDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsAllowed(PsiReferenceList list2) {
        boolean isExtends;
        PsiClass aClass2;
        if (list2.getParent() instanceof PsiClass && (aClass2 = (PsiClass)list2.getParent()).isEnum() && (isExtends = list2.equals(aClass2.getExtendsList()))) {
            String description2 = JavaErrorMessages.message("extends.after.enum", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkImplementsAllowed(PsiReferenceList list2) {
        boolean isImplements;
        PsiClass aClass2;
        if (list2.getParent() instanceof PsiClass && (aClass2 = (PsiClass)list2.getParent()).isInterface() && (isImplements = list2.equals(aClass2.getImplementsList()))) {
            String description2 = JavaErrorMessages.message("implements.after.interface", new Object[0]);
            HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description2).create();
            PsiClassType[] referencedTypes = list2.getReferencedTypes();
            if (referencedTypes.length > 0) {
                QuickFixAction.registerQuickFixAction(result2, QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass2, referencedTypes[0]));
            }
            return result2;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsClassAndImplementsInterface(PsiReferenceList referenceList, JavaResolveResult resolveResult, PsiJavaCodeReferenceElement ref) {
        PsiClass aClass2 = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals(aClass2.getImplementsList());
        boolean isInterface = aClass2.isInterface();
        if (isInterface && isImplements) {
            return null;
        }
        boolean mustBeInterface = isImplements || isInterface;
        HighlightInfo errorResult = null;
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom.isInterface() != mustBeInterface) {
            String message = JavaErrorMessages.message(mustBeInterface ? "interface.expected" : "no.interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(message).create();
            PsiClassType type2 = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(ref);
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass2, type2));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkCannotInheritFromFinal(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            String message = JavaErrorMessages.message("inheritance.from.final.class", superClass.getQualifiedName());
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(superClass, "final", false, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAnonymousInheritFinal(PsiNewExpression expression2) {
        PsiAnonymousClass aClass2 = PsiTreeUtil.getChildOfType(expression2, PsiAnonymousClass.class);
        if (aClass2 == null) {
            return null;
        }
        PsiClassType baseClassReference = aClass2.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return null;
        }
        return HighlightClassUtil.checkCannotInheritFromFinal(baseClass, aClass2.getBaseClassReference());
    }

    @Nullable
    private static String checkDefaultConstructorThrowsException(PsiMethod constructor, @NotNull PsiClassType[] handledExceptions) {
        if (handledExceptions == null) {
            HighlightClassUtil.$$$reportNull$$$0(6);
        }
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException(referencedType) || ExceptionUtil.isHandledBy(referencedType, handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            return HighlightUtil.getUnhandledExceptionsDescriptor(exceptions);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassDoesNotCallSuperConstructorOrHandleExceptions(@NotNull PsiClass aClass2, RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        if (aClass2 == null) {
            HighlightClassUtil.$$$reportNull$$$0(7);
        }
        if (resolveHelper == null) {
            HighlightClassUtil.$$$reportNull$$$0(8);
        }
        if (aClass2.isEnum()) {
            return null;
        }
        if (aClass2.getConstructors().length != 0) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
        return HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass2, refCountHolder, resolveHelper, textRange, PsiClassType.EMPTY_ARRAY);
    }

    static HighlightInfo checkBaseClassDefaultConstructorProblem(@NotNull PsiClass aClass2, RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper, @NotNull TextRange range, @NotNull PsiClassType[] handledExceptions) {
        if (aClass2 == null) {
            HighlightClassUtil.$$$reportNull$$$0(9);
        }
        if (resolveHelper == null) {
            HighlightClassUtil.$$$reportNull$$$0(10);
        }
        if (range == null) {
            HighlightClassUtil.$$$reportNull$$$0(11);
        }
        if (handledExceptions == null) {
            HighlightClassUtil.$$$reportNull$$$0(12);
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass baseClass = aClass2.getSuperClass();
        if (baseClass == null) {
            return null;
        }
        PsiMethod[] constructors2 = baseClass.getConstructors();
        if (constructors2.length == 0) {
            return null;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace(aClass2, aClass2.getProject(), baseClass);
        List constructorCandidates = (resolved != null ? Collections.singletonList((PsiMethod)resolved) : Arrays.asList(constructors2)).stream().filter(constructor -> {
            PsiParameter[] parameters2;
            if (resolveHelper == null) {
                HighlightClassUtil.$$$reportNull$$$0(16);
            }
            if (aClass2 == null) {
                HighlightClassUtil.$$$reportNull$$$0(17);
            }
            return ((parameters2 = constructor.getParameterList().getParameters()).length == 0 || parameters2.length == 1 && parameters2[0].isVarArgs()) && resolveHelper.isAccessible((PsiMember)constructor, aClass2, null);
        }).limit(2L).collect(Collectors.toList());
        if (constructorCandidates.size() >= 2) {
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)constructorCandidates.get(0), PsiSubstitutor.EMPTY, 4353, 2);
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)constructorCandidates.get(1), PsiSubstitutor.EMPTY, 4353, 2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(JavaErrorMessages.message("ambiguous.method.call", m1, m2)).create();
        }
        if (!constructorCandidates.isEmpty()) {
            PsiMethod constructor2 = (PsiMethod)constructorCandidates.get(0);
            String description2 = HighlightClassUtil.checkDefaultConstructorThrowsException(constructor2, handledExceptions);
            if (description2 != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description2).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass2));
                return info;
            }
            if (refCountHolder != null) {
                refCountHolder.registerLocallyReferenced(constructor2);
            }
            return null;
        }
        String description3 = JavaErrorMessages.message("no.default.constructor.available", HighlightUtil.formatClass(baseClass));
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description3).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass2));
        return info;
    }

    @Nullable
    static HighlightInfo checkInterfaceCannotBeLocal(PsiClass aClass2) {
        if (PsiUtil.isLocalClass(aClass2)) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            String description2 = JavaErrorMessages.message("interface.cannot.be.local", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCyclicInheritance(PsiClass aClass2) {
        PsiClass circularClass = HighlightClassUtil.getCircularClass(aClass2, new HashSet<PsiClass>());
        if (circularClass != null) {
            String description2 = JavaErrorMessages.message("cyclic.inheritance", HighlightUtil.formatClass(circularClass));
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiClass getCircularClass(PsiClass aClass2, Collection<PsiClass> usedClasses) {
        if (usedClasses.contains(aClass2)) {
            return aClass2;
        }
        try {
            PsiClass[] superTypes2;
            usedClasses.add(aClass2);
            for (PsiElement superType : superTypes2 = aClass2.getSupers()) {
                while (superType instanceof PsiClass) {
                    PsiClass circularClass;
                    if (!"java.lang.Object".equals(superType.getQualifiedName()) && (circularClass = HighlightClassUtil.getCircularClass(superType, usedClasses)) != null) {
                        PsiClass psiClass = circularClass;
                        return psiClass;
                    }
                    superType = superType.getParent();
                }
            }
        }
        finally {
            usedClasses.remove(aClass2);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsDuplicate(PsiJavaCodeReferenceElement element, PsiElement resolved, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            HighlightClassUtil.$$$reportNull$$$0(13);
        }
        if (!(element.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList list2 = (PsiReferenceList)element.getParent();
        if (!(list2.getParent() instanceof PsiClass)) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass2 = (PsiClass)resolved;
        PsiClassType[] referencedTypes = list2.getReferencedTypes();
        int dupCount = 0;
        PsiManager manager = containingFile.getManager();
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass resolvedElement = referencedType.resolve();
            if (resolvedElement == null || !manager.areElementsEquivalent(resolvedElement, aClass2)) continue;
            ++dupCount;
        }
        if (dupCount > 1) {
            String description2 = JavaErrorMessages.message("duplicate.class", HighlightUtil.formatClass(aClass2));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassAlreadyImported(PsiClass aClass2, PsiElement elementToHighlight) {
        PsiImportStatementBase[] importStatements;
        PsiFile file2 = aClass2.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        if (aClass2.getParent() != javaFile) {
            return null;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return null;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass) || resolved.equals(aClass2) || !Comparing.equal(aClass2.getName(), ((PsiClass)resolved).getName(), true)) continue;
            String description2 = JavaErrorMessages.message("class.already.imported", HighlightUtil.formatClass(aClass2, false));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassExtendsOnlyOneClass(PsiReferenceList list2) {
        PsiClassType[] referencedTypes = list2.getReferencedTypes();
        PsiElement parent2 = list2.getParent();
        if (!(parent2 instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass2 = (PsiClass)parent2;
        if (!aClass2.isInterface() && referencedTypes.length > 1 && aClass2.getExtendsList() == list2) {
            String description2 = JavaErrorMessages.message("class.cannot.extend.multiple.classes", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThingNotAllowedInInterface(PsiElement element, PsiClass aClass2) {
        if (aClass2 == null || !aClass2.isInterface()) {
            return null;
        }
        String description2 = JavaErrorMessages.message("not.allowed.in.interface", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description2).create();
    }

    @Nullable
    static HighlightInfo checkQualifiedNew(PsiNewExpression expression2, PsiType type2, PsiClass aClass2) {
        PsiExpression qualifier = expression2.getQualifier();
        if (qualifier == null) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            String description2 = JavaErrorMessages.message("invalid.qualified.new", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, null));
            return info;
        }
        HighlightInfo info = null;
        if (aClass2 != null) {
            PsiClass baseClass;
            if (aClass2.hasModifierProperty("static")) {
                String description3 = JavaErrorMessages.message("qualified.new.of.static.class", new Object[0]);
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description3).create();
                if (!aClass2.isEnum()) {
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "static", false, false));
                }
            } else if (aClass2 instanceof PsiAnonymousClass && (baseClass = PsiUtil.resolveClassInType(((PsiAnonymousClass)aClass2).getBaseClassType())) != null && baseClass.isInterface()) {
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip("Anonymous class implements interface; cannot have qualifier for new").create();
            }
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, aClass2));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkClassExtendsForeignInnerClass(final PsiJavaCodeReferenceElement extendRef, final PsiElement resolved) {
        PsiClass containerClass;
        PsiElement parent2 = extendRef.getParent();
        if (!(parent2 instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grand = parent2.getParent();
        if (!(grand instanceof PsiClass)) {
            return null;
        }
        final PsiClass aClass2 = (PsiClass)grand;
        if (aClass2 instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)aClass2).getOwner();
            if (!(owner instanceof PsiClass)) {
                return null;
            }
            containerClass = (PsiClass)owner;
        } else {
            containerClass = aClass2;
        }
        if (aClass2.getExtendsList() != parent2 && aClass2.getImplementsList() != parent2) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            String description2 = JavaErrorMessages.message("class.name.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(extendRef).descriptionAndTooltip(description2).create();
        }
        final HighlightInfo[] infos2 = new HighlightInfo[1];
        extendRef.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (infos2[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiClass) {
                    PsiClass base = (PsiClass)resolve2;
                    PsiClass baseClass = base.getContainingClass();
                    if (baseClass != null && base.hasModifierProperty("private") && baseClass == containerClass) {
                        String description2 = JavaErrorMessages.message("private.symbol", HighlightUtil.formatClass(base), HighlightUtil.formatClass(baseClass));
                        infos2[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(extendRef).descriptionAndTooltip(description2).create();
                        return;
                    }
                    if (!PsiUtil.isInnerClass(base)) {
                        return;
                    }
                    if (!(resolve2 != resolved || baseClass == null || PsiTreeUtil.isAncestor(baseClass, extendRef, true) && !aClass2.hasModifierProperty("static") || InheritanceUtil.hasEnclosingInstanceInScope(baseClass, (PsiElement)extendRef, psiClass -> psiClass != aClass2, true) || HighlightClassUtil.qualifiedNewCalledInConstructors(aClass2))) {
                        String description3 = JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.formatClass(baseClass));
                        infos2[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(extendRef).descriptionAndTooltip(description3).create();
                    }
                }
            }
        });
        return infos2[0];
    }

    private static boolean qualifiedNewCalledInConstructors(PsiClass aClass2) {
        PsiMethod[] constructors2 = aClass2.getConstructors();
        if (constructors2.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors2) {
            PsiReferenceExpression referenceExpression;
            PsiExpression qualifierExpression;
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return false;
            }
            PsiStatement firstStatement = statements[0];
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!RefactoringChangeUtil.isSuperOrThisMethodCall(expression2)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            if ("this".equals(methodCallExpression.getMethodExpression().getReferenceName()) || (qualifierExpression = PsiUtil.skipParenthesizedExprDown((referenceExpression = methodCallExpression.getMethodExpression()).getQualifierExpression())) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(PsiNewExpression expression2, PsiType type2, PsiClass aClass2) {
        if (type2 == null || type2 instanceof PsiArrayType || type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (aClass2 == null) {
            return null;
        }
        if (aClass2 instanceof PsiAnonymousClass && (aClass2 = ((PsiAnonymousClass)aClass2).getBaseClassType().resolve()) == null) {
            return null;
        }
        PsiExpression qualifier = expression2.getQualifier();
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)expression2, qualifier, aClass2);
    }

    @Nullable
    public static HighlightInfo checkCreateInnerClassFromStaticContext(PsiElement element, @Nullable PsiExpression qualifier, PsiClass aClass2) {
        PsiElement placeToSearchEnclosingFrom;
        if (qualifier != null) {
            PsiType qType = qualifier.getType();
            placeToSearchEnclosingFrom = PsiUtil.resolveClassInType(qType);
        } else {
            placeToSearchEnclosingFrom = element;
        }
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext(element, placeToSearchEnclosingFrom, aClass2);
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(PsiElement element, PsiElement placeToSearchEnclosingFrom, PsiClass aClass2) {
        if (aClass2 == null || !PsiUtil.isInnerClass(aClass2)) {
            return null;
        }
        PsiClass outerClass2 = aClass2.getContainingClass();
        if (outerClass2 == null) {
            return null;
        }
        if (outerClass2 instanceof PsiSyntheticClass || InheritanceUtil.hasEnclosingInstanceInScope(outerClass2, placeToSearchEnclosingFrom, true, false)) {
            return null;
        }
        return HighlightClassUtil.reportIllegalEnclosingUsage(placeToSearchEnclosingFrom, aClass2, outerClass2, element);
    }

    @Nullable
    static HighlightInfo checkSuperQualifierType(@NotNull Project project, @NotNull PsiMethodCallExpression superCall) {
        if (project == null) {
            HighlightClassUtil.$$$reportNull$$$0(14);
        }
        if (superCall == null) {
            HighlightClassUtil.$$$reportNull$$$0(15);
        }
        if (!RefactoringChangeUtil.isSuperMethodCall(superCall)) {
            return null;
        }
        PsiMethod ctr = PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, true, PsiMember.class);
        if (ctr == null) {
            return null;
        }
        PsiClass aClass2 = ctr.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        PsiClass targetClass = aClass2.getSuperClass();
        if (targetClass == null) {
            return null;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            if (PsiUtil.isInnerClass(targetClass)) {
                PsiClass outerClass2 = targetClass.getContainingClass();
                if (outerClass2 != null) {
                    PsiClassType outerType = JavaPsiFacade.getInstance(project).getElementFactory().createType(outerClass2);
                    return HighlightUtil.checkAssignability(outerType, null, qualifier, qualifier);
                }
            } else {
                String description2 = "'" + HighlightUtil.formatClass(targetClass) + "' is not an inner class";
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(description2).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo reportIllegalEnclosingUsage(PsiElement place, @Nullable PsiClass aClass2, PsiClass outerClass2, PsiElement elementToHighlight) {
        if (outerClass2 != null && !PsiTreeUtil.isContextAncestor(outerClass2, place, false)) {
            String description2 = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(outerClass2));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description2).create();
            HighlightClassUtil.registerMakeInnerClassStatic(highlightInfo, aClass2);
            return highlightInfo;
        }
        PsiModifierListOwner staticParent = PsiUtil.getEnclosingStaticElement(place, outerClass2);
        if (staticParent != null) {
            String element = outerClass2 == null ? "" : HighlightUtil.formatClass(outerClass2) + "." + (place instanceof PsiSuperExpression ? "super" : "this");
            String description3 = JavaErrorMessages.message("cannot.be.referenced.from.static.context", element);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description3).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
            if (aClass2 != null && HighlightUtil.getIncompatibleModifier("static", aClass2.getModifierList()) == null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "static", true, false));
            }
            return highlightInfo;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightElement";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledExceptions";
                break;
            }
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAbstractInstantiation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstantiationOfAbstractClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassAndPackageConflict";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticFieldDeclarationInInnerClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnclosingStaticClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDefaultConstructorThrowsException";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassDoesNotCallSuperConstructorOrHandleExceptions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBaseClassDefaultConstructorProblem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExtendsDuplicate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSuperQualifierType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkBaseClassDefaultConstructorProblem$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

