/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoHolder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder");
    private final PsiFile myContextFile;
    private final HighlightInfoFilter[] myFilters;
    private final AnnotationSession myAnnotationSession;
    private int myErrorCount;
    private final List<HighlightInfo> myInfos;

    public HighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters) {
        if (contextFile == null) {
            HighlightInfoHolder.$$$reportNull$$$0(0);
        }
        if (filters == null) {
            HighlightInfoHolder.$$$reportNull$$$0(1);
        }
        this.myInfos = new ArrayList<HighlightInfo>(5);
        this.myContextFile = contextFile;
        this.myAnnotationSession = new AnnotationSession(contextFile);
        this.myFilters = filters;
    }

    @NotNull
    public AnnotationSession getAnnotationSession() {
        AnnotationSession annotationSession = this.myAnnotationSession;
        if (annotationSession == null) {
            HighlightInfoHolder.$$$reportNull$$$0(2);
        }
        return annotationSession;
    }

    public boolean add(@Nullable HighlightInfo info) {
        if (info == null || !this.accepted(info)) {
            return false;
        }
        HighlightSeverity severity = info.getSeverity();
        if (severity == HighlightSeverity.ERROR) {
            ++this.myErrorCount;
        }
        return this.myInfos.add(info);
    }

    public void clear() {
        this.myErrorCount = 0;
        this.myInfos.clear();
    }

    public boolean hasErrorResults() {
        return this.myErrorCount != 0;
    }

    public boolean addAll(Collection<? extends HighlightInfo> highlightInfos) {
        if (highlightInfos == null) {
            return false;
        }
        LOG.assertTrue(highlightInfos != this);
        boolean added = false;
        for (HighlightInfo highlightInfo : highlightInfos) {
            added |= this.add(highlightInfo);
        }
        return added;
    }

    public int size() {
        return this.myInfos.size();
    }

    public HighlightInfo get(int i) {
        return this.myInfos.get(i);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myContextFile.getProject();
        if (project == null) {
            HighlightInfoHolder.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public PsiFile getContextFile() {
        PsiFile psiFile = this.myContextFile;
        if (psiFile == null) {
            HighlightInfoHolder.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    private boolean accepted(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfoHolder.$$$reportNull$$$0(5);
        }
        for (HighlightInfoFilter filter2 : this.myFilters) {
            if (filter2.accept(info, this.getContextFile())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextAttributesScheme getColorsScheme() {
        TextAttributesScheme textAttributesScheme = new TextAttributesScheme(){

            @Override
            public TextAttributes getAttributes(TextAttributesKey key) {
                return key.getDefaultAttributes();
            }
        };
        if (textAttributesScheme == null) {
            HighlightInfoHolder.$$$reportNull$$$0(6);
        }
        return textAttributesScheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

