/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertDoubleToFloatFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFixFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final String MISMATCH_COLOR = UIUtil.isUnderDarcula() ? "ff6464" : "red";
    private static final Logger LOG = Logger.getInstance(HighlightMethodUtil.class);

    private HighlightMethodUtil() {
    }

    static String createClashMethodMessage(PsiMethod method1, PsiMethod method2, boolean showContainingClasses) {
        if (showContainingClasses) {
            PsiClass class1 = method1.getContainingClass();
            PsiClass class2 = method2.getContainingClass();
            if (class1 != null && class2 != null) {
                return JavaErrorMessages.message("clash.methods.message.show.classes", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2), HighlightUtil.formatClass(class1), HighlightUtil.formatClass(class2));
            }
        }
        return JavaErrorMessages.message("clash.methods.message", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2));
    }

    static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiFile containingFile) {
        PsiMethod method;
        PsiModifierList modifierList;
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(0);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(1);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(2);
        }
        if ((modifierList = (method = methodSignature.getMethod()).getModifierList()).hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel(modifierList);
        String accessModifier = PsiUtil.getAccessModifier(accessLevel);
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod(superMethod, method) || !PsiUtil.isAccessible(containingFile.getProject(), superMethod, method, null) || !includeRealPositionInfo && MethodSignatureUtil.isSuperMethod(superMethod, method) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(PsiMethod method, PsiModifierList modifierList, String accessModifier, int accessLevel, PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel = PsiUtil.getAccessLevel(superMethod.getModifierList());
        if (accessLevel < superAccessLevel) {
            String description2 = JavaErrorMessages.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), VisibilityUtil.toPresentableText(accessModifier), PsiUtil.getAccessModifier(superAccessLevel));
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (includeRealPositionInfo) {
                PsiElement keyword = PsiUtil.findModifierInList(modifierList, accessModifier);
                if (keyword != null) {
                    textRange = keyword.getTextRange();
                } else {
                    PsiIdentifier identifier = method.getNameIdentifier();
                    if (identifier != null) {
                        textRange = identifier.getTextRange();
                    }
                }
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(method, PsiUtil.getAccessModifier(superAccessLevel), true, false));
            return info;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(3);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(4);
        }
        return HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, includeRealPositionInfo, null);
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @Nullable TextRange textRange) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(5);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(6);
        }
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiTypeElement typeElement;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure(declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null) continue;
            if (textRange == null && includeRealPositionInfo && (typeElement = method.getReturnTypeElement()) != null) {
                textRange = typeElement.getTextRange();
            }
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            if ((info = HighlightMethodUtil.checkSuperMethodSignature(superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType, JavaErrorMessages.message("incompatible.return.type", new Object[0]), textRange, PsiUtil.getLanguageLevel(aClass2))) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange range, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor unifyingSubstitutor;
        PsiClass containingClass;
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(7);
        }
        if (superMethodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(9);
        }
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(10);
        }
        if (returnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(11);
        }
        if (detailMessage == null) {
            HighlightMethodUtil.$$$reportNull$$$0(12);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(13);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(14);
        }
        if (superReturnType == null) {
            return null;
        }
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (superContainingClass != null && "java.lang.Object".equals(superContainingClass.getQualifiedName()) && !superMethod.hasModifierProperty("public") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
            return null;
        }
        boolean isJdk15 = languageLevel.isAtLeast(LanguageLevel.JDK_1_5);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals(methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure(superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && LambdaUtil.performWithSubstitutedParameterBounds(methodSignature.getTypeParameters(), methodSignature.getSubstitutor(), () -> {
            if (returnType == null) {
                HighlightMethodUtil.$$$reportNull$$$0(79);
            }
            return TypeConversionUtil.isAssignable(substitutedSuperReturnType, returnType);
        }).booleanValue()) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(method, superMethod, substitutedSuperReturnType, returnType, detailMessage, range);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiType substitutedSuperReturnType, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange textRange) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(15);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(16);
        }
        if (substitutedSuperReturnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(17);
        }
        if (returnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(18);
        }
        if (detailMessage == null) {
            HighlightMethodUtil.$$$reportNull$$$0(19);
        }
        if (textRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(20);
        }
        String description2 = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSuperMethodReturnFix(superMethod, returnType));
        PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly(returnType);
        if (returnClass != null && substitutedSuperReturnType instanceof PsiClassType) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createChangeParameterClassFix(returnClass, (PsiClassType)substitutedSuperReturnType));
        }
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures) {
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(PsiMethod method, PsiMethod superMethod) {
        if (superMethod.hasModifierProperty("final")) {
            PsiClass superClass = superMethod.getContainingClass();
            String description2 = JavaErrorMessages.message("final.method.override", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(superMethod, "final", false, true));
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleThrows(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method = methodSignature.getMethod();
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(aClass2, analyzedClass, PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (psiClassType == null) {
                LOG.error("throws: " + method.getThrowsList().getText() + "; method: " + method);
                continue;
            }
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange textRange;
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index2 = HighlightMethodUtil.getExtraExceptionNum(methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index2 == -1 || aClass2.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass2.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index2);
            String description2 = JavaErrorMessages.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), JavaHighlightUtil.formatType(exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index2);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(errorResult, new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false)));
            QuickFixAction.registerQuickFixAction(errorResult, new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true)));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(MethodSignature methodSignature, MethodSignatureBackedByPsiMethod superSignature, List<PsiClassType> checkedExceptions, PsiSubstitutor substitutorForDerivedClass) {
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod != null ? substitutorForMethod.substitute(checkedEx) : TypeConversionUtil.erasure(checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, PsiType exception, PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute(thrownException1) : TypeConversionUtil.erasure(thrownException1);
            if (!TypeConversionUtil.isAssignable(thrownException = substitutorForDerivedClass.substitute(thrownException), exception)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull JavaSdkVersion javaSdkVersion, @NotNull PsiFile file2) {
        HighlightInfo highlightInfo;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(21);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(22);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(23);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(25);
        }
        PsiExpressionList list2 = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult[] results = referenceToMethod.multiResolve(true);
        JavaResolveResult resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = resolveResult.getElement();
        boolean isDummy = HighlightMethodUtil.isDummyConstructorCall(methodCall, resolveHelper, list2, referenceToMethod);
        if (isDummy) {
            return null;
        }
        PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
        if (resolved instanceof PsiMethod && resolveResult.isValidResult()) {
            String errorMessage;
            String message;
            PsiElement element;
            PsiClass containingClass;
            PsiElement nameElement = referenceToMethod.getReferenceNameElement();
            TextRange fixRange = HighlightMethodUtil.getFixRange(methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions(methodCall, nameElement != null ? new TextRange(nameElement.getTextOffset(), fixRange.getEndOffset()) : fixRange);
            if (highlightInfo == null && ((PsiMethod)resolved).hasModifierProperty("static") && (containingClass = ((PsiMethod)resolved).getContainingClass()) != null && containingClass.isInterface() && (highlightInfo = HighlightUtil.checkFeature(element = (PsiElement)ObjectUtils.notNull(referenceToMethod.getReferenceNameElement(), referenceToMethod), HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file2)) == null && (message = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(referenceToMethod, resolveResult.getCurrentFileResolveScope(), containingClass)) != null) {
                highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(message).range(fixRange).create();
            }
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkInferredIntersections(substitutor2, fixRange);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.checkVarargParameterErasureToBeAccessible((MethodCandidateInfo)resolveResult, methodCall);
            }
            if (highlightInfo == null && (errorMessage = ((MethodCandidateInfo)resolveResult).getInferenceErrorMessage()) != null && (highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(errorMessage).range(fixRange).create()) != null) {
                HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list2, resolveHelper);
                HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, (MethodCandidateInfo)resolveResult, methodCall);
                HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, (MethodCandidateInfo)resolveResult, (PsiMethod)resolved, highlightInfo);
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = null;
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    PsiElement element;
                    String toolTip;
                    assert (resolved != null);
                    String methodName = HighlightMessageUtil.getSymbolName(resolved, substitutor2);
                    PsiElement parent2 = resolved.getParent();
                    String containerName = parent2 == null ? "" : HighlightMessageUtil.getSymbolName(parent2, substitutor2);
                    String argTypes = HighlightMethodUtil.buildArgTypesList(list2);
                    String description2 = JavaErrorMessages.message("wrong.method.arguments", methodName, containerName, argTypes);
                    Ref<PsiElement> elementToHighlight = new Ref<PsiElement>(list2);
                    if (parent2 instanceof PsiClass) {
                        toolTip = HighlightMethodUtil.buildOneLineMismatchDescription(list2, candidateInfo, elementToHighlight);
                        if (toolTip == null) {
                            toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list2);
                        }
                    } else {
                        toolTip = description2;
                    }
                    int navigationShift = (element = elementToHighlight.get()) instanceof PsiExpressionList ? 1 : 0;
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).description(description2).escapedToolTip(toolTip).navigationShift(navigationShift).create();
                    if (highlightInfo != null) {
                        HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list2, resolveHelper);
                        HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, candidateInfo, methodCall);
                        HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, candidateInfo, resolvedMethod, highlightInfo);
                    }
                } else {
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    PsiSubstitutor applicabilitySubstitutor = candidateInfo.getSubstitutor(false);
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments(resolvedMethod, (PsiElement)methodCall, applicabilitySubstitutor) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, referenceToMethod, applicabilitySubstitutor, javaSdkVersion);
                }
            } else {
                String description3 = JavaErrorMessages.message("method.call.expected", new Object[0]);
                highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(methodCall).descriptionAndTooltip(description3).create();
                if (resolved instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createInsertNewFix(methodCall, (PsiClass)resolved));
                } else {
                    PsiMethod method;
                    TextRange range = HighlightMethodUtil.getFixRange(methodCall);
                    HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, range);
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
                    if (resolved instanceof PsiVariable && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method = LambdaUtil.getFunctionalInterfaceMethod(((PsiVariable)resolved).getType())) != null) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createInsertMethodCallFix(methodCall, method));
                    }
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, referenceToMethod, substitutor2, javaSdkVersion);
        }
        return highlightInfo;
    }

    private static void registerUsageFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(26);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(27);
        }
        if (JvmElementActionFactories.useInterlaguageActions()) {
            for (IntentionAction action2 : QUICK_FIX_FACTORY.createCreateMethodFromUsageFixes(methodCall)) {
                QuickFixAction.registerQuickFixAction(highlightInfo, range, action2);
            }
        } else {
            QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreateMethodFromUsageFix(methodCall));
            QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreateAbstractMethodFromUsageFix(methodCall));
        }
    }

    private static void registerTargetTypeFixesBasedOnApplicabilityInference(@NotNull PsiMethodCallExpression methodCall, MethodCandidateInfo resolveResult, PsiMethod resolved, HighlightInfo highlightInfo) {
        PsiType expectedTypeByApplicabilityConstraints;
        PsiType rType;
        PsiElement resolve2;
        PsiExpression lExpression;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(28);
        }
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(methodCall.getParent());
        PsiVariable variable2 = null;
        if (parent2 instanceof PsiVariable) {
            variable2 = (PsiVariable)parent2;
        } else if (parent2 instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent2).getLExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            variable2 = (PsiVariable)resolve2;
        }
        if (variable2 != null && (rType = methodCall.getType()) != null && !variable2.getType().isAssignableFrom(rType) && (expectedTypeByApplicabilityConstraints = resolveResult.getSubstitutor(false).substitute(resolved.getReturnType())) != null && !expectedTypeByApplicabilityConstraints.equals(rType)) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable2, expectedTypeByApplicabilityConstraints, (PsiExpression)methodCall, highlightInfo);
        }
    }

    @Nullable
    private static String checkStaticInterfaceMethodCallQualifier(PsiReferenceExpression ref, PsiElement scope, PsiClass containingClass) {
        PsiExpression qualifierExpression = ref.getQualifierExpression();
        if (qualifierExpression == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, ref, true))) {
            return null;
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
            if (resolve2 == containingClass) {
                return null;
            }
            if (resolve2 instanceof PsiTypeParameter) {
                HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                    PsiClass aClass2 = type2.resolve();
                    if (aClass2 == null) continue;
                    classes2.add(aClass2);
                }
                if (classes2.size() == 1 && classes2.contains(containingClass)) {
                    return null;
                }
            }
        }
        return JavaErrorMessages.message("static.interface.method.call.qualifier", new Object[0]);
    }

    private static void registerMethodReturnFixAction(HighlightInfo highlightInfo, MethodCandidateInfo candidate2, PsiCall methodCall) {
        PsiMethod containerMethod;
        if (methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, true, PsiLambdaExpression.class)) != null) {
            PsiMethod method = candidate2.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory(method.getProject()).createExpressionFromText(methodCall.getText(), methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(method).substitute(methodCallTypeByArgs);
            if (methodCallTypeByArgs != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange(methodCall), QUICK_FIX_FACTORY.createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
            }
        }
    }

    private static String buildOneLineMismatchDescription(@NotNull PsiExpressionList list2, @NotNull MethodCandidateInfo candidateInfo, @NotNull Ref<PsiElement> elementToHighlight) {
        if (list2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(29);
        }
        if (candidateInfo == null) {
            HighlightMethodUtil.$$$reportNull$$$0(30);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(31);
        }
        PsiExpression[] expressions = list2.getExpressions();
        PsiMethod resolvedMethod = candidateInfo.getElement();
        PsiSubstitutor substitutor2 = candidateInfo.getSubstitutor();
        PsiParameter[] parameters2 = resolvedMethod.getParameterList().getParameters();
        if (expressions.length == parameters2.length && parameters2.length > 1) {
            PsiExpression wrongArg;
            PsiType argType;
            int idx = -1;
            for (int i = 0; i < expressions.length; ++i) {
                JavaResolveResult result2;
                PsiExpression expression2 = expressions[i];
                if (expression2 instanceof PsiMethodCallExpression && (result2 = ((PsiCallExpression)expression2).resolveMethodGenerics()) instanceof MethodCandidateInfo && PsiUtil.isLanguageLevel8OrHigher(list2) && ((MethodCandidateInfo)result2).isToInferApplicability() && ((MethodCandidateInfo)result2).getInferenceErrorMessage() == null || TypeConversionUtil.areTypesAssignmentCompatible(substitutor2.substitute(parameters2[i].getType()), expression2)) continue;
                if (idx != -1) {
                    idx = -1;
                    break;
                }
                idx = i;
            }
            if (idx > -1 && (argType = (wrongArg = expressions[idx]).getType()) != null) {
                elementToHighlight.set(wrongArg);
                String message = JavaErrorMessages.message("incompatible.call.types", idx + 1, substitutor2.substitute(parameters2[idx].getType()).getCanonicalText(), argType.getCanonicalText());
                return XmlStringUtil.wrapInHtml("<body>" + XmlStringUtil.escapeString(message) + " <a href=\"#assignment/" + XmlStringUtil.escapeString(HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list2)) + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message("inspection.extended.description", new Object[0]) + "</a></body>");
            }
        }
        return null;
    }

    static boolean isDummyConstructorCall(PsiMethodCallExpression methodCall, PsiResolveHelper resolveHelper, PsiExpressionList list2, PsiReferenceExpression referenceToMethod) {
        CandidateInfo[] candidates2;
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list2.getExpressions().length == 0 && (candidates2 = resolveHelper.getReferencedMethodCandidates(methodCall, true)).length == 1 && !candidates2[0].getElement().isPhysical()) {
            isDummy = true;
        }
        return isDummy;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallIdentifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list2, @Nullable PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file2) {
        HighlightInfo info;
        String description2;
        MethodCandidateInfo methodCandidate2;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(32);
        }
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(33);
        }
        if (list2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(34);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(35);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(36);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(37);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(39);
        }
        if ((methodCandidate2 = (MethodCandidateInfo)HighlightMethodUtil.findCandidates((JavaResolveResult[])resolveResults).second) != null) {
            return null;
        }
        JavaResolveResult[] candidates2 = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        PsiElement elementToHighlight = ObjectUtils.notNull(referenceToMethod.getReferenceNameElement(), referenceToMethod);
        if (element != null && !resolveResult.isAccessible()) {
            description2 = HighlightUtil.accessProblemDescription(referenceToMethod, element, resolveResult);
        } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            PsiClass containingClass;
            if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("static") && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface()) {
                info = HighlightUtil.checkFeature(elementToHighlight, HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file2);
                if (info != null) {
                    return info;
                }
                description2 = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(referenceToMethod, resolveResult.getCurrentFileResolveScope(), containingClass);
                if (description2 != null) {
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description2).escapedToolTip(XmlStringUtil.escapeString(description2)).create();
                    QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAccessStaticViaInstanceFix(referenceToMethod, resolveResult));
                    return highlightInfo;
                }
            }
            description2 = HighlightUtil.staticContextProblemDescription(element);
        } else {
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list2);
            description2 = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates2.length == 0) {
                highlightInfoType = HighlightInfoType.WRONG_REF;
            } else {
                return null;
            }
        }
        String toolTip = XmlStringUtil.escapeString(description2);
        info = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description2).escapedToolTip(toolTip).create();
        HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list2, resolveHelper);
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates2, methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates2, methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates2, methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, methodCall, (CandidateInfo[])candidates2, fixRange);
        WrapExpressionFix.registerWrapAction(candidates2, list2.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix(methodCall, list2, info);
        if (candidates2.length == 0) {
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(methodCall.getMethodExpression(), new QuickFixActionRegistrarImpl(info));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallArguments(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list2, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiElement elementToHighlight) {
        String toolTip;
        String description2;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(40);
        }
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(41);
        }
        if (list2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(42);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(43);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(44);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(45);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(46);
        }
        Pair<MethodCandidateInfo, MethodCandidateInfo> pair = HighlightMethodUtil.findCandidates(resolveResults);
        MethodCandidateInfo methodCandidate1 = (MethodCandidateInfo)pair.first;
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)pair.second;
        JavaResolveResult[] candidates2 = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            VirtualFile virtualFile2;
            PsiMethod element1 = methodCandidate1.getElement();
            String m1 = PsiFormatUtil.formatMethod(element1, methodCandidate1.getSubstitutor(false), 4353, 2);
            PsiMethod element2 = methodCandidate2.getElement();
            String m2 = PsiFormatUtil.formatMethod(element2, methodCandidate2.getSubstitutor(false), 4353, 2);
            VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile(element1);
            if (!Comparing.equal(virtualFile1, virtualFile2 = PsiUtilCore.getVirtualFile(element2))) {
                if (virtualFile1 != null) {
                    m1 = m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
                }
                if (virtualFile2 != null) {
                    m2 = m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
                }
            }
            description2 = JavaErrorMessages.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                return null;
            }
            if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                return null;
            }
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list2);
            description2 = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates2.length == 0) {
                return null;
            }
            toolTip = XmlStringUtil.escapeString(description2);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description2).escapedToolTip(toolTip).create();
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list2, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightFixUtil.registerAccessQuickFixAction((PsiMember)element, referenceToMethod, info, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates2, methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates2, methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates2, methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, methodCall, (CandidateInfo[])candidates2, fixRange);
        WrapExpressionFix.registerWrapAction(candidates2, list2.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix(methodCall, list2, info);
        return info;
    }

    private static Pair<MethodCandidateInfo, MethodCandidateInfo> findCandidates(JavaResolveResult[] resolveResults) {
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result2 : resolveResults) {
            MethodCandidateInfo candidate2;
            if (!(result2 instanceof MethodCandidateInfo) || !(candidate2 = (MethodCandidateInfo)result2).isApplicable() || candidate2.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate2;
                continue;
            }
            methodCandidate2 = candidate2;
            break;
        }
        return Pair.pair(methodCandidate1, methodCandidate2);
    }

    private static MethodCandidateInfo[] toMethodCandidates(JavaResolveResult[] resolveResults) {
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>(resolveResults.length);
        for (JavaResolveResult result2 : resolveResults) {
            MethodCandidateInfo candidate2;
            if (!(result2 instanceof MethodCandidateInfo) || !(candidate2 = (MethodCandidateInfo)result2).isAccessible()) continue;
            candidateList.add(candidate2);
        }
        return candidateList.toArray(new MethodCandidateInfo[candidateList.size()]);
    }

    private static void registerMethodCallIntentions(@Nullable HighlightInfo highlightInfo, PsiMethodCallExpression methodCall, PsiExpressionList list2, PsiResolveHelper resolveHelper) {
        TextRange fixRange = HighlightMethodUtil.getFixRange(methodCall);
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
            if (resolve2 instanceof PsiClass && ((PsiClass)resolve2).getContainingClass() != null && !((PsiClass)resolve2).hasModifierProperty("static")) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix((PsiClass)resolve2, "static", true, false));
            }
        } else if (qualifierExpression instanceof PsiSuperExpression && ((PsiSuperExpression)qualifierExpression).getQualifier() == null) {
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifierExpression, highlightInfo);
        }
        HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, fixRange);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateConstructorFromSuperFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateConstructorFromThisFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateGetterSetterPropertyFromUsageFix(methodCall));
        JavaResolveResult[] methodCandidates = resolveHelper.getReferencedMethodCandidates(methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        PermuteArgumentsFix.registerFix(highlightInfo, methodCall, (CandidateInfo[])methodCandidates, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        MethodReturnFixFactory.INSTANCE.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions((CandidateInfo[])methodCandidates, methodCall, list2, highlightInfo);
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(methodCandidates, list2, highlightInfo, fixRange);
        RemoveRedundantArgumentsFix.registerIntentions(methodCandidates, list2, highlightInfo, fixRange);
        ConvertDoubleToFloatFix.registerIntentions(methodCandidates, list2, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction(methodCandidates, list2.getExpressions(), highlightInfo);
        HighlightMethodUtil.registerChangeParameterClassFix(methodCall, list2, highlightInfo);
        if (methodCandidates.length == 0) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
        }
        for (IntentionAction action2 : QUICK_FIX_FACTORY.getVariableTypeFromCallFixes(methodCall, list2)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, action2);
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createReplaceAddAllArrayToCollectionFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createSurroundWithArrayFix(methodCall, null));
        QualifyThisArgumentFix.registerQuickFixAction((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        CandidateInfo[] candidates2 = resolveHelper.getReferencedMethodCandidates(methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates2, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(CandidateInfo[] methodCandidates, PsiMethodCallExpression methodCall, PsiExpressionList exprList, HighlightInfo highlightInfo) {
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable(method, methodCandidate.getSubstitutor(), exprList)) continue;
            HighlightFixUtil.registerAccessQuickFixAction(method, methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    @NotNull
    private static String createAmbiguousMethodHtmlTooltip(MethodCandidateInfo[] methodCandidates) {
        String string = JavaErrorMessages.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    private static String getContainingClassName(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiClass containingClass = method.getContainingClass();
        return containingClass == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
    }

    @Language(value="HTML")
    private static String createAmbiguousMethodHtmlTooltipMethodRow(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiSubstitutor substitutor2 = methodCandidate.getSubstitutor();
        StringBuilder ms = new StringBuilder("<td><b>" + method.getName() + "</b></td>");
        for (int j = 0; j < parameters2.length; ++j) {
            PsiParameter parameter = parameters2[j];
            PsiType type2 = substitutor2.substitute(parameter.getType());
            ms.append("<td><b>").append(j == 0 ? "(" : "").append(XmlStringUtil.escapeString(type2.getPresentableText())).append(j == parameters2.length - 1 ? ")" : ",").append("</b></td>");
        }
        if (parameters2.length == 0) {
            ms.append("<td><b>()</b></td>");
        }
        return ms.toString();
    }

    private static String createMismatchedArgumentsHtmlTooltip(MethodCandidateInfo info, PsiExpressionList list2) {
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor2 = info.getSubstitutor();
        PsiClass aClass2 = method.getContainingClass();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        String methodName = method.getName();
        return HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list2, info, parameters2, methodName, substitutor2, aClass2);
    }

    private static String createShortMismatchedArgumentsHtmlTooltip(PsiExpressionList list2, @Nullable MethodCandidateInfo info, PsiParameter[] parameters2, String methodName, PsiSubstitutor substitutor2, PsiClass aClass2) {
        PsiExpression[] expressions = list2.getExpressions();
        int cols = Math.max(parameters2.length, expressions.length);
        String parenthesizedName = methodName + (parameters2.length == 0 ? "(&nbsp;)&nbsp;" : "");
        String errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        return JavaErrorMessages.message("argument.mismatch.html.tooltip", cols - parameters2.length + 1, parenthesizedName, HighlightUtil.formatClass(aClass2, false), HighlightMethodUtil.createMismatchedArgsHtmlTooltipParamsRow(parameters2, substitutor2, expressions), HighlightMethodUtil.createMismatchedArgsHtmlTooltipArgumentsRow(expressions, parameters2, substitutor2, cols), errorMessage != null ? "<br/>reason: " + XmlStringUtil.escapeString(errorMessage).replaceAll("\n", "<br/>") : "");
    }

    private static String escTrim(@NotNull String s) {
        if (s == null) {
            HighlightMethodUtil.$$$reportNull$$$0(48);
        }
        return XmlStringUtil.escapeString(HighlightMethodUtil.trimNicely(s));
    }

    private static String trimNicely(String s) {
        if (s.length() <= 40) {
            return s;
        }
        List<TextRange> wordIndices = StringUtil.getWordIndicesIn(s);
        if (wordIndices.size() > 2) {
            int firstWordEnd = wordIndices.get(0).getEndOffset();
            for (int i = 1; i < wordIndices.size(); ++i) {
                int stringLength = firstWordEnd + s.length() - wordIndices.get(i).getStartOffset();
                if (stringLength > 40) continue;
                return s.substring(0, firstWordEnd) + "..." + s.substring(wordIndices.get(i).getStartOffset());
            }
        }
        if (!wordIndices.isEmpty() && s.length() - wordIndices.get(wordIndices.size() - 1).getStartOffset() <= 40) {
            return "..." + s.substring(wordIndices.get(wordIndices.size() - 1).getStartOffset());
        }
        return StringUtil.last(s, 40, true).toString();
    }

    private static String createMismatchedArgumentsHtmlTooltip(PsiExpressionList list2, MethodCandidateInfo info, PsiParameter[] parameters2, String methodName, PsiSubstitutor substitutor2, PsiClass aClass2) {
        return Math.max(parameters2.length, list2.getExpressions().length) <= 2 ? HighlightMethodUtil.createShortMismatchedArgumentsHtmlTooltip(list2, info, parameters2, methodName, substitutor2, aClass2) : HighlightMethodUtil.createLongMismatchedArgumentsHtmlTooltip(list2, info, parameters2, methodName, substitutor2, aClass2);
    }

    @Language(value="HTML")
    private static String createLongMismatchedArgumentsHtmlTooltip(PsiExpressionList list2, @Nullable MethodCandidateInfo info, PsiParameter[] parameters2, String methodName, PsiSubstitutor substitutor2, PsiClass aClass2) {
        String errorMessage;
        PsiExpression[] expressions = list2.getExpressions();
        StringBuilder s = new StringBuilder().append("<html><body><table border=0>").append("<tr><td colspan=3>").append("<nobr><b>").append(methodName).append("()</b> in <b>").append(HighlightUtil.formatClass(aClass2, false)).append("</b> cannot be applied to:</nobr>").append("</td></tr>").append("<tr><td colspan=2 align=left>Expected<br>Parameters:</td><td align=left>Actual<br>Arguments:</td></tr>").append("<tr><td colspan=3><hr></td></tr>");
        for (int i = 0; i < Math.max(parameters2.length, expressions.length); ++i) {
            PsiType type2;
            String name;
            PsiParameter parameter = i < parameters2.length ? parameters2[i] : null;
            PsiExpression expression2 = i < expressions.length ? expressions[i] : null;
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions, substitutor2);
            String mismatchColor = showShort ? null : (UIUtil.isUnderDarcula() ? "FF6B68" : "red");
            s.append("<tr");
            if (i % 2 == 0) {
                String bg = UIUtil.isUnderDarcula() ? ColorUtil.toHex(ColorUtil.shift(UIUtil.getToolTipBackground(), 1.1)) : "eeeeee";
                s.append(" style='background-color: #").append(bg).append("'");
            }
            s.append(">");
            s.append("<td><b><nobr>");
            if (parameter != null && (name = parameter.getName()) != null) {
                s.append(HighlightMethodUtil.escTrim(name)).append(":");
            }
            s.append("</nobr></b></td>");
            s.append("<td><b><nobr>");
            if (parameter != null) {
                type2 = substitutor2.substitute(parameter.getType());
                s.append("<font ");
                if (mismatchColor != null) {
                    s.append("color=").append(mismatchColor);
                }
                s.append(">");
                s.append(HighlightMethodUtil.escTrim(showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2)));
                s.append("</font>");
            }
            s.append("</nobr></b></td>");
            s.append("<td><b><nobr>");
            if (expression2 != null) {
                type2 = expression2.getType();
                s.append("<font ");
                if (mismatchColor != null) {
                    s.append("color='").append(mismatchColor).append("'");
                }
                s.append(">");
                s.append(HighlightMethodUtil.escTrim(expression2.getText()));
                s.append("&nbsp;&nbsp;");
                if (mismatchColor != null && type2 != null && type2 != PsiType.NULL) {
                    s.append("(").append(HighlightMethodUtil.escTrim(JavaHighlightUtil.formatType(type2))).append(")");
                }
                s.append("</font>");
            }
            s.append("</nobr></b></td>");
            s.append("</tr>");
        }
        s.append("</table>");
        String string = errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        if (errorMessage != null) {
            s.append("reason: ").append(XmlStringUtil.escapeString(errorMessage).replaceAll("\n", "<br/>"));
        }
        s.append("</body></html>");
        return s.toString();
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipArgumentsRow(PsiExpression[] expressions, PsiParameter[] parameters2, PsiSubstitutor substitutor2, int cols) {
        int i;
        StringBuilder ms = new StringBuilder();
        for (i = 0; i < expressions.length; ++i) {
            PsiExpression expression2 = expressions[i];
            PsiType type2 = expression2.getType();
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions, substitutor2);
            String mismatchColor = showShort ? null : MISMATCH_COLOR;
            ms.append("<td> <b><nobr>");
            ms.append(i == 0 ? "(" : "");
            ms.append("<font ");
            if (!showShort) {
                ms.append("color=").append(mismatchColor);
            }
            ms.append(">");
            ms.append(XmlStringUtil.escapeString(type2 != null && showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2)));
            ms.append("</font>");
            ms.append(i == expressions.length - 1 ? ")" : ",");
            ms.append("</nobr></b></td>");
        }
        for (i = expressions.length; i < cols + 1; ++i) {
            ms.append("<td>");
            if (i == 0) {
                ms.append("<b>()</b>");
            }
            ms.append("&nbsp;</td>");
        }
        return ms.toString();
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipParamsRow(PsiParameter[] parameters2, PsiSubstitutor substitutor2, PsiExpression[] expressions) {
        StringBuilder ms = new StringBuilder();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter = parameters2[i];
            PsiType type2 = substitutor2.substitute(parameter.getType());
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions, substitutor2);
            ms.append("<td><b><nobr>");
            ms.append(i == 0 ? "(" : "");
            ms.append(XmlStringUtil.escapeString(showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2)));
            ms.append(i == parameters2.length - 1 ? ")" : ",");
            ms.append("</nobr></b></td>");
        }
        return ms.toString();
    }

    private static boolean showShortType(int i, PsiParameter[] parameters2, PsiExpression[] expressions, PsiSubstitutor substitutor2) {
        PsiExpression expression2;
        PsiExpression psiExpression = expression2 = i < expressions.length ? expressions[i] : null;
        if (expression2 == null) {
            return true;
        }
        PsiType paramType = i < parameters2.length && parameters2[i] != null ? substitutor2.substitute(parameters2[i].getType()) : null;
        PsiType expressionType = expression2.getType();
        return paramType != null && expressionType != null && TypeConversionUtil.isAssignable(paramType, expressionType);
    }

    static HighlightInfo checkMethodMustHaveBody(PsiMethod method, PsiClass aClass2) {
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass2 == null || aClass2.isInterface() || PsiUtilCore.hasErrorElementChild(method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            String description2 = JavaErrorMessages.message("missing.method.body", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description2).create();
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null && !(aClass2 instanceof PsiAnonymousClass)) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(method, "abstract", true, false));
            }
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(PsiMethod method, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        PsiClass aClass2 = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass2 != null && !aClass2.hasModifierProperty("abstract") && !aClass2.isEnum() && !PsiUtilCore.hasErrorElementChild(method)) {
            String description2 = JavaErrorMessages.message("abstract.method.in.non.abstract.class", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description2).create();
            if (method.getBody() != null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(method, "abstract", false, false));
            }
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(aClass2, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(@NotNull PsiMethod method) {
        PsiClass aClass2;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(49);
        }
        if ((aClass2 = method.getContainingClass()) != null) {
            String className2;
            String string = className2 = aClass2 instanceof PsiAnonymousClass ? null : aClass2.getName();
            if (className2 == null || !Comparing.strEqual(method.getName(), className2)) {
                PsiElement element = ObjectUtils.notNull(method.getNameIdentifier(), method);
                String description2 = JavaErrorMessages.message("missing.return.type", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description2).create();
                if (className2 != null) {
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRenameElementFix(method, className2));
                }
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkDuplicateMethod(PsiClass aClass2, @NotNull PsiMethod method, @NotNull MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(50);
        }
        if (duplicateMethods == null) {
            HighlightMethodUtil.$$$reportNull$$$0(51);
        }
        if (aClass2 == null || method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 1;
        List methods2 = (List)duplicateMethods.get(methodSignature);
        if (methods2.size() > 1) {
            ++methodCount;
        }
        if (methodCount == 1 && aClass2.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass2.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String description2 = JavaErrorMessages.message("duplicate.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass2));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(method, textRange.getStartOffset(), textRange.getEndOffset()).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMethodCanHaveBody(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(52);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(53);
        }
        PsiClass aClass2 = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass2 != null && aClass2.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        ArrayList<IntentionAction> additionalFixes = new ArrayList<IntentionAction>();
        String description2 = null;
        if (hasNoBody) {
            if (isExtension) {
                description2 = JavaErrorMessages.message("extension.method.should.have.a.body", new Object[0]);
                additionalFixes.add(QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            } else if (isInterface) {
                if (isStatic && languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    description2 = "Static methods in interfaces should have a body";
                } else if (isPrivate && languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                    description2 = "Private methods in interfaces should have a body";
                }
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate)) {
                description2 = JavaErrorMessages.message("interface.methods.cannot.have.body", new Object[0]);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix(method, "default", true, false));
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix(method, "static", true, false));
                }
            }
        } else if (isExtension) {
            description2 = JavaErrorMessages.message("extension.method.in.class", new Object[0]);
        } else if (method.hasModifierProperty("abstract")) {
            description2 = JavaErrorMessages.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            description2 = JavaErrorMessages.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (description2 == null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
        if (!hasNoBody) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createDeleteMethodBodyFix(method));
        }
        if (method.hasModifierProperty("abstract") && !isInterface) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(method, "abstract", false, false));
        }
        for (IntentionAction intentionAction : additionalFixes) {
            QuickFixAction.registerQuickFixAction(info, intentionAction);
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkConstructorCallMustBeFirstStatement(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(54);
        }
        if (!RefactoringChangeUtil.isSuperOrThisMethodCall(methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && codeBlock.getParent() instanceof PsiMethod && ((PsiMethod)codeBlock.getParent()).isConstructor()) {
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        PsiReferenceExpression expression2 = methodCall.getMethodExpression();
        String message = JavaErrorMessages.message("constructor.call.must.be.first.statement", expression2.getText() + "()");
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(methodCall).descriptionAndTooltip(message).create();
    }

    static HighlightInfo checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression expression2;
        if (methodCallExpression == null) {
            HighlightMethodUtil.$$$reportNull$$$0(55);
        }
        if (!((expression2 = methodCallExpression.getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            String message = JavaErrorMessages.message("direct.abstract.method.access", JavaHighlightUtil.formatMethod(method));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(methodCallExpression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorCallsBaseClassConstructor(PsiMethod constructor, RefCountHolder refCountHolder, PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass2 = constructor.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        if (aClass2.isEnum()) {
            return null;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return null;
        }
        PsiElement element = new PsiMatcherImpl(body).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).getElement();
        if (element != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass2, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createInsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createInsertThisFix(constructor));
            PsiClass superClass = aClass2.getSuperClass();
            if (superClass != null) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddDefaultConstructorFix(superClass));
            }
        }
        return info;
    }

    static HighlightInfo checkStaticMethodOverride(@NotNull PsiMethod method, @NotNull PsiFile containingFile) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(56);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(57);
        }
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method);
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return null;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature2 : superSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod superMethod = signature2.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null || (highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass2, method, isStatic, superClass, superMethod, containingFile)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(PsiClass aClass2, PsiMethod method, boolean isMethodStatic, PsiClass superClass, PsiMethod superMethod, PsiFile containingFile) {
        if (superMethod == null) {
            return null;
        }
        PsiManager manager = containingFile.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(manager.getProject()).arePackagesTheSame(aClass2, superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String description2 = JavaErrorMessages.message(messageKey, JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass2), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(method, "static", isSuperMethodStatic, false));
            }
            if (manager.isInProject(superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(superMethod, "static", isMethodStatic, true));
            }
            return info;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return null;
            }
            int accessLevel = PsiUtil.getAccessLevel(modifierList);
            String accessModifier = PsiUtil.getAccessModifier(accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures, LanguageLevel languageLevel) {
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod[] returnTypeSubstitutable = new MethodSignatureBackedByPsiMethod[]{superMethodSignatures.get(0)};
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable[0].getMethod();
            PsiType currentType = returnTypeSubstitutable[0].getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiSubstitutor otherSubstitutor = otherSuperSignature.getSubstitutor();
            PsiType otherSuperReturnType = otherSubstitutor.substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(returnTypeSubstitutable[0], otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            PsiType otherReturnType = otherSuperReturnType;
            PsiType curType = currentType;
            HighlightInfo info = LambdaUtil.performWithSubstitutedParameterBounds(otherSuperMethod.getTypeParameters(), otherSubstitutor, () -> {
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                    if (!(otherReturnType instanceof PsiPrimitiveType) && !(curType instanceof PsiPrimitiveType)) {
                        if (otherReturnType.isAssignableFrom(curType)) {
                            return null;
                        }
                        if (curType.isAssignableFrom(otherReturnType)) {
                            returnTypeSubstitutable[0] = otherSuperSignature;
                            return null;
                        }
                    }
                    if (otherSuperMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric(otherReturnType, curType)) {
                        return null;
                    }
                }
                return HighlightMethodUtil.createIncompatibleReturnTypeMessage(otherSuperMethod, currentMethod, curType, otherReturnType, JavaErrorMessages.message("unrelated.overriding.methods.return.types", new Object[0]), TextRange.EMPTY_RANGE);
            });
            if (info == null) continue;
            return info;
        }
        return null;
    }

    static HighlightInfo checkOverrideEquivalentInheritedMethods(PsiClass aClass2, PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(58);
        }
        String description2 = null;
        boolean appendImplementMethodFix = true;
        Collection<HierarchicalMethodSignature> visibleSignatures = aClass2.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass2.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature2 : visibleSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod method = signature2.getMethod();
            if (!resolveHelper.isAccessible(method, aClass2, null)) continue;
            List<HierarchicalMethodSignature> superSignatures = signature2.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || aClass2.equals(containingClass) || aClass2.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(0, signature2);
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes(superSignatures, languageLevel);
            } else {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType(signature2, superSignatures, false);
            }
            if (highlightInfo != null) {
                description2 = highlightInfo.getDescription();
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    PsiClass superClass = superMethod.getContainingClass();
                    description2 = JavaErrorMessages.message("static.method.cannot.override.instance.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
                    appendImplementMethodFix = false;
                    break block0;
                }
                continue;
            }
            if (description2 == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows(signature2, superSignatures, false, aClass2)) != null) {
                description2 = highlightInfo.getDescription();
            }
            if (description2 == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges(signature2, superSignatures, false, containingFile)) != null) {
                description2 = highlightInfo.getDescription();
            }
            if (description2 == null) continue;
            break;
        }
        if (description2 != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass2);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
            if (appendImplementMethodFix) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createImplementMethodsFix(aClass2));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkConstructorHandleSuperClassExceptions(PsiMethod method) {
        PsiStatement[] statements;
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        PsiStatement[] psiStatementArray = statements = body == null ? null : body.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions(method, method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description2 = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false)));
        }
        return highlightInfo;
    }

    static HighlightInfo checkRecursiveConstructorInvocation(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(59);
        }
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String description2 = JavaErrorMessages.message("recursive.constructor.invocation", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description2).create();
        }
        return null;
    }

    @NotNull
    public static TextRange getFixRange(@NotNull PsiElement element) {
        if (element == null) {
            HighlightMethodUtil.$$$reportNull$$$0(60);
        }
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (PsiUtil.isJavaToken(nextSibling, JavaTokenType.SEMICOLON)) {
            TextRange textRange = new TextRange(start, end + 1);
            if (textRange == null) {
                HighlightMethodUtil.$$$reportNull$$$0(61);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(62);
        }
        return textRange;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression2, PsiType type2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (expression2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(63);
        }
        if (holder == null) {
            HighlightMethodUtil.$$$reportNull$$$0(64);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(65);
        }
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
        PsiClass aClass2 = typeResult.getElement();
        if (aClass2 == null) {
            return;
        }
        if (aClass2 instanceof PsiAnonymousClass && (aClass2 = (typeResult = ((PsiClassType)(type2 = ((PsiAnonymousClass)aClass2).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression2.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, expression2, type2, classReference, holder, javaSdkVersion);
    }

    static void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @NotNull PsiType type2, PsiJavaCodeReferenceElement classReference, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiExpression qualifier;
        PsiExpressionList list2;
        if (typeResolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(66);
        }
        if (constructorCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(67);
        }
        if (type2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(68);
        }
        if (holder == null) {
            HighlightMethodUtil.$$$reportNull$$$0(69);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(70);
        }
        if ((list2 = constructorCall.getArgumentList()) == null) {
            return;
        }
        PsiClass aClass2 = typeResolveResult.getElement();
        if (aClass2 == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(holder.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
        }
        if (classReference != null && !resolveHelper.isAccessible(aClass2, constructorCall, accessObjectClass)) {
            String description2 = HighlightUtil.accessProblemDescription(classReference, aClass2, typeResolveResult);
            PsiElement element = ObjectUtils.notNull(classReference.getReferenceNameElement(), classReference);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description2).create();
            HighlightFixUtil.registerAccessQuickFixAction(aClass2, classReference, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors2 = aClass2.getConstructors();
        if (constructors2.length == 0) {
            PsiReferenceParameterList typeArgumentList;
            if (list2.getExpressions().length != 0) {
                String constructorName = aClass2.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list2);
                String description3 = JavaErrorMessages.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list2, null, PsiParameter.EMPTY_ARRAY, constructorName, PsiSubstitutor.EMPTY, aClass2);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).description(description3).escapedToolTip(tooltip).navigationShift(1).create();
                QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), QUICK_FIX_FACTORY.createCreateConstructorFromCallFix(constructorCall));
                if (classReference != null) {
                    ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange(list2));
                }
                holder.add(info);
                return;
            }
            if (classReference != null && aClass2.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass2)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference, aClass2, typeResolveResult));
            } else if (aClass2.isInterface() && constructorCall instanceof PsiNewExpression && (typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList()).getTypeArguments().length > 0) {
                holder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeArgumentList).descriptionAndTooltip("Anonymous class implements interface; cannot have type arguments").create());
            }
        } else {
            PsiReferenceParameterList typeArgumentList;
            HighlightInfo info;
            PsiElement infoElement;
            PsiAnonymousClass anonymousClass;
            PsiElement place = list2;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type2, list2, place);
            MethodCandidateInfo result2 = null;
            if (results.length == 1) {
                result2 = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result2 == null ? null : result2.getElement();
            boolean applicable = true;
            try {
                JavaResolveResult staticFactory;
                PsiDiamondType diamondType = constructorCall instanceof PsiNewExpression ? PsiDiamondType.getDiamondType((PsiNewExpression)constructorCall) : null;
                JavaResolveResult javaResolveResult = staticFactory = diamondType != null ? diamondType.getStaticFactory() : null;
                applicable = staticFactory instanceof MethodCandidateInfo ? ((MethodCandidateInfo)staticFactory).isApplicable() : result2 != null && result2.isApplicable();
            }
            catch (IndexNotReadyException diamondType) {
                // empty catch block
            }
            PsiElement psiElement = infoElement = list2.getTextLength() > 0 ? list2 : constructorCall;
            if (constructor == null) {
                String name = aClass2.getName();
                name = name + HighlightMethodUtil.buildArgTypesList(list2);
                String description4 = JavaErrorMessages.message("cannot.resolve.constructor", name);
                HighlightInfo info2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list2).descriptionAndTooltip(description4).navigationShift(1).create();
                if (info2 != null) {
                    WrapExpressionFix.registerWrapAction(results, list2.getExpressions(), info2);
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference, list2, aClass2, constructors2, results, infoElement, info2);
                    holder.add(info2);
                }
            } else if (classReference != null && (!result2.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass2))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference, constructor, result2));
            } else if (!applicable) {
                String constructorName = HighlightMessageUtil.getSymbolName(constructor, result2.getSubstitutor());
                PsiClass constructorClass = constructor.getContainingClass();
                String containerName = constructorClass != null ? HighlightMessageUtil.getSymbolName(constructorClass, result2.getSubstitutor()) : "<unknown>";
                String argTypes = HighlightMethodUtil.buildArgTypesList(list2);
                String description5 = JavaErrorMessages.message("wrong.method.arguments", constructorName, containerName, argTypes);
                String toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(result2, list2);
                HighlightInfo info3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(infoElement).description(description5).escapedToolTip(toolTip).navigationShift(1).create();
                if (info3 != null) {
                    JavaResolveResult[] methodCandidates = results;
                    if (constructorCall instanceof PsiNewExpression) {
                        methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)((Object)constructorCall), true);
                    }
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference, list2, aClass2, constructors2, methodCandidates, infoElement, info3);
                    HighlightMethodUtil.registerMethodReturnFixAction(info3, result2, constructorCall);
                    holder.add(info3);
                }
            } else if (constructorCall instanceof PsiNewExpression && (info = GenericsHighlightUtil.checkReferenceTypeArgumentList(constructor, typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList(), result2.getSubstitutor(), false, javaSdkVersion)) != null) {
                holder.add(info);
            }
            if (result2 != null && !holder.hasErrorResults()) {
                holder.add(HighlightMethodUtil.checkVarargParameterErasureToBeAccessible(result2, constructorCall));
            }
        }
    }

    private static HighlightInfo checkVarargParameterErasureToBeAccessible(MethodCandidateInfo info, PsiCall place) {
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher(place)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters2[parameters2.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure(info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly(substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible(targetClass, place, null)) {
                PsiExpressionList argumentList2 = place.getArgumentList();
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Formal varargs element type " + PsiFormatUtil.formatClass(targetClass, 2048) + " is inaccessible here").range(argumentList2 != null ? argumentList2 : place).create();
            }
        }
        return null;
    }

    private static void registerFixesOnInvalidConstructorCall(PsiConstructorCall constructorCall, PsiJavaCodeReferenceElement classReference, PsiExpressionList list2, PsiClass aClass2, PsiMethod[] constructors2, JavaResolveResult[] results, PsiElement infoElement, @NotNull HighlightInfo info) {
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(71);
        }
        QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), QUICK_FIX_FACTORY.createCreateConstructorFromCallFix(constructorCall));
        if (classReference != null) {
            ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange(infoElement));
            ChangeTypeArgumentsFix.registerIntentions(results, list2, info, aClass2);
            ConvertDoubleToFloatFix.registerIntentions(results, list2, info, null);
        }
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(results, list2, info, null);
        PermuteArgumentsFix.registerFix(info, constructorCall, HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange(list2));
        HighlightMethodUtil.registerChangeParameterClassFix(constructorCall, list2, info);
        QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange(list2), QUICK_FIX_FACTORY.createSurroundWithArrayFix(constructorCall, null));
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors2, constructorCall, info);
    }

    private static HighlightInfo buildAccessProblem(PsiJavaCodeReferenceElement ref, PsiMember resolved, JavaResolveResult result2) {
        String description2 = HighlightUtil.accessProblemDescription(ref, resolved, result2);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(description2).navigationShift(1).create();
        if (result2.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerAccessQuickFixAction(resolved, ref, info, result2.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(PsiConstructorCall place, PsiClass constructorClass) {
        PsiClass aClass2;
        if (constructorClass == null) {
            return false;
        }
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiElement curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass2 = PsiTreeUtil.getParentOfType(curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass2;
        } while (!aClass2.isInheritor(constructorClass, true) && (containingClass == null || !aClass2.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance(aClass2.getProject()).arePackagesTheSame(aClass2, constructorClass));
        return true;
    }

    private static String buildArgTypesList(PsiExpressionList list2) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list2.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? JavaHighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    private static void registerChangeParameterClassFix(@NotNull PsiCall methodCall, @NotNull PsiExpressionList list2, HighlightInfo highlightInfo) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(72);
        }
        if (list2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(73);
        }
        JavaResolveResult result2 = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result2.getElement();
        PsiSubstitutor substitutor2 = result2.getSubstitutor();
        PsiExpression[] expressions = list2.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != expressions.length) {
            return;
        }
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression2 = expressions[i];
            PsiParameter parameter = parameters2[i];
            PsiType expressionType = expression2.getType();
            PsiType parameterType = substitutor2.substitute(parameter.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType(expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType(parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType(parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType(expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntentions(@NotNull JavaResolveResult[] candidates2, @NotNull PsiExpressionList list2, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(74);
        }
        if (list2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(75);
        }
        if (candidates2.length == 0) {
            return;
        }
        PsiExpression[] expressions = list2.getExpressions();
        for (JavaResolveResult candidate2 : candidates2) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntention(expressions, highlightInfo, fixRange, candidate2, list2);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(@NotNull PsiExpression[] expressions, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate2, @NotNull PsiElement context) {
        if (expressions == null) {
            HighlightMethodUtil.$$$reportNull$$$0(76);
        }
        if (candidate2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(77);
        }
        if (context == null) {
            HighlightMethodUtil.$$$reportNull$$$0(78);
        }
        if (!candidate2.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate2.getElement();
        PsiSubstitutor substitutor2 = candidate2.getSubstitutor();
        if (method != null && context.getManager().isInProject(method)) {
            IntentionAction fix = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageFix(method, expressions, substitutor2, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, fix);
            IntentionAction f2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions, substitutor2, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, f2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 47: 
            case 61: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 47: 
            case 61: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignatures";
                break;
            }
            case 2: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignature";
                break;
            }
            case 9: 
            case 15: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: 
            case 18: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailMessage";
                break;
            }
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 23: 
            case 38: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedSuperReturnType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 21: 
            case 26: 
            case 28: 
            case 36: 
            case 44: 
            case 54: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 22: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 24: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdkVersion";
                break;
            }
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: 
            case 34: 
            case 42: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateInfo";
                break;
            }
            case 31: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToMethod";
                break;
            }
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 47: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateMethods";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 64: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolveResult";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createAmbiguousMethodHtmlTooltip";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodWeakerPrivileges";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleReturnType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethodSignature";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleReturnTypeMessage";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCall";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerUsageFixes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerTargetTypeFixesBasedOnApplicabilityInference";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildOneLineMismatchDescription";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallIdentifier";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallArguments";
                break;
            }
            case 47: 
            case 61: 
            case 62: {
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "escTrim";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorName";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateMethod";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCanHaveBody";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallMustBeFirstStatement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperAbstractMethodDirectCall";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMethodOverride";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkOverrideEquivalentInheritedMethods";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkRecursiveConstructorInvocation";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getFixRange";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "checkNewExpression";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCall";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesOnInvalidConstructorCall";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeParameterClassFix";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntentions";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntention";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkSuperMethodSignature$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 47: 
            case 61: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

