/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.CheckLevelHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.ImportsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.PostHighlightingVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.PsiMethodReferenceHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AdjustFunctionContextFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightVisitorImpl
extends JavaElementVisitor
implements HighlightVisitor {
    private final PsiResolveHelper myResolveHelper;
    private HighlightInfoHolder myHolder;
    private RefCountHolder myRefCountHolder;
    private LanguageLevel myLanguageLevel;
    private JavaSdkVersion myJavaSdkVersion;
    private PsiFile myFile;
    private PsiJavaModule myJavaModule;
    private final Map<PsiElement, Collection<PsiReferenceExpression>> myUninitializedVarProblems;
    private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myFinalVarProblems;
    private final TObjectIntHashMap<PsiParameter> myReassignedParameters;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> mySingleImportedClasses;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiField>> mySingleImportedFields;
    private final PsiElementVisitor REGISTER_REFERENCES_VISITOR;
    private final Map<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>> myDuplicateMethods;
    private final Set<PsiClass> myOverrideEquivalentMethodsVisitedClasses;

    protected HighlightVisitorImpl(@NotNull PsiResolveHelper resolveHelper) {
        if (resolveHelper == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(0);
        }
        this.myUninitializedVarProblems = new THashMap<PsiElement, Collection<PsiReferenceExpression>>();
        this.myFinalVarProblems = new THashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>();
        this.myReassignedParameters = new TObjectIntHashMap();
        this.mySingleImportedClasses = new THashMap<String, Pair<PsiImportStaticReferenceElement, PsiClass>>();
        this.mySingleImportedFields = new THashMap<String, Pair<PsiImportStaticReferenceElement, PsiField>>();
        this.REGISTER_REFERENCES_VISITOR = new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                super.visitElement(element);
                for (PsiReference reference : element.getReferences()) {
                    PsiElement resolved = reference.resolve();
                    if (!(resolved instanceof PsiNamedElement)) continue;
                    HighlightVisitorImpl.this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
                    if (!(resolved instanceof PsiMember)) continue;
                    HighlightVisitorImpl.this.myRefCountHolder.registerReference(reference, new CandidateInfo(resolved, PsiSubstitutor.EMPTY));
                }
            }
        };
        this.myDuplicateMethods = new THashMap<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>>();
        this.myOverrideEquivalentMethodsVisitedClasses = new THashSet<PsiClass>();
        this.myResolveHelper = resolveHelper;
    }

    @NotNull
    private MostlySingularMultiMap<MethodSignature, PsiMethod> getDuplicateMethods(@NotNull PsiClass aClass2) {
        MostlySingularMultiMap<MethodSignature, PsiMethod> signatures;
        if (aClass2 == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(1);
        }
        if ((signatures = this.myDuplicateMethods.get(aClass2)) == null) {
            signatures = new MostlySingularMultiMap();
            for (PsiMethod method : aClass2.getMethods()) {
                if (method instanceof ExternallyDefinedPsiElement) continue;
                MethodSignature signature2 = method.getSignature(PsiSubstitutor.EMPTY);
                signatures.add(signature2, method);
            }
            this.myDuplicateMethods.put(aClass2, signatures);
        }
        MostlySingularMultiMap<MethodSignature, PsiMethod> mostlySingularMultiMap = signatures;
        if (mostlySingularMultiMap == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(2);
        }
        return mostlySingularMultiMap;
    }

    @Override
    @NotNull
    public HighlightVisitorImpl clone() {
        HighlightVisitorImpl highlightVisitorImpl = new HighlightVisitorImpl(this.myResolveHelper);
        if (highlightVisitorImpl == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(3);
        }
        return highlightVisitorImpl;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(4);
        }
        return file2 instanceof PsiImportHolder && !InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2);
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(5);
        }
        if (Holder.CHECK_ELEMENT_LEVEL) {
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(element);
            element.accept(this);
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(null);
        } else {
            element.accept(this);
        }
    }

    private void registerReferencesFromInjectedFragments(@NotNull PsiElement element) {
        if (element == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(6);
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.myFile.getProject());
        manager.enumerateEx(element, this.myFile, false, (injectedPsi, places) -> injectedPsi.accept(this.REGISTER_REFERENCES_VISITOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable highlight) {
        if (file2 == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(8);
        }
        if (highlight == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(9);
        }
        boolean success = true;
        try {
            this.prepare(Holder.CHECK_ELEMENT_LEVEL ? new CheckLevelHighlightInfoHolder(file2, holder) : holder, file2);
            if (updateWholeFile) {
                RefCountHolder refCountHolder;
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress == null) {
                    throw new IllegalStateException("Must be run under progress");
                }
                this.myRefCountHolder = refCountHolder = RefCountHolder.get(file2);
                Project project = file2.getProject();
                Document document = PsiDocumentManager.getInstance(project).getDocument(file2);
                TextRange dirtyScope = Optional.ofNullable(document).map(doc -> DaemonCodeAnalyzerEx.getInstanceEx(project).getFileStatusMap().getFileDirtyScope((Document)doc, 4)).orElse(file2.getTextRange());
                success = refCountHolder.analyze(file2, dirtyScope, progress, () -> {
                    if (highlight == null) {
                        HighlightVisitorImpl.$$$reportNull$$$0(21);
                    }
                    if (file2 == null) {
                        HighlightVisitorImpl.$$$reportNull$$$0(22);
                    }
                    if (holder == null) {
                        HighlightVisitorImpl.$$$reportNull$$$0(23);
                    }
                    highlight.run();
                    ProgressManager.checkCanceled();
                    if (document != null) {
                        new PostHighlightingVisitor(file2, document, refCountHolder).collectHighlights(holder, progress);
                    }
                });
            } else {
                this.myRefCountHolder = null;
                highlight.run();
            }
        }
        finally {
            this.myUninitializedVarProblems.clear();
            this.myFinalVarProblems.clear();
            this.mySingleImportedClasses.clear();
            this.mySingleImportedFields.clear();
            this.myReassignedParameters.clear();
            this.myRefCountHolder = null;
            this.myJavaModule = null;
            this.myFile = null;
            this.myHolder = null;
            this.myDuplicateMethods.clear();
            this.myOverrideEquivalentMethodsVisitedClasses.clear();
        }
        return success;
    }

    protected void prepareToRunAsInspection(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(10);
        }
        this.prepare(holder, holder.getContextFile());
    }

    private void prepare(HighlightInfoHolder holder, PsiFile file2) {
        this.myHolder = holder;
        this.myFile = file2;
        this.myLanguageLevel = PsiUtil.getLanguageLevel(file2);
        this.myJavaSdkVersion = ObjectUtils.notNull(JavaVersionService.getInstance().getJavaSdkVersion(file2), JavaSdkVersion.fromLanguageLevel(this.myLanguageLevel));
        this.myJavaModule = this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) ? JavaModuleGraphUtil.findDescriptorByElement(file2) : null;
    }

    @Override
    public void visitElement(PsiElement element) {
        if (this.myRefCountHolder != null && this.myFile instanceof ServerPageFile) {
            try {
                for (PsiReference reference : element.getReferences()) {
                    if (!(reference instanceof PsiJavaReference)) continue;
                    PsiJavaReference psiJavaReference = (PsiJavaReference)reference;
                    this.myRefCountHolder.registerReference(psiJavaReference, psiJavaReference.advancedResolve(false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!(this.myFile instanceof ServerPageFile)) {
            this.myHolder.add(DefaultHighlightUtil.checkBadCharacter(element));
        }
    }

    @Override
    public void visitAnnotation(PsiAnnotation annotation2) {
        super.visitAnnotation(annotation2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(annotation2, HighlightUtil.Feature.ANNOTATIONS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkApplicability(annotation2, this.myLanguageLevel, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationType(annotation2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMissingAttributes(annotation2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkTargetAnnotationDuplicates(annotation2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkDuplicateAnnotations(annotation2, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkFunctionalInterface(annotation2, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkRepeatableAnnotation(annotation2));
        }
        if ("java.lang.Override".equals(annotation2.getQualifiedName())) {
            PsiElement parent2;
            PsiAnnotationOwner owner = annotation2.getOwner();
            PsiElement psiElement = parent2 = owner instanceof PsiModifierList ? ((PsiModifierList)owner).getParent() : null;
            if (parent2 instanceof PsiMethod) {
                this.myHolder.add(GenericsHighlightUtil.checkOverrideAnnotation((PsiMethod)parent2, annotation2, this.myLanguageLevel));
            }
        }
    }

    @Override
    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer2) {
        PsiType type2;
        PsiMethod method = null;
        PsiElement parent2 = initializer2.getParent();
        if (parent2 instanceof PsiNameValuePair) {
            PsiReference reference = parent2.getReference();
            if (reference != null) {
                method = (PsiMethod)reference.resolve();
            }
        } else if (PsiUtil.isAnnotationMethod(parent2)) {
            method = (PsiMethod)parent2;
        }
        if (method != null && (type2 = method.getReturnType()) instanceof PsiArrayType) {
            PsiAnnotationMemberValue[] initializers;
            type2 = ((PsiArrayType)type2).getComponentType();
            for (PsiAnnotationMemberValue initializer1 : initializers = initializer2.getInitializers()) {
                this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(initializer1, type2));
            }
        }
    }

    @Override
    public void visitAnnotationMethod(PsiAnnotationMethod method) {
        PsiTypeElement typeElement;
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value = method.getDefaultValue();
        if (returnType != null && value != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(value, returnType));
        }
        if ((typeElement = method.getReturnTypeElement()) != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkValidAnnotationType(returnType, typeElement));
        }
        PsiClass aClass2 = method.getContainingClass();
        if (typeElement != null && aClass2 != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkCyclicMemberType(typeElement, aClass2));
        }
        this.myHolder.add(AnnotationsHighlightUtil.checkClashesWithSuperMethods(method));
        if (!this.myHolder.hasErrorResults() && aClass2 != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass2, method, this.getDuplicateMethods(aClass2)));
        }
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        super.visitArrayInitializerExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkArrayInitializerApplicable(expression2));
        }
        if (!(expression2.getParent() instanceof PsiNewExpression) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation(expression2, expression2.getType()));
        }
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentCompatibleTypes(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentOperatorApplicable(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(assignment);
        }
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        super.visitPolyadicExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPolyadicOperatorApplicable(expression2));
        }
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        PsiElement body;
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        this.myHolder.add(this.checkFeature(expression2, HighlightUtil.Feature.LAMBDA_EXPRESSIONS));
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expression2.getParent());
        if (HighlightVisitorImpl.toReportFunctionalExpressionProblemOnParent(parent2)) {
            return;
        }
        if (!this.myHolder.hasErrorResults() && !LambdaUtil.isValidLambdaContext(parent2)) {
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip("Lambda expression not expected here").create());
        }
        PsiType functionalInterfaceType = null;
        if (!this.myHolder.hasErrorResults()) {
            functionalInterfaceType = expression2.getFunctionalInterfaceType();
            if (functionalInterfaceType != null) {
                String notFunctionalMessage = LambdaHighlightingUtil.checkInterfaceFunctional(functionalInterfaceType);
                if (notFunctionalMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(notFunctionalMessage).create());
                } else {
                    this.checkFunctionalInterfaceTypeAccessible(expression2, functionalInterfaceType);
                }
            } else if (LambdaUtil.getFunctionalInterfaceType(expression2, true) != null) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip("Cannot infer functional interface type").create());
            }
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null) {
            JavaResolveResult containingCallResolveResult;
            String parentInferenceErrorMessage = null;
            PsiCall callExpression = parent2 instanceof PsiExpressionList && parent2.getParent() instanceof PsiCallExpression ? (PsiCallExpression)parent2.getParent() : null;
            JavaResolveResult javaResolveResult = containingCallResolveResult = callExpression != null ? callExpression.resolveMethodGenerics() : null;
            if (containingCallResolveResult instanceof MethodCandidateInfo) {
                parentInferenceErrorMessage = ((MethodCandidateInfo)containingCallResolveResult).getInferenceErrorMessage();
            }
            Map<PsiElement, String> returnErrors = LambdaUtil.checkReturnTypeCompatible(expression2, LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType));
            if (!(parentInferenceErrorMessage == null || returnErrors != null && returnErrors.containsValue(parentInferenceErrorMessage))) {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(parentInferenceErrorMessage).create();
                if (returnErrors != null) {
                    returnErrors.keySet().forEach(k -> QuickFixAction.registerQuickFixAction(info, AdjustFunctionContextFix.createFix(k)));
                }
                this.myHolder.add(info);
            } else if (returnErrors != null) {
                for (Map.Entry<PsiElement, String> entry : returnErrors.entrySet()) {
                    HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(entry.getKey()).descriptionAndTooltip(entry.getValue()).create();
                    QuickFixAction.registerQuickFixAction(info, AdjustFunctionContextFix.createFix(entry.getKey()));
                    if (entry.getKey() instanceof PsiExpression) {
                        PsiExpression expr = (PsiExpression)entry.getKey();
                        HighlightFixUtil.registerLambdaReturnTypeFixes(info, expression2, expr);
                    }
                    this.myHolder.add(info);
                }
            }
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType))) != null) {
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            this.myHolder.add(LambdaHighlightingUtil.checkParametersCompatible(expression2, parameters2, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)));
        }
        if (!this.myHolder.hasErrorResults() && (body = expression2.getBody()) instanceof PsiCodeBlock) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement((PsiCodeBlock)body));
        }
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement2) {
        super.visitBreakStatement(statement2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement2.getLabelIdentifier(), statement2.findExitedStatement()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkBreakOutsideLoop(statement2));
        }
    }

    @Override
    public void visitClass(PsiClass aClass2) {
        super.visitClass(aClass2);
        if (aClass2 instanceof PsiSyntheticClass) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassSupersAccessibility(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkDuplicateTopLevelClass(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumMustNotBeLocal(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumWithoutConstantsCantHaveAbstractMethods(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkImplicitThisReferenceBeforeSuper(aClass2, this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassAndPackageConflict(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkPublicClassInRightFile(aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterOverrideEquivalentMethods(aClass2, this.myLanguageLevel));
        }
    }

    @Override
    public void visitClassInitializer(PsiClassInitializer initializer2) {
        super.visitClassInitializer(initializer2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkInitializerCompleteNormally(initializer2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(initializer2.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface(initializer2, initializer2.getContainingClass()));
        }
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        super.visitClassObjectAccessExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassObjectAccessExpression(expression2));
        }
    }

    @Override
    public void visitComment(PsiComment comment) {
        super.visitComment(comment);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments(comment);
        }
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement2) {
        super.visitContinueStatement(statement2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement2.getLabelIdentifier(), statement2.findContinuedStatement()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkContinueOutsideLoop(statement2));
        }
    }

    @Override
    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        if (!this.myHolder.hasErrorResults() && token.getTokenType() == JavaTokenType.RBRACE && token.getParent() instanceof PsiCodeBlock) {
            PsiType returnType;
            PsiCodeBlock codeBlock;
            PsiElement gParent = token.getParent().getParent();
            if (gParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)gParent;
                codeBlock = method.getBody();
                returnType = method.getReturnType();
            } else if (gParent instanceof PsiLambdaExpression) {
                PsiElement body = ((PsiLambdaExpression)gParent).getBody();
                if (!(body instanceof PsiCodeBlock)) {
                    return;
                }
                codeBlock = (PsiCodeBlock)body;
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)gParent);
            } else {
                return;
            }
            this.myHolder.add(HighlightControlFlowUtil.checkMissingReturnStatement(codeBlock, returnType));
        }
    }

    @Override
    public void visitDocComment(PsiDocComment comment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
    }

    @Override
    public void visitDocTagValue(PsiDocTagValue value) {
        PsiReference reference = value.getReference();
        if (reference != null) {
            PsiElement element = reference.resolve();
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (element instanceof PsiMethod) {
                PsiElement nameElement = ((PsiDocMethodOrFieldRef)value).getNameElement();
                if (nameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)element, nameElement, false, colorsScheme));
                }
            } else if (element instanceof PsiParameter) {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)element, value.getNavigationElement(), colorsScheme));
            }
        }
    }

    @Override
    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        if (!this.myHolder.hasErrorResults()) {
            GenericsHighlightUtil.checkEnumConstantForConstructorProblems(enumConstant, this.myHolder, this.myJavaSdkVersion);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall(enumConstant);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions(enumConstant, null));
        }
    }

    @Override
    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        super.visitEnumConstantInitializer(enumConstantInitializer);
        if (!this.myHolder.hasErrorResults()) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(enumConstantInitializer);
            this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(enumConstantInitializer, textRange));
        }
    }

    @Override
    public void visitExpression(PsiExpression expression2) {
        PsiElement parent2;
        ProgressManager.checkCanceled();
        super.visitExpression(expression2);
        PsiType type2 = expression2.getType();
        if (this.myHolder.add(HighlightUtil.checkMustBeBoolean(expression2, type2))) {
            return;
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            this.myHolder.add(HighlightUtil.checkValidArrayAccessExpression((PsiArrayAccessExpression)expression2));
        }
        if ((parent2 = expression2.getParent()) instanceof PsiNewExpression && ((PsiNewExpression)parent2).getQualifier() != expression2 && ((PsiNewExpression)parent2).getArrayInitializer() != expression2) {
            this.myHolder.add(HighlightUtil.checkAssignability(PsiType.INT, expression2.getType(), expression2, expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkCannotWriteToFinal(expression2, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkVariableExpected(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkArrayInitializer(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTernaryOperatorConditionIsBoolean(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssertOperatorTypes(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSynchronizedExpressionType(expression2, type2, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkConditionalExpressionBranchTypesMatch(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults() && parent2 instanceof PsiThrowStatement && ((PsiThrowStatement)parent2).getException() == expression2) {
            this.myHolder.add(HighlightUtil.checkMustBeThrowable(type2, expression2, true));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkConstantExpression(expression2));
        }
        if (!this.myHolder.hasErrorResults() && parent2 instanceof PsiForeachStatement && ((PsiForeachStatement)parent2).getIteratedValue() == expression2) {
            this.myHolder.add(GenericsHighlightUtil.checkForeachExpressionTypeIsIterable(expression2));
        }
    }

    @Override
    public void visitExpressionList(PsiExpressionList list2) {
        PsiMethodCallExpression expression2;
        super.visitExpressionList(list2);
        PsiElement parent2 = list2.getParent();
        if (parent2 instanceof PsiMethodCallExpression && (expression2 = (PsiMethodCallExpression)parent2).getArgumentList() == list2) {
            PsiReferenceExpression referenceExpression = expression2.getMethodExpression();
            JavaResolveResult[] results = this.resolveOptimised(referenceExpression);
            if (results == null) {
                return;
            }
            JavaResolveResult result2 = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            PsiElement resolved = result2.getElement();
            if (!(result2.isAccessible() && result2.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(expression2, this.myResolveHelper, list2, referenceExpression) || referenceExpression.getParent() != expression2)) {
                try {
                    if (PsiTreeUtil.findChildrenOfType(expression2.getArgumentList(), PsiLambdaExpression.class).isEmpty()) {
                        this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(referenceExpression, results, list2, resolved, result2, expression2, this.myResolveHelper, list2));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void visitField(PsiField field) {
        super.visitField(field);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkFinalFieldInitialized(field));
        }
    }

    @Override
    public void visitForStatement(PsiForStatement statement2) {
        this.myHolder.add(HighlightUtil.checkForStatement(statement2));
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement2) {
        this.myHolder.add(this.checkFeature(statement2, HighlightUtil.Feature.FOR_EACH));
    }

    @Override
    public void visitImportStaticStatement(PsiImportStaticStatement statement2) {
        this.myHolder.add(this.checkFeature(statement2, HighlightUtil.Feature.STATIC_IMPORTS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ImportsHighlightUtil.checkStaticOnDemandImportResolvesToClass(statement2));
        }
    }

    @Override
    public void visitIdentifier(PsiIdentifier identifier) {
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        PsiElement parent2 = identifier.getParent();
        if (parent2 instanceof PsiVariable) {
            boolean isMethodParameter;
            PsiElement child;
            PsiVariable variable2 = (PsiVariable)parent2;
            this.myHolder.add(HighlightUtil.checkVariableAlreadyDefined(variable2));
            if (variable2.getInitializer() == null && (child = variable2.getLastChild()) instanceof PsiErrorElement && child.getPrevSibling() == identifier) {
                return;
            }
            boolean bl = isMethodParameter = variable2 instanceof PsiParameter && ((PsiParameter)variable2).getDeclarationScope() instanceof PsiMethod;
            if (isMethodParameter) {
                this.myReassignedParameters.put((PsiParameter)variable2, 1);
            } else if (HighlightControlFlowUtil.isReassigned(variable2, this.myFinalVarProblems)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable2, identifier));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable2, identifier, colorsScheme));
            }
        } else if (parent2 instanceof PsiClass) {
            PsiClass aClass2 = (PsiClass)parent2;
            if (aClass2.isAnnotationType()) {
                this.myHolder.add(this.checkFeature(identifier, HighlightUtil.Feature.ANNOTATIONS));
            }
            this.myHolder.add(HighlightClassUtil.checkClassAlreadyImported(aClass2, identifier));
            if (!(parent2 instanceof PsiAnonymousClass) && aClass2.getNameIdentifier() == identifier) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName(aClass2, identifier, colorsScheme));
            }
            if (!this.myHolder.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_X)) {
                this.myHolder.add(HighlightClassUtil.checkVarClassConflict(aClass2, identifier));
            }
            if (!this.myHolder.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedDefaultMethods(aClass2, identifier));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedConcrete(aClass2, identifier));
            }
        } else if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            if (method.isConstructor()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorName(method));
            }
            this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, identifier, true, colorsScheme));
            PsiClass aClass3 = method.getContainingClass();
            if (aClass3 != null) {
                this.myHolder.add(GenericsHighlightUtil.checkDefaultMethodOverrideEquivalentToObjectNonPrivate(this.myLanguageLevel, aClass3, method, identifier));
            }
        }
        this.myHolder.add(HighlightUtil.checkUnderscore(identifier, this.myLanguageLevel));
        super.visitIdentifier(identifier);
    }

    @Override
    public void visitImportStatement(PsiImportStatement statement2) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSingleImportClassConflict(statement2, this.mySingleImportedClasses, this.myFile));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitImportStaticReferenceElement(@NotNull PsiImportStaticReferenceElement ref) {
        if (ref == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(11);
        }
        String refName = ref.getReferenceName();
        JavaResolveResult[] results = ref.multiResolve(false);
        PsiElement referenceNameElement = ref.getReferenceNameElement();
        if (results.length == 0) {
            String description2 = JavaErrorMessages.message("cannot.resolve.symbol", refName);
            assert (referenceNameElement != null) : ref;
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(referenceNameElement).descriptionAndTooltip(description2).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSetupJDKFix());
            this.myHolder.add(highlightInfo);
        } else {
            PsiManager manager = ref.getManager();
            for (JavaResolveResult result2 : results) {
                Pair<PsiImportStaticReferenceElement, PomRenameableTarget<PsiElement>> imported;
                PsiElement element = result2.getElement();
                String description3 = null;
                if (element instanceof PsiClass) {
                    PsiClass aClass2;
                    imported = this.mySingleImportedClasses.get(refName);
                    PsiClass psiClass = aClass2 = imported == null ? null : imported.getSecond();
                    if (aClass2 != null && !manager.areElementsEquivalent(aClass2, element)) {
                        description3 = imported.first == null ? JavaErrorMessages.message("single.import.class.conflict", refName) : (((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorMessages.message("class.is.ambiguous.in.single.static.import", refName) : JavaErrorMessages.message("class.is.already.defined.in.single.static.import", refName));
                    }
                    this.mySingleImportedClasses.put(refName, Pair.create(ref, (PsiClass)element));
                } else if (element instanceof PsiField) {
                    PsiField field;
                    imported = this.mySingleImportedFields.get(refName);
                    PsiField psiField = field = imported == null ? null : (PsiField)imported.getSecond();
                    if (field != null && !manager.areElementsEquivalent(field, element)) {
                        description3 = ((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorMessages.message("field.is.ambiguous.in.single.static.import", refName) : JavaErrorMessages.message("field.is.already.defined.in.single.static.import", refName);
                    }
                    this.mySingleImportedFields.put(refName, Pair.create(ref, (PsiField)element));
                }
                if (description3 == null) continue;
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(description3).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            PsiElement resolved;
            PsiElement psiElement = resolved = results.length >= 1 ? results[0].getElement() : null;
            if (results.length > 1) {
                void var6_10;
                boolean bl = true;
                while (var6_10 < results.length) {
                    PsiElement element = results[var6_10].getElement();
                    if (resolved instanceof PsiMethod && !(element instanceof PsiMethod) || resolved instanceof PsiVariable && !(element instanceof PsiVariable) || resolved instanceof PsiClass && !(element instanceof PsiClass)) {
                        resolved = null;
                        break;
                    }
                    ++var6_10;
                }
            }
            TextAttributesScheme textAttributesScheme = this.myHolder.getColorsScheme();
            if (resolved instanceof PsiClass) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, ref, textAttributesScheme));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(ref, textAttributesScheme));
                if (referenceNameElement != null) {
                    if (resolved instanceof PsiVariable) {
                        this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)resolved, referenceNameElement, textAttributesScheme));
                    } else if (resolved instanceof PsiMethod) {
                        this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)resolved, referenceNameElement, false, textAttributesScheme));
                    }
                }
            }
        }
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        super.visitInstanceOfExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkInstanceOfApplicable(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInstanceOfGenericType(expression2));
        }
    }

    @Override
    public void visitKeyword(PsiKeyword keyword) {
        super.visitKeyword(keyword);
        PsiElement parent2 = keyword.getParent();
        String text2 = keyword.getText();
        if (parent2 instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)parent2;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkNotAllowedModifier(keyword, psiModifierList));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIllegalModifierCombination(keyword, psiModifierList));
            }
            if ("abstract".equals(text2) && psiModifierList.getParent() instanceof PsiMethod && !this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkAbstractMethodInConcreteClass((PsiMethod)psiModifierList.getParent(), keyword));
            }
        } else if ("interface".equals(text2) && parent2 instanceof PsiClass && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInterfaceCannotBeLocal((PsiClass)parent2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkStaticDeclarationInInnerClass(keyword));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalVoidType(keyword));
        }
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        super.visitLabeledStatement(statement2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelWithoutStatement(statement2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelAlreadyInUse(statement2));
        }
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        super.visitLiteralExpression(expression2);
        if (this.myHolder.hasErrorResults()) {
            return;
        }
        this.myHolder.add(HighlightUtil.checkLiteralExpressionParsingError(expression2, this.myLanguageLevel, this.myFile));
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments(expression2);
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            for (PsiReference reference : expression2.getReferences()) {
                PsiElement resolve2 = reference.resolve();
                if (!(resolve2 instanceof PsiMember)) continue;
                this.myRefCountHolder.registerReference(reference, new CandidateInfo(resolve2, PsiSubstitutor.EMPTY));
            }
        }
    }

    @Override
    public void visitMethod(PsiMethod method) {
        super.visitMethod(method);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(method.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorHandleSuperClassExceptions(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkRecursiveConstructorInvocation(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSafeVarargsAnnotation(method, this.myLanguageLevel));
        }
        PsiClass aClass2 = method.getContainingClass();
        if (!this.myHolder.hasErrorResults() && method.isConstructor()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface(method, aClass2));
        }
        if (!this.myHolder.hasErrorResults() && method.hasModifierProperty("default")) {
            this.myHolder.add(this.checkFeature(method, HighlightUtil.Feature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass2 != null && aClass2.isInterface() && method.hasModifierProperty("static")) {
            this.myHolder.add(this.checkFeature(method, HighlightUtil.Feature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass2 != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass2, method, this.getDuplicateMethods(aClass2)));
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        for (PsiParameter parameter : parameters2) {
            PsiIdentifier nameIdentifier;
            int info = this.myReassignedParameters.get(parameter);
            if (info == 0 || (nameIdentifier = parameter.getNameIdentifier()) == null) continue;
            if (info == 2) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(parameter, nameIdentifier));
                continue;
            }
            this.myHolder.add(HighlightNamesUtil.highlightVariableName(parameter, nameIdentifier, colorsScheme));
        }
    }

    private void highlightReferencedMethodOrClassName(@NotNull PsiJavaCodeReferenceElement element, PsiElement resolved) {
        if (element == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(12);
        }
        PsiElement parent2 = element.getParent();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        if (parent2 instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)parent2).resolveMethod();
            PsiElement methodNameElement = element.getReferenceNameElement();
            if (method != null && methodNameElement != null && !(methodNameElement instanceof PsiKeyword)) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, methodNameElement, false, colorsScheme));
                this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(element, colorsScheme));
            }
        } else if (parent2 instanceof PsiConstructorCall) {
            try {
                PsiElement referenceNameElement;
                PsiMethod methodOrClass;
                PsiMethod method = ((PsiConstructorCall)parent2).resolveConstructor();
                PsiTypeParameterListOwner psiTypeParameterListOwner = method != null ? method : (methodOrClass = resolved instanceof PsiClass ? (PsiClass)resolved : null);
                if (methodOrClass != null && (referenceNameElement = element.getReferenceNameElement()) != null) {
                    TextRange range = referenceNameElement.getTextRange();
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName(methodOrClass, referenceNameElement, range, colorsScheme, false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (resolved instanceof PsiPackage) {
            this.myHolder.add(HighlightNamesUtil.highlightPackage(resolved, element, colorsScheme));
        } else if (resolved instanceof PsiClass) {
            this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, element, colorsScheme));
        }
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumSuperConstructorCall(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSuperQualifierType(this.myFile.getProject(), expression2));
        }
        if (this.myFile.isPhysical() && !this.myHolder.hasErrorResults()) {
            try {
                this.myHolder.add(HighlightMethodUtil.checkMethodCall(expression2, this.myResolveHelper, this.myLanguageLevel, this.myJavaSdkVersion, this.myFile));
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorCallMustBeFirstStatement(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkSuperAbstractMethodDirectCall(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expression2);
        }
    }

    @Override
    public void visitModifierList(PsiModifierList list2) {
        super.visitModifierList(list2);
        PsiElement parent2 = list2.getParent();
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodCanHaveBody(method, this.myLanguageLevel));
            }
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                try {
                    List<HierarchicalMethodSignature> superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
                    if (!superMethodSignatures.isEmpty()) {
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, true));
                        }
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleThrows(methodSignature, superMethodSignatures, true, method.getContainingClass()));
                        }
                        if (!method.hasModifierProperty("static")) {
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodWeakerPrivileges(methodSignature, superMethodSignatures, true, this.myFile));
                            }
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodOverridesFinal(methodSignature, superMethodSignatures));
                            }
                        }
                    }
                }
                catch (IndexNotReadyException superMethodSignatures) {
                    // empty catch block
                }
            }
            PsiClass aClass2 = method.getContainingClass();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodMustHaveBody(method, aClass2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorCallsBaseClassConstructor(method, this.myRefCountHolder, this.myResolveHelper));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkStaticMethodOverride(method, this.myFile));
            }
            if (!this.myHolder.hasErrorResults() && aClass2 != null && this.myOverrideEquivalentMethodsVisitedClasses.add(aClass2)) {
                this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass2));
            }
        } else if (parent2 instanceof PsiClass) {
            PsiClass aClass3 = (PsiClass)parent2;
            try {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkDuplicateNestedClass(aClass3));
                }
                if (!this.myHolder.hasErrorResults()) {
                    TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass3);
                    this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(aClass3, textRange));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkClassDoesNotCallSuperConstructorOrHandleExceptions(aClass3, this.myRefCountHolder, this.myResolveHelper));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightMethodUtil.checkOverrideEquivalentInheritedMethods(aClass3, this.myFile, this.myLanguageLevel));
                }
                if (!this.myHolder.hasErrorResults() && this.myOverrideEquivalentMethodsVisitedClasses.add(aClass3)) {
                    this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass3));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkCyclicInheritance(aClass3));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (parent2 instanceof PsiEnumConstant && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(GenericsHighlightUtil.checkEnumConstantModifierList(list2));
        }
    }

    @Override
    public void visitNameValuePair(PsiNameValuePair pair) {
        PsiIdentifier nameId;
        this.myHolder.add(AnnotationsHighlightUtil.checkNameValuePair(pair));
        if (!this.myHolder.hasErrorResults() && (nameId = pair.getNameIdentifier()) != null) {
            HighlightInfo result2 = HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.ANNOTATION_ATTRIBUTE_NAME).range(nameId).create();
            this.myHolder.add(result2);
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression2) {
        PsiType type2 = expression2.getType();
        PsiClass aClass2 = PsiUtil.resolveClassInType(type2);
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions(expression2, null));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousInheritFinal(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkQualifiedNew(expression2, type2, aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext(expression2, type2, aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterInstantiation(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(aClass2, expression2));
        }
        try {
            if (!this.myHolder.hasErrorResults()) {
                HighlightMethodUtil.checkNewExpression(expression2, type2, this.myHolder, this.myJavaSdkVersion);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation(expression2, aClass2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall(expression2);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expression2);
        }
    }

    @Override
    public void visitPackageStatement(PsiPackageStatement statement2) {
        super.visitPackageStatement(statement2);
        this.myHolder.add(AnnotationsHighlightUtil.checkPackageAnnotationContainingFile(statement2, this.myFile));
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkPackageStatement(statement2, this.myFile, this.myJavaModule));
        }
    }

    @Override
    public void visitParameter(PsiParameter parameter) {
        super.visitParameter(parameter);
        PsiElement parent2 = parameter.getParent();
        if (parent2 instanceof PsiParameterList && parameter.isVarArgs()) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(this.checkFeature(parameter, HighlightUtil.Feature.VARARGS));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkVarArgParameterIsLast(parameter));
            }
        } else if (parent2 instanceof PsiCatchSection) {
            if (!this.myHolder.hasErrorResults() && parameter.getType() instanceof PsiDisjunctionType) {
                this.myHolder.add(this.checkFeature(parameter, HighlightUtil.Feature.MULTI_CATCH));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkCatchParameterIsThrowable(parameter));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(GenericsHighlightUtil.checkCatchParameterIsClass(parameter));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(HighlightUtil.checkCatchTypeIsDisjoint(parameter));
            }
        } else if (parent2 instanceof PsiForeachStatement && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkForEachParameterType((PsiForeachStatement)parent2, parameter));
        }
    }

    @Override
    public void visitParameterList(PsiParameterList list2) {
        super.visitParameterList(list2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAnnotationMethodParameters(list2));
        }
    }

    @Override
    public void visitUnaryExpression(PsiUnaryExpression expression2) {
        super.visitUnaryExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression2.getOperationSign(), expression2.getOperand()));
        }
    }

    private void registerConstructorCall(@NotNull PsiConstructorCall constructorCall) {
        JavaResolveResult resolveResult;
        PsiElement resolved;
        if (constructorCall == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(13);
        }
        if (this.myRefCountHolder != null && (resolved = (resolveResult = constructorCall.resolveMethodGenerics()).getElement()) instanceof PsiNamedElement) {
            this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
        }
    }

    @Override
    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        JavaResolveResult result2 = this.doVisitReferenceElement(ref);
        if (result2 != null) {
            PsiElement resolved = result2.getElement();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkRawOnParameterizedType(ref, resolved));
            }
        }
    }

    private JavaResolveResult doVisitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiClass containingClass;
        JavaResolveResult result2;
        if (ref == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(14);
        }
        if ((result2 = this.resolveOptimised(ref)) == null) {
            return null;
        }
        PsiElement resolved = result2.getElement();
        PsiElement parent2 = ref.getParent();
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference(ref, result2);
        }
        this.myHolder.add(HighlightUtil.checkReference(ref, result2, this.myFile, this.myLanguageLevel));
        if ((parent2 instanceof PsiJavaCodeReferenceElement || ref.isQualified()) && !this.myHolder.hasErrorResults() && resolved instanceof PsiTypeParameter) {
            boolean canSelectFromTypeParameter = this.myJavaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7);
            if (canSelectFromTypeParameter && (containingClass = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class)) != null && (PsiTreeUtil.isAncestor(containingClass.getExtendsList(), ref, false) || PsiTreeUtil.isAncestor(containingClass.getImplementsList(), ref, false))) {
                canSelectFromTypeParameter = false;
            }
            if (!canSelectFromTypeParameter) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Cannot select from a type parameter").range(ref).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAbstractInstantiation(ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkExtendsDuplicate(ref, resolved, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassExtendsForeignInnerClass(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSelectStaticClassFromParameterizedType(resolved, ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, ref, result2.getSubstitutor(), this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkCannotPassInner(ref));
        }
        if (resolved != null && parent2 instanceof PsiReferenceList && !this.myHolder.hasErrorResults()) {
            PsiReferenceList referenceList = (PsiReferenceList)parent2;
            this.myHolder.add(HighlightUtil.checkElementInReferenceList(ref, referenceList, result2));
        }
        if (parent2 instanceof PsiAnonymousClass && ref.equals(((PsiAnonymousClass)parent2).getBaseClassReference()) && this.myOverrideEquivalentMethodsVisitedClasses.add((PsiClass)parent2)) {
            PsiClass aClass2 = (PsiClass)parent2;
            this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass2));
        }
        if (resolved instanceof PsiVariable) {
            PsiVariable variable2 = (PsiVariable)resolved;
            containingClass = PsiTreeUtil.getNonStrictParentOfType(ref, PsiClass.class, PsiLambdaExpression.class);
            if (!(!(containingClass instanceof PsiAnonymousClass) && !(containingClass instanceof PsiLambdaExpression) || PsiTreeUtil.isAncestor(containingClass, variable2, false) || variable2 instanceof PsiField || !(containingClass instanceof PsiLambdaExpression) && PsiTreeUtil.isAncestor(((PsiAnonymousClass)containingClass).getArgumentList(), ref, false))) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.IMPLICIT_ANONYMOUS_CLASS_PARAMETER).range(ref).create());
            }
            if (variable2 instanceof PsiParameter && ref instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((Object)ref))) {
                this.myReassignedParameters.put((PsiParameter)variable2, 2);
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (!variable2.hasModifierProperty("final") && this.isReassigned(variable2)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable2, ref));
            } else {
                PsiElement nameElement = ref.getReferenceNameElement();
                if (nameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable2, nameElement, colorsScheme));
                }
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(ref, colorsScheme));
        } else {
            this.highlightReferencedMethodOrClassName(ref, resolved);
        }
        if (parent2 instanceof PsiNewExpression && !(resolved instanceof PsiClass) && resolved instanceof PsiNamedElement && ((PsiNewExpression)parent2).getClassOrAnonymousClassReference() == ref) {
            String text2 = JavaErrorMessages.message("cannot.resolve.symbol", ((PsiNamedElement)resolved).getName());
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(text2).create());
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiClass) {
            PsiClass outerClass2;
            PsiTypeParameterListOwner owner;
            PsiClass aClass3 = ((PsiClass)resolved).getContainingClass();
            if (aClass3 != null) {
                PsiExpression newQualifier;
                PsiElement qualifier = ref.getQualifier();
                PsiElement place = qualifier instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)qualifier).resolve() : (parent2 instanceof PsiNewExpression ? ((newQualifier = ((PsiNewExpression)parent2).getQualifier()) == null ? ref : PsiUtil.resolveClassInType(newQualifier.getType())) : ref);
                if (place != null && PsiTreeUtil.isAncestor(aClass3, place, false) && aClass3.hasTypeParameters()) {
                    this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)ref, place, (PsiClass)resolved));
                }
            } else if (resolved instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)resolved).getOwner()) instanceof PsiClass && !InheritanceUtil.hasEnclosingInstanceInScope(outerClass2 = (PsiClass)owner, (PsiElement)ref, false, false)) {
                this.myHolder.add(HighlightClassUtil.reportIllegalEnclosingUsage(ref, null, (PsiClass)owner, ref));
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPackageAndClassConflict(ref, this.myFile));
        }
        return result2;
    }

    @Nullable
    private JavaResolveResult resolveOptimised(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(15);
        }
        try {
            if (ref instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver2 = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                JavaResolveResult[] results = JavaResolveUtil.resolveWithContainingFile(ref, resolver2, true, true, this.myFile);
                return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            }
            return ref.advancedResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private JavaResolveResult[] resolveOptimised(@NotNull PsiReferenceExpression expression2) {
        if (expression2 == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(16);
        }
        try {
            if (expression2 instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver2 = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                return JavaResolveUtil.resolveWithContainingFile(expression2, resolver2, true, true, this.myFile);
            }
            return expression2.multiResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiExpressionList list2;
        PsiMethodCallExpression methodCallExpression2;
        PsiElement parent2;
        JavaResolveResult[] results;
        JavaResolveResult resultForIncompleteCode = this.doVisitReferenceElement(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expression2);
            if (this.myHolder.hasErrorResults()) {
                return;
            }
        }
        if ((results = this.resolveOptimised(expression2)) == null) {
            return;
        }
        JavaResolveResult result2 = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = result2.getElement();
        if (resolved instanceof PsiVariable && resolved.getContainingFile() == expression2.getContainingFile()) {
            PsiVariable variable2;
            boolean isFinal;
            if (!this.myHolder.hasErrorResults()) {
                try {
                    this.myHolder.add(HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression2, (PsiVariable)resolved, this.myUninitializedVarProblems, this.myFile));
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
            if ((isFinal = (variable2 = (PsiVariable)resolved).hasModifierProperty("final")) && !variable2.hasInitializer()) {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable2, expression2, this.myFinalVarProblems));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableInitializedInLoop(expression2, resolved));
                }
            }
        }
        if (!(!((parent2 = expression2.getParent()) instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)parent2).getMethodExpression() != expression2 || result2.isAccessible() && result2.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(methodCallExpression2 = (PsiMethodCallExpression)parent2, this.myResolveHelper, list2 = methodCallExpression2.getArgumentList(), expression2))) {
            try {
                PsiElement nameElement;
                this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallIdentifier(expression2, results, list2, resolved, result2, methodCallExpression2, this.myResolveHelper, this.myLanguageLevel, this.myFile));
                if (!PsiTreeUtil.findChildrenOfType(methodCallExpression2.getArgumentList(), PsiLambdaExpression.class).isEmpty() && (nameElement = expression2.getReferenceNameElement()) != null) {
                    this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(expression2, results, list2, resolved, result2, methodCallExpression2, this.myResolveHelper, nameElement));
                }
            }
            catch (IndexNotReadyException nameElement) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults() && resultForIncompleteCode != null) {
            this.myHolder.add(HighlightUtil.checkExpressionRequired(expression2, resultForIncompleteCode));
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiField) {
            try {
                this.myHolder.add(HighlightUtil.checkIllegalForwardReferenceToField(expression2, (PsiField)resolved));
            }
            catch (IndexNotReadyException methodCallExpression2) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkAccessStaticFieldFromEnumConstructor(expression2, result2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkClassReferenceAfterQualifier(expression2, resolved));
        }
        PsiExpression qualifierExpression = expression2.getQualifierExpression();
        this.myHolder.add(HighlightUtil.checkUnqualifiedSuperInDefaultMethod(this.myLanguageLevel, expression2, qualifierExpression));
        if (!this.myHolder.hasErrorResults() && qualifierExpression != null && this.myJavaModule == null) {
            PsiClass psiClass;
            PsiType type2 = qualifierExpression.getType();
            if (type2 instanceof PsiCapturedWildcardType) {
                type2 = ((PsiCapturedWildcardType)type2).getUpperBound();
            }
            if ((psiClass = PsiUtil.resolveClassInType(type2)) != null) {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(GenericsHighlightUtil.checkClassSupersAccessibility(psiClass, expression2));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(GenericsHighlightUtil.checkMemberSignatureTypesAccessibility(expression2));
                }
            }
        }
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        String badReturnTypeMessage;
        HighlightInfo info;
        PsiType functionalInterfaceType;
        String description2;
        PsiElement qualifier;
        PsiElement referenceNameElement;
        PsiElement method;
        JavaResolveResult result2;
        JavaResolveResult[] results;
        this.myHolder.add(this.checkFeature(expression2, HighlightUtil.Feature.METHOD_REFERENCES));
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expression2.getParent());
        if (HighlightVisitorImpl.toReportFunctionalExpressionProblemOnParent(parent2)) {
            return;
        }
        try {
            results = expression2.multiResolve(true);
            result2 = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference(expression2, result2);
        }
        if ((method = result2.getElement()) != null && !result2.isAccessible()) {
            String accessProblem = HighlightUtil.accessProblemDescription(expression2, method, result2);
            HighlightInfo info2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(accessProblem).create();
            HighlightFixUtil.registerAccessQuickFixAction((PsiMember)method, expression2, info2, result2.getCurrentFileResolveScope());
            this.myHolder.add(info2);
        } else {
            PsiElement methodNameElement;
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (method instanceof PsiMethod && !expression2.isConstructor() && (methodNameElement = expression2.getReferenceNameElement()) != null) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)method, methodNameElement, false, colorsScheme));
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(expression2, colorsScheme));
        }
        if (!LambdaUtil.isValidLambdaContext(parent2)) {
            String description3 = "Method reference expression is not expected here";
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description3).create());
        }
        if (!this.myHolder.hasErrorResults() && (referenceNameElement = expression2.getReferenceNameElement()) instanceof PsiKeyword && !PsiMethodReferenceUtil.isValidQualifier(expression2) && (qualifier = expression2.getQualifier()) != null) {
            description2 = "Cannot find class " + qualifier.getText();
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(description2).create());
        }
        if ((functionalInterfaceType = expression2.getFunctionalInterfaceType()) != null) {
            String errorMessage;
            if (!this.myHolder.hasErrorResults()) {
                boolean notFunctional;
                boolean bl = notFunctional = !LambdaUtil.isFunctionalType(functionalInterfaceType);
                if (notFunctional) {
                    description2 = functionalInterfaceType.getPresentableText() + " is not a functional interface";
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description2).create());
                }
            }
            if (!this.myHolder.hasErrorResults()) {
                this.checkFunctionalInterfaceTypeAccessible(expression2, functionalInterfaceType);
            }
            if (!this.myHolder.hasErrorResults() && (errorMessage = PsiMethodReferenceUtil.checkMethodReferenceContext(expression2)) != null) {
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(errorMessage).create();
                if (method instanceof PsiMethod && !((PsiMethod)method).isConstructor() && !((PsiMethod)method).hasModifierProperty("abstract")) {
                    boolean shouldHave = !((PsiMethod)method).hasModifierProperty("static");
                    QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)method, "static", shouldHave, false));
                }
                this.myHolder.add(info);
            }
        }
        if (!this.myHolder.hasErrorResults() && (qualifier = expression2.getQualifier()) instanceof PsiTypeElement) {
            PsiType psiType = ((PsiTypeElement)qualifier).getType();
            HighlightInfo genericArrayCreationInfo = GenericsHighlightUtil.checkGenericArrayCreation(qualifier, psiType);
            if (genericArrayCreationInfo != null) {
                this.myHolder.add(genericArrayCreationInfo);
            } else {
                String wildcardMessage = PsiMethodReferenceUtil.checkTypeArguments((PsiTypeElement)qualifier, psiType);
                if (wildcardMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(wildcardMessage).create());
                }
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(PsiMethodReferenceHighlightingUtil.checkRawConstructorReference(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions(expression2, expression2.getTextRange()));
        }
        if (!this.myHolder.hasErrorResults() && (badReturnTypeMessage = PsiMethodReferenceUtil.checkReturnType(expression2, result2, functionalInterfaceType)) != null) {
            info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(badReturnTypeMessage).create();
            QuickFixAction.registerQuickFixAction(info, AdjustFunctionContextFix.createFix(expression2));
            this.myHolder.add(info);
        }
        if (!this.myHolder.hasErrorResults() && (results.length == 0 || results[0] instanceof MethodCandidateInfo && !((MethodCandidateInfo)results[0]).isApplicable() && functionalInterfaceType != null)) {
            String description4 = null;
            if (results.length == 1) {
                description4 = ((MethodCandidateInfo)results[0]).getInferenceErrorMessage();
            }
            if (expression2.isConstructor()) {
                PsiClass containingClass = PsiMethodReferenceUtil.getQualifierResolveResult(expression2).getContainingClass();
                if (containingClass != null && !this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, expression2)) && !this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation(expression2, containingClass)) && containingClass.isPhysical() && description4 == null) {
                    description4 = JavaErrorMessages.message("cannot.resolve.constructor", containingClass.getName());
                }
            } else if (description4 == null) {
                description4 = JavaErrorMessages.message("cannot.resolve.method", expression2.getReferenceName());
            }
            if (description4 != null) {
                PsiElement referenceNameElement2 = ObjectUtils.notNull(expression2.getReferenceNameElement(), expression2);
                HighlightInfoType type2 = results.length == 0 ? HighlightInfoType.WRONG_REF : HighlightInfoType.ERROR;
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(type2).descriptionAndTooltip(description4).range(referenceNameElement2).create();
                this.myHolder.add(highlightInfo);
                TextRange fixRange = HighlightMethodUtil.getFixRange(referenceNameElement2);
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QuickFixFactory.getInstance().createCreateMethodFromUsageFix(expression2));
            }
        }
    }

    private static boolean toReportFunctionalExpressionProblemOnParent(PsiElement parent2) {
        if (parent2 instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)parent2).getTypeElement().isInferredType();
        }
        return parent2 instanceof PsiExpressionStatement;
    }

    private void checkFunctionalInterfaceTypeAccessible(@NotNull PsiFunctionalExpression expression2, PsiType functionalInterfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (expression2 == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(17);
        }
        if ((psiClass = (resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType)).getElement()) != null) {
            if (!PsiUtil.isAccessible(this.myFile.getProject(), psiClass, expression2, null)) {
                Pair<String, List<IntentionAction>> problem = HighlightUtil.accessProblemDescriptionAndFixes(expression2, psiClass, resolveResult);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip((String)problem.first).create();
                this.myHolder.add(info);
                if (problem.second != null) {
                    ((List)problem.second).forEach(fix -> QuickFixAction.registerQuickFixAction(info, fix));
                }
            } else {
                for (PsiType type2 : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    this.checkFunctionalInterfaceTypeAccessible(expression2, type2);
                }
            }
        }
    }

    @Override
    public void visitReferenceList(PsiReferenceList list2) {
        if (list2.getFirstChild() == null) {
            return;
        }
        PsiElement parent2 = list2.getParent();
        if (!(parent2 instanceof PsiTypeParameter)) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationDeclaration(parent2, list2));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkExtendsAllowed(list2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkImplementsAllowed(list2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassExtendsOnlyOneClass(list2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkGenericCannotExtendException(list2));
            }
        }
    }

    @Override
    public void visitReferenceParameterList(PsiReferenceParameterList list2) {
        if (list2.getTextLength() == 0) {
            return;
        }
        this.myHolder.add(this.checkFeature(list2, HighlightUtil.Feature.GENERICS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersAllowed(list2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersOnRaw(list2));
        }
        if (!this.myHolder.hasErrorResults()) {
            for (PsiTypeElement typeElement : list2.getTypeParameterElements()) {
                if (!(typeElement.getType() instanceof PsiDiamondType)) continue;
                this.myHolder.add(this.checkFeature(list2, HighlightUtil.Feature.DIAMOND_TYPES));
            }
        }
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement2) {
        try {
            this.myHolder.add(HighlightUtil.checkReturnStatementType(statement2));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void visitStatement(PsiStatement statement2) {
        super.visitStatement(statement2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkNotAStatement(statement2));
        }
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expr) {
        this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext(expr, expr.getQualifier(), this.myLanguageLevel));
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expr);
        }
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        super.visitSwitchLabelStatement(statement2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkCaseStatement(statement2));
        }
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement statement2) {
        super.visitSwitchStatement(statement2);
        this.myHolder.add(HighlightUtil.checkStatementPrependedWithCaseInsideSwitch(statement2));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSwitchSelectorType(statement2, this.myLanguageLevel));
        }
    }

    @Override
    public void visitThisExpression(PsiThisExpression expr) {
        if (!(expr.getParent() instanceof PsiReceiverParameter)) {
            this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext(expr, expr.getQualifier(), this.myLanguageLevel));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkMemberReferencedBeforeConstructorCalled(expr, null, this.myFile));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.visitExpression(expr);
            }
        }
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement2) {
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions(statement2, null));
        if (!this.myHolder.hasErrorResults()) {
            this.visitStatement(statement2);
        }
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement2) {
        super.visitTryStatement(statement2);
        if (!this.myHolder.hasErrorResults()) {
            Set<PsiClassType> thrownTypes = HighlightUtil.collectUnhandledExceptions(statement2);
            for (PsiParameter parameter : statement2.getCatchBlockParameters()) {
                boolean added = this.myHolder.addAll(HighlightUtil.checkExceptionAlreadyCaught(parameter));
                if (!added) {
                    added = this.myHolder.addAll(HighlightUtil.checkExceptionThrownInTry(parameter, thrownTypes));
                }
                if (added) continue;
                this.myHolder.addAll(HighlightUtil.checkWithImprovedCatchAnalysis(parameter, thrownTypes, this.myFile));
            }
        }
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        super.visitResourceList(resourceList);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(resourceList, HighlightUtil.Feature.TRY_WITH_RESOURCES));
        }
    }

    @Override
    public void visitResourceVariable(PsiResourceVariable resource) {
        super.visitResourceVariable(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions(resource));
        }
    }

    @Override
    public void visitResourceExpression(PsiResourceExpression resource) {
        super.visitResourceExpression(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(resource, HighlightUtil.Feature.REFS_AS_RESOURCE));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkResourceVariableIsFinal(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions(resource));
        }
    }

    @Override
    public void visitTypeElement(PsiTypeElement type2) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalType(type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkReferenceTypeUsedAsTypeArgument(type2, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkWildcardUsage(type2));
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
        super.visitTypeCastExpression(typeCast);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIntersectionInTypeCast(typeCast, this.myLanguageLevel, this.myFile));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkInconvertibleTypeCast(typeCast));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void visitTypeParameterList(PsiTypeParameterList list2) {
        PsiTypeParameter[] typeParameters2 = list2.getTypeParameters();
        if (typeParameters2.length > 0) {
            this.myHolder.add(this.checkFeature(list2, HighlightUtil.Feature.GENERICS));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkTypeParametersList(list2, typeParameters2, this.myLanguageLevel));
            }
        }
    }

    @Override
    public void visitVariable(PsiVariable variable2) {
        super.visitVariable(variable2);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkVarTypeApplicability(variable2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkVariableInitializerType(variable2));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    private boolean isReassigned(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(18);
        }
        try {
            boolean reassigned = variable2 instanceof PsiParameter ? this.myReassignedParameters.get((PsiParameter)variable2) == 2 : HighlightControlFlowUtil.isReassigned(variable2, this.myFinalVarProblems);
            return reassigned;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        super.visitConditionalExpression(expression2);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && PsiPolyExpressionUtil.isPolyExpression(expression2)) {
            PsiType conditionalType;
            PsiExpression thenExpression = expression2.getThenExpression();
            PsiExpression elseExpression = expression2.getElseExpression();
            if (thenExpression != null && elseExpression != null && (conditionalType = expression2.getType()) != null) {
                PsiExpression[] sides;
                for (PsiExpression side : sides = new PsiExpression[]{thenExpression, elseExpression}) {
                    PsiType sideType = side.getType();
                    if (sideType == null || TypeConversionUtil.isAssignable(conditionalType, sideType)) continue;
                    this.myHolder.add(HighlightUtil.checkAssignability(conditionalType, sideType, side, side));
                }
            }
        }
    }

    @Override
    public void visitReceiverParameter(PsiReceiverParameter parameter) {
        super.visitReceiverParameter(parameter);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(parameter, HighlightUtil.Feature.RECEIVERS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverPlacement(parameter));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverType(parameter));
        }
    }

    @Override
    public void visitModule(PsiJavaModule module2) {
        super.visitModule(module2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(module2, HighlightUtil.Feature.MODULES));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileName(module2, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileDuplicates(module2, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkDuplicateStatements(module2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkClashingReads(module2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkUnusedServices(module2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileLocation(module2, this.myFile));
        }
    }

    @Override
    public void visitRequiresStatement(PsiRequiresStatement statement2) {
        super.visitRequiresStatement(statement2);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            PsiJavaModule container2 = (PsiJavaModule)statement2.getParent();
            PsiJavaModuleReferenceElement ref = statement2.getReferenceElement();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkModuleReference(ref, container2));
            }
        }
    }

    @Override
    public void visitPackageAccessibilityStatement(PsiPackageAccessibilityStatement statement2) {
        super.visitPackageAccessibilityStatement(statement2);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkHostModuleStrength(statement2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkPackageReference(statement2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(ModuleHighlightUtil.checkPackageAccessTargets(statement2));
            }
        }
    }

    @Override
    public void visitUsesStatement(PsiUsesStatement statement2) {
        super.visitUsesStatement(statement2);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkServiceReference(statement2.getClassReference()));
        }
    }

    @Override
    public void visitProvidesStatement(PsiProvidesStatement statement2) {
        super.visitProvidesStatement(statement2);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkServiceImplementations(statement2));
        }
    }

    @Nullable
    private HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull HighlightUtil.Feature feature) {
        if (element == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(19);
        }
        if (feature == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(20);
        }
        return HighlightUtil.checkFeature(element, feature, this.myLanguageLevel, this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl";
                break;
            }
            case 4: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateMethods";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerReferencesFromInjectedFragments";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareToRunAsInspection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitImportStaticReferenceElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "highlightReferencedMethodOrClassName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerConstructorCall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doVisitReferenceElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptimised";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionalInterfaceTypeAccessible";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isReassigned";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkFeature";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$analyze$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final boolean CHECK_ELEMENT_LEVEL = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }
}

