/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHighlightUtil {
    public static boolean isSerializable(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(0);
        }
        return JavaHighlightUtil.isSerializable(aClass2, "java.io.Serializable");
    }

    public static boolean isSerializable(@NotNull PsiClass aClass2, String serializableClassName) {
        Project project;
        PsiClass serializableClass;
        if (aClass2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(1);
        }
        return (serializableClass = JavaPsiFacade.getInstance(project = aClass2.getManager().getProject()).findClass(serializableClassName, aClass2.getResolveScope())) != null && aClass2.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationRelatedMethod(PsiMethod method, PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        if (method.isConstructor()) {
            return JavaHighlightUtil.isSerializable(containingClass, "java.io.Externalizable") && method.getParameterList().getParametersCount() == 0 && method.hasModifierProperty("public");
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        String name = method.getName();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiType returnType = method.getReturnType();
        if ("readObjectNoData".equals(name)) {
            return parameters2.length == 0 && TypeConversionUtil.isVoidType(returnType) && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name)) {
            return parameters2.length == 1 && parameters2[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType(returnType) && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name)) {
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeReplace".equals(name)) {
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeObject".equals(name)) {
            return parameters2.length == 1 && TypeConversionUtil.isVoidType(returnType) && parameters2[0].getType().equalsToText("java.io.ObjectOutputStream") && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    @NotNull
    public static String formatType(@Nullable PsiType type2) {
        String string = type2 == null ? "null" : type2.getInternalCanonicalText();
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static PsiType getArrayInitializerType(@NotNull PsiArrayInitializerExpression element) {
        PsiType typeCheckResult;
        if (element == null) {
            JavaHighlightUtil.$$$reportNull$$$0(3);
        }
        return (typeCheckResult = JavaHighlightUtil.sameType(element.getInitializers())) != null ? typeCheckResult.createArrayType() : null;
    }

    @Nullable
    public static PsiType sameType(@NotNull PsiExpression[] expressions) {
        if (expressions == null) {
            JavaHighlightUtil.$$$reportNull$$$0(4);
        }
        PsiType type2 = null;
        for (PsiExpression expression2 : expressions) {
            PsiType currentType = expression2 instanceof PsiArrayInitializerExpression ? JavaHighlightUtil.getArrayInitializerType((PsiArrayInitializerExpression)expression2) : expression2.getType();
            if (type2 == null) {
                type2 = currentType;
                continue;
            }
            if (type2.equals(currentType)) continue;
            return null;
        }
        return type2;
    }

    @NotNull
    public static String formatMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaHighlightUtil.$$$reportNull$$$0(5);
        }
        String string = PsiFormatUtil.formatMethod(method, PsiSubstitutor.EMPTY, 257, 2);
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean isSuperOrThisCall(PsiStatement statement2, boolean testForSuper, boolean testForThis) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statement2).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression2).getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    @Nullable
    public static List<PsiMethod> getChainedConstructors(PsiMethod constructor) {
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        return info.visitedConstructors;
    }

    static void visitConstructorChain(PsiMethod constructor, @NotNull ConstructorVisitorInfo info) {
        if (info == null) {
            JavaHighlightUtil.$$$reportNull$$$0(7);
        }
        while (constructor != null) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            PsiStatement statement2 = statements[0];
            PsiElement element = new PsiMatcherImpl(statement2).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText("this")).parent(null).parent(null).getElement();
            if (element == null) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method)) {
                info.recursivelyCalledConstructor = method;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method);
            constructor = method;
        }
        return;
    }

    @Nullable
    public static String checkPsiTypeUseInContext(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(8);
        }
        if (type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            return JavaHighlightUtil.checkPsiTypeUseInContext(((PsiArrayType)type2).getComponentType(), context);
        }
        if (PsiUtil.resolveClassInType(type2) != null) {
            return null;
        }
        if (type2 instanceof PsiClassType) {
            return JavaHighlightUtil.checkClassType((PsiClassType)type2, context);
        }
        return "Invalid Java type";
    }

    private static String checkClassType(@NotNull PsiClassType type2, @NotNull PsiElement context) {
        String className2;
        if (type2 == null) {
            JavaHighlightUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(10);
        }
        if (JavaHighlightUtil.classExists(context, className2 = PsiNameHelper.getQualifiedClassName(type2.getCanonicalText(false), true))) {
            return JavaHighlightUtil.getClassInaccessibleMessage(context, className2);
        }
        return "Invalid Java type";
    }

    private static boolean classExists(@NotNull PsiElement context, String className2) {
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(11);
        }
        return JavaPsiFacade.getInstance(context.getProject()).findClass(className2, GlobalSearchScope.allScope(context.getProject())) != null;
    }

    @NotNull
    private static String getClassInaccessibleMessage(@NotNull PsiElement context, String className2) {
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(12);
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement(context);
        String string = "Class '" + className2 + "' is not accessible " + (module2 == null ? "here" : "from module '" + module2.getName() + "'");
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInaccessibleMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSerializable";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializerType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sameType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitConstructorChain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTypeUseInContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkClassType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "classExists";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassInaccessibleMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        ConstructorVisitorInfo() {
        }
    }
}

