/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeNewOperatorTypeFix
implements IntentionAction {
    private final PsiType myType;
    private final PsiNewExpression myExpression;

    private ChangeNewOperatorTypeFix(PsiType type2, PsiNewExpression expression2) {
        this.myType = type2;
        this.myExpression = expression2;
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("change.new.operator.type.text", new PsiExpressionTrimRenderer.RenderFunction().fun(this.myExpression), this.myType.getPresentableText(), this.myType instanceof PsiArrayType ? "" : "()");
        if (string == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.new.operator.type.family", new Object[0]);
        if (string == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(2);
        }
        return this.myType.isValid() && this.myExpression.isValid() && this.myExpression.getManager().isInProject(this.myExpression) && !TypeConversionUtil.isPrimitiveAndNotNull(this.myType) && (this.myType instanceof PsiArrayType || this.myExpression.getArgumentList() != null);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(3);
        }
        ChangeNewOperatorTypeFix.changeNewOperatorType(this.myExpression, this.myType, editor);
    }

    private static void changeNewOperatorType(PsiNewExpression originalExpression, PsiType toType, Editor editor) throws IncorrectOperationException {
        TextRange selection;
        PsiNewExpression newExpression;
        int caretOffset;
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(originalExpression.getProject()).getElementFactory();
        if (toType instanceof PsiArrayType) {
            PsiExpression[] originalExpressionArrayDimensions = originalExpression.getArrayDimensions();
            caretOffset = 0;
            String text2 = "new " + toType.getDeepComponentType().getCanonicalText() + "[";
            if (originalExpressionArrayDimensions.length > 0) {
                text2 = text2 + originalExpressionArrayDimensions[0].getText();
            } else {
                text2 = text2 + "0";
                caretOffset = -2;
            }
            text2 = text2 + "]";
            for (int i = 1; i < toType.getArrayDimensions(); ++i) {
                text2 = text2 + "[";
                String arrayDimension = "";
                if (originalExpressionArrayDimensions.length > i) {
                    arrayDimension = originalExpressionArrayDimensions[i].getText();
                    text2 = text2 + arrayDimension;
                }
                text2 = text2 + "]";
                if (caretOffset >= 0) continue;
                caretOffset -= arrayDimension.length() + 2;
            }
            newExpression = (PsiNewExpression)factory2.createExpressionFromText(text2, originalExpression);
            selection = caretOffset < 0 ? new UnfairTextRange(caretOffset, caretOffset + 1) : null;
        } else {
            PsiAnonymousClass anonymousClass = originalExpression.getAnonymousClass();
            newExpression = (PsiNewExpression)factory2.createExpressionFromText("new " + toType.getCanonicalText() + "()" + (anonymousClass != null ? "{}" : ""), originalExpression);
            PsiExpressionList argumentList2 = originalExpression.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            newExpression.getArgumentList().replace(argumentList2);
            if (anonymousClass == null && PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, originalExpression, toType)) {
                PsiElement paramList = PsiDiamondTypeUtil.replaceExplicitWithDiamond(newExpression.getClassOrAnonymousClassReference().getParameterList());
                newExpression = PsiTreeUtil.getParentOfType(paramList, PsiNewExpression.class);
            }
            if (anonymousClass != null) {
                PsiAnonymousClass newAnonymousClass = newExpression.getAnonymousClass();
                PsiElement childInside = anonymousClass.getLBrace().getNextSibling();
                if (childInside != null) {
                    newAnonymousClass.addRange(childInside, anonymousClass.getRBrace().getPrevSibling());
                }
            }
            selection = null;
            caretOffset = -1;
        }
        PsiElement element = originalExpression.replace(newExpression);
        editor.getCaretModel().moveToOffset(element.getTextRange().getEndOffset() + caretOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (selection != null) {
            selection = selection.shiftRight(element.getTextRange().getEndOffset());
            editor.getSelectionModel().setSelection(selection.getStartOffset(), selection.getEndOffset());
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static void register(HighlightInfo highlightInfo, PsiExpression expression2, PsiType lType) {
        if (!((expression2 = PsiUtil.deparenthesizeExpression(expression2)) instanceof PsiNewExpression)) {
            return;
        }
        PsiType rType = expression2.getType();
        PsiType newType = lType;
        if (rType instanceof PsiClassType && newType instanceof PsiClassType) {
            PsiSubstitutor substitutor2;
            PsiClassType.ClassResolveResult lResolveResult;
            PsiClass lClass;
            PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
            PsiClass rClass = rResolveResult.getElement();
            if (rClass instanceof PsiAnonymousClass) {
                rClass = ((PsiAnonymousClass)rClass).getBaseClassType().resolve();
            }
            if (rClass != null && (lClass = (lResolveResult = ((PsiClassType)newType).resolveGenerics()).getElement()) != null && (substitutor2 = ChangeNewOperatorTypeFix.getInheritorSubstitutorForNewExpression(lClass, rClass, lResolveResult.getSubstitutor(), expression2)) != null) {
                newType = JavaPsiFacade.getInstance(lClass.getProject()).getElementFactory().createType(rClass, substitutor2);
            }
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression2;
        QuickFixAction.registerQuickFixAction(highlightInfo, new ChangeNewOperatorTypeFix(newType, newExpression));
    }

    @Nullable
    private static PsiSubstitutor getInheritorSubstitutorForNewExpression(PsiClass baseClass, PsiClass inheritor, PsiSubstitutor baseSubstitutor, PsiElement context) {
        Project project = baseClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor(baseClass, inheritor, PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        PsiSubstitutor inheritorSubstitutor = PsiSubstitutor.EMPTY;
        block0: for (PsiTypeParameter inheritorParameter : PsiUtil.typeParametersIterable(inheritor)) {
            for (PsiTypeParameter baseParameter : PsiUtil.typeParametersIterable(baseClass)) {
                PsiType substitution2;
                PsiType substituted = superSubstitutor.substitute(baseParameter);
                PsiType arg = baseSubstitutor.substitute(baseParameter);
                if (arg instanceof PsiWildcardType) {
                    arg = ((PsiWildcardType)arg).getBound();
                }
                if (PsiType.NULL.equals(substitution2 = resolveHelper.getSubstitutionForTypeParameter(inheritorParameter, substituted, arg, true, PsiUtil.getLanguageLevel(context)))) continue;
                if (substitution2 == null) {
                    return facade.getElementFactory().createRawSubstitutor(inheritor);
                }
                inheritorSubstitutor = inheritorSubstitutor.put(inheritorParameter, substitution2);
                continue block0;
            }
        }
        return inheritorSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

