/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeStringLiteralToCharInMethodCallFix
implements IntentionAction {
    private final PsiLiteralExpression myLiteral;
    private final PsiCall myCall;

    public ChangeStringLiteralToCharInMethodCallFix(PsiLiteralExpression literal, PsiCall methodCall) {
        this.myLiteral = literal;
        this.myCall = methodCall;
    }

    @Override
    @NotNull
    public String getText() {
        String convertedValue = this.convertedValue();
        boolean isString = ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType());
        String string = QuickFixBundle.message("fix.single.character.string.to.char.literal.text", this.myLiteral.getText(), ChangeStringLiteralToCharInMethodCallFix.quote(convertedValue, !isString), isString ? PsiType.CHAR.getCanonicalText() : "String");
        if (string == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.single.character.string.to.char.literal.family", new Object[0]);
        if (string == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(2);
        }
        return this.myCall.isValid() && this.myLiteral.isValid() && this.myCall.getManager().isInProject(this.myCall);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        Object value;
        if (project == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(3);
        }
        if ((value = this.myLiteral.getValue()) != null && value.toString().length() == 1) {
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(project).getElementFactory();
            PsiExpression newExpression = factory2.createExpressionFromText(ChangeStringLiteralToCharInMethodCallFix.quote(this.convertedValue(), !ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType())), this.myLiteral.getParent());
            this.myLiteral.replace(newExpression);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static String quote(String value, boolean doubleQuotes) {
        char quote = doubleQuotes ? (char)'\"' : '\'';
        return quote + value + quote;
    }

    private String convertedValue() {
        String value = String.valueOf(this.myLiteral.getValue());
        StringBuilder builder = new StringBuilder();
        StringUtil.escapeStringCharacters(value.length(), value, "\"'", builder);
        return builder.toString();
    }

    public static void registerFixes(@NotNull PsiMethod[] candidates2, @NotNull PsiConstructorCall call2, @NotNull HighlightInfo out) {
        if (candidates2 == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(4);
        }
        if (call2 == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(5);
        }
        if (out == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(6);
        }
        HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
        if (call2.getArgumentList() == null) {
            return;
        }
        boolean exactMatch = false;
        for (PsiMethod method : candidates2) {
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(call2.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, call2, out);
        }
    }

    public static void registerFixes(@NotNull CandidateInfo[] candidates2, @NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo info) {
        if (candidates2 == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(7);
        }
        if (methodCall == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(8);
        }
        if (info == null) {
            return;
        }
        HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
        boolean exactMatch = false;
        for (CandidateInfo candidate2 : candidates2) {
            if (!(candidate2 instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)candidate2).getElement();
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(methodCall.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, methodCall, info);
        }
    }

    private static void processLiterals(@NotNull Set<PsiLiteralExpression> literals, @NotNull PsiCall call2, @NotNull HighlightInfo info) {
        if (literals == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(9);
        }
        if (call2 == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(10);
        }
        if (info == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(11);
        }
        for (PsiLiteralExpression literal : literals) {
            ChangeStringLiteralToCharInMethodCallFix fix = new ChangeStringLiteralToCharInMethodCallFix(literal, call2);
            QuickFixAction.registerQuickFixAction(info, fix);
        }
    }

    private static boolean findMatchingExpressions(PsiExpression[] arguments2, PsiMethod existingMethod, Set<PsiLiteralExpression> result2) {
        PsiParameterList parameterList = existingMethod.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (arguments2.length != parameters2.length) {
            return false;
        }
        boolean typeMatch = true;
        for (int i = 0; i < parameters2.length && i < arguments2.length; ++i) {
            String value;
            PsiParameter parameter = parameters2[i];
            PsiType parameterType = parameter.getType();
            PsiType argumentType = arguments2[i].getType();
            typeMatch &= Comparing.equal(parameterType, argumentType);
            if (!(arguments2[i] instanceof PsiLiteralExpression) || result2.contains(arguments2[i]) || !ChangeStringLiteralToCharInMethodCallFix.charToString(parameterType, argumentType) && !ChangeStringLiteralToCharInMethodCallFix.charToString(argumentType, parameterType) || (value = String.valueOf(((PsiLiteralExpression)arguments2[i]).getValue())) == null || value.length() != 1) continue;
            result2.add((PsiLiteralExpression)arguments2[i]);
        }
        return typeMatch;
    }

    private static boolean charToString(PsiType firstType, PsiType secondType) {
        return Comparing.equal(PsiType.CHAR, firstType) && ChangeStringLiteralToCharInMethodCallFix.isString(secondType);
    }

    private static boolean isString(PsiType type2) {
        return type2 != null && type2.equalsToText("java.lang.String");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literals";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processLiterals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

