/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.annotations.NotNull;

public class ConstructorParametersFixer {
    public static void registerFixActions(@NotNull PsiJavaCodeReferenceElement ctrRef, PsiConstructorCall constructorCall, HighlightInfo highlightInfo, TextRange fixRange) {
        JavaResolveResult resolved;
        PsiClass aClass2;
        if (ctrRef == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(0);
        }
        if ((aClass2 = (PsiClass)(resolved = ctrRef.advancedResolve(false)).getElement()) == null) {
            return;
        }
        PsiMethod[] methods2 = aClass2.getConstructors();
        CandidateInfo[] candidates2 = new CandidateInfo[methods2.length];
        for (int i = 0; i < candidates2.length; ++i) {
            candidates2[i] = new CandidateInfo(methods2[i], resolved.getSubstitutor());
        }
        CastMethodArgumentFix.REGISTRAR.registerCastActions(candidates2, constructorCall, highlightInfo, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(candidates2, constructorCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(candidates2, constructorCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions(candidates2, constructorCall, highlightInfo, fixRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctrRef", "com/intellij/codeInsight/daemon/impl/quickfix/ConstructorParametersFixer", "registerFixActions"));
    }
}

