/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertDoubleToFloatFix
implements IntentionAction {
    private final PsiExpression myExpression;

    public ConvertDoubleToFloatFix(PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Convert '" + this.myExpression.getText() + "' to float";
        if (string == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(2);
        }
        if (this.myExpression.isValid() && !StringUtil.endsWithIgnoreCase(this.myExpression.getText(), "f")) {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)this.createFloatingPointExpression(project);
            Object value = expression2.getValue();
            return value instanceof Float && !((Float)value).isInfinite() && (((Float)value).floatValue() != 0.0f || TypeConversionUtil.isFPZero(expression2.getText()));
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(3);
        }
        this.myExpression.replace(this.createFloatingPointExpression(project));
    }

    private PsiExpression createFloatingPointExpression(Project project) {
        String text2 = this.myExpression.getText();
        if (StringUtil.endsWithIgnoreCase(text2, "d")) {
            return JavaPsiFacade.getElementFactory(project).createExpressionFromText(text2.substring(0, text2.length() - 1) + "f", this.myExpression);
        }
        return JavaPsiFacade.getElementFactory(project).createExpressionFromText(text2 + "f", this.myExpression);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates2, @NotNull PsiExpressionList list2, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates2 == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(4);
        }
        if (list2 == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(5);
        }
        if (candidates2.length == 0) {
            return;
        }
        PsiExpression[] expressions = list2.getExpressions();
        for (JavaResolveResult candidate2 : candidates2) {
            ConvertDoubleToFloatFix.registerIntention(expressions, highlightInfo, fixRange, candidate2, list2);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate2, @NotNull PsiElement context) {
        PsiParameter[] parameters2;
        if (expressions == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(6);
        }
        if (candidate2 == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ConvertDoubleToFloatFix.$$$reportNull$$$0(8);
        }
        if (!candidate2.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate2.getElement();
        if (method != null && context.getManager().isInProject(method) && (parameters2 = method.getParameterList().getParameters()).length == expressions.length) {
            int length = parameters2.length;
            for (int i = 0; i < length; ++i) {
                PsiParameter parameter = parameters2[i];
                PsiExpression expression2 = expressions[i];
                if (!(expression2 instanceof PsiLiteralExpression) || !PsiType.FLOAT.equals(parameter.getType()) || !PsiType.DOUBLE.equals(expression2.getType())) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new ConvertDoubleToFloatFix(expression2));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

