/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergePackageAccessibilityStatementsFix
extends MergeModuleStatementsFix<PsiPackageAccessibilityStatement> {
    private static final Logger LOG = Logger.getInstance(MergePackageAccessibilityStatementsFix.class);
    private final String myPackageName;
    private final PsiPackageAccessibilityStatement.Role myRole;

    protected MergePackageAccessibilityStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String packageName, @NotNull PsiPackageAccessibilityStatement.Role role) {
        if (javaModule == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(1);
        }
        if (role == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(2);
        }
        super(javaModule);
        this.myPackageName = packageName;
        this.myRole = role;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.name", this.getKeyword(), this.myPackageName);
        if (string == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", this.getKeyword());
        if (string == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<PsiPackageAccessibilityStatement> statementsToMerge) {
        List<String> moduleNames;
        if (statementsToMerge == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(5);
        }
        if (!(moduleNames = MergePackageAccessibilityStatementsFix.getModuleNames(statementsToMerge)).isEmpty()) {
            String string = this.getKeyword() + " " + this.myPackageName + " " + "to" + " " + MergePackageAccessibilityStatementsFix.joinUniqueNames(moduleNames) + ";";
            if (string == null) {
                MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.getKeyword() + " " + this.myPackageName + ";";
        if (string == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<String> getModuleNames(@NotNull List<PsiPackageAccessibilityStatement> statements) {
        if (statements == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(8);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiPackageAccessibilityStatement statement2 : statements) {
            List<String> moduleNames = statement2.getModuleNames();
            if (moduleNames.isEmpty()) {
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(9);
                }
                return list2;
            }
            result2.addAll(moduleNames);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiPackageAccessibilityStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(11);
        }
        List<PsiPackageAccessibilityStatement> list2 = ((StreamEx)StreamEx.of(MergePackageAccessibilityStatementsFix.getStatements(javaModule, this.myRole).iterator()).filter(statement2 -> this.myPackageName.equals(statement2.getPackageName()))).toList();
        if (list2 == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiPackageAccessibilityStatement statement2) {
        String packageName;
        PsiElement parent2;
        if (statement2 != null && (parent2 = statement2.getParent()) instanceof PsiJavaModule && (packageName = statement2.getPackageName()) != null) {
            return new MergePackageAccessibilityStatementsFix((PsiJavaModule)parent2, packageName, statement2.getRole());
        }
        return null;
    }

    @NotNull
    private static Iterable<PsiPackageAccessibilityStatement> getStatements(@NotNull PsiJavaModule javaModule, @NotNull PsiPackageAccessibilityStatement.Role role) {
        if (javaModule == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(13);
        }
        if (role == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(14);
        }
        switch (role) {
            case OPENS: {
                Iterable<PsiPackageAccessibilityStatement> iterable = javaModule.getOpens();
                if (iterable == null) {
                    MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(15);
                }
                return iterable;
            }
            case EXPORTS: {
                Iterable<PsiPackageAccessibilityStatement> iterable = javaModule.getExports();
                if (iterable == null) {
                    MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(16);
                }
                return iterable;
            }
        }
        LOG.error("Unexpected role " + (Object)((Object)role));
        List<PsiPackageAccessibilityStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    private String getKeyword() {
        switch (this.myRole) {
            case OPENS: {
                if ("opens" == null) {
                    MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(18);
                }
                return "opens";
            }
            case EXPORTS: {
                if ("exports" == null) {
                    MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(19);
                }
                return "exports";
            }
        }
        LOG.error("Unexpected role " + (Object)((Object)this.myRole));
        if ("" == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(20);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToMerge";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsToMerge";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsToMerge";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStatements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

