/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisOrSuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class QualifyThisArgumentFix
extends QualifyThisOrSuperArgumentFix {
    public QualifyThisArgumentFix(@NotNull PsiExpression expression2, @NotNull PsiClass psiClass) {
        if (expression2 == null) {
            QualifyThisArgumentFix.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            QualifyThisArgumentFix.$$$reportNull$$$0(1);
        }
        super(expression2, psiClass);
    }

    @Override
    protected String getQualifierText() {
        return "this";
    }

    @Override
    protected PsiExpression getQualifier(PsiManager manager) {
        return RefactoringChangeUtil.createThisExpression(manager, this.myPsiClass);
    }

    public static void registerQuickFixAction(CandidateInfo[] candidates2, PsiCall call2, HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates2.length == 0) {
            return;
        }
        HashSet<PsiClass> containingClasses = new HashSet<PsiClass>();
        PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)call2, PsiClass.class);
        while (parentClass != null && !parentClass.hasModifierProperty("static")) {
            if (!(parentClass instanceof PsiAnonymousClass)) {
                containingClasses.add(parentClass);
            }
            parentClass = PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, true);
        }
        if (containingClasses.isEmpty()) {
            return;
        }
        PsiExpressionList list2 = call2.getArgumentList();
        PsiExpression[] expressions = list2.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        int expressionsLength = expressions.length;
        for (int i1 = 0; i1 < expressionsLength; ++i1) {
            PsiExpression expression2 = expressions[i1];
            if (!(expression2 instanceof PsiThisExpression)) continue;
            PsiType exprType = expression2.getType();
            for (CandidateInfo candidate2 : candidates2) {
                PsiClass psiClass;
                PsiMethod method = (PsiMethod)candidate2.getElement();
                PsiSubstitutor substitutor2 = candidate2.getSubstitutor();
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (expressions.length != parameters2.length) continue;
                PsiParameter parameter = parameters2[i1];
                PsiType parameterType = substitutor2.substitute(parameter.getType());
                if (exprType == null || parameterType == null || TypeConversionUtil.isAssignable(parameterType, exprType) || (psiClass = PsiUtil.resolveClassInClassTypeOnly(parameterType)) == null || !containingClasses.contains(psiClass)) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new QualifyThisArgumentFix((PsiThisExpression)expression2, psiClass));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisArgumentFix";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

