/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedVariableUtil {
    public static boolean checkSideEffects(PsiExpression element, @Nullable PsiVariable variableToIgnore, List<PsiElement> sideEffects) {
        if (sideEffects == null || element == null) {
            return false;
        }
        ArrayList<PsiElement> writes = new ArrayList<PsiElement>();
        SideEffectChecker.checkSideEffects(element, writes);
        if (variableToIgnore != null) {
            for (int i = writes.size() - 1; i >= 0; --i) {
                PsiExpression lExpression;
                PsiElement write2 = (PsiElement)writes.get(i);
                if (!(write2 instanceof PsiAssignmentExpression) || !((lExpression = ((PsiAssignmentExpression)write2).getLExpression()) instanceof PsiReference) || ((PsiReference)((Object)lExpression)).resolve() != variableToIgnore) continue;
                writes.remove(i);
            }
        }
        sideEffects.addAll(writes);
        return !writes.isEmpty();
    }

    static PsiElement replaceElementWithExpression(PsiExpression expression2, PsiElementFactory factory2, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiElement expressionToReplaceWith = expression2;
        if (element.getParent() instanceof PsiExpressionStatement) {
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory2.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory2.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
        }
        return elementToReplace.replace(expressionToReplaceWith);
    }

    static PsiElement createStatementIfNeeded(PsiExpression expression2, PsiElementFactory factory2, PsiElement element) throws IncorrectOperationException {
        if (!(element.getParent() instanceof PsiExpressionStatement) && !(element.getParent() instanceof PsiDeclarationStatement)) {
            return expression2;
        }
        return factory2.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
    }

    static void deleteWholeStatement(PsiElement element, PsiElementFactory factory2) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiExpressionStatement) {
            PsiExpressionStatement parent2 = (PsiExpressionStatement)element.getParent();
            if (parent2.getParent() instanceof PsiCodeBlock) {
                parent2.delete();
            } else {
                parent2.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(null, factory2, element));
            }
        } else {
            element.delete();
        }
    }

    static void deleteReferences(PsiVariable variable2, List<PsiElement> references, @NotNull RemoveMode mode) throws IncorrectOperationException {
        if (mode == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(0);
        }
        for (PsiElement expression2 : references) {
            RemoveUnusedVariableUtil.processUsage(expression2, variable2, null, mode);
        }
    }

    static void collectReferences(@NotNull PsiElement context, final PsiVariable variable2, final List<PsiElement> references) {
        if (context == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(1);
        }
        context.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable2) {
                    references.add(expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    static Boolean processUsage(PsiElement element, PsiVariable variable2, List<PsiElement> sideEffects, @NotNull RemoveMode deleteMode) throws IncorrectOperationException {
        if (deleteMode == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(2);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(variable2.getProject()).getElementFactory();
        while (element != null) {
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression2 = (PsiAssignmentExpression)element;
                PsiExpression lExpression = expression2.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || variable2 != ((PsiReferenceExpression)lExpression).resolve()) {
                    return null;
                }
                PsiExpression rExpression = expression2.getRExpression();
                if ((rExpression = PsiUtil.deparenthesizeExpression(rExpression)) == null) {
                    return true;
                }
                boolean sideEffectFound = RemoveUnusedVariableUtil.checkSideEffects(rExpression, variable2, sideEffects);
                if (!(element.getParent() instanceof PsiExpressionStatement) || PsiUtil.isStatement(rExpression)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT || deleteMode == RemoveMode.DELETE_ALL && !(element.getParent() instanceof PsiExpressionStatement)) {
                        element = RemoveUnusedVariableUtil.replaceElementWithExpression(rExpression, factory2, element);
                        while (element.getParent() instanceof PsiParenthesizedExpression) {
                            element = element.getParent().replace(element);
                        }
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableUtil.collectReferences(element, variable2, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable2, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        RemoveUnusedVariableUtil.deleteWholeStatement(element, factory2);
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    RemoveUnusedVariableUtil.deleteWholeStatement(element, factory2);
                }
                return !sideEffectFound;
            }
            if (element instanceof PsiExpressionStatement && deleteMode != RemoveMode.CANCEL) {
                PsiElement parent2 = element.getParent();
                if (parent2 instanceof PsiIfStatement || parent2 instanceof PsiLoopStatement && ((PsiLoopStatement)parent2).getBody() == element) {
                    element.replace(JavaPsiFacade.getElementFactory(element.getProject()).createStatementFromText(";", element));
                    break;
                }
                element.delete();
                break;
            }
            if (element instanceof PsiVariable && element == variable2) {
                PsiExpression expression3 = variable2.getInitializer();
                if (expression3 != null) {
                    expression3 = PsiUtil.deparenthesizeExpression(expression3);
                }
                boolean sideEffectsFound = RemoveUnusedVariableUtil.checkSideEffects(expression3, variable2, sideEffects);
                if (expression3 != null && PsiUtil.isStatement(expression3) && variable2 instanceof PsiLocalVariable && (!(variable2.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)variable2.getParent()).getDeclaredElements().length <= 1)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT) {
                        element = element.getParent().replace(RemoveUnusedVariableUtil.createStatementIfNeeded(expression3, factory2, element));
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableUtil.collectReferences(element, variable2, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable2, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        element.delete();
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    if (element instanceof PsiField) {
                        ((PsiField)element).normalizeDeclaration();
                    }
                    element.delete();
                }
                return !sideEffectsFound;
            }
            element = element.getParent();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum RemoveMode {
        MAKE_STATEMENT,
        DELETE_ALL,
        CANCEL;

    }
}

