/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableArrayTypeFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final PsiArrayType myTargetType;
    private final String myName;
    private final String myFamilyName;

    private VariableArrayTypeFix(@NotNull PsiArrayInitializerExpression initializer2, @NotNull PsiArrayType arrayType, @NotNull PsiVariable variable2) {
        if (initializer2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(0);
        }
        if (arrayType == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(1);
        }
        if (variable2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(2);
        }
        super(initializer2);
        this.myTargetType = arrayType;
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(initializer2);
        this.myName = this.myTargetType.equals(variable2.getType()) && myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.text", VariableArrayTypeFix.getNewText(myNewExpression, initializer2), this.myTargetType.getCanonicalText(), "") : QuickFixBundle.message("fix.variable.type.text", VariableArrayTypeFix.formatType(variable2), variable2.getName(), this.myTargetType.getCanonicalText());
        this.myFamilyName = QuickFixBundle.message(this.myTargetType.equals(variable2.getType()) && myNewExpression != null ? "change.new.operator.type.family" : "fix.variable.type.family", new Object[0]);
    }

    @Nullable
    public static VariableArrayTypeFix createFix(PsiArrayInitializerExpression initializer2, @NotNull PsiType componentType) {
        if (componentType == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(3);
        }
        PsiArrayType arrayType = new PsiArrayType(componentType);
        PsiArrayInitializerExpression arrayInitializer = initializer2;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
            arrayType = new PsiArrayType(arrayType);
        }
        PsiVariable variable2 = VariableArrayTypeFix.getVariableLocal(arrayInitializer);
        if (variable2 == null) {
            return null;
        }
        return new VariableArrayTypeFix(arrayInitializer, arrayType, variable2);
    }

    private static String formatType(@NotNull PsiVariable variable2) {
        FindUsagesProvider provider;
        String type2;
        if (variable2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty(type2 = (provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(variable2.getLanguage())).getType(variable2))) {
            return type2;
        }
        return TypePresentationService.getService().getTypePresentableName(variable2.getClass());
    }

    private static PsiArrayInitializerExpression getInitializer(PsiArrayInitializerExpression initializer2) {
        PsiArrayInitializerExpression arrayInitializer = initializer2;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
        }
        return arrayInitializer;
    }

    private static PsiVariable getVariableLocal(@NotNull PsiArrayInitializerExpression initializer2) {
        if (initializer2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(5);
        }
        PsiVariable variableLocal = null;
        PsiElement parent2 = initializer2.getParent();
        if (parent2 instanceof PsiVariable) {
            variableLocal = (PsiVariable)parent2;
        } else if (parent2 instanceof PsiNewExpression) {
            PsiNewExpression newExpressionLocal = (PsiNewExpression)parent2;
            PsiElement newParent = newExpressionLocal.getParent();
            if (newParent instanceof PsiAssignmentExpression) {
                variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)newParent);
            } else if (newParent instanceof PsiVariable) {
                variableLocal = (PsiVariable)newParent;
            }
        } else if (parent2 instanceof PsiAssignmentExpression) {
            variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)parent2);
        }
        return variableLocal;
    }

    private static PsiNewExpression getNewExpressionLocal(@NotNull PsiArrayInitializerExpression initializer2) {
        if (initializer2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(6);
        }
        PsiNewExpression newExpressionLocal = null;
        PsiElement parent2 = initializer2.getParent();
        if (!(parent2 instanceof PsiVariable) && parent2 instanceof PsiNewExpression) {
            newExpressionLocal = (PsiNewExpression)parent2;
        }
        return newExpressionLocal;
    }

    @Nullable
    private static PsiVariable getFromAssignment(PsiAssignmentExpression assignment) {
        PsiExpression reference = assignment.getLExpression();
        PsiElement referencedElement = reference instanceof PsiReferenceExpression ? ((PsiReferenceExpression)reference).resolve() : null;
        return referencedElement != null && referencedElement instanceof PsiVariable ? (PsiVariable)referencedElement : null;
    }

    private static String getNewText(PsiElement myNewExpression, PsiArrayInitializerExpression myInitializer) {
        String newText = myNewExpression.getText();
        int initializerIdx = newText.indexOf(myInitializer.getText());
        if (initializerIdx != -1) {
            return newText.substring(0, initializerIdx).trim();
        }
        return newText;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiArrayInitializerExpression myInitializer;
        PsiVariable myVariable;
        if (project == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(12);
        }
        return (myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer = (PsiArrayInitializerExpression)startElement)) != null && myVariable.isValid() && myVariable.getManager().isInProject(myVariable) && this.myTargetType.isValid() && myInitializer.isValid();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiArrayInitializerExpression myInitializer;
        PsiVariable myVariable;
        if (project == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(14);
        }
        if (startElement == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(15);
        }
        if (endElement == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(16);
        }
        if ((myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer = (PsiArrayInitializerExpression)startElement)) == null) {
            return;
        }
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(myInitializer);
        if (!FileModificationService.getInstance().prepareFileForWrite(myVariable.getContainingFile())) {
            return;
        }
        if (!this.myTargetType.equals(myVariable.getType())) {
            WriteAction.run(() -> {
                if (project == null) {
                    VariableArrayTypeFix.$$$reportNull$$$0(19);
                }
                if (file2 == null) {
                    VariableArrayTypeFix.$$$reportNull$$$0(20);
                }
                this.fixVariableType(project, file2, myVariable);
            });
        }
        if (myNewExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            WriteAction.run(() -> this.fixArrayInitializer(myInitializer, myNewExpression));
        }
    }

    private void fixVariableType(@NotNull Project project, @NotNull PsiFile file2, PsiVariable myVariable) {
        if (project == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(18);
        }
        myVariable.normalizeDeclaration();
        myVariable.getTypeElement().replace(JavaPsiFacade.getElementFactory(project).createTypeElement(this.myTargetType));
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(myVariable);
        if (!myVariable.getContainingFile().equals(file2)) {
            UndoUtil.markPsiFileForUndo(myVariable.getContainingFile());
        }
    }

    private void fixArrayInitializer(PsiArrayInitializerExpression myInitializer, PsiNewExpression myNewExpression) {
        String text2 = "new " + this.myTargetType.getCanonicalText() + "{}";
        PsiNewExpression newExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory(myNewExpression.getProject()).createExpressionFromText(text2, myNewExpression.getParent());
        PsiElement[] children2 = newExpression.getChildren();
        children2[children2.length - 1].replace(myInitializer);
        myNewExpression.replace(newExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariableLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionLocal";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

