/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapExpressionFix
implements IntentionAction {
    private final PsiExpression myExpression;
    private final PsiClassType myExpectedType;
    private final boolean myPrimitiveExpected;

    public WrapExpressionFix(@NotNull PsiType expectedType2, @NotNull PsiExpression expression2) {
        if (expectedType2 == null) {
            WrapExpressionFix.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            WrapExpressionFix.$$$reportNull$$$0(1);
        }
        this.myExpression = expression2;
        this.myExpectedType = WrapExpressionFix.getClassType(expectedType2, expression2);
        this.myPrimitiveExpected = expectedType2 instanceof PsiPrimitiveType;
    }

    @Nullable
    private static PsiClassType getClassType(PsiType type2, PsiElement place) {
        if (type2 instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type2).getBoxedType(place.getManager(), GlobalSearchScope.allScope(place.getProject()));
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        PsiType type2 = this.myExpression.getType();
        PsiMember wrapper = this.myExpression.isValid() && this.myExpectedType != null && type2 != null ? WrapExpressionFix.findWrapper(type2, this.myExpectedType, this.myPrimitiveExpected) : null;
        String methodPresentation = wrapper != null ? wrapper.getContainingClass().getName() + "." + wrapper.getName() : "";
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.text", methodPresentation);
        if (string == null) {
            WrapExpressionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static PsiMethod findWrapper(@NotNull PsiType type2, @NotNull PsiClassType expectedType2, boolean primitiveExpected) {
        PsiClass aClass2;
        if (type2 == null) {
            WrapExpressionFix.$$$reportNull$$$0(3);
        }
        if (expectedType2 == null) {
            WrapExpressionFix.$$$reportNull$$$0(4);
        }
        if ((aClass2 = expectedType2.resolve()) != null) {
            PsiType expectedReturnType = expectedType2;
            if (primitiveExpected) {
                expectedReturnType = PsiPrimitiveType.getUnboxedType(expectedType2);
            }
            if (expectedReturnType == null) {
                return null;
            }
            PsiMethod[] methods2 = aClass2.getMethods();
            LinkedHashSet<PsiMethod> wrapperMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod method : methods2) {
                if (!method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || !method.getParameterList().getParameters()[0].getType().isAssignableFrom(type2) || method.getReturnType() == null || !expectedReturnType.equals(method.getReturnType())) continue;
                String methodName = method.getName();
                if (methodName.startsWith("parse") || methodName.equals("valueOf")) {
                    return method;
                }
                wrapperMethods.add(method);
            }
            if (!wrapperMethods.isEmpty()) {
                return (PsiMethod)wrapperMethods.iterator().next();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.family", new Object[0]);
        if (string == null) {
            WrapExpressionFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            WrapExpressionFix.$$$reportNull$$$0(6);
        }
        return this.myExpression.isValid() && this.myExpression.getManager().isInProject(this.myExpression) && this.myExpectedType != null && this.myExpectedType.isValid() && this.myExpression.getType() != null && WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType, this.myPrimitiveExpected) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            WrapExpressionFix.$$$reportNull$$$0(7);
        }
        PsiType type2 = this.myExpression.getType();
        assert (type2 != null);
        PsiMethod wrapper = WrapExpressionFix.findWrapper(type2, this.myExpectedType, this.myPrimitiveExpected);
        assert (wrapper != null);
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(file2.getProject()).getElementFactory();
        String methodCallText = "Foo." + wrapper.getName() + "()";
        PsiMethodCallExpression call2 = (PsiMethodCallExpression)factory2.createExpressionFromText(methodCallText, null);
        call2.getArgumentList().add(this.myExpression);
        ((PsiReferenceExpression)call2.getMethodExpression().getQualifierExpression()).bindToElement(wrapper.getContainingClass());
        this.myExpression.replace(call2);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static void registerWrapAction(JavaResolveResult[] candidates2, PsiExpression[] expressions, HighlightInfo highlightInfo) {
        PsiType expectedType2 = null;
        PsiElement expr = null;
        block0: for (int i = 0; i < candidates2.length && expectedType2 == null; ++i) {
            JavaResolveResult candidate2 = candidates2[i];
            PsiSubstitutor substitutor2 = candidate2.getSubstitutor();
            PsiElement element = candidate2.getElement();
            assert (element != null);
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (!method.isVarArgs() && parameters2.length != expressions.length) continue;
            for (int j = 0; j < expressions.length; ++j) {
                PsiExpression expression2 = expressions[j];
                PsiType exprType = expression2.getType();
                if (exprType == null) continue;
                PsiType paramType = parameters2[Math.min(j, parameters2.length - 1)].getType();
                if (paramType instanceof PsiEllipsisType) {
                    paramType = ((PsiEllipsisType)paramType).getComponentType();
                }
                PsiType psiType = paramType = substitutor2 != null ? substitutor2.substitute(paramType) : paramType;
                if (paramType.isAssignableFrom(exprType)) continue;
                PsiClassType classType = WrapExpressionFix.getClassType(paramType, expression2);
                if (expectedType2 == null && classType != null && WrapExpressionFix.findWrapper(exprType, classType, paramType instanceof PsiPrimitiveType) != null) {
                    expectedType2 = paramType;
                    expr = expression2;
                    continue;
                }
                expectedType2 = null;
                expr = null;
                continue block0;
            }
        }
        if (expectedType2 != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, expr.getTextRange(), new WrapExpressionFix(expectedType2, (PsiExpression)expr));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

