/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public abstract class AbstractDependencyVisitor
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.dsm.model.classes.DependencyVisitor");
    private final AnnotationDependencyVisitor myAnnotationVisitor = new AnnotationDependencyVisitor();
    private final DependencySignatureVisitor mySignatureVisitor = new DependencySignatureVisitor();
    private final DependencyFieldVisitor myFieldVisitor = new DependencyFieldVisitor();
    private String myCurrentClassName;
    private final Map<String, String> mySlotNames = new HashMap<String, String>();

    protected AbstractDependencyVisitor() {
        super(393216);
    }

    protected abstract void addClassName(String var1);

    public void processFile(File file2) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file2));){
            this.processStream(is);
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    public void processStream(InputStream is) throws IOException {
        ClassReader cr = new ClassReader(is);
        cr.accept(this, 4);
    }

    @Override
    public void visit(int version, int access, String name, String signature2, String superName, String[] interfaces) {
        this.myCurrentClassName = this.getSlotName(name);
        if (signature2 == null) {
            this.addName(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature2);
        }
    }

    private String getSlotName(String name) {
        String result2 = this.mySlotNames.get(name);
        if (result2 == null) {
            result2 = name.replace("/", ".");
            int idx = result2.indexOf("$");
            if (idx >= 0) {
                result2 = result2.substring(0, idx);
            }
            this.mySlotNames.put(name, result2);
        }
        return result2;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature2, Object value) {
        if (signature2 == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature2);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.myFieldVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature2, String[] exceptions) {
        if ((access & 0x1000) == 0) {
            if (signature2 == null) {
                this.addMethodDesc(desc);
            } else {
                this.addSignature(signature2);
            }
            this.addNames(exceptions);
        }
        if ((access & 0x400) != 0) {
            return null;
        }
        return new DependencyMethodVisitor();
    }

    private void addName(String name) {
        if (name == null) {
            return;
        }
        if ((name = this.getSlotName(name)).equals(this.myCurrentClassName)) {
            return;
        }
        this.addClassName(name);
    }

    private void addNames(String[] names2) {
        for (int i = 0; names2 != null && i < names2.length; ++i) {
            this.addName(names2[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType(desc));
    }

    private void addHandle(Handle h) {
        this.addName(h.getOwner());
        this.addMethodDesc(h.getDesc());
    }

    private void addMethodDesc(String desc) {
        Type[] types;
        this.addType(Type.getReturnType(desc));
        for (Type type2 : types = Type.getArgumentTypes(desc)) {
            this.addType(type2);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
                break;
            }
            case 11: {
                this.addMethodDesc(t.getDescriptor());
            }
        }
    }

    private void addSignature(String signature2) {
        if (signature2 != null) {
            new SignatureReader(signature2).accept(this.mySignatureVisitor);
        }
    }

    private void addTypeSignature(String signature2) {
        if (signature2 != null) {
            new SignatureReader(signature2).acceptType(this.mySignatureVisitor);
        }
    }

    public String getCurrentClassName() {
        return this.myCurrentClassName;
    }

    private class DependencySignatureVisitor
    extends SignatureVisitor {
        public DependencySignatureVisitor() {
            super(393216);
        }

        @Override
        public void visitClassType(String name) {
            AbstractDependencyVisitor.this.addName(name);
        }

        @Override
        public void visitInnerClassType(String name) {
            AbstractDependencyVisitor.this.addName(name);
        }
    }

    private class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        public AnnotationDependencyVisitor() {
            super(393216);
        }

        @Override
        public void visit(String name, Object value) {
            if (value instanceof Type) {
                AbstractDependencyVisitor.this.addType((Type)value);
            }
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    private class DependencyFieldVisitor
    extends FieldVisitor {
        public DependencyFieldVisitor() {
            super(393216);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }
    }

    private class DependencyMethodVisitor
    extends MethodVisitor {
        private Label myFirstLabel;

        public DependencyMethodVisitor() {
            super(393216);
            this.myFirstLabel = null;
        }

        @Override
        public void visitLabel(Label label) {
            if (this.myFirstLabel == null) {
                this.myFirstLabel = label;
            }
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            if (187 == opcode) {
                return;
            }
            if (desc.charAt(0) == '[') {
                AbstractDependencyVisitor.this.addDesc(desc);
            } else {
                AbstractDependencyVisitor.this.addName(desc);
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            AbstractDependencyVisitor.this.addName(owner);
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            AbstractDependencyVisitor.this.addName(owner);
            AbstractDependencyVisitor.this.addMethodDesc(desc);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                AbstractDependencyVisitor.this.addType((Type)cst);
            }
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler2, String type2) {
            AbstractDependencyVisitor.this.addName(type2);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature2, Label start, Label end, int index2) {
            if (this.myFirstLabel == start) {
                return;
            }
            AbstractDependencyVisitor.this.addTypeSignature(signature2 == null ? desc : signature2);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            AbstractDependencyVisitor.this.addDesc(desc);
            for (Object arg : bsmArgs) {
                if (!(arg instanceof Handle)) continue;
                AbstractDependencyVisitor.this.addHandle((Handle)arg);
            }
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index2, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }
    }
}

