/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.HMethod;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

public final class EKey {
    @NotNull
    final MethodDescriptor method;
    final int dirKey;
    final boolean stable;
    final boolean negated;

    public EKey(@NotNull MethodDescriptor method, Direction direction, boolean stable) {
        if (method == null) {
            EKey.$$$reportNull$$$0(0);
        }
        this(method, direction, stable, false);
    }

    EKey(@NotNull MethodDescriptor method, Direction direction, boolean stable, boolean negated) {
        if (method == null) {
            EKey.$$$reportNull$$$0(1);
        }
        this(method, direction.asInt(), stable, negated);
    }

    EKey(@NotNull MethodDescriptor method, int dirKey, boolean stable, boolean negated) {
        if (method == null) {
            EKey.$$$reportNull$$$0(2);
        }
        this.method = method;
        this.dirKey = dirKey;
        this.stable = stable;
        this.negated = negated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EKey key = (EKey)o;
        if (this.stable != key.stable) {
            return false;
        }
        if (this.negated != key.negated) {
            return false;
        }
        if (this.dirKey != key.dirKey) {
            return false;
        }
        return this.method.equals(key.method);
    }

    public int hashCode() {
        int result2 = this.method.hashCode();
        result2 = 31 * result2 + this.dirKey;
        result2 = 31 * result2 + (this.stable ? 1 : 0);
        result2 = 31 * result2 + (this.negated ? 1 : 0);
        return result2;
    }

    EKey invertStability() {
        return new EKey(this.method, this.dirKey, !this.stable, this.negated);
    }

    EKey mkStable() {
        return this.stable ? this : new EKey(this.method, this.dirKey, true, this.negated);
    }

    EKey mkUnstable() {
        return this.stable ? new EKey(this.method, this.dirKey, false, this.negated) : this;
    }

    public EKey mkBase() {
        return this.withDirection(Direction.Out);
    }

    EKey withDirection(Direction dir) {
        return this.dirKey == dir.asInt() ? this : new EKey(this.method, dir, this.stable, false);
    }

    EKey negate() {
        return new EKey(this.method, this.dirKey, this.stable, true);
    }

    public EKey hashed(MessageDigest md) {
        HMethod hmethod = this.method.hashed(md);
        return hmethod == this.method ? this : new EKey((MethodDescriptor)hmethod, this.dirKey, this.stable, this.negated);
    }

    public Direction getDirection() {
        return Direction.fromInt(this.dirKey);
    }

    public String toString() {
        return "Key [" + this.method + "|" + (this.stable ? "S" : "-") + (this.negated ? "N" : "-") + "|" + Direction.fromInt(this.dirKey) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/bytecodeAnalysis/EKey", "<init>"));
    }
}

