/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.security.MessageDigest;
import java.util.Arrays;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HMethod
implements MethodDescriptor {
    private static final int CLASS_HASH_SIZE = 10;
    private static final int SIGNATURE_HASH_SIZE = 4;
    static final int HASH_SIZE = 14;
    @NotNull
    final byte[] myBytes;

    HMethod(Method method, MessageDigest md) {
        if (md == null) {
            md = BytecodeAnalysisConverter.getMessageDigest();
        }
        byte[] classDigest = md.digest(method.internalClassName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(method.methodName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(method.methodDesc.getBytes(CharsetToolkit.UTF8_CHARSET));
        byte[] sigDigest = md.digest();
        this.myBytes = new byte[14];
        System.arraycopy(classDigest, 0, this.myBytes, 0, 10);
        System.arraycopy(sigDigest, 0, this.myBytes, 10, 4);
    }

    public HMethod(@NotNull byte[] bytes) {
        if (bytes == null) {
            HMethod.$$$reportNull$$$0(0);
        }
        this.myBytes = bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.myBytes, ((HMethod)o).myBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myBytes);
    }

    @Override
    @NotNull
    public HMethod hashed(MessageDigest md) {
        HMethod hMethod = this;
        if (hMethod == null) {
            HMethod.$$$reportNull$$$0(1);
        }
        return hMethod;
    }

    public String toString() {
        return HMethod.bytesToString(this.myBytes);
    }

    static String bytesToString(byte[] key) {
        return IntStreamEx.of((byte[])key).mapToObj(b -> String.format("%02x", b & 0xFF)).joining(".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/HMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/HMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "hashed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

