/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.LambdaIndy;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

class InOutInterpreter
extends BasicInterpreter {
    final Direction.ParamValueBasedDirection direction;
    final InsnList insns;
    final boolean[] resultOrigins;
    final boolean nullAnalysis;
    boolean deReferenced;

    InOutInterpreter(Direction direction, InsnList insns, boolean[] resultOrigins) {
        this.insns = insns;
        this.resultOrigins = resultOrigins;
        if (direction instanceof Direction.ParamValueBasedDirection) {
            this.direction = (Direction.ParamValueBasedDirection)direction;
            this.nullAnalysis = this.direction.inValue == Value.Null;
        } else {
            this.direction = null;
            this.nullAnalysis = false;
        }
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        boolean propagate = this.resultOrigins[this.insns.indexOf(insn)];
        if (propagate) {
            switch (insn.getOpcode()) {
                case 3: {
                    return AbstractValues.FalseValue;
                }
                case 4: {
                    return AbstractValues.TrueValue;
                }
                case 1: {
                    return AbstractValues.NullValue;
                }
                case 18: {
                    Object cst = ((LdcInsnNode)insn).cst;
                    if (cst instanceof Type) {
                        Type type2 = (Type)cst;
                        if (type2.getSort() == 10 || type2.getSort() == 9) {
                            return AbstractValues.CLASS_VALUE;
                        }
                        if (type2.getSort() != 11) break;
                        return AbstractValues.METHOD_VALUE;
                    }
                    if (cst instanceof String) {
                        return AbstractValues.STRING_VALUE;
                    }
                    if (!(cst instanceof Handle)) break;
                    return AbstractValues.METHOD_HANDLE_VALUE;
                }
                case 187: {
                    return new AbstractValues.NotNullValue(Type.getObjectType(((TypeInsnNode)insn).desc));
                }
            }
        }
        return super.newOperation(insn);
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        boolean propagate = this.resultOrigins[this.insns.indexOf(insn)];
        switch (insn.getOpcode()) {
            case 180: 
            case 190: 
            case 194: {
                if (this.nullAnalysis && value instanceof AbstractValues.ParamValue) {
                    this.deReferenced = true;
                }
                return super.unaryOperation(insn, value);
            }
            case 192: {
                if (!(value instanceof AbstractValues.ParamValue)) break;
                return new AbstractValues.ParamValue(Type.getObjectType(((TypeInsnNode)insn).desc));
            }
            case 193: {
                if (!(value instanceof AbstractValues.ParamValue)) break;
                return AbstractValues.InstanceOfCheckValue;
            }
            case 188: 
            case 189: {
                if (!propagate) break;
                return new AbstractValues.NotNullValue(super.unaryOperation(insn, value).getType());
            }
        }
        return super.unaryOperation(insn, value);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 181: {
                if (!this.nullAnalysis || !(value1 instanceof AbstractValues.ParamValue)) break;
                this.deReferenced = true;
                break;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                if (!this.nullAnalysis || !(value1 instanceof AbstractValues.ParamValue)) break;
                this.deReferenced = true;
            }
        }
        return null;
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values2) throws AnalyzerException {
        boolean propagate = this.resultOrigins[this.insns.indexOf(insn)];
        int opCode = insn.getOpcode();
        int shift = opCode == 184 ? 0 : 1;
        switch (opCode) {
            case 182: 
            case 183: 
            case 185: {
                if (!this.nullAnalysis || !(values2.get(0) instanceof AbstractValues.ParamValue)) break;
                this.deReferenced = true;
                return super.naryOperation(insn, (List)values2);
            }
        }
        if (propagate) {
            switch (opCode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    boolean isRefRetType;
                    boolean stable = opCode == 184 || opCode == 183;
                    MethodInsnNode mNode = (MethodInsnNode)insn;
                    Method method = new Method(mNode.owner, mNode.name, mNode.desc);
                    Type retType = Type.getReturnType(mNode.desc);
                    boolean bl = isRefRetType = retType.getSort() == 10 || retType.getSort() == 9;
                    if (Type.VOID_TYPE.equals(retType)) break;
                    if (this.direction != null) {
                        HashSet<EKey> keys2 = new HashSet<EKey>();
                        for (int i = shift; i < values2.size(); ++i) {
                            if (!(values2.get(i) instanceof AbstractValues.ParamValue)) continue;
                            keys2.add(new EKey(method, this.direction.withIndex(i - shift), stable));
                        }
                        if (isRefRetType) {
                            keys2.add(new EKey(method, Direction.Out, stable));
                        }
                        if (keys2.isEmpty()) break;
                        return new AbstractValues.CallResultValue(retType, keys2);
                    }
                    if (!isRefRetType) break;
                    HashSet<EKey> keys3 = new HashSet<EKey>();
                    keys3.add(new EKey(method, Direction.Out, stable));
                    return new AbstractValues.CallResultValue(retType, keys3);
                }
                case 186: {
                    LambdaIndy lambda2 = LambdaIndy.from((InvokeDynamicInsnNode)insn);
                    if (lambda2 == null) break;
                    return new AbstractValues.NotNullValue(lambda2.getFunctionalInterfaceType());
                }
                case 197: {
                    return new AbstractValues.NotNullValue(((BasicValue)super.naryOperation(insn, (List)values2)).getType());
                }
            }
        }
        return super.naryOperation(insn, (List)values2);
    }
}

