/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import java.util.HashSet;
import java.util.Set;

public final class DFSTree {
    public final int[] preOrder;
    public final int[] postOrder;
    public final Set<ControlFlowGraph.Edge> nonBack;
    public final Set<ControlFlowGraph.Edge> back;
    public final boolean[] loopEnters;

    DFSTree(int[] preOrder, int[] postOrder, Set<ControlFlowGraph.Edge> nonBack, Set<ControlFlowGraph.Edge> back, boolean[] loopEnters) {
        this.preOrder = preOrder;
        this.postOrder = postOrder;
        this.nonBack = nonBack;
        this.back = back;
        this.loopEnters = loopEnters;
    }

    public final boolean isDescendant(int child, int parent2) {
        return this.preOrder[parent2] <= this.preOrder[child] && this.postOrder[child] <= this.postOrder[parent2];
    }

    public static DFSTree build(int[][] transitions, int edgeCount) {
        HashSet<ControlFlowGraph.Edge> nonBack = new HashSet<ControlFlowGraph.Edge>();
        HashSet<ControlFlowGraph.Edge> back = new HashSet<ControlFlowGraph.Edge>();
        boolean[] marked = new boolean[transitions.length];
        boolean[] scanned = new boolean[transitions.length];
        int[] preOrder = new int[transitions.length];
        int[] postOrder = new int[transitions.length];
        int entered = 0;
        int completed = 0;
        boolean[] loopEnters = new boolean[transitions.length];
        preOrder[0] = ++entered;
        marked[0] = true;
        boolean[] stackFlag = new boolean[edgeCount * 2 + 1];
        int[] stackFrom = new int[edgeCount * 2 + 1];
        int[] stackTo = new int[edgeCount * 2 + 1];
        int top = 0;
        stackFlag[top] = true;
        stackTo[top] = 0;
        ++top;
        for (int to : transitions[0]) {
            stackFlag[top] = false;
            stackFrom[top] = 0;
            stackTo[top] = to;
            ++top;
        }
        while (top > 0) {
            if (stackFlag[--top]) {
                postOrder[stackTo[top]] = ++completed;
                scanned[stackTo[top]] = true;
                continue;
            }
            int from = stackFrom[top];
            int to = stackTo[top];
            if (!marked[to]) {
                nonBack.add(new ControlFlowGraph.Edge(from, to));
                preOrder[to] = ++entered;
                marked[to] = true;
                stackFlag[top] = true;
                stackTo[top] = to;
                ++top;
                for (int to1 : transitions[to]) {
                    stackFlag[top] = false;
                    stackFrom[top] = to;
                    stackTo[top] = to1;
                    ++top;
                }
                continue;
            }
            if (preOrder[to] > preOrder[from]) {
                nonBack.add(new ControlFlowGraph.Edge(from, to));
                continue;
            }
            if (preOrder[to] < preOrder[from] && !scanned[to]) {
                back.add(new ControlFlowGraph.Edge(from, to));
                loopEnters[to] = true;
                continue;
            }
            nonBack.add(new ControlFlowGraph.Edge(from, to));
        }
        return new DFSTree(preOrder, postOrder, nonBack, back, loopEnters);
    }
}

